/*
 * Decompiled with CFR 0.152.
 */
package XMLConsumer;

import XMLConsumer.IEntry;
import XMLConsumer.IdxData;
import hhapplet.BsscFontFixPatch;
import hhapplet.IActionSink;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Vector;

public class GlossaryEntry
implements IEntry {
    private String m_name;
    private String m_value;
    private boolean m_bSelect;
    private boolean m_bHighLight;
    private IdxData m_IdxData;
    private static Color GREEN = new Color(0, 127, 0);
    private static final int GLO_INDENT = 2;
    private static Color m_activeColor = Color.gray;
    private static int m_indent = 2;
    private static Font m_normalFont = new Font(BsscFontFixPatch.GetFontName(), 0, BsscFontFixPatch.GetFontSize());
    private static Font m_hoverFont = new Font(BsscFontFixPatch.GetFontName(), 0, BsscFontFixPatch.GetFontSize());
    private static Color m_normalColor = Color.black;
    private static Color m_hoverColor = GREEN;
    private static boolean m_normalUnderline = false;
    private static boolean m_hoverUnderline = true;

    public int getPrevSpan() {
        return 0;
    }

    public static void setHoverUnderline(boolean bl) {
        m_hoverUnderline = bl;
    }

    public boolean isMainEntry() {
        return true;
    }

    public static void setNormalColor(Color color) {
        m_normalColor = color;
    }

    public static void setHoverFont(Font font) {
        if (font.getSize() != m_normalFont.getSize()) {
            m_hoverFont = new Font(font.getFamily(), font.getStyle(), m_normalFont.getSize());
            return;
        }
        m_hoverFont = font;
    }

    public GlossaryEntry(String string, String string2) {
        this.m_name = string;
        this.m_bHighLight = false;
        this.m_bSelect = false;
        this.m_value = string2;
    }

    public void select(boolean bl) {
        this.m_bSelect = bl;
    }

    public static void setNormalFont(Font font) {
        m_normalFont = font;
    }

    public static void setNormalUnderline(boolean bl) {
        m_normalUnderline = bl;
    }

    public static void setActiveColor(Color color) {
        m_activeColor = color;
    }

    public String getName() {
        return this.m_name;
    }

    public void highLight(boolean bl) {
        this.m_bHighLight = bl;
    }

    public void action(IActionSink iActionSink) {
        Vector<String> vector = new Vector<String>();
        vector.addElement(this.m_name);
        vector.addElement(this.m_value);
        iActionSink.accept(vector);
    }

    public int getNextSpan() {
        return 0;
    }

    public void display(Graphics graphics, int n, int n2, Color color, Image image) {
        int n3;
        FontMetrics fontMetrics = graphics.getFontMetrics(m_normalFont);
        FontMetrics fontMetrics2 = graphics.getFontMetrics(m_hoverFont);
        Color color2 = graphics.getColor();
        int n4 = fontMetrics.stringWidth(this.m_name + " ");
        n4 = n4 > (n3 = fontMetrics2.stringWidth(this.m_name + " ")) ? n4 : n3;
        int n5 = fontMetrics.getAscent();
        int n6 = fontMetrics.getLeading();
        int n7 = fontMetrics2.getAscent();
        int n8 = fontMetrics2.getLeading();
        if (this.m_bSelect) {
            graphics.setColor(m_activeColor);
            graphics.fill3DRect(m_indent, n * n2, n4, n2, true);
        } else if (image != null) {
            graphics.drawImage(image, m_indent, n * n2, m_indent + n4, n * n2 + n2, m_indent, n * n2, m_indent + n4, n * n2 + n2, null);
        } else {
            graphics.setColor(color);
            graphics.fillRect(m_indent, n * n2, n4, n2);
        }
        graphics.setColor(color2);
        Font font = graphics.getFont();
        if (this.m_bHighLight) {
            graphics.setFont(m_hoverFont);
            graphics.setColor(m_hoverColor);
            graphics.drawString(this.m_name, m_indent, n * n2 + n7 + n8);
            if (m_hoverUnderline) {
                graphics.drawLine(m_indent, (n + 1) * n2 - 1, m_indent + n4 - 1, (n + 1) * n2 - 1);
            }
            graphics.setFont(font);
            graphics.setColor(color2);
            return;
        }
        graphics.setFont(m_normalFont);
        graphics.setColor(m_normalColor);
        graphics.drawString(this.m_name, m_indent, n * n2 + n5 + n6);
        if (m_normalUnderline) {
            graphics.drawLine(m_indent, (n + 1) * n2 - 1, m_indent + n4 - 1, (n + 1) * n2 - 1);
        }
        graphics.setFont(font);
        graphics.setColor(color2);
    }

    public static void setIndent(int n) {
        m_indent = n;
    }

    public int getWidth(Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics(m_normalFont);
        int n = fontMetrics.stringWidth(this.m_name + " ");
        return m_indent + n + 1;
    }

    public static void setHoverColor(Color color) {
        m_hoverColor = color;
    }
}

