/*



	Copyright 1992-1999 Hyperion Solutions Corporation. All Rights Reserved.



	RESTRICTED RIGHTS LEGEND:



	Use, duplication, or disclosure by the Government is subject to 

	restrictions as set forth in subparagraph (c)(1)(ii) of the Rights 

	in Technical Data and Computer Software clause at DFARS 252.227-7013, 

	or in the Commercial Computer Software Restricted Rights clause at 

	FAR 52.227-19, as applicable.



	Hyperion Solutions Corporation

	1344 Crossman Avenue, Sunnyvale, CA  94089  USA



	NAME

	cs3.c



	DEPENDENCIES

	You must add ESSAPIN.LIB to your project.

	You must also identify the Essbase/API/Include and Essbase/API/Lib 

	directories to the compiler/linker.



	DESCRIPTION

         This file is used by Hyperion Publications as an extended example of

	 API programming techniques.  This program illustrates the sequence of function

	 call expected by the Essbase server and shows the syntax of actual API function 

	 calls in an actual working program.



	 This program has three sections:

	  1 - the includes and function definitions

	  2 - the function declarations

	  3 - the main program flow

	  



	NOTES





	MODIFIED

	* Created	26July99	Publications

*/



/*************************  Includes and Definitions  *******************************/

/************************************************************************************/







#if defined _WIN32 || defined _WINDOWS

#include <windows.h>

#endif 



#include <string.h>

#include <stdio.h> 

#include <stdlib.h>

#pragma pack (1)

#include <essapi.h>

#include <essotl.h>

#pragma pack ()





ESS_HINST_T  hInst;              

ESS_HCTX_T hCtx;

ESS_SVRNAME_T	srvrName	=	"";

ESS_USERNAME_T	userName	=	"";

ESS_PASSWORD_T	pswd		=	"";



/* Initialization and Login functions */

void ESS_Init();

void ESS_Login();

void ESS_Logout();  

void ESS_Term();

void ESS_AutoLogin();                    

void ESS_GetVersion();

void ESS_GetAPIVersion();            

void ESS_LoginSetPassword();



void ESS_SetActive();

// void ESS_GetActive(); 



void ESS_ListDatabases();

void ESS_UnloadDb();

void ESS_ClearDatabase();    



/* Report - updating - Calculation */

void ESS_Report();

void ESS_RunRept ();  

void ESS_ReportFile ();



void ESS_Update();

void ESS_UpdateFile();



void ESS_Calc();

void ESS_CalcLine();

void ESS_RunCalc ();

void ESS_CalcFile();

void ESS_Import ();



void ESS_Free();





/**********************  START FUNCTION DECLARATIONS  *******************************/

/************************************************************************************/

void ESS_Init()

{

    ESS_STS_T    sts;

    ESS_INIT_T InitStruct = {ESS_API_VERSION,

     							NULL,

     							0L,

     							255,

     							NULL,

     							NULL,

     							NULL,

     							NULL,

     							NULL,

								NULL,

								NULL,

     							0L

     						};  

   if ((sts = EssInit(&InitStruct, &hInst)) != ESS_STS_NOERR)

   {       printf("EssInit failure: %ld\n", sts);

      exit ((int) sts);

   }

   printf("EssInit sts: %ld\n", sts);  

}    

  

/************************************************************************************/

void ESS_Login ()

{

   ESS_STS_T sts = ESS_STS_NOERR;                                    

   ESS_USHORT_T Items;

   ESS_PAPPDB_T pAppsDbs = NULL;

    

   sts = EssLogin (hInst, srvrName, userName, pswd, &Items, &pAppsDbs, &hCtx);

   printf("EssLogin sts: %ld\r\n", sts);

   if ( (sts == 1051093L) || (sts == 1051090L) )

   {	ESS_LoginSetPassword(); }

   else 

   if ( (sts != 0) && (sts != 1051093L) && (sts != 1051090L) )

   {   printf("\n\tUsage:  MAINAPI servername username password\n");

	   printf("\tDefault: \n\tserver name: local\n\tuser name:  admin\n\tpassword:  password\n");

	   exit ((int) sts);

   }

}



/************************************************************************************/

void ESS_AutoLogin ()

{

   ESS_STS_T sts = ESS_STS_NOERR;                                    

   ESS_CHAR_T SvrName[ESS_SVRNAMELEN];		//this is different in VC++6

   ESS_CHAR_T UserName[ESS_USERNAMELEN];

   ESS_CHAR_T Password[ESS_PASSWORDLEN];

   ESS_CHAR_T AppName[ESS_APPNAMELEN];

   ESS_CHAR_T DbName[ESS_DBNAMELEN];

  

   ESS_USHORT_T   Option;

   ESS_ACCESS_T   Access ;

//   ESS_HCTX_T     hCtx;  Don't set this again, it is set at the top

   

   /* Initialize parameters */

   strcpy(SvrName,"localhost");

   strcpy(UserName,"Admin");

   strcpy(Password,"Password");

   strcpy(AppName,"");

   strcpy(DbName,"");

   Option = AUTO_DEFAULT;

   

   /* Login to Essbase server */

   sts = EssAutoLogin (hInst, SvrName, UserName, Password,

                 AppName, DbName, Option, &Access, &hCtx);

   printf("EssAutoLogin sts: %ld\r\n", sts);

}   



/************************************************************************************/

void ESS_LoginSetPassword()

{

   ESS_STS_T sts = ESS_STS_NOERR;                                    

   ESS_USHORT_T Items;

   ESS_PAPPDB_T pAppsDbs = NULL;

   ESS_PASSWORD_T newPswd = "password2";

    

   sts = EssLoginSetPassword (hInst, srvrName, userName, pswd, newPswd, &Items, &pAppsDbs, &hCtx);

   printf("EssLoginSetPassword sts: %ld\r\n", sts);

   if (sts)

   {   printf("\n\tEssLoginSetPassword sts: %ld\n",sts);

	   exit ((int) sts);

   }

}



/************************************************************************************/

void ESS_GetAPIVersion()

{     

   ESS_STS_T    sts = ESS_STS_NOERR;   

   ESS_ULONG_T  Version;                                   

   

   sts = EssGetAPIVersion(&Version); 

   

   if(!sts)

      printf("API Version %#x\n",Version);

}



/************************************************************************************/

void ESS_Term()

{     

   ESS_STS_T sts = ESS_STS_NOERR;                                    

   if ((sts = EssTerm(hInst)) != ESS_STS_NOERR)

   {

      /* error terminating API */

      exit((ESS_USHORT_T) sts);

   }

   printf("EssTerm sts: %ld\r\n", sts);

}



/************************************************************************************/

void ESS_Logout()

{

   ESS_STS_T sts = ESS_STS_NOERR;

   

   sts = EssLogout (hCtx);

   printf("\n\nEssLogout sts: %ld\n",sts);

}



/************************************************************************************/

void ESS_GetVersion()

{

   ESS_STS_T sts = ESS_STS_NOERR;

   ESS_USHORT_T Release;

   ESS_USHORT_T Version;

   ESS_USHORT_T Revision;

   

   sts = EssGetVersion (hCtx, &Release, &Version, &Revision);

   printf("EssGetVersion sts: %ld\r\n", sts);

   

   if(!sts)

   {

     printf("\r\nEssbase Application Server -  Version %d.%d.%d\r\n", Release, Version, Revision);

   }

}



/************************************************************************************/

void ESS_GetActive()

{

   ESS_STS_T sts = ESS_STS_NOERR;

   ESS_STR_T pDbName;

   ESS_STR_T pAppName;

   ESS_ACCESS_T Access;

   

   if((sts = EssAlloc (hInst, 80, (ESS_PPVOID_T)&pAppName)) == 0)

   {

      if((sts = EssAlloc (hInst, 80, (ESS_PPVOID_T)&pDbName)) == 0)

      {

         if((sts = EssGetActive(hCtx, &pAppName, &pDbName, &Access)) == 0)

         {

            if(pAppName)

            {

               if(*pAppName)

                  printf("Current active application is [%s]\r\n",pAppName);

               else

                  printf("No active Application is set\r\n");

            }

            EssFree(hInst, pDbName);

         }

         EssFree(hInst, pAppName);     

      }

   }

}     





/************************************************************************************/

void ESS_SetActive()

{

   ESS_STS_T sts = ESS_STS_NOERR;

   ESS_ACCESS_T Access;

   ESS_STR_T AppName;

   ESS_STR_T DbName;

   

   AppName = "sample";

   DbName = "basic";

   sts = EssSetActive(hCtx, AppName, DbName, &Access);

   printf("EssSetActive sts: %ld\r\n",sts);

}

   

/************************************************************************************/

void ESS_ListDatabases()

{

   ESS_STS_T sts = ESS_STS_NOERR;

   ESS_USHORT_T Items;

   ESS_USHORT_T ind;

   ESS_PAPPDB_T pAppsDbs = NULL;

   

   sts = EssListDatabases(hCtx, NULL, &Items, &pAppsDbs);    

   printf("EssListDatabases sts: %ld\r\n",sts);

   

   if(!sts)

   {

      if(Items && pAppsDbs)

      {

         printf("\r\n--Applications/databases available--\r\n");

         for (ind = 0; ind<Items; ind++)

         {

            if((pAppsDbs+ind) !=NULL)

            {

               if((pAppsDbs[ind].AppName != NULL) && (pAppsDbs[ind].DbName != NULL))

               {

                  printf("%s",pAppsDbs[ind].AppName);

                  printf(" ==> ");

                  printf("%s",pAppsDbs[ind].DbName);

                  printf("\n\r");

               }

            }

         }

         EssFree(hInst, pAppsDbs);

      }

      else

         printf("\r\nDatabase List is Empty\r\n\r\n");

   }

}



/************************************************************************************/

void ESS_ClearDatabase()

{

   ESS_STS_T sts = ESS_STS_NOERR;

   

   sts = EssClearDatabase(hCtx);

   printf("EssClearDatabase sts:%ld\r\n",sts);

   printf("The database is now empty\n");

}



/************************************************************************************/

void ESS_Report()

{

   ESS_STS_T sts = ESS_STS_NOERR;

   ESS_STR_T rString;

   ESS_CHAR_T	 pszReportIn[512];

   	strcpy(pszReportIn, 

	" {TABDELIMIT} \

{SUPALL COLHEADING NAMESON BLOCKHEADERS PAGEHEAD INDENTGEN 2 DECIMALS \

VARIABLE} \

	{BRACKET} \

<SINGLECOLUMN \

<QUOTEMBRNAMES \

	{SUPMISSING} \

<BOTTOM ( 4, @DATACOL(1) ) \

<SYM \

<PAGE( 'Measures') \

'Measures' \

<COL( 'Market','Scenario') \

	{ OUTALTNAMES } \

<ICHILDREN 'Market' \

'Actual' \

'Budget' \

<ROW( 'Year','Product') \

<ICHILDREN 'Year' \

<DIMBOTTOM 'Product' \

! " );



   sts = EssReport (hCtx, ESS_TRUE, ESS_FALSE, pszReportIn);

   //sts = EssReport (hCtx, ESS_TRUE, ESS_FALSE, "<Desc &ThisMonth !");

   //sts = EssReport (hCtx, ESS_TRUE, ESS_FALSE, "<Desc Year !");

   printf("EssReport sts: %ld\r\n",sts);

   

   if(!sts)

      sts = EssGetString(hCtx, &rString);

   while ((!sts) && (rString != NULL))

   {

      printf("%s", rString);

      EssFree (hInst, rString);

      sts = EssGetString (hCtx, &rString);

   }

   printf("\r\n");

}



/************************************************************************************/

void ESS_Update()

{

   ESS_STS_T sts = ESS_STS_NOERR;

   

   sts = EssUpdate(hCtx, ESS_TRUE, ESS_FALSE, "Year Market Scenario Measures Product 123456");

   printf("EssUpdate sts: %ld\r\n",sts);

}

       

/************************************************************************************/

void ESS_CalcLine()

{

   ESS_STS_T	    sts = ESS_STS_NOERR;

   ESS_STR_T        Script;

   ESS_PROCSTATE_T  pState; 



   Script = "CALC DIM (Measures, Product, Market, Year, Scenario);";



   sts = EssCalc(hCtx, ESS_TRUE, Script);

   printf("EssCalc sts: %ld\r\n",sts);



   if (!sts)

   {

      sts = EssGetProcessState (hCtx, &pState);

      while (!sts || (pState.State != ESS_STATE_DONE))

            sts = EssGetProcessState (hCtx, &pState);      

   }

}



/************************************************************************************/

void ESS_Calc()

{

   ESS_STS_T	     sts = ESS_STS_NOERR;

   ESS_STR_T         Script;

   ESS_PROCSTATE_T   pState; 

   Script = "CALC ALL;";

            

   sts = EssBeginCalc (hCtx,ESS_TRUE);  

   printf("EssBeginCalc sts: %ld\r\n",sts);

   if (!sts)                                

   {

      sts = EssSendString (hCtx, Script);  

      printf("EssSendString sts: %ld\r\n",sts);

   }

   if (!sts)

   {

      sts = EssEndCalc (hCtx);             

      printf("EssEndCalc sts: %ld\r\n",sts);

   }

   if (!sts)

   {

      sts = EssGetProcessState (hCtx, &pState);

      while(!sts || (pState.State != ESS_STATE_DONE))

         sts = EssGetProcessState (hCtx, &pState);   

   }

}

 

/************************************************************************************/

void ESS_ReportFile ()

{

   ESS_STS_T	sts = ESS_STS_NOERR;

   ESS_HCTX_T   hSrcCtx;

   ESS_STR_T    rString;

   ESS_STR_T    AppName;

   ESS_STR_T    DbName;

   ESS_STR_T    FileName;

      

   hSrcCtx = hCtx;

   AppName = "Sample";

   DbName  = "Basic";

   FileName = "cdlockdb";

      

   sts = EssReportFile (hCtx, hSrcCtx, AppName, DbName, FileName,

                        ESS_TRUE, ESS_FALSE);   

   printf("EssReportFile sts: %ld\r\n",sts);                        

  

   if (!sts)

      sts = EssGetString (hCtx, &rString);

   while ((!sts) && (rString != NULL))

   {

      printf ("%s", rString);

      EssFree (hInst, rString);

      sts = EssGetString (hCtx,&rString);

   }

}



/************************************************************************************/

void ESS_UpdateFile ()

{

   ESS_STS_T	sts = ESS_STS_NOERR;

   ESS_HCTX_T   hSrcCtx;

   ESS_BOOL_T	isStore;

   ESS_BOOL_T	isUnlock;

   ESS_STR_T    AppName;

   ESS_STR_T    DbName;

   ESS_STR_T    FileName;

   

   AppName  = "Sample";

   DbName   = "Basic";

   hSrcCtx  = hCtx; 

   FileName = "cdupdtdb.txt";

   isStore  = ESS_TRUE;

   isUnlock = ESS_FALSE;



   sts = EssUpdateFile (hCtx, hSrcCtx, AppName, DbName, FileName, isStore, isUnlock);

   printf("EssUpdateFile sts: %ld\r\n",sts);                        

}



/************************************************************************************/

void ESS_RunCalc ()

{

   ESS_STS_T		sts = ESS_STS_NOERR;

   ESS_HCTX_T		hSrcCtx;

   ESS_BOOL_T		isObject = ESS_FALSE; 

   ESS_STR_T		AppName;

   ESS_STR_T		DbName;

   ESS_STR_T		FileName;

   ESS_PROCSTATE_T	pState;

   

   hSrcCtx  = hCtx;

   AppName  = "Sample";

   DbName   = "Basic";

   FileName = "calc5dim"; 

   

    sts = EssCalcFile (hCtx, hSrcCtx, AppName, DbName, FileName, ESS_TRUE);

    printf("EssCalcFile sts: %ld\r\n",sts);                        



   if (!sts)

   {

      sts = EssGetProcessState (hCtx, &pState);

      while (!sts || (pState.State != ESS_STATE_DONE))

            sts = EssGetProcessState (hCtx, &pState);

   }

}



/************************************************************************************/

void ESS_Import ()

{

   eSS_STS_T       sts = eSS_STS_NOERR;

   eSS_SHORT_T     isAbortOnError;

   eSS_OBJDEF_T    Rules;

   eSS_OBJDEF_T    Data;

   eSS_PMBRERR_T   pMbrErr = NULL;

      

   Data.hCtx      = hCtx;

   Data.AppName   = "Sample";

   Data.DbName    = "Basic";

   Data.ObjType   = ESS_OBJTYPE_TEXT;

   Data.FileName  = "calcdat.txt";

   

   Rules.hCtx     = hCtx;

   Rules.AppName  = "Olap";

   Rules.DbName   = "Demo";

   Rules.ObjType  = eSS_OBJTYPE_RULES;

   Rules.FileName = "Actmap";

       

    //* Running conditions *



   isAbortOnError = eSS_TRUE;

   

   sts = EssImport (hCtx, NULL, &Data, &pMbrErr, NULL, isAbortOnError);

   printf("EssImport sts: %ld\r\n",sts);

   

   if(pMbrErr)

      EssFreeMbrErr(hCtx, pMbrErr);

}





/************************************************************************************/

/*

	This routine gets arguments from the command line.  The routine understands a number of

	arguments will be present up to 3 arguments total.  The first parameter, argc, is the 

	number of arguments present following the command to start (csamp3). The second parameter,

	argv, is the array of arguments. This program (csamp3) has been built to override the 

	command line arguments, but could be easily modified to use them. In other words,

	this routine is not used.

*/



void getCmdLineArgs(int argc, char *argv[])

{

   if (argc>1)

	strcpy(srvrName,argv[1]);

   if (argc>2)

	   strcpy(userName,argv[2]);

   if (argc>3)

	   strcpy(pswd,argv[3]);



    printf("Server name:  %s\n",srvrName);

    printf("User name:  %s\n",userName);

    printf("Password:  %s\n",pswd);

}



/*************************  Program Main Flow  **************************************/

/************************************************************************************/



void main(int argc, char *argv[])

{                 



	getCmdLineArgs(argc,argv);



   /**** Initialization and Login Functions ****/

   

   ESS_Init();

   ESS_AutoLogin();  

   ESS_GetVersion();   

   ESS_GetAPIVersion();   

   ESS_SetActive();

   ESS_ListDatabases();         

   

   /**** Report and Updating Calculation ****/   

   /*

	This section issues a report to show what is in the database, then clears all the data,

	runs another report to show that the database is empty, then imports data from

	calcdat.txt, then finally, issues another report to show that the database now

	has data.  

   */



    ESS_Report();

	ESS_ClearDatabase();    

    ESS_Report();

    ESS_Import ();

    ESS_Report();

  

   /*

	This section runs a calculation from a file.  (ESS_RunCalc calls EssCalcFile, which 

	specifies the calculation script in the file calc5dim.csc.) 

	Then issues yet another report to show the results. 

   */



    ESS_CalcLine();  

	ESS_Report();



	ESS_ReportFile();

	ESS_UpdateFile();

	ESS_ReportFile();



	ESS_Logout(); 

    ESS_Term();   

}

/*

End of program cs3.c

*/

