@
CREATE PROCEDURE VO.XWishedtitlesAdd(
      IN MID    INT,
      IN TITLES VARCHAR(4000))
    RESULT SETS 0
    LANGUAGE SQL
------------------------------------------------------------------------
-- Add multiple titles to wished titles list
------------------------------------------------------------------------
P1: BEGIN
    DECLARE MYERRORCODE CHAR(5);
    DECLARE SQLSTATE CHAR(5);
    DECLARE SQLCODE INT;

    DECLARE TID INT;
    DECLARE at_end INT DEFAULT 0;

    DECLARE cursor1 CURSOR FOR
      SELECT TitleID
      FROM   TABLE (VO.XWishedTitles(Titles)) AS T;

    DECLARE CONTINUE HANDLER FOR SQLEXCEPTION SET MYERRORCODE = SQLSTATE;
    DECLARE CONTINUE HANDLER FOR not found SET at_end = 1;

    OPEN cursor1;

    FETCH cursor1 INTO TID;
    WHILE (at_end = 0) DO
      INSERT
        INTO   VO.WISHEDTITLES ( CUSTOMERID, TITLEID, DATEADDED )
        VALUES ( MID, TID, CURRENT DATE );

      FETCH cursor1 INTO TID;
    END WHILE;
    CLOSE cursor1;
END P1
@
