/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cli.traceparse;

import com.ibm.db2.cli.traceparse.CLIAPIFunction;
import com.ibm.db2.cli.traceparse.CLIAttribute;
import com.ibm.db2.cli.traceparse.CLIConnection;
import com.ibm.db2.cli.traceparse.CLIDescriptor;
import com.ibm.db2.cli.traceparse.CLIEnvironment;
import com.ibm.db2.cli.traceparse.CLIHandle;
import com.ibm.db2.cli.traceparse.CLIStatement;
import com.ibm.db2.cli.traceparse.InvalidCliTraceErrorCodes;
import com.ibm.db2.cli.traceparse.InvalidCliTraceException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CLITrace
implements Serializable,
InvalidCliTraceErrorCodes {
    private Vector statements;
    private Vector environmentHandles;
    private Vector connectionHandles;
    private Vector statementHandles;
    private Vector descriptorHandles;
    private Vector errors;
    private Vector connections;
    private double appProcessingTime;
    private double cliProcessingTime;
    private double netSendProcessingTime;
    private double netRecvProcessingTime;
    private long sendFlows;
    private long recvFlows;
    private long bytesSent;
    private long bytesRecd;
    private Hashtable apiCallInfo;
    private static final int APPLICATION = 0;
    private static final int CLIPROCESSING = 1;
    private static final int INITIALCAPACITY = 150;
    private final int CAPACITY = 115;
    private String cliTraceBuild;
    private boolean headerComplete;
    private String pidtidInfo;
    private String dateTime;
    private String clientProduct;
    private String clientLevel;
    private String driverVersion;
    private String informationalTokens;
    private int cliTraceVersion;
    private long numberOfStatements;
    private CLIAPIFunction currentFunction;
    private boolean conserveMemory;

    CLITrace() {
        this.conserveMemory = false;
        this.cliTraceVersion = 6;
        this.headerComplete = false;
    }

    CLITrace(boolean bl) {
        this.conserveMemory = bl;
        this.cliTraceVersion = 6;
        this.headerComplete = false;
    }

    protected void addDescriptorHandle(CLIDescriptor cLIDescriptor) {
        if (this.descriptorHandles == null) {
            this.descriptorHandles = new Vector();
        }
        this.descriptorHandles.addElement(cLIDescriptor);
    }

    protected void addEnvironmentHandle(CLIEnvironment cLIEnvironment) {
        if (this.environmentHandles == null) {
            this.environmentHandles = new Vector();
        }
        this.environmentHandles.addElement(cLIEnvironment);
    }

    public void addError(CLIAPIFunction cLIAPIFunction) {
        if (this.errors == null) {
            this.errors = new Vector();
        }
        this.errors.addElement(cLIAPIFunction);
    }

    protected void addInformationalMessage(String string) throws InvalidCliTraceException {
        if (string == null) {
            throw new InvalidCliTraceException("Invalid return code.");
        }
        if ((this.currentFunction.getClass().getName().equals("com.ibm.db2.cli.traceparse.SQLDriverConnectW") || this.currentFunction.getClass().getName().equals("com.ibm.db2.cli.traceparse.SQLDriverConnect") || this.currentFunction.getClass().getName().equals("com.ibm.db2.cli.traceparse.SQLConnect") || this.currentFunction.getClass().getName().equals("com.ibm.db2.cli.traceparse.SQLConnectW")) && (string.startsWith("( DBMS") || string.startsWith("( Application Codepage"))) {
            this.currentFunction.setConnectInformation(string);
        }
    }

    public void addConnectionInfo(CLIAPIFunction cLIAPIFunction) {
        if (this.connections == null) {
            this.connections = new Vector();
        }
        this.connections.addElement(cLIAPIFunction);
    }

    protected void addStatementHandle(CLIStatement cLIStatement) {
        if (this.statementHandles == null) {
            this.statementHandles = new Vector();
        }
        this.statementHandles.addElement(cLIStatement);
    }

    public boolean conserveMemory() {
        return this.conserveMemory;
    }

    protected CLIConnection getConnectionHandle(int n) {
        if (this.connectionHandles == null) {
            return null;
        }
        return (CLIConnection)this.getHandle(this.connectionHandles, n);
    }

    protected CLIDescriptor getDescriptorHandle(int n) {
        if (this.descriptorHandles == null) {
            return null;
        }
        return (CLIDescriptor)this.getHandle(this.descriptorHandles, n);
    }

    protected CLIEnvironment getEnvironmentHandle(int n) {
        if (this.environmentHandles == null) {
            return null;
        }
        return (CLIEnvironment)this.getHandle(this.environmentHandles, n);
    }

    public Enumeration getConnections() {
        if (this.connections == null) {
            return null;
        }
        return this.connections.elements();
    }

    public Enumeration getErrors() {
        if (this.errors == null) {
            return null;
        }
        return this.errors.elements();
    }

    public Enumeration getFunctionStatistics() {
        if (this.apiCallInfo != null) {
            return this.apiCallInfo.elements();
        }
        return null;
    }

    private CLIHandle getHandle(Vector vector, int n) {
        int n2 = vector.size();
        for (int i = n2 - 1; i >= 0; --i) {
            CLIHandle cLIHandle = (CLIHandle)vector.elementAt(i);
            if (cLIHandle.getHandleNumber() != n) continue;
            return cLIHandle;
        }
        return null;
    }

    public long getNumberOfStatements() {
        return this.numberOfStatements;
    }

    public CLIAPIFunction getStatement(int n) {
        if (this.statements == null || n >= this.statements.size()) {
            return null;
        }
        return (CLIAPIFunction)this.statements.elementAt(n - 1);
    }

    protected CLIStatement getStatementHandle(int n) {
        if (this.statementHandles == null) {
            return null;
        }
        return (CLIStatement)this.getHandle(this.statementHandles, n);
    }

    public double getTotalAppProcessingTime() {
        return this.appProcessingTime;
    }

    public long getTotalBytesRecd() {
        return this.bytesRecd;
    }

    public long getTotalBytesSent() {
        return this.bytesSent;
    }

    public double getTotalCliProcessingTime() {
        return this.cliProcessingTime;
    }

    public long getTotalNetworkRecvFlows() {
        return this.recvFlows;
    }

    public double getTotalNetworkRecvProcessingTime() {
        return this.netRecvProcessingTime;
    }

    public long getTotalNetworkSendFlows() {
        return this.sendFlows;
    }

    public double getTotalNetworkSendProcessingTime() {
        return this.netSendProcessingTime;
    }

    public double getTotalTraceTime() {
        return this.appProcessingTime + this.cliProcessingTime;
    }

    public String getTraceBuild() {
        return this.cliTraceBuild;
    }

    public String getPIDInfo() {
        return this.pidtidInfo;
    }

    public String getDateTime() {
        return this.dateTime;
    }

    public String getClientProduct() {
        return this.clientProduct;
    }

    public String getClientLevel() {
        return this.clientLevel;
    }

    public String getDriverVersion() {
        return this.driverVersion;
    }

    public String getInformationalTokens() {
        return this.informationalTokens;
    }

    public void parseAppTimeElapsed(String string) throws InvalidCliTraceException {
        double d;
        if (!(string != null && string.length() >= 35 || string.startsWith("---> Time elapsed - 0 seconds"))) {
            throw new InvalidCliTraceException("Invalid time elapsed string.");
        }
        try {
            d = string.length() < 35 ? 0.0 : new Double(string.substring(20, 34));
        }
        catch (NumberFormatException numberFormatException) {
            d = 0.0;
        }
        this.appProcessingTime += d;
        this.updateTimeElapsed(0, d);
        this.currentFunction.setAppProcessingTime(d);
    }

    private String parseCLIFunctionName(String string) {
        int n = string.indexOf(40);
        if (n > 0) {
            return string.substring(0, n);
        }
        return null;
    }

    private Enumeration parseCliFunctionValues(String string) throws InvalidCliTraceException {
        int n = string.indexOf("(") + 1;
        Vector<CLIAttribute> vector = new Vector<CLIAttribute>();
        int n2 = string.indexOf("=", n);
        while (n < n2) {
            CLIAttribute cLIAttribute = new CLIAttribute();
            cLIAttribute.setAttributeName(string.substring(n + 1, n2));
            n = n2 + 1;
            if (string.charAt(n) == '\"') {
                n2 = string.indexOf("\", ", n + 1) + 1;
                if (n2 == 0) {
                    n2 = string.length() - 2;
                }
                cLIAttribute.setAttributeValue(string.substring(n + 1, n2 - 1));
            } else {
                n2 = string.indexOf(",", n);
                if (n2 == -1) {
                    n2 = string.length() - 2;
                }
                cLIAttribute.setAttributeValue(string.substring(n, n2));
            }
            vector.addElement(cLIAttribute);
            n = n2 + 1;
            n2 = string.indexOf("=", n);
        }
        return vector.elements();
    }

    public void parseReturnCode(String string) throws InvalidCliTraceException, Exception {
        double d;
        if (string == null) {
            throw new InvalidCliTraceException("Invalid return code.");
        }
        this.currentFunction.setReturnCode(string.substring(5, string.indexOf(" ", 5)));
        int n = string.indexOf("Time elapsed - ") + "Time elapsed - ".length() + 1;
        try {
            d = new Double(string.substring(n, n + 14));
        }
        catch (NumberFormatException numberFormatException) {
            d = 0.0;
        }
        this.cliProcessingTime += d;
        this.updateTimeElapsed(1, d);
        this.currentFunction.setCliProcessingTime(d);
    }

    protected void processCommBuffer(String string) throws InvalidCliTraceException {
        boolean bl = false;
        if (string.startsWith("sqlccsend")) {
            bl = true;
        }
        int n = 0;
        int n2 = 0;
        CliAPICallInfo cliAPICallInfo = (CliAPICallInfo)this.apiCallInfo.get(this.currentFunction.getFunctionName());
        if ((n = string.indexOf("ulBytes - ", n)) != -1) {
            n2 = string.indexOf(" )", n);
            long l = new Long(string.substring(n + "ulBytes - ".length(), n2));
            if (bl) {
                ++this.sendFlows;
                cliAPICallInfo.sendFlows++;
                this.bytesSent += l;
                cliAPICallInfo.bytesSent += l;
            } else {
                ++this.recvFlows;
                cliAPICallInfo.recvFlows++;
                this.bytesRecd += l;
                cliAPICallInfo.bytesRecd += l;
            }
        }
        if ((n = string.indexOf("time elapsed - ", n)) != -1) {
            double d = new Double(string.substring(n++ + "time elapsed - ".length()));
            if (bl) {
                this.netSendProcessingTime += d;
                cliAPICallInfo.netSendProcessingTime += d;
            } else {
                this.netRecvProcessingTime += d;
                cliAPICallInfo.netRecvProcessingTime += d;
            }
        }
    }

    public void processInputValues(String string, long l) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvalidCliTraceException {
        CliAPICallInfo cliAPICallInfo;
        boolean bl = false;
        String string2 = this.parseCLIFunctionName(string);
        if (string2 == null) {
            throw new InvalidCliTraceException("Invalid input values: No function name");
        }
        this.currentFunction = CLIAPIFunction.getFunction(this, string2, ++this.numberOfStatements, l);
        if (this.apiCallInfo == null) {
            this.apiCallInfo = new Hashtable(115);
        }
        if ((cliAPICallInfo = (CliAPICallInfo)this.apiCallInfo.get(string2)) == null) {
            cliAPICallInfo = new CliAPICallInfo();
            bl = true;
            cliAPICallInfo.functionName = string2;
            this.apiCallInfo.put(string2, cliAPICallInfo);
        }
        cliAPICallInfo.timesCalled++;
        if (!this.conserveMemory) {
            if (this.statements == null) {
                this.statements = new Vector(150);
            }
            this.statements.addElement(this.currentFunction);
        }
    }

    public void processReturnValues(String string) throws InvalidCliTraceException {
        String string2;
        if (this.currentFunction == null && (string2 = this.parseCLIFunctionName(string)) == null) {
            throw new InvalidCliTraceException("Invalid output values: No function name");
        }
        try {
            this.currentFunction.setReturnValues(this.parseCliFunctionValues(string));
        }
        catch (InvalidCliTraceException invalidCliTraceException) {
            throw invalidCliTraceException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new InvalidCliTraceException(exception.getMessage());
        }
    }

    public void setBuild(String string) throws InvalidCliTraceException {
        if (this.cliTraceBuild != null) {
            throw new InvalidCliTraceException("Build information already exists.", -2);
        }
        this.cliTraceBuild = string;
    }

    private void updateTimeElapsed(int n, double d) {
        String string = this.currentFunction.getFunctionName();
        CliAPICallInfo cliAPICallInfo = (CliAPICallInfo)this.apiCallInfo.get(string);
        if (n == 0) {
            cliAPICallInfo.appProcessingTime += d;
        } else {
            cliAPICallInfo.cliProcessingTime += d;
        }
    }

    public void setCLITraceVersion(int n) {
        this.cliTraceVersion = n < 7 ? 6 : 7;
    }

    public int getCLITraceVersion() {
        return this.cliTraceVersion;
    }

    public void setHeader(String string) throws InvalidCliTraceException {
        if (this.cliTraceVersion == 6) {
            if (this.cliTraceBuild != null) {
                throw new InvalidCliTraceException("Build already exists.", -2);
            }
            this.cliTraceBuild = string;
        } else {
            if (this.headerComplete) {
                throw new InvalidCliTraceException("Header already exists.", -4);
            }
            if (string.startsWith("[ Process:")) {
                this.pidtidInfo = string;
            } else if (string.startsWith("[ Date & Time:")) {
                this.dateTime = string;
            } else if (string.startsWith("[ Product:")) {
                this.clientProduct = string;
            } else if (string.startsWith("[ Level Identifier:")) {
                this.clientLevel = string;
            } else if (string.startsWith("[ CLI Driver Version:")) {
                this.driverVersion = string;
            } else if (string.startsWith("[ Informational Tokens:")) {
                this.informationalTokens = string;
                this.headerComplete = true;
            }
        }
    }

    public class CliAPICallInfo
    implements Serializable {
        private double appProcessingTime;
        private double cliProcessingTime;
        private double netSendProcessingTime = this.netRecvProcessingTime = (double)0L;
        private double netRecvProcessingTime;
        private long sendFlows = 0L;
        private long recvFlows = 0L;
        private long bytesSent = 0L;
        private long bytesRecd = 0L;
        private long timesCalled = 0L;
        private String functionName;

        private CliAPICallInfo() {
            this.cliProcessingTime = this.netRecvProcessingTime;
            this.appProcessingTime = this.netRecvProcessingTime;
        }

        public double getAppProcessingTime() {
            return this.appProcessingTime;
        }

        public double getCliProcessingTime() {
            return this.cliProcessingTime;
        }

        public double getNetSendProcessingTime() {
            return this.netSendProcessingTime;
        }

        public double getNetRecvProcessingTime() {
            return this.netRecvProcessingTime;
        }

        public long getSendFlows() {
            return this.sendFlows;
        }

        public long getRecvFlows() {
            return this.recvFlows;
        }

        public long getBytesSent() {
            return this.bytesSent;
        }

        public long getBytesRecd() {
            return this.bytesRecd;
        }

        public long getTimesCalled() {
            return this.timesCalled;
        }

        public String getFunctionName() {
            return this.functionName;
        }
    }
}

