@echo off
REM ***************************************************
REM * (c) INTERNATIONAL BUSINESS MACHINES CORPORATION *
REM *              All rights reserved.               *
REM *      Licensed Materials -- Property of IBM.     *
REM * ------------------------------------------------*
REM * IWHREORG.BAT -- This is a sample batch file to  *
REM * invoke the DB2 REORG utility and then the DB2   *
REM * RUNSTATS utility.                               *
REM *                                                 *
REM * NOTE: This batch file can ONLY be invoked from  *
REM *       IWHDB2CL.BAT                              *
REM * NOTE: Parameters %7 and %8 are optional.  They  *
REM *       can be filled in the "Parameters" section *
REM *       of the UDP definition for IWHDB2CL.BAT.   *
REM *       They will only be used if you want to use *
REM *       either the INDEX and/or USE options on    *
REM *       the REORG command.                        *
REM *                                                 *
REM *       "INDEX" tells DB2 to use a given index to *
REM *       reorganize the table. "USE" tells db2 to  *
REM *       use a given tablespace for the reorg.     *
REM *                                                 *
REM *       These parameters must appear AFTER the    *
REM *       path/name of this .bat file in the list   *
REM *       of user-parameters specified in the UDP   *
REM *       definition for IWHDB2CL.BAT. For Example: *
REM *          d:\udp-path\IWHREORG.BAT idx1 tblspc5  *
REM *                                                 *
REM *       THIS BATCH FILE ASSUMES THAT A TABLESPACE *
REM *       NAME WILL ONLY BE PROVIDED IF AN INDEX IS *
REM *       BEING USED FOR THE REORG.  IF YOU WANT TO *
REM *       SPECIFY A TABLESPACE ONLY, YOU WILL HAVE  *
REM *       TO MODIFY THIS .BAT FILE.  HOWEVER, YOU   *   
REM *       CAN SPECIFY AN INDEX TO USE (%7) WITHOUT  *
REM *       SPECIFYING A TABLESPACE NAME (%8).        *
REM ***************************************************
REM parameter %1 is the number of parameters that follow (VW USE ONLY)
REM parameter %2 is the warehouse database name (VW USE ONLY)
REM parameter %3 is the warehouse database userid (VW USE ONLY)
REM parameter %4 is the warehouse database password (VW USE ONLY)
REM parameter %5 is the business view (BV) table name (VW USE ONLY)
REM parameter %6 is the current BV edition number (VW USE ONLY)
REM parameter %7 the name of an index to reorg the table by
REM parameter %8 the name of a tablespace to use for the reorg

REM Initialize the variable to hold the reorg statement
set IWHREORG=reorg table %5

REM Connect to DB2
db2 connect to %2 user %3 using %4

REM If parameter 7 is present, add it and the "INDEX" keyword to the
REM reorg statement.  If you want to use this batch file to ONLY
REM specify the USE (tablespace) parameter, then change the word "INDEX"
REM here to "USE" and get rid of the IF statement for parameter 8.
if not "%7" == "" set IWHREORG=%IWHREORG% INDEX %7

REM If parameter 8 is present, this line adds it and the "USE" keyword 
REM to the reorg command.
if not "%8" == "" set IWHREORG=%IWHREORG% USE %8

REM Do the REORG
db2 %IWHREORG%

REM Run RUNSTATS
db2 runstats on table %5 with distribution and detailed indexes all

REM Disconnect from the database
db2 connect reset
exit
