/**INC+***********************************************************************/
/*                                                                           */
/* Include: appc_c.h                                                         */
/*                                                                           */
/* Purpose: Standard include file for APPC library                           */
/*                                                                           */
/*  COPYRIGHT DATA CONNECTION LIMITED 1989, 1990, 1991, 1992, 1993, 1994,   */
/*                                       1997, 1999                          */
/*                                                                           */
/**INC-***********************************************************************/
#ifndef APPC_C_INCLUDED
#define APPC_C_INCLUDED

#include <values_c.h>

#ifdef __cplusplus
extern "C" {
#endif

/* ========================================================================= */
/*****************************************************************************/
/* ---------------------- APPC function prototype -------------------------- */
/*****************************************************************************/

#define VAV_CALLBACK_VOID void
#if defined (__STDC__) || defined (__cplusplus)
typedef VAV_CALLBACK_VOID  (*VAV_CALLBACK) (void *, unsigned char *,
                                                           AP_UINT32, AP_CORR);
#else
typedef VAV_CALLBACK_VOID  (*VAV_CALLBACK) ( );
#endif
#undef  VAV_CALLBACK_VOID

/*****************************************************************************/
/* APPC API Versions                                                         */
/*****************************************************************************/
#define SNAPIX_API_APPC_VERSION_1       1
#define SNAPIX_API_APPC_VERSION_2       2

/*****************************************************************************/
/* Latest versions of the SNAP-IX APIs.                                      */
/*****************************************************************************/
#define SNAPIX_API_APPC_CURRENT_VERSION     SNAPIX_API_APPC_VERSION_2

#define APPC(X)    appc_c_version(SNAPIX_API_APPC_CURRENT_VERSION, X)
#define APPC_P(X)  appc_c_version(SNAPIX_API_APPC_CURRENT_VERSION, X)
#define APPC_C(X)  appc_c_version(SNAPIX_API_APPC_CURRENT_VERSION, X)

#define APPC_Async(X, Y, Z)   \
                 appc_c_async_version(SNAPIX_API_APPC_CURRENT_VERSION, X, Y, Z)

#if defined (__STDC__) || defined (__cplusplus)
extern void appc_c_version(AP_INT32  version, void *vcb);
extern AP_UINT16      appc_c_async_version(AP_INT32      version,
                                           void         *vcb,
                                           VAV_CALLBACK  callback,
                                           AP_CORR       correlator);
#else
extern void appc_c_version();
extern AP_UINT16      appc_c_async_version();
#endif

/**STRUCT+********************************************************************/
/* Structure: LUWID_OVERLAY                                                  */
/*                                                                           */
/* Description: Identifier for Logical Unit of Work                          */
/*****************************************************************************/
typedef struct luwid_overlay
{
  unsigned char        fq_length;
  unsigned char        fq_luw_name[17];
  unsigned char        instance[6];
  unsigned char        sequence[2];
} LUWID_OVERLAY;
/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: TP_STARTED                                                     */
/*                                                                           */
/* Description: TP_STARTED verb control block                                */
/*****************************************************************************/
typedef struct tp_started
{
  AP_UINT16            opcode;
  unsigned char        opext;
  unsigned char        format;
  AP_UINT16            primary_rc;
  AP_UINT32            secondary_rc;
  unsigned char        lu_alias[8];
  unsigned char        tp_id[8];
  unsigned char        tp_name[64];
  unsigned char        delay_start;
  unsigned char        enable_pool;
  unsigned char        pip_dlen;
} TP_STARTED;
/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: RECEIVE_ALLOCATE                                               */
/*                                                                           */
/* Description: RECEIVE_ALLOCATE verb control block                          */
/*****************************************************************************/
typedef struct receive_allocate
{
  AP_UINT16            opcode;
  unsigned char        opext;
  unsigned char        format;
  AP_UINT16            primary_rc;
  AP_UINT32            secondary_rc;
  unsigned char        tp_name[64];
  unsigned char        tp_id[8];
  AP_UINT32            conv_id;
  unsigned char        sync_level;
  unsigned char        conv_type;
  unsigned char        user_id[10];
  unsigned char        lu_alias[8];
  unsigned char        plu_alias[8];
  unsigned char        mode_name[8];
  unsigned char        reserv3[2];
  AP_UINT32            conv_group_id;
  unsigned char        fqplu_name[17];
  unsigned char        pip_incoming;
  unsigned char        duplex_type;
  unsigned char        reserv4[3];
  unsigned char        password[10];
  unsigned char        reserv5[2];
  unsigned char        dload_id[8];
} RECEIVE_ALLOCATE;
/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: TP_ENDED                                                       */
/*                                                                           */
/* Description: TP_ENDED verb control block                                  */
/*****************************************************************************/
typedef struct tp_ended
{
  AP_UINT16            opcode;
  unsigned char        opext;
  unsigned char        format;
  AP_UINT16            primary_rc;
  AP_UINT32            secondary_rc;
  unsigned char        tp_id[8];
  unsigned char        type;
} TP_ENDED;
/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: ALLOCATE                                                       */
/*                                                                           */
/* Description: ALLOCATE verb control block                                  */
/*****************************************************************************/
typedef struct allocate
{
  AP_UINT16            opcode;
  unsigned char        opext;
  unsigned char        format;
  AP_UINT16            primary_rc;
  AP_UINT32            secondary_rc;
  unsigned char        tp_id[8];
  AP_UINT32            conv_id;
  unsigned char        conv_type;
  unsigned char        sync_level;
  unsigned char        reserv3[2];
  unsigned char        rtn_ctl;
  unsigned char        duplex_type;
  AP_UINT32            conv_group_id;
  AP_UINT32            sense_data;
  unsigned char        plu_alias[8];
  unsigned char        mode_name[8];
  unsigned char        tp_name[64];
  unsigned char        security;
  unsigned char        reserv5[11];
  unsigned char        pwd[10];
  unsigned char        user_id[10];
  AP_UINT16            pip_dlen;
  unsigned char        *pip_dptr;
  unsigned char        reserv5a;
  unsigned char        fqplu_name[17];
  unsigned char        reserv6[8];
} ALLOCATE;
/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: CONFIRM                                                        */
/*                                                                           */
/* Description: CONFIRM verb control block                                   */
/*****************************************************************************/
typedef struct confirm
{
  AP_UINT16            opcode;
  unsigned char        opext;
  unsigned char        format;
  AP_UINT16            primary_rc;
  AP_UINT32            secondary_rc;
  unsigned char        tp_id[8];
  AP_UINT32            conv_id;
  unsigned char        rts_rcvd;
  unsigned char        expd_rcvd;
} CONFIRM;
/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: CONFIRMED                                                      */
/*                                                                           */
/* Description: CONFIRMED verb control block                                 */
/*****************************************************************************/
typedef struct confirmed
{
  AP_UINT16            opcode;
  unsigned char        opext;
  unsigned char        format;
  AP_UINT16            primary_rc;
  AP_UINT32            secondary_rc;
  unsigned char        tp_id[8];
  AP_UINT32            conv_id;
} CONFIRMED;
/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: DEALLOCATE                                                     */
/*                                                                           */
/* Description: DEALLOCATE verb control block                                */
/*****************************************************************************/
typedef struct deallocate
{
  AP_UINT16            opcode;
  unsigned char        opext;
  unsigned char        format;
  AP_UINT16            primary_rc;
  AP_UINT32            secondary_rc;
  unsigned char        tp_id[8];
  AP_UINT32            conv_id;
  unsigned char        expd_rcvd;
  unsigned char        dealloc_type;
  AP_UINT16            log_dlen;
  unsigned char        *log_dptr;
  void                 (*callback)();
  void                 *correlator;
  unsigned char        reserv6[4];
} DEALLOCATE;
/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: FLUSH                                                          */
/*                                                                           */
/* Description: FLUSH verb control block                                     */
/*****************************************************************************/
typedef struct flush
{
  AP_UINT16            opcode;
  unsigned char        opext;
  unsigned char        format;
  AP_UINT16            primary_rc;
  AP_UINT32            secondary_rc;
  unsigned char        tp_id[8];
  AP_UINT32            conv_id;
} FLUSH;
/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: GET_ATTRIBUTES                                                 */
/*                                                                           */
/* Description: GET_ATTRIBUTES verb control block                            */
/*****************************************************************************/
typedef struct get_attributes
{
  AP_UINT16            opcode;
  unsigned char        opext;
  unsigned char        format;
  AP_UINT16            primary_rc;
  AP_UINT32            secondary_rc;
  unsigned char        tp_id[8];
  AP_UINT32            conv_id;
  unsigned char        reserv3;
  unsigned char        sync_level;
  unsigned char        mode_name[8];
  unsigned char        net_name[8];
  unsigned char        lu_name[8];
  unsigned char        lu_alias[8];
  unsigned char        plu_alias[8];
  unsigned char        plu_un_name[8];
  unsigned char        reserv4[2];
  unsigned char        fqplu_name[17];
  unsigned char        reserv5;
  unsigned char        user_id[10];
  AP_UINT32            conv_group_id;
  unsigned char        conv_corr_len;
  unsigned char        conv_corr[8];
  unsigned char        reserv6[13];
  LUWID_OVERLAY        luw_id;
  unsigned char        sess_id[8];
} GET_ATTRIBUTES;
/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: PREPARE_TO_RECEIVE                                             */
/*                                                                           */
/* Description: PREPARE_TO_RECEIVE verbtrol block                            */
/*****************************************************************************/
typedef struct prepare_to_receive
{
  AP_UINT16            opcode;
  unsigned char        opext;
  unsigned char        format;
  AP_UINT16            primary_rc;
  AP_UINT32            secondary_rc;
  unsigned char        tp_id[8];
  AP_UINT32            conv_id;
  unsigned char        ptr_type;
  unsigned char        locks;
} PREPARE_TO_RECEIVE;
/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: RECEIVE_AND_POST                                               */
/*                                                                           */
/* Description: RECEIVE_AND_POST verb control block                          */
/*****************************************************************************/
typedef struct receive_and_post
{
  AP_UINT16            opcode;
  unsigned char        opext;
  unsigned char        format;
  AP_UINT16            primary_rc;
  AP_UINT32            secondary_rc;
  unsigned char        tp_id[8];
  AP_UINT32            conv_id;
  AP_UINT16            what_rcvd;
  unsigned char        rtn_status;
  unsigned char        fill;
  unsigned char        rts_rcvd;
  unsigned char        expd_rcvd;
  AP_UINT16            max_len;
  AP_UINT16            dlen;
  unsigned char        *dptr;
  void                 (*callback)();
  unsigned char        reserv5;
} RECEIVE_AND_POST;
/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: RECEIVE_AND_WAIT                                               */
/*                                                                           */
/* Description: RECEIVE_AND_WAIT verb control block                          */
/*****************************************************************************/
typedef struct receive_and_wait
{
  AP_UINT16            opcode;
  unsigned char        opext;
  unsigned char        format;
  AP_UINT16            primary_rc;
  AP_UINT32            secondary_rc;
  unsigned char        tp_id[8];
  AP_UINT32            conv_id;
  AP_UINT16            what_rcvd;
  unsigned char        rtn_status;
  unsigned char        fill;
  unsigned char        rts_rcvd;
  unsigned char        expd_rcvd;
  AP_UINT16            max_len;
  AP_UINT16            dlen;
  unsigned char        *dptr;
  unsigned char        reserv5[5];
} RECEIVE_AND_WAIT;
/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: RECEIVE_EXPEDITED_DATA                                         */
/*                                                                           */
/* Description: RECEIVE_EXPEDITED_DATA verb control block                    */
/*****************************************************************************/
typedef struct receive_expedited_data
{
  AP_UINT16            opcode;
  unsigned char        opext;
  unsigned char        format;
  AP_UINT16            primary_rc;
  AP_UINT32            secondary_rc;
  unsigned char        tp_id[8];
  AP_UINT32            conv_id;
  unsigned char        rtn_ctl;
  unsigned char        reserv1[3];
  unsigned char        rts_rcvd;
  unsigned char        expd_rcvd;
  AP_UINT16            max_len;
  AP_UINT16            dlen;
  unsigned char        *dptr;
} RECEIVE_EXPEDITED_DATA;
/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: RECEIVE_IMMEDIATE                                              */
/*                                                                           */
/* Description: RECEIVE_IMMEDIATE verb control block                         */
/*****************************************************************************/
typedef struct receive_immediate
{
  AP_UINT16            opcode;
  unsigned char        opext;
  unsigned char        format;
  AP_UINT16            primary_rc;
  AP_UINT32            secondary_rc;
  unsigned char        tp_id[8];
  AP_UINT32            conv_id;
  AP_UINT16            what_rcvd;
  unsigned char        rtn_status;
  unsigned char        fill;
  unsigned char        rts_rcvd;
  unsigned char        expd_rcvd;
  AP_UINT16            max_len;
  AP_UINT16            dlen;
  unsigned char        *dptr;
  unsigned char        reserv5[5];
} RECEIVE_IMMEDIATE;
/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: REQUEST_TO_SEND                                                */
/*                                                                           */
/* Description: REQUEST_TO_SEND verb control block                           */
/*****************************************************************************/
typedef struct request_to_send
{
  AP_UINT16            opcode;
  unsigned char        opext;
  unsigned char        format;
  AP_UINT16            primary_rc;
  AP_UINT32            secondary_rc;
  unsigned char        tp_id[8];
  AP_UINT32            conv_id;
} REQUEST_TO_SEND;
/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: SEND_CONVERSATION                                              */
/*                                                                           */
/* Description: SEND_CONVERSATION verb control block                         */
/*****************************************************************************/
typedef struct send_conversation
{
  AP_UINT16            opcode;
  unsigned char        opext;
  unsigned char        format;
  AP_UINT16            primary_rc;
  AP_UINT32            secondary_rc;
  unsigned char        tp_id[8];
  unsigned char        reserv3[8];
  unsigned char        rtn_ctl;
  unsigned char        reserv4;
  AP_UINT32            conv_group_id;
  AP_UINT32            sense_data;
  unsigned char        plu_alias[8];
  unsigned char        mode_name[8];
  unsigned char        tp_name[64];
  unsigned char        security;
  unsigned char        reserv5[11];
  unsigned char        pwd[10];
  unsigned char        user_id[10];
  AP_UINT16            pip_dlen;
  unsigned char        *pip_dptr;
  unsigned char        reserv5a;
  unsigned char        fqplu_name[17];
  unsigned char        reserv6[8];
  AP_UINT16            dlen;
  unsigned char        *dptr;
} SEND_CONVERSATION;
/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: SEND_DATA                                                      */
/*                                                                           */
/* Description: SEND_DATA verb control block                                 */
/*****************************************************************************/
typedef struct send_data
{
  AP_UINT16            opcode;
  unsigned char        opext;
  unsigned char        format;
  AP_UINT16            primary_rc;
  AP_UINT32            secondary_rc;
  unsigned char        tp_id[8];
  AP_UINT32            conv_id;
  unsigned char        rts_rcvd;
  unsigned char        expd_rcvd;
  AP_UINT16            dlen;
  unsigned char        *dptr;
  unsigned char        type;
  unsigned char        reserv4;
} SEND_DATA;
/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: SEND_ERROR                                                     */
/*                                                                           */
/* Description: SEND_ERROR verb control block                                */
/*****************************************************************************/
typedef struct send_error
{
  AP_UINT16            opcode;
  unsigned char        opext;
  unsigned char        format;
  AP_UINT16            primary_rc;
  AP_UINT32            secondary_rc;
  unsigned char        tp_id[8];
  AP_UINT32            conv_id;
  unsigned char        rts_rcvd;
  unsigned char        err_type;
  unsigned char        err_dir;
  unsigned char        expd_rcvd;
  AP_UINT16            log_dlen;
  unsigned char        *log_dptr;
} SEND_ERROR;
/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: SEND_EXPEDITED_DATA                                            */
/*                                                                           */
/* Description: SEND_EXPEDITED_DATA verb control block                       */
/*****************************************************************************/
typedef struct send_expedited_data
{
  AP_UINT16            opcode;
  unsigned char        opext;
  unsigned char        format;
  AP_UINT16            primary_rc;
  AP_UINT32            secondary_rc;
  unsigned char        tp_id[8];
  AP_UINT32            conv_id;
  unsigned char        rts_rcvd;
  unsigned char        expd_rcvd;
  AP_UINT16            dlen;
  unsigned char        *dptr;
  unsigned char        reserv4[2];
} SEND_EXPEDITED_DATA;
/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: TEST_RTS                                                       */
/*                                                                           */
/* Description:    TEST_RTS verb control block                               */
/*****************************************************************************/
typedef struct test_rts
{
  AP_UINT16            opcode;
  unsigned char        opext;
  unsigned char        format;
  AP_UINT16            primary_rc;
  AP_UINT32            secondary_rc;
  unsigned char        tp_id[8];
  AP_UINT32            conv_id;
  unsigned char        reserv3;
} TEST_RTS;
/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: TEST_RTS_AND_POST                                              */
/*                                                                           */
/* Description:    TEST_RTS_AND_POST verb control block                      */
/*****************************************************************************/
typedef struct test_rts_and_post
{
  AP_UINT16            opcode;
  unsigned char        opext;
  unsigned char        format;
  AP_UINT16            primary_rc;
  AP_UINT32            secondary_rc;
  unsigned char        tp_id[8];
  AP_UINT32            conv_id;
  unsigned char        reserv3;
  void                 (*callback)();
} TEST_RTS_AND_POST;
/**STRUCT-********************************************************************/


/**STRUCT+********************************************************************/
/* Structure: MC_ALLOCATE                                                    */
/*                                                                           */
/* Description: MC_ALLOCATE verb control block                               */
/*****************************************************************************/
typedef struct mc_allocate
{
  AP_UINT16            opcode;
  unsigned char        opext;
  unsigned char        format;
  AP_UINT16            primary_rc;
  AP_UINT32            secondary_rc;
  unsigned char        tp_id[8];
  AP_UINT32            conv_id;
  unsigned char        reserv3;
  unsigned char        sync_level;
  unsigned char        reserv4[2];
  unsigned char        rtn_ctl;
  unsigned char        duplex_type;
  AP_UINT32            conv_group_id;
  AP_UINT32            sense_data;
  unsigned char        plu_alias[8];
  unsigned char        mode_name[8];
  unsigned char        tp_name[64];
  unsigned char        security;
  unsigned char        reserv6[11];
  unsigned char        pwd[10];
  unsigned char        user_id[10];
  AP_UINT16            pip_dlen;
  unsigned char        *pip_dptr;
  unsigned char        reserv6a;
  unsigned char        fqplu_name[17];
  unsigned char        reserv7[8];
} MC_ALLOCATE;
/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: MC_CONFIRM                                                     */
/*                                                                           */
/* Description: MC_CONFIRM verb control block                                */
/*****************************************************************************/
typedef struct mc_confirm
{
  AP_UINT16            opcode;
  unsigned char        opext;
  unsigned char        format;
  AP_UINT16            primary_rc;
  AP_UINT32            secondary_rc;
  unsigned char        tp_id[8];
  AP_UINT32            conv_id;
  unsigned char        rts_rcvd;
  unsigned char        expd_rcvd;
} MC_CONFIRM;
/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: MC_CONFIRMED                                                   */
/*                                                                           */
/* Description: MC_CONFIRMED verb control block                              */
/*****************************************************************************/
typedef struct mc_confirmed
{
  AP_UINT16            opcode;
  unsigned char        opext;
  unsigned char        format;
  AP_UINT16            primary_rc;
  AP_UINT32            secondary_rc;
  unsigned char        tp_id[8];
  AP_UINT32            conv_id;
} MC_CONFIRMED;
/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: MC_DEALLOCATE                                                  */
/*                                                                           */
/* Description: MC_DEALLOCATE verb control block                             */
/*****************************************************************************/
typedef struct mc_deallocate
{
  AP_UINT16            opcode;
  unsigned char        opext;
  unsigned char        format;
  AP_UINT16            primary_rc;
  AP_UINT32            secondary_rc;
  unsigned char        tp_id[8];
  AP_UINT32            conv_id;
  unsigned char        expd_rcvd;
  unsigned char        dealloc_type;
  unsigned char        reserv4[2];
  unsigned char        reserv5[4];
  void                 (*callback)();
  void                 *correlator;
  unsigned char        reserv6[4];
} MC_DEALLOCATE;
/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: MC_FLUSH                                                       */
/*                                                                           */
/* Description: MC_FLUSH verb control block                                  */
/*****************************************************************************/
typedef struct mc_flush
{
  AP_UINT16            opcode;
  unsigned char        opext;
  unsigned char        format;
  AP_UINT16            primary_rc;
  AP_UINT32            secondary_rc;
  unsigned char        tp_id[8];
  AP_UINT32            conv_id;
} MC_FLUSH;
/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: MC_GET_ATTRIBUTES                                              */
/*                                                                           */
/* Description: MC_GET_ATTRIBUTES verb control block                         */
/*****************************************************************************/
typedef struct mc_get_attributes
{
  AP_UINT16            opcode;
  unsigned char        opext;
  unsigned char        format;
  AP_UINT16            primary_rc;
  AP_UINT32            secondary_rc;
  unsigned char        tp_id[8];
  AP_UINT32            conv_id;
  unsigned char        reserv3;
  unsigned char        sync_level;
  unsigned char        mode_name[8];
  unsigned char        net_name[8];
  unsigned char        lu_name[8];
  unsigned char        lu_alias[8];
  unsigned char        plu_alias[8];
  unsigned char        plu_un_name[8];
  unsigned char        reserv4[2];
  unsigned char        fqplu_name[17];
  unsigned char        reserv5;
  unsigned char        user_id[10];
  AP_UINT32            conv_group_id;
  unsigned char        conv_corr_len;
  unsigned char        conv_corr[8];
  unsigned char        reserv6[13];
  LUWID_OVERLAY        luw_id;
  unsigned char        sess_id[8];
} MC_GET_ATTRIBUTES;
/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: MC_PREPARE_TO_RECEIVE                                          */
/*                                                                           */
/* Description: MC_PREPARE_TO_RECEIVE vcontrol block                         */
/*****************************************************************************/
typedef struct mc_prepare_to_receive
{
  AP_UINT16            opcode;
  unsigned char        opext;
  unsigned char        format;
  AP_UINT16            primary_rc;
  AP_UINT32            secondary_rc;
  unsigned char        tp_id[8];
  AP_UINT32            conv_id;
  unsigned char        ptr_type;
  unsigned char        locks;
} MC_PREPARE_TO_RECEIVE;
/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: MC_RECEIVE_AND_POST                                            */
/*                                                                           */
/* Description: MC_RECEIVE_AND_POST verb control block                       */
/*****************************************************************************/
typedef struct mc_receive_and_post
{
  AP_UINT16            opcode;
  unsigned char        opext;
  unsigned char        format;
  AP_UINT16            primary_rc;
  AP_UINT32            secondary_rc;
  unsigned char        tp_id[8];
  AP_UINT32            conv_id;
  AP_UINT16            what_rcvd;
  unsigned char        rtn_status;
  unsigned char        reserv4;
  unsigned char        rts_rcvd;
  unsigned char        expd_rcvd;
  AP_UINT16            max_len;
  AP_UINT16            dlen;
  unsigned char        *dptr;
  void                 (*callback)();
  unsigned char        reserv6;
} MC_RECEIVE_AND_POST;
/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: MC_RECEIVE_AND_WAIT                                            */
/*                                                                           */
/* Description: MC_RECEIVE_AND_WAIT verb control block                       */
/*****************************************************************************/
typedef struct mc_receive_and_wait
{
  AP_UINT16            opcode;
  unsigned char        opext;
  unsigned char        format;
  AP_UINT16            primary_rc;
  AP_UINT32            secondary_rc;
  unsigned char        tp_id[8];
  AP_UINT32            conv_id;
  AP_UINT16            what_rcvd;
  unsigned char        rtn_status;
  unsigned char        reserv4;
  unsigned char        rts_rcvd;
  unsigned char        expd_rcvd;
  AP_UINT16            max_len;
  AP_UINT16            dlen;
  unsigned char        *dptr;
  unsigned char        reserv6[5];
} MC_RECEIVE_AND_WAIT;
/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: MC_RECEIVE_EXPEDITED_DATA                                      */
/*                                                                           */
/* Description: MC_RECEIVE_EXPEDITED_DATA verb control block                 */
/*****************************************************************************/
typedef struct mc_receive_expedited_data
{
  AP_UINT16            opcode;
  unsigned char        opext;
  unsigned char        format;
  AP_UINT16            primary_rc;
  AP_UINT32            secondary_rc;
  unsigned char        tp_id[8];
  AP_UINT32            conv_id;
  unsigned char        rtn_ctl;
  unsigned char        reserv1[3];
  unsigned char        rts_rcvd;
  unsigned char        expd_rcvd;
  AP_UINT16            max_len;
  AP_UINT16            dlen;
  unsigned char        *dptr;
} MC_RECEIVE_EXPEDITED_DATA;
/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: MC_RECEIVE_IMMEDIATE                                           */
/*                                                                           */
/* Description: MC_RECEIVE_IMMEDIATE verb control block                      */
/*****************************************************************************/
typedef struct mc_receive_immediate
{
  AP_UINT16            opcode;
  unsigned char        opext;
  unsigned char        format;
  AP_UINT16            primary_rc;
  AP_UINT32            secondary_rc;
  unsigned char        tp_id[8];
  AP_UINT32            conv_id;
  AP_UINT16            what_rcvd;
  unsigned char        rtn_status;
  unsigned char        reserv4;
  unsigned char        rts_rcvd;
  unsigned char        expd_rcvd;
  AP_UINT16            max_len;
  AP_UINT16            dlen;
  unsigned char        *dptr;
  unsigned char        reserv6[5];
} MC_RECEIVE_IMMEDIATE;
/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: MC_REQUEST_TO_SEND                                             */
/*                                                                           */
/* Description: MC_REQUEST_TO_SEND verb control block                        */
/*****************************************************************************/
typedef struct mc_request_to_send
{
  AP_UINT16            opcode;
  unsigned char        opext;
  unsigned char        format;
  AP_UINT16            primary_rc;
  AP_UINT32            secondary_rc;
  unsigned char        tp_id[8];
  AP_UINT32            conv_id;
} MC_REQUEST_TO_SEND;
/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: MC_SEND_CONVERSATION                                           */
/*                                                                           */
/* Description: MC_SEND_CONVERSATION verb control block                      */
/*****************************************************************************/
typedef struct mc_send_conversation
{
  AP_UINT16            opcode;
  unsigned char        opext;
  unsigned char        format;
  AP_UINT16            primary_rc;
  AP_UINT32            secondary_rc;
  unsigned char        tp_id[8];
  unsigned char        reserv3[8];
  unsigned char        rtn_ctl;
  unsigned char        reserv4;
  AP_UINT32            conv_group_id;
  AP_UINT32            sense_data;
  unsigned char        plu_alias[8];
  unsigned char        mode_name[8];
  unsigned char        tp_name[64];
  unsigned char        security;
  unsigned char        reserv6[11];
  unsigned char        pwd[10];
  unsigned char        user_id[10];
  AP_UINT16            pip_dlen;
  unsigned char        *pip_dptr;
  unsigned char        reserv6a;
  unsigned char        fqplu_name[17];
  unsigned char        reserv7[8];
  AP_UINT16            dlen;
  unsigned char        *dptr;
} MC_SEND_CONVERSATION;
/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: MC_SEND_DATA                                                   */
/*                                                                           */
/* Description: MC_SEND_DATA verb control block                              */
/*****************************************************************************/
typedef struct mc_send_data
{
  AP_UINT16            opcode;
  unsigned char        opext;
  unsigned char        format;
  AP_UINT16            primary_rc;
  AP_UINT32            secondary_rc;
  unsigned char        tp_id[8];
  AP_UINT32            conv_id;
  unsigned char        rts_rcvd;
  unsigned char        expd_rcvd;
  AP_UINT16            dlen;
  unsigned char        *dptr;
  unsigned char        type;
  unsigned char        data_type;
} MC_SEND_DATA;
/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: MC_SEND_ERROR                                                  */
/*                                                                           */
/* Description: MC_SEND_ERROR verb control block                             */
/*****************************************************************************/
typedef struct mc_send_error
{
  AP_UINT16            opcode;
  unsigned char        opext;
  unsigned char        format;
  AP_UINT16            primary_rc;
  AP_UINT32            secondary_rc;
  unsigned char        tp_id[8];
  AP_UINT32            conv_id;
  unsigned char        rts_rcvd;
  unsigned char        err_type;
  unsigned char        err_dir;
  unsigned char        expd_rcvd;
  unsigned char        reserv5[2];
  unsigned char        reserv6[4];
} MC_SEND_ERROR;
/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: MC_SEND_EXPEDITED_DATA                                         */
/*                                                                           */
/* Description: MC_SEND_EXPEDITED_DATA verb control block                    */
/*****************************************************************************/
typedef struct mc_send_expedited_data
{
  AP_UINT16            opcode;
  unsigned char        opext;
  unsigned char        format;
  AP_UINT16            primary_rc;
  AP_UINT32            secondary_rc;
  unsigned char        tp_id[8];
  AP_UINT32            conv_id;
  unsigned char        rts_rcvd;
  unsigned char        expd_rcvd;
  AP_UINT16            dlen;
  unsigned char        *dptr;
  unsigned char        reserv4[2];
} MC_SEND_EXPEDITED_DATA;
/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: MC_TEST_RTS                                                    */
/*                                                                           */
/* Description: MC_TEST_RTS verb control block                               */
/*****************************************************************************/
typedef struct mc_test_rts
{
  AP_UINT16            opcode;
  unsigned char        opext;
  unsigned char        format;
  AP_UINT16            primary_rc;
  AP_UINT32            secondary_rc;
  unsigned char        tp_id[8];
  AP_UINT32            conv_id;
  unsigned char        reserv3;
} MC_TEST_RTS;
/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: MC_TEST_RTS_AND_POST                                           */
/*                                                                           */
/* Description:    MC_TEST_RTS_AND_POST verb control block                   */
/*****************************************************************************/
typedef struct mc_test_rts_and_post
{
  AP_UINT16            opcode;
  unsigned char        opext;
  unsigned char        format;
  AP_UINT16            primary_rc;
  AP_UINT32            secondary_rc;
  unsigned char        tp_id[8];
  AP_UINT32            conv_id;
  void                 (*callback)();
  unsigned char        reserv3;
} MC_TEST_RTS_AND_POST;
/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: GET_TYPE                                                       */
/*                                                                           */
/* Description: GET_TYPE verb control block                                  */
/*****************************************************************************/
typedef struct get_type
{
  AP_UINT16            opcode;
  unsigned char        opext;
  unsigned char        format;
  AP_UINT16            primary_rc;
  AP_UINT32            secondary_rc;
  unsigned char        tp_id[8];
  AP_UINT32            conv_id;
  unsigned char        conv_type;
  unsigned char        duplex_type;
} GET_TYPE;
/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: GET_TP_PROPERTIES                                              */
/*                                                                           */
/* Description: GET_TP_PROPERTIES verb control block                         */
/*****************************************************************************/
typedef struct get_tp_properties
{
  AP_UINT16            opcode;
  unsigned char        opext;
  unsigned char        format;
  AP_UINT16            primary_rc;
  AP_UINT32            secondary_rc;
  unsigned char        tp_id[8];
  unsigned char        tp_name[64];
  unsigned char        lu_alias[8];
  LUWID_OVERLAY        luw_id;
  unsigned char        fqlu_name[17];
  unsigned char        reserv3[9];
  unsigned char        verified;
  unsigned char        user_id[10];
  LUWID_OVERLAY        prot_luw_id;
} GET_TP_PROPERTIES;
/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: SET_TP_PROPERTIES                                              */
/*                                                                           */
/* Description: SET_TP_PROPERTIES verb control block                         */
/*****************************************************************************/

typedef struct set_tp_properties
{
  AP_UINT16         opcode;
  unsigned char     opext;
  unsigned char     format;
  AP_UINT16         primary_rc;
  AP_UINT32         secondary_rc;
  unsigned char     tp_id[8];
  unsigned char     set_prot_id;
  unsigned char     new_prot_id;
  LUWID_OVERLAY     prot_id;
  unsigned char     set_unprot_id;
  unsigned char     new_unprot_id;
  LUWID_OVERLAY     unprot_id;
  unsigned char     set_user_id;
  unsigned char     set_password;
  unsigned char     user_id[10];
  unsigned char     new_password[10];
} SET_TP_PROPERTIES;

/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: GET_STATE                                                      */
/*                                                                           */
/* Description: GET_STATE verb control block                                 */
/*****************************************************************************/

typedef struct get_state
{
  AP_UINT16        opcode;
  unsigned char    opext;
  unsigned char    format;
  AP_UINT16        primary_rc;
  AP_UINT32        secondary_rc;
  unsigned char    tp_id[8];
  AP_UINT32        conv_id;
  unsigned char    conv_state;
} GET_STATE;

/**STRUCT-********************************************************************/


/**STRUCT+********************************************************************/
/* Structure: GET_LU_STATUS                                                  */
/*                                                                           */
/* Description: GET_LU_STATUS verb control block                             */
/*****************************************************************************/

typedef struct get_lu_status
{
  AP_UINT16       opcode;
  unsigned char   opext;
  unsigned char   format;
  AP_UINT16       primary_rc;
  AP_UINT32       secondary_rc;
  unsigned char   tp_id[8];
  unsigned char   plu_alias[8];
  AP_UINT16       active_sess;
  unsigned char   zero_sess;
  unsigned char   reserv3[7];
} GET_LU_STATUS;

/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: CANCEL_CONVERSATION                                            */
/*                                                                           */
/* Description: CANCEL_CONVERSATION verb control block                       */
/*****************************************************************************/
typedef struct cancel_conversation
{
  AP_UINT16            opcode;
  unsigned char        opext;
  unsigned char        format;
  AP_UINT16            primary_rc;
  AP_UINT32            secondary_rc;
  unsigned char        tp_id[8];
  AP_UINT32            conv_id;
} CANCEL_CONVERSATION;
/**STRUCT-********************************************************************/

#ifdef __cplusplus
}
#endif

#endif
