/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.findroots;

import com.ibm.jvm.findroots.Base;
import com.ibm.jvm.findroots.PrintClient;
import com.ibm.jvm.findroots.ReachabilityGraph;
import com.ibm.jvm.findroots.SimpleGraph;
import com.ibm.jvm.findroots.StrongComponentsGraph;
import com.ibm.jvm.findroots.Vertex;
import com.ibm.jvm.findroots.Visitor;
import com.ibm.jvm.util.BitSetArray;
import com.ibm.jvm.util.IntEnumeration;
import com.ibm.jvm.util.IntegerArray;
import com.ibm.jvm.util.IntegerStack;
import com.ibm.jvm.util.SvcdumpProperties;
import java.util.BitSet;
import java.util.Vector;

public final class ReachabilityGraph
extends SimpleGraph {
    int[] dagIndex;
    int[] reach;
    StrongComponentsGraph dag;
    BitSet visited;
    int maxdepth = SvcdumpProperties.getIntProperty("findroots.depth", 1000);
    int maxroots = 20;
    int prune = SvcdumpProperties.getIntProperty("findroots.prune", this.sizeMatters ? 10000 : 1000);
    boolean calculateReachability = true;
    static int logFreq = 4096;
    BitSetArray domChildren;

    public ReachabilityGraph() {
        this.maxroots = SvcdumpProperties.getIntProperty("findroots.maxroots", 20);
        this.calculateReachability = SvcdumpProperties.getBooleanProperty("findroots.calculate.reachability", true);
    }

    String className() {
        return "ReachabilityGraph";
    }

    public int reachFrom(int n) {
        if (this.visited == null) {
            this.visited = new BitSet();
        }
        return this.reachFrom(n, this.visited);
    }

    public int reachFrom(Vertex vertex) {
        return this.reachFrom(vertex.id());
    }

    public boolean reachGreaterThan(Vertex vertex, int n) {
        this.complete();
        class ReachVisitor
        extends Visitor {
            int n;
            boolean greater;
            int target;
            private final /* synthetic */ ReachabilityGraph this$0;

            ReachVisitor(ReachabilityGraph reachabilityGraph, int n) {
                this.this$0 = reachabilityGraph;
                this.n = 0;
                this.target = n;
            }

            public boolean continueSearch(int n, int n2) {
                return !this.greater;
            }

            public void enterNode(int n, int n2) {
                if (++this.n > this.target) {
                    this.greater = true;
                }
            }

            public Object result() {
                return new Boolean(this.greater);
            }
        }
        Boolean bl = (Boolean)this.dfs(new ReachVisitor(this, n), vertex.index);
        return bl;
    }

    public int reachableVertices(int n) {
        Base.Assert(false);
        return 0;
    }

    public int reachableSize(int n) {
        Base.Assert(false);
        return 0;
    }

    int reach(int n) {
        if (this.reach == null) {
            this.findStrongComponents();
            this.dag.transitiveClosure();
            this.reach = new int[this.size];
            int n2 = 0;
            while (n2 < this.size) {
                this.reach[n2] = this.dag.reach[this.dagIndex[n2]];
                ++n2;
            }
            this.dag = null;
            this.dagIndex = null;
        }
        return this.reach[n];
    }

    void printNode(int n, int n2, boolean bl) {
        int n3 = this.vertexIds.get(n);
        int n4 = 0;
        while (n4 < n2) {
            System.out.print("   ");
            ++n4;
        }
        if (this.reach == null) {
            System.out.println("0x" + Base.hex(n3) + " " + this.client.getName(n3) + (bl ? "" : " (already visited)"));
        } else {
            System.out.println(this.reach[n] + " 0x" + Base.hex(n3) + " " + this.client.getName(n3) + (bl ? "" : " (already visited)"));
        }
    }

    void printTree(int n) {
        this.complete();
        int n2 = this.idToIndex(n);
        this.log("begin printTree");
        this.printNode(n2, 0, true);
        this.dfs(new Visitor(){
            int count = 0;

            public void visitChild(int n, int n2, boolean bl, int n3) {
                if (ReachabilityGraph.this.reach != null && ReachabilityGraph.this.reach[n2] < ReachabilityGraph.this.prune) {
                    return;
                }
                ReachabilityGraph.this.printNode(n2, n3, bl);
            }

            public boolean continueSearch(int n, int n2) {
                return n2 < ReachabilityGraph.this.maxdepth && (ReachabilityGraph.this.reach == null || ReachabilityGraph.this.reach[n] > ReachabilityGraph.this.prune);
            }

            public int getCount(int n) {
                return ReachabilityGraph.this.reach == null ? 0 : ReachabilityGraph.this.reach[n];
            }

            public boolean sort() {
                return true;
            }
        }, n2);
        this.log("end printTree");
    }

    void printTree(PrintClient printClient, int n) {
        this.client = printClient;
        this.reach(0);
        this.printTree(n);
    }

    ReachabilityGraph findDominators(int n) {
        this.calculateImmediateDominators(n);
        ReachabilityGraph reachabilityGraph = new ReachabilityGraph();
        int n2 = 0;
        while (n2 < this.size) {
            reachabilityGraph.idToIndex(this.vertexIds.get(n2));
            ++n2;
        }
        int n3 = this.idToIndex(n);
        int n4 = 0;
        while (n4 < this.size) {
            if (n4 != n3) {
                int n5 = this.vertexIds.get(this.idom[n4]);
                int n6 = this.vertexIds.get(n4);
                reachabilityGraph.addEdge(n5, n6);
                reachabilityGraph.vertexSizes.put(n4, this.vertexSizes.get(n4));
            }
            ++n4;
        }
        reachabilityGraph.complete();
        return reachabilityGraph;
    }

    BitSetArray edges() {
        return this.domChildren == null ? super.edges() : this.domChildren;
    }

    void treeReach(int n) {
        int n2 = this.idToIndex(n);
        this.dfs(new Visitor(){
            int cnt = 0;

            public void enterNode(int n, int n2) {
                block0: {
                    ReachabilityGraph.this.reach[n] = this.cnt++;
                    if (!ReachabilityGraph.this.exact && !ReachabilityGraph.this.sizeMatters) break block0;
                    this.cnt += ReachabilityGraph.this.vertexSizes.get(n);
                }
            }

            public void exitNode(int n) {
                ReachabilityGraph.this.reach[n] = this.cnt - ReachabilityGraph.this.reach[n];
            }
        }, n2);
    }

    void findDominatorEdges(int n) {
        this.log("begin findDominatorEdges");
        this.calculateImmediateDominators(n);
        this.domChildren = new BitSetArray(this.size, "Dominator children");
        int n2 = 0;
        while (n2 < this.size) {
            if (this.idom[n2] != -1) {
                this.domChildren.set(this.idom[n2], n2);
            }
            ++n2;
        }
        this.log("calculate tree reachability");
        this.treeReach(n);
        this.log("end findDominatorEdges");
    }

    StrongComponentsGraph findStrongComponents() {
        int n;
        this.log("begin findStrongComponents");
        int[] nArray = (int[])this.dfs(new Visitor(){
            IntegerStack s = new IntegerStack();
            IntegerStack path = new IntegerStack();
            int[] pre;
            int[] sc;
            int cnt0;
            int cnt1;
            {
                this.pre = new int[ReachabilityGraph.this.size];
                this.sc = new int[ReachabilityGraph.this.size];
                this.cnt0 = 0;
                this.cnt1 = 1;
            }

            public void init() {
                int n = 0;
                while (n < ReachabilityGraph.this.size) {
                    this.sc[n] = -1;
                    ++n;
                }
            }

            public void enterNode(int n, int n2) {
                ++this.cnt0;
                this.s.push(n);
                this.path.push(n);
                ReachabilityGraph.this.trace("enter node " + n + " at depth " + n2);
            }

            public void visitChild(int n, int n2, boolean bl, int n3) {
                if (!bl && this.sc[n2] == -1) {
                    while (this.pre[this.path.peek()] > this.pre[n2]) {
                        this.path.pop();
                    }
                }
            }

            public void exitNode(int n) {
                if (this.path.peek() == n) {
                    int n2;
                    this.path.pop();
                    do {
                        n2 = this.s.pop();
                        this.sc[n2] = this.cnt1++;
                    } while (n2 != n);
                }
            }

            public Object result() {
                return this.sc;
            }
        });
        this.log("create dag");
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.size) {
            if (nArray[n3] > n2) {
                n2 = nArray[n3];
            }
            ++n3;
        }
        this.dag = new StrongComponentsGraph();
        this.dag.setRecordParents(true);
        this.dagIndex = new int[this.size];
        this.dag.idToIndex(0);
        if (SimpleGraph.optinterval) {
            int n4 = 1;
            while (n4 <= n2) {
                this.dag.idToIndex(n4);
                ++n4;
            }
        }
        this.dag.isNotRoot.set(0);
        IntEnumeration intEnumeration = this.edges.elements(0);
        int n5 = 0;
        while (n5 < this.size) {
            if (!this.deleted.get(n5)) {
                this.trace("doing dag stuff for " + n5);
                this.dagIndex[n5] = n = this.dag.idToIndex(nArray[n5]);
                this.dag.vertexSizes.put(n, this.dag.vertexSizes.get(n) + this.vertexSizes.get(n5));
                this.dag.dagSizes.put(n, this.dag.dagSizes.get(n) + 1);
                IntEnumeration intEnumeration2 = this.edges.elements(n5, intEnumeration);
                while (intEnumeration2.hasMoreElements()) {
                    int n6 = intEnumeration2.nextInt();
                    this.dagIndex[n6] = this.dag.idToIndex(nArray[n6]);
                    if (nArray[n5] == nArray[n6]) continue;
                    this.dag.addEdge(nArray[n5], nArray[n6]);
                    this.dag.isNotRoot.set(this.dagIndex[n6]);
                }
            }
            ++n5;
        }
        n = 1;
        while (n < this.dag.size) {
            this.dag.vertexSizes.put(n, this.dag.vertexSizes.get(n) - 1);
            if (!this.dag.isNotRoot.get(n)) {
                this.dag.addEdgeByIndex(0, n);
            }
            ++n;
        }
        this.dag.complete();
        this.log("end findStrongComponents");
        return this.dag;
    }

    int dagIdToId(int n) {
        return this.dagIdToIds(n)[0];
    }

    int[] dagIdToIds(int n) {
        IntegerArray integerArray = new IntegerArray();
        int n2 = this.dag.idToIndex(n);
        int n3 = 0;
        while (n3 < this.size) {
            if (!this.deleted.get(n3) && this.dagIndex[n3] == n2) {
                integerArray.add(this.vertexIds.get(n3));
            }
            ++n3;
        }
        return integerArray.toArray();
    }

    boolean isRoot(int n) {
        return !this.dag.isNotRoot.get(this.dagIndex[n]);
    }

    public void print(PrintClient printClient) {
        this.complete();
        this.log("begin analysis");
        this.client = printClient;
        this.log("number of vertexes = " + this.vertexIds.size());
        int n = 0;
        while (n < this.maxroots) {
            int n2;
            int n3 = 0;
            int n4 = 0;
            if (n > 0) {
                System.out.println("");
            }
            System.out.println("*** doing root " + n + " ***");
            System.out.println("");
            this.findStrongComponents();
            this.dag.transitiveClosure();
            this.reach = new int[this.size];
            int n5 = 0;
            while (n5 < this.size) {
                this.reach[n5] = this.dag.reach[this.dagIndex[n5]];
                ++n5;
            }
            this.dag = null;
            this.log("after trans closure");
            int n6 = 0;
            while (n6 < this.vertexIds.size()) {
                n2 = this.reach[n6];
                if (n2 > n4) {
                    n4 = n2;
                    n3 = n6;
                    this.log("new max " + n2 + " at " + n6);
                }
                ++n6;
            }
            if (n4 == 0) {
                this.log("no more roots!");
                break;
            }
            n2 = this.vertexIds.get(n3);
            this.log("max reach = " + n4 + " for vertex " + Base.hex(n2) + " " + printClient.getName(n2));
            this.printTree(n2);
            this.deleteTree(n3);
            ++n;
        }
    }

    public void print(PrintClient printClient, int n) {
        this.complete();
        this.client = printClient;
        this.log("number of vertexes = " + this.vertexIds.size());
        if (this.calculateReachability) {
            this.findStrongComponents();
            this.dag.transitiveClosure();
            this.reach = new int[this.size];
            int n2 = 0;
            while (n2 < this.size) {
                this.reach[n2] = this.dag.reach[this.dagIndex[n2]];
                ++n2;
            }
            this.dag = null;
        }
        this.printTree(n);
    }

    public Vertex[] getRoots() {
        this.complete();
        this.findStrongComponents();
        this.dag.transitiveClosure();
        this.reach = this.dag.reach;
        Vector<Vertex> vector = new Vector<Vertex>();
        int n = 1;
        while (n < this.size) {
            if (this.isRoot(n)) {
                Vertex vertex = new Vertex(this, n);
                vector.add(vertex);
            }
            ++n;
        }
        return vector.toArray(new Vertex[0]);
    }

    int getBiggestRoot() {
        int n = 0;
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.size) {
            int n4 = this.reach(n3);
            if (n4 > n) {
                n = n4;
                n2 = n3;
            }
            ++n3;
        }
        if (n2 == -1) {
            return -1;
        }
        return this.id(n2);
    }

    public static void main(String[] stringArray) {
        Object object;
        int n;
        int n2 = 0;
        while (n2 < 3) {
            System.out.println("doing " + n2);
            ReachabilityGraph reachabilityGraph = new ReachabilityGraph();
            reachabilityGraph.setRecordParents(true);
            reachabilityGraph.random(n2, 100, 150);
            int n3 = reachabilityGraph.getBiggestRoot();
            if (n3 != -1) {
                reachabilityGraph = (ReachabilityGraph)reachabilityGraph.getSubgraph(n3);
                n = reachabilityGraph.idToIndex(n3);
                Integer n4 = (Integer)reachabilityGraph.dfs(new Visitor(){
                    int n = -1;

                    public void enterNode(int n, int n2) {
                        this.n = n;
                    }

                    public Object result() {
                        return new Integer(this.n);
                    }
                }, n);
                int n5 = reachabilityGraph.vertexIds.get(n4);
                BitSetArray bitSetArray = reachabilityGraph.findDominators(n3, n5);
                BitSetArray bitSetArray2 = reachabilityGraph.getDominators(n3, n5);
                object = bitSetArray.elements();
                while (object.hasMoreElements()) {
                    int n6 = object.nextInt();
                    n6 = reachabilityGraph.vertexIds.get(n6);
                }
                IntEnumeration intEnumeration = bitSetArray2.elements();
                while (intEnumeration.hasMoreElements()) {
                    int n7 = intEnumeration.nextInt();
                    n7 = reachabilityGraph.vertexIds.get(n7);
                }
                if (!bitSetArray.equals(bitSetArray2)) {
                    throw new Error("no match!");
                }
                System.out.println("done " + n2);
            }
            ++n2;
        }
        int n8 = 1;
        while (true) {
            ReachabilityGraph reachabilityGraph = new ReachabilityGraph();
            n = 10000;
            if (stringArray.length > 0) {
                try {
                    n = Integer.parseInt(stringArray[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            reachabilityGraph.random(n8, n, n * 3 / 2);
            reachabilityGraph.findStrongComponents();
            reachabilityGraph.dag.uselessmemory = false;
            reachabilityGraph.dag.usebranches = false;
            reachabilityGraph.dag.usecomplex = false;
            reachabilityGraph.dag.onlymedium = false;
            reachabilityGraph.dag.exact = true;
            long l = System.currentTimeMillis();
            reachabilityGraph.dag.transitiveClosure();
            long l2 = System.currentTimeMillis();
            object = reachabilityGraph.dag.reach;
            reachabilityGraph.dag.uselessmemory = true;
            reachabilityGraph.dag.transitiveClosure();
            long l3 = System.currentTimeMillis();
            int[] nArray = reachabilityGraph.dag.reach;
            reachabilityGraph.dag.uselessmemory = false;
            reachabilityGraph.dag.usebranches = true;
            reachabilityGraph.dag.transitiveClosure();
            long l4 = System.currentTimeMillis();
            int[] nArray2 = reachabilityGraph.dag.reach;
            reachabilityGraph.dag.usebranches = false;
            reachabilityGraph.dag.usecomplex = true;
            reachabilityGraph.dag.transitiveClosure();
            long l5 = System.currentTimeMillis();
            int[] nArray3 = reachabilityGraph.dag.reach;
            reachabilityGraph.dag.usecomplex = false;
            reachabilityGraph.dag.onlymedium = true;
            reachabilityGraph.dag.transitiveClosure();
            long l6 = System.currentTimeMillis();
            int[] nArray4 = reachabilityGraph.dag.reach;
            reachabilityGraph.dag.onlymedium = false;
            int n9 = 0;
            while (n9 < reachabilityGraph.dag.size) {
                if (!reachabilityGraph.dag.ignoreNode(n9)) {
                    if (object[n9] != nArray[n9]) {
                        throw new Error("mismatch at " + n9 + "! " + (int)object[n9] + " compared with " + nArray[n9]);
                    }
                    if (object[n9] != nArray2[n9]) {
                        // empty if block
                    }
                    if (object[n9] != nArray3[n9]) {
                        System.out.println("dag:");
                        System.out.println(reachabilityGraph.dag.toString());
                        throw new Error("mismatch at " + n9 + "! " + (int)object[n9] + " compared with " + nArray3[n9]);
                    }
                    if (object[n9] != nArray4[n9]) {
                        System.out.println("dag:");
                        System.out.println(reachabilityGraph.dag.toString());
                        throw new Error("mismatch at " + n9 + "! " + (int)object[n9] + " compared with " + nArray4[n9]);
                    }
                }
                ++n9;
            }
            System.out.println("done " + n8 + " fast: " + (l2 - l) + " ms, slow: " + (l3 - l2) + " ms, medium: " + (l6 - l5) + " ms, complex: " + (l5 - l4) + " ms, dag size " + reachabilityGraph.dag.size);
            ++n8;
        }
    }
}

