/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.findroots;

import com.ibm.jvm.findroots.Base;
import com.ibm.jvm.findroots.Heapdump;
import com.ibm.jvm.findroots.HeapdumpListener;
import com.ibm.jvm.findroots.PrintClient;
import com.ibm.jvm.findroots.ReachabilityGraph;
import com.ibm.jvm.findroots.SimpleGraph;
import com.ibm.jvm.findroots.VertexClass;
import com.ibm.jvm.findroots.Visitor;
import com.ibm.jvm.util.IntegerArray;
import com.ibm.jvm.util.SortListener;
import com.ibm.jvm.util.SvcdumpProperties;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;

public class PrintBase
extends Base
implements HeapdumpListener,
PrintClient {
    String className;
    Heapdump dump = new Heapdump();
    Vector strings = new Vector();
    ReachabilityGraph graph = new ReachabilityGraph();
    SimpleGraph printGraph;
    IntegerArray ids = new IntegerArray();
    IntegerArray indexes = new IntegerArray();
    IntegerArray types = new IntegerArray();
    IntegerArray sizes = new IntegerArray();
    IntegerArray excludeObjects = new IntegerArray();
    Vector excludeClasses = new Vector();
    Hashtable classTable = new Hashtable();
    VertexClass[] classes;
    String filename;
    int totalSize = 0;
    int totalCount = 0;
    byte[] btypes;
    String[] arrayName = new String[]{"unknown array type", "primitive array", "array of references", "unknown array type", "array of boolean", "array of char", "array of float", "array of double", "array of byte", "array of short", "array of int", "array of long", "unknown array type", "unknown array type", "unknown array type", "unknown array type"};

    String className() {
        return this.className;
    }

    void printInfo() {
        System.out.println("For more information on FindRoots visit http://w3.hursley.ibm.com/~dgriff/findroots.html");
        System.out.println("");
        System.out.println("Properties:");
        System.out.println("findroots.maxroots = " + this.graph.maxroots);
        System.out.println("findroots.depth = " + this.graph.maxdepth);
        System.out.println("findroots.prune = " + this.graph.prune);
        System.out.println("findroots.sizematters = " + this.graph.sizeMatters);
        System.out.println("");
    }

    public ReachabilityGraph getReachabilityGraph() {
        return this.graph;
    }

    public void setReachabilityGraph(ReachabilityGraph reachabilityGraph) {
        this.graph = reachabilityGraph;
    }

    public void start(String[] stringArray, String string) {
        this.className = string;
        if (stringArray.length == 0) {
            this.usage();
        }
        this.parseOptions(stringArray);
        Object var3_3 = null;
        this.filename = stringArray[stringArray.length - 1];
        if (!new File(this.filename).canRead()) {
            System.err.println("Could not open: " + this.filename);
            this.usage();
        }
        this.printInfo();
        this.parseStart();
        this.dump.parse(this.filename, this);
        this.parseEnd();
    }

    public boolean parseOption(String string, String string2) {
        if ("-excludeobject".equals(string)) {
            try {
                int n = SvcdumpProperties.parseInt(string2, 16);
                this.excludeObjects.add(n);
            }
            catch (Exception exception) {
                System.err.println(string2 + " is not a valid number");
                this.usage();
            }
            return true;
        }
        if ("-excludeclass".equals(string)) {
            this.excludeClasses.add(string2);
            return true;
        }
        return false;
    }

    protected void parseStart() {
    }

    protected void createClasses() {
        this.classes = new VertexClass[this.ids.size()];
        int n = 0;
        while (n < this.ids.size()) {
            int n2 = this.type(n);
            int n3 = this.ids.get(n);
            int n4 = this.sizes.get(n);
            String string = this.getName(n3);
            VertexClass vertexClass = (VertexClass)this.classTable.get(string);
            if (vertexClass == null) {
                vertexClass = new VertexClass(string, n2, n4);
                this.classTable.put(string, vertexClass);
            } else if (vertexClass.instanceSize == 0 && n2 == 1) {
                vertexClass.instanceSize = n4;
            }
            vertexClass.add(n3, n4);
            this.classes[n] = vertexClass;
            ++n;
        }
    }

    protected void parseEnd() {
        this.ids.sort(new SortListener(){

            public void swap(int n, int n2) {
                PrintBase.this.indexes.swap(n, n2);
                PrintBase.this.types.swap(n, n2);
                PrintBase.this.sizes.swap(n, n2);
            }
        });
        this.btypes = new byte[this.ids.size()];
        int n = 0;
        while (n < this.ids.size()) {
            this.btypes[n] = (byte)this.types.get(n);
            ++n;
        }
        this.types = null;
        this.graph.complete();
    }

    String getString(int n) {
        return (String)this.strings.elementAt(n);
    }

    void addObject(int n, int n2, int n3, int n4) {
        this.ids.add(n);
        this.indexes.add(n2);
        this.types.add(n4);
        this.sizes.add(n3);
        this.totalSize += n3;
        ++this.totalCount;
        if (this.totalCount % 262144 == 0) {
            this.log("done " + this.totalCount + " objects");
        }
    }

    boolean excludeObject(int n) {
        int n2 = 0;
        while (n2 < this.excludeObjects.size()) {
            if (this.excludeObjects.get(n2) == n) {
                System.out.println("exclude object match found for " + Base.hex(n));
                return true;
            }
            ++n2;
        }
        return false;
    }

    boolean excludeClass(int n, String string) {
        int n2 = 0;
        while (n2 < this.excludeClasses.size()) {
            String string2 = (String)this.excludeClasses.elementAt(n2);
            if (string2.equals(string)) {
                System.out.println("exclude class match found for " + Base.hex(n));
                return true;
            }
            ++n2;
        }
        return false;
    }

    int maxroots() {
        return this.graph.maxroots;
    }

    int maxdepth() {
        return this.graph.maxdepth;
    }

    int prune() {
        return this.graph.prune;
    }

    int reachability(int n) {
        return 0;
    }

    void printNode(int n, int n2, boolean bl) {
        int n3 = this.printGraph.vertexIds.get(n);
        int n4 = this.reachability(n);
        int n5 = 0;
        while (n5 < n2) {
            System.out.print("   ");
            ++n5;
        }
        System.out.println(n4 + " " + this.getName(n3) + (bl ? "" : " (already visited)"));
    }

    void printTree(SimpleGraph simpleGraph, int n) {
        this.printGraph = simpleGraph;
        simpleGraph.complete();
        this.log("begin printTree");
        this.printNode(n, 0, true);
        simpleGraph.dfs(new Visitor(){
            int count = 0;

            public void visitChild(int n, int n2, boolean bl, int n3) {
                if (PrintBase.this.reachability(n2) < PrintBase.this.prune()) {
                    return;
                }
                PrintBase.this.printNode(n2, n3, bl);
            }

            public boolean continueSearch(int n, int n2) {
                return n2 < PrintBase.this.maxdepth() && PrintBase.this.reachability(n) > PrintBase.this.prune();
            }

            public int getCount(int n) {
                return PrintBase.this.reachability(n);
            }

            public boolean sort() {
                return true;
            }
        }, n);
        this.log("end printTree");
    }

    public void stringDump(String string) {
        this.strings.add(string);
    }

    public void objectDump(int n, int n2, int n3, int n4, int[] nArray) {
        if (this.excludeObject(n) || this.excludeClass(n, this.getString(n2))) {
            return;
        }
        this.graph.addVertex(n, nArray, n4);
        this.addObject(n, n2, n4, 1);
    }

    public void classDump(int n, int n2, int n3, int n4, int[] nArray) {
        if (this.excludeObject(n)) {
            return;
        }
        this.graph.addVertex(n, nArray, n4);
        this.addObject(n, n2, n4, 2);
    }

    public void primitiveArrayDump(int n, int n2, int n3, int n4) {
        if (this.excludeObject(n)) {
            return;
        }
        this.graph.addVertex(n, n4);
        this.addObject(n, n2, n4, 3);
    }

    public void objectArrayDump(int n, int n2, int n3, int n4, int[] nArray) {
        if (this.excludeObject(n)) {
            return;
        }
        this.graph.addVertex(n, nArray, n4);
        this.addObject(n, n2, n4, 4);
    }

    public int classId(int n) {
        return this.indexes.get(n) << 3 | this.type(n);
    }

    public String getClassName(int n) {
        int n2 = n & 7;
        int n3 = n >> 3;
        return this.getName(n3, n2);
    }

    public String getName(int n) {
        int n2 = this.ids.indexOf(n);
        if (n2 == -1) {
            return "(unknown id " + Base.hex(n) + ")";
        }
        int n3 = this.indexes.get(n2);
        int n4 = this.type(n2);
        return this.getName(n3, n4);
    }

    public String getName(int n, int n2) {
        switch (n2) {
            case 1: {
                return this.getString(n);
            }
            case 2: {
                return "class " + this.getString(n);
            }
            case 3: {
                return this.arrayName[n];
            }
            case 4: {
                return "array of " + this.getString(n);
            }
        }
        Base.Assert(false);
        return null;
    }

    int type(int n) {
        return this.btypes[n];
    }
}

