/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.plugins;

import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.plugins.OutputStrategy;
import com.ibm.jvm.dump.plugins.STGlobalData;

public abstract class HeapVisitor {
    protected boolean verbose = false;
    OutputStrategy outputStrategy = null;

    HeapVisitor(boolean bl, OutputStrategy outputStrategy) {
        this.verbose = bl;
        this.outputStrategy = outputStrategy;
    }

    HeapVisitor(OutputStrategy outputStrategy) {
        this(false, outputStrategy);
    }

    protected void reportVisit(String string, long l) {
        this.outputStrategy.output("Visiting " + string + " at 0x" + DvUtils.rJustifyZ(Long.toHexString(l + (long)STGlobalData.getSTGlobalData().getPtrSize()), 0));
    }

    public void visitObject(String string, long l, int[] nArray) {
        if (this.verbose) {
            this.reportVisit(string, l);
        }
        this.processObject(string, l, nArray);
    }

    abstract void processObject(String var1, long var2, int[] var4);

    public void visitArray(String string, long l) {
        if (this.verbose) {
            this.reportVisit(string, l);
        }
        this.processArray(string, l);
    }

    abstract void processArray(String var1, long var2);
}

