/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.plugins;

import com.ibm.jvm.dump.format.CTypeObject;
import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvAddressException;
import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvConsole;
import com.ibm.jvm.dump.format.DvDump;
import com.ibm.jvm.dump.format.DvJavaFrame;
import com.ibm.jvm.dump.format.DvRas;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.plugins.DvXeCommands;
import java.util.Vector;

public class DvXeCommandsSov
extends DvXeCommands {
    private static DvXeCommandsSov selfRef;
    private static int ptrLength;
    private static String[] commandsSupported;
    private static String[] mySuffixes;

    public DvXeCommandsSov() {
        selfRef = this;
        ptrLength = DvUtils.pointerLength();
    }

    public String[] getSuffixes() {
        return mySuffixes;
    }

    public String pluginName() {
        return "General plugin supporting trace format commands (for sov)";
    }

    public String[] getSyntax() {
        return commandsSupported;
    }

    public String[] guiPopupSyntax() {
        return null;
    }

    public static void showJavaFrameDetails(Vector vector, DvAddressSpace dvAddressSpace, DvJavaFrame dvJavaFrame) {
        block16: {
            long l = 3L;
            int n = (int)(dvJavaFrame.frameid() & l);
            long l2 = dvJavaFrame.frameid() & (l ^ 0xFFFFFFFFFFFFFFFFL);
            if (!DvXeCommands.showDetail || l2 == 0L || dvJavaFrame.getMb() == 0L) {
                return;
            }
            try {
                int n2;
                String string;
                CTypeObject cTypeObject = new CTypeObject("methodblock", dvJavaFrame.getMb(), dvAddressSpace);
                vector.add("\t\tMethod signature: " + DvXeCommandsSov.getMethodSignature(cTypeObject, dvAddressSpace));
                if (n == 0) {
                    CTypeObject cTypeObject2 = new CTypeObject("JavaFrame", l2, dvAddressSpace);
                    long l3 = cTypeObject2.getField("vars").getValue();
                    long l4 = cTypeObject.getField("args_size").getValue();
                    DvAddress dvAddress = new DvAddress(l3);
                    vector.add("\t\tJavaFrame = 0x" + Long.toHexString(l2));
                    vector.add("\t\targuments @ 0x" + Long.toHexString(l3));
                    if (l3 == 0L) {
                        return;
                    }
                    if (l4 > 0L) {
                        String string2 = "\t\tArguments = ";
                        int n3 = 0;
                        while ((long)n3 < l4) {
                            string2 = string2 + "0x" + Long.toHexString(dvAddressSpace.readPointer(dvAddress).getAddressAsLong()) + " ";
                            dvAddress.offsetBy(dvAddressSpace.pointerSize());
                            ++n3;
                        }
                        vector.add(string2);
                    } else {
                        vector.add("\t\tArguments : None");
                    }
                    vector.add("\t\tlocals    @ 0x" + Long.toHexString(l3 + l4 * (long)dvAddressSpace.pointerSize()));
                    long l5 = cTypeObject.getField("nlocals").getValue();
                    if ((l5 -= l4) > 0L) {
                        String string3 = "\t\tLocals    = ";
                        int n4 = 0;
                        while ((long)n4 < l5) {
                            dvAddress.offsetBy(dvAddressSpace.pointerSize());
                            string3 = string3 + "0x" + Long.toHexString(dvAddressSpace.readPointer(dvAddress).getAddressAsLong()) + " ";
                            ++n4;
                        }
                        vector.add(string3);
                    } else {
                        vector.add("\t\tLocals    : None");
                    }
                    break block16;
                }
                if (DvConsole.theDump.getProcessor() != 1 || n != 1 || dvAddressSpace.pointerSize() != 4) break block16;
                long l6 = cTypeObject.getField("args_size").getValue();
                long l7 = l2 + 36L;
                long l8 = cTypeObject.getField("nlocals").getValue();
                long l9 = l7 + cTypeObject.getField("nlocals").getValue() * (long)dvAddressSpace.pointerSize();
                vector.add("\t\tMmiFrame  = 0x" + Integer.toHexString((int)l2));
                vector.add("\t\targuments @ 0x" + Integer.toHexString((int)l9));
                DvAddress dvAddress = new DvAddress(l9);
                if (l6 > 0L) {
                    string = "\t\tArguments = ";
                    n2 = 0;
                    while ((long)n2 < l6) {
                        string = string + "0x" + Long.toHexString(dvAddressSpace.readPointer(dvAddress).getAddressAsLong()) + " ";
                        dvAddress.offsetBy(-dvAddressSpace.pointerSize());
                        ++n2;
                    }
                    vector.add(string);
                } else {
                    vector.add("\t\tArguments : None");
                }
                vector.add("\t\tlocals    @ 0x" + Integer.toHexString((int)l7));
                dvAddress = new DvAddress(l7);
                if ((l8 -= l6) > 0L) {
                    string = "\t\tLocals    = ";
                    n2 = 0;
                    while ((long)n2 < l8) {
                        string = string + "0x" + Long.toHexString(dvAddressSpace.readPointer(dvAddress).getAddressAsLong()) + " ";
                        dvAddress.offsetBy(-dvAddressSpace.pointerSize());
                        ++n2;
                    }
                    vector.add(string);
                    break block16;
                }
                vector.add("\t\tLocals    : None");
            }
            catch (Exception exception) {}
        }
    }

    private static String getMethodSignature(CTypeObject cTypeObject, DvAddressSpace dvAddressSpace) throws DvAddressException {
        return DvUtils.getStringFromBytes(dvAddressSpace.readBytes(cTypeObject.getField("member.signature").getValue(), 1024L));
    }

    public static void displayCC(CTypeObject cTypeObject, DvAddressSpace dvAddressSpace, Vector vector) {
        if (cTypeObject == null) {
            return;
        }
        try {
            CTypeObject cTypeObject2;
            String string;
            int n = 8;
            String string2 = "0000000000000000";
            String string3 = "00000000";
            if (DvUtils.is64BitSystem(DvConsole.theDump.getArchitecture())) {
                n = 16;
            }
            if (DvUtils.filtrate(string = DvXeCommandsSov.getMethodName(cTypeObject2 = cTypeObject.getField("mb").deReference(), dvAddressSpace), DvXeCommands.filter)) {
                String string4 = "0x" + Long.toHexString(cTypeObject.getField("start").getValue());
                int n2 = string4.length();
                if (8 == n && n2 < n) {
                    string4 = string3.substring(n2) + string4;
                }
                if (16 == n && n2 < n) {
                    string4 = string2.substring(n2) + string4;
                }
                String string5 = "0x" + Long.toHexString(cTypeObject.getField("end").getValue());
                n2 = string5.length();
                if (8 == n && n2 < n) {
                    string5 = string3.substring(n2) + string5;
                }
                if (16 == n && n2 < n) {
                    string5 = string2.substring(n2) + string5;
                }
                vector.add(string + " " + DvXeCommandsSov.getMethodSignature(cTypeObject2, dvAddressSpace) + " : (" + string4 + " - " + string5 + ")");
            }
            DvXeCommandsSov.displayCC(cTypeObject.getField("left").deReference(), dvAddressSpace, vector);
            DvXeCommandsSov.displayCC(cTypeObject.getField("right").deReference(), dvAddressSpace, vector);
        }
        catch (Exception exception) {}
    }

    public String whatIs(DvAddress dvAddress, String string, DvDump dvDump) {
        try {
            DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
            CTypeObject cTypeObject = DvXeCommandsSov.findAvlTreeRoot(dvAddressSpace, dvDump);
            CTypeObject cTypeObject2 = DvXeCommandsSov.findJitMethod(cTypeObject, dvAddress.getAddressAsLong());
            if (cTypeObject2 != null) {
                CTypeObject cTypeObject3 = cTypeObject2.getField("mb").deReference();
                String string2 = DvXeCommandsSov.getMethodName(cTypeObject3, dvAddressSpace);
                return "Address is in JITed code for method " + string2 + " " + DvXeCommandsSov.getMethodSignature(cTypeObject3, dvAddressSpace);
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static CTypeObject findAvlTreeRoot(DvAddressSpace dvAddressSpace, DvDump dvDump) {
        try {
            DvRas dvRas = dvDump.getRas();
            CTypeObject cTypeObject = new CTypeObject("jvm_ras_t", dvRas.jvmRas, dvAddressSpace);
            DvAddress dvAddress = new DvAddress(cTypeObject.getField("ras.data.jitRas").getValue());
            CTypeObject cTypeObject2 = null;
            if (dvAddress.getAddressAsLong() != 0L) {
                cTypeObject2 = new CTypeObject("jit_ras_t", dvAddressSpace.readPointer(dvAddress), dvAddressSpace);
            }
            DvAddress dvAddress2 = new DvAddress(cTypeObject2.getField("ras.data.avl_tree_root").getValue());
            CTypeObject cTypeObject3 = new CTypeObject("committed_code", dvAddressSpace.readPointer(dvAddress2), dvAddressSpace);
            return cTypeObject3;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String getMethodName(CTypeObject cTypeObject, DvAddressSpace dvAddressSpace) throws DvAddressException {
        String string = DvUtils.getStringFromBytes(dvAddressSpace.readBytes(cTypeObject.getField("member.name").getValue(), 1024L));
        CTypeObject cTypeObject2 = cTypeObject.getField("member.clazz").deReference();
        String string2 = DvUtils.getStringFromBytes(dvAddressSpace.readBytes(cTypeObject2.getField("obj.name").getValue(), 1024L));
        return string2 + "/" + string;
    }

    public static CTypeObject findJitMethod(CTypeObject cTypeObject, long l) throws DvAddressException {
        if (cTypeObject == null) {
            return null;
        }
        DvAddress dvAddress = new DvAddress(cTypeObject.getField("start").getValue());
        DvAddress dvAddress2 = new DvAddress(cTypeObject.getField("end").getValue());
        DvAddress dvAddress3 = new DvAddress(l);
        if (dvAddress3.compare(dvAddress) <= 0 && dvAddress3.compare(dvAddress2) >= 0) {
            return cTypeObject;
        }
        CTypeObject cTypeObject2 = DvXeCommandsSov.findJitMethod(cTypeObject.getField("left").deReference(), l);
        if (cTypeObject2 != null) {
            return cTypeObject2;
        }
        cTypeObject2 = DvXeCommandsSov.findJitMethod(cTypeObject.getField("right").deReference(), l);
        if (cTypeObject2 != null) {
            return cTypeObject2;
        }
        return null;
    }

    static {
        ptrLength = 4;
        commandsSupported = new String[0];
        mySuffixes = new String[]{"sov"};
    }
}

