/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.plugins;

import com.ibm.jvm.dump.format.CTypeObject;
import com.ibm.jvm.dump.format.Dumpviewer;
import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvAddressException;
import com.ibm.jvm.dump.format.DvConsole;
import com.ibm.jvm.dump.format.DvDump;
import com.ibm.jvm.dump.format.DvEnvData;
import com.ibm.jvm.dump.format.DvLoaded;
import com.ibm.jvm.dump.format.DvModule;
import com.ibm.jvm.dump.format.DvNativeFrame;
import com.ibm.jvm.dump.format.DvProcess;
import com.ibm.jvm.dump.format.DvThread;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.plugins.DvClassCommands;
import com.ibm.jvm.dump.plugins.DvJavacorePlugin;
import com.ibm.jvm.dump.plugins.DvObjectsCommands;
import com.ibm.jvm.dump.plugins.SovTraceObject;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class DvJavacoreSov
extends DvJavacorePlugin {
    private static DvThread myThread = null;
    private static boolean verbose = false;
    private static boolean DEBUG = false;
    private static boolean staticsInitialised = false;
    private static CTypeObject ee = null;
    private static CTypeObject jvm = null;
    private static SovTraceObject traceData = null;
    private static CTypeObject xeData = null;
    private static CTypeObject stData = null;
    private static DvJavacoreSov selfRef;
    private static int ptrLength;
    private static String[] commandsSupported;
    private static String[] mySuffixes;
    private static final int TRUE = 1;
    private static final int FALSE = 0;
    private static final long DG_TRC_BUFFER_ACTIVE = 0x80000000L;

    public DvJavacoreSov() {
        selfRef = this;
        ptrLength = DvUtils.pointerLength();
    }

    public String[] getSuffixes() {
        return mySuffixes;
    }

    public String pluginName() {
        return "General plugin supporting Javacore commands (for sov)";
    }

    public String[] getSyntax() {
        return commandsSupported;
    }

    public String[] guiPopupSyntax() {
        return null;
    }

    protected static void newSection(String string) {
        if (!staticsInitialised) {
            DvJavacoreSov.initStatics();
        }
        DvJavacorePlugin.newSection(string);
    }

    public static void doTITLESection() {
        try {
            DvJavacoreSov.newSection("TITLE");
            String string = null;
            try {
                int n = DvJavacorePlugin.readAnInt(traceData.getField("signalNumber"));
                string = "signal " + n + " received";
                if (n == 0) {
                    string = "signal received not available in dump";
                }
            }
            catch (Exception exception) {
                string = "signal received not available in dump";
            }
            DvJavacorePlugin.printWithTag("1TISIGINFO", string);
            String string2 = null;
            try {
                CTypeObject cTypeObject = traceData.getField("signalTime");
                string2 = DvJavacorePlugin.getCStringFromPtr(cTypeObject);
                if (string2.equals("")) {
                    string2 = "<not available in dump>";
                }
            }
            catch (Exception exception) {
                string2 = "<not available in dump>";
            }
            DvJavacorePlugin.printWithTag("1TIDATETIME", "Date:                 " + string2);
            DvJavacorePlugin.printWithTag("1TIFILENAME", "Javacore filename:    <simulated javadump>");
        }
        catch (Exception exception) {
            DvJavacorePlugin.outputAdd("*** Unexpected exception received in doTITLESection ");
            DvJavacorePlugin.outputAdd("    " + exception.getMessage());
            DvJavacorePlugin.outputFlush();
            exception.printStackTrace();
        }
        DvJavacorePlugin.outputFlush();
    }

    public static void doXHPISection() {
        DvJavacoreSov.newSection("XHPI");
        DvJavacorePlugin.printWithTag("NULL", " ");
        DvJavacorePlugin.printWithTag("2HXENVVARS", "Environment Variables");
        DvJavacorePlugin.printWithTag("NULL", "---------------------");
        String[] stringArray = DvJavacorePlugin.getEnvVarsFromDump();
        if (stringArray == null) {
            DvJavacorePlugin.printWithTag("3HXNOENVVARS", "UNSUPPORTED: No environment variables in this dump");
        } else if (stringArray[0].indexOf("No loaded information for this process") != -1) {
            DvJavacorePlugin.printWithTag("3HXNOENVVARS", "UNSUPPORTED: No environment variables in this dump");
        } else {
            int n = 0;
            while (n < stringArray.length) {
                DvJavacorePlugin.printWithTag("3HXENVVAR", stringArray[n]);
                ++n;
            }
        }
        DvJavacorePlugin.printWithTag("NULL", " ");
        DvJavacorePlugin.printWithTag("1XHLOADEDLIBS", "Loaded Libraries (sizes in bytes)");
        DvJavacorePlugin.printWithTag("NULL", "----------------");
        DvLoaded dvLoaded = null;
        DvProcess[] dvProcessArray = DvJavacorePlugin.as.getProcesses();
        int n = 0;
        while (n < dvProcessArray.length) {
            try {
                boolean bl = false;
                try {
                    dvLoaded = dvProcessArray[n].getLoaded();
                }
                catch (Error error) {
                    bl = true;
                }
                if (bl) {
                    DvJavacorePlugin.printWithTag("2XHNOLIBS", "UNSUPPORTED: Unsupported function DvProcess.getLoaded()");
                } else if (dvLoaded == null) {
                    DvJavacorePlugin.printWithTag("2XHNOLIBS", "No loaded information for process " + dvProcessArray[n].id());
                } else {
                    DvModule[] dvModuleArray = dvLoaded.getModules();
                    int n2 = 0;
                    while (n2 < dvModuleArray.length) {
                        String string = DvJavacorePlugin.truncateAtIllegalChar(dvModuleArray[n2].name());
                        DvJavacorePlugin.printWithTag("2XHLIBNAME", string);
                        if (dvModuleArray[n2].moduleSize == 0L) {
                            DvJavacorePlugin.printWithTag("3XHNOLIBINFO", "    filesize    : unknown");
                        } else {
                            DvJavacorePlugin.printWithTag("3XHLIBSIZE", "    filesize    : " + dvModuleArray[n2].size());
                        }
                        DvJavacorePlugin.printWithTag("3XHLIBSTART", "    start addr  : 0x" + Long.toHexString(dvModuleArray[n2].address().getAddressAsLong()));
                        ++n2;
                    }
                }
            }
            catch (Exception exception) {
                DvJavacorePlugin.output.add("*** Error: Unexpected exception in doXHPISection()");
                DvJavacorePlugin.outputFlush();
                exception.printStackTrace();
            }
            ++n;
        }
        DvJavacorePlugin.printWithTag("NULL", " ");
        DvJavacorePlugin.outputFlush();
    }

    public static void doCISection() {
        DvJavacorePlugin.newSection("CI");
        DvEnvData dvEnvData = null;
        DvProcess dvProcess = null;
        DvDump dvDump = DvConsole.theDump;
        try {
            dvProcess = DvJavacorePlugin.as.getCurrentProcess();
        }
        catch (Error error) {
            DvJavacorePlugin.printWithTag("NULL", "UNSUPPORTED: Unsupported function DvAddressSpace.getCurrentProcess()");
            DvJavacorePlugin.outputFlush();
            dvProcess = null;
        }
        try {
            String string;
            String string2;
            String[] stringArray;
            block32: {
                if (dvProcess != null) {
                    dvEnvData = dvProcess.getEnvData();
                }
                stringArray = DvJavacorePlugin.getEnvVarsFromDump();
                CTypeObject cTypeObject = jvm.getField("fullVersion");
                string2 = null;
                try {
                    string2 = DvJavacorePlugin.getCStringFromPtr(cTypeObject);
                }
                catch (DvAddressException dvAddressException) {
                    string2 = "<version not available>";
                    if (dvEnvData == null || (string2 = dvEnvData.javaVersion().trim()) != null && !string2.equals("")) break block32;
                    string2 = "<version not available>";
                }
            }
            DvJavacorePlugin.printWithTag("1CIJAVAVERSION", string2);
            String string3 = "";
            int n = 0;
            int n2 = 1;
            int n3 = 2;
            int n4 = DvJavacorePlugin.readAnInt(jvm.getField("mode"));
            if (n4 == n) {
                string3 = "standalone";
            } else if (n4 == n2) {
                string3 = "master";
            } else if (n4 == n3) {
                string3 = "worker";
            }
            DvJavacorePlugin.printWithTag("1CIRUNNINGAS", "Running as a " + string3 + " JVM");
            if (dvProcess != null) {
                if (stringArray != null) {
                    string = null;
                    int n5 = 0;
                    while (n5 < stringArray.length) {
                        if (stringArray[n5].startsWith("IBM_JAVA_COMMAND_LINE=")) {
                            string = stringArray[n5].substring(22);
                        }
                        ++n5;
                    }
                    if (string != null) {
                        DvJavacorePlugin.printWithTag("1CICMDLINE", string);
                    } else {
                        DvJavacorePlugin.printWithTag("1CICMDLINE", "<not present in dump>");
                    }
                } else {
                    DvJavacorePlugin.printWithTag("1CICMDLINE", "<not supported in dump>");
                }
            } else {
                DvJavacorePlugin.printWithTag("NULL", "UNSUPPORTED: Unable to display Java commandline");
            }
            if (dvProcess != null && dvEnvData != null) {
                string = dvEnvData.javaHomeDir().trim();
                DvJavacorePlugin.outputFlush();
                if (string == null || string.startsWith("<<<<") || string.equals("Not available")) {
                    DvJavacorePlugin.printWithTag("1CIJAVAHOMEDIR", "Java Home Dir:   <not present in dump>");
                } else {
                    DvJavacorePlugin.printWithTag("1CIJAVAHOMEDIR", "Java Home Dir:   " + string);
                }
            } else {
                DvJavacorePlugin.printWithTag("NULL", "UNSUPPORTED: Unable to display Java Home");
            }
            if (dvProcess != null && dvEnvData != null) {
                string = dvEnvData.javaDllDir().trim();
                if (string == null || string.startsWith("<<<<") || string.equals("Not available")) {
                    DvJavacorePlugin.printWithTag("1CIJAVADLLDIR", "Java DLL Dir:    <not present in dump>");
                } else {
                    DvJavacorePlugin.printWithTag("1CIJAVADLLDIR", "Java DLL Dir:    " + string);
                }
            } else {
                DvJavacorePlugin.printWithTag("1CIJAVADLLDIR", "UNSUPPORTED: Unable to display Java DLL directory");
            }
            DvJavacorePlugin.printWithTag("1CISYSCP", "Sys Classpath:   <not yet available>");
            if (dvProcess != null && dvEnvData != null) {
                string = dvEnvData.classpath().trim();
                if (string == null || string.startsWith("<<<<") || string.equals("Not available")) {
                    DvJavacorePlugin.printWithTag("1CIUSRCP", "User Classpath:  <not present in dump>");
                } else {
                    DvJavacorePlugin.printWithTag("1CIUSRCP", "User Classpath:  " + string);
                }
            } else {
                DvJavacorePlugin.printWithTag("1CIUSRCP", "UNSUPPORTED: Unable to display User Classpath");
            }
            DvJavacorePlugin.printWithTag("1CIUSERARGS", "UserArgs:");
            DvJavacorePlugin.printWithTag("2CIUSERARG", "          <not yet available>");
            DvJavacorePlugin.printWithTag("NULL", "");
            DvJavacorePlugin.printWithTag("1CIJVMMI", "JVM Monitoring Interface (JVMMI)");
            DvJavacorePlugin.printWithTag("NULL", "------------------------");
            DvJavacorePlugin.printWithTag("NULL", "<not yet available>");
            DvJavacorePlugin.printWithTag("NULL", "");
            DvJavacorePlugin.outputFlush();
        }
        catch (Exception exception) {
            DvJavacorePlugin.outputAdd("*** Error: unexpected exception received in doCISection");
            DvJavacorePlugin.outputFlush();
            exception.printStackTrace();
        }
    }

    public static void doDCSection() {
        DvDump dvDump = DvConsole.theDump;
        DvJavacoreSov.newSection("DC");
        CTypeObject cTypeObject = jvm.getField("facade.dc");
        CTypeObject cTypeObject2 = cTypeObject.getField("header");
        CTypeObject cTypeObject3 = cTypeObject2.getField("length");
        boolean bl = DvUtils.is64BitSystem(dvDump.getArchitecture());
        int n = 0;
        n = bl ? 8 : 4;
        long l = cTypeObject.getAddr();
        int n2 = DvJavacorePlugin.readAnInt(cTypeObject3);
        try {
            long l2 = l + (long)n2 - (long)n;
            DvAddress dvAddress = DvJavacorePlugin.as.readPointer(DvJavacorePlugin.as.createAddress(l2));
            long l3 = dvAddress.getAddressAsLong();
            CTypeObject cTypeObject4 = new CTypeObject("JvmDataHeader", DvJavacorePlugin.as.createAddress(l3), DvJavacorePlugin.as);
            CTypeObject cTypeObject5 = cTypeObject4.getField("eyecatcher");
            CTypeObject cTypeObject6 = cTypeObject4.getField("length");
            CTypeObject cTypeObject7 = cTypeObject4.getField("version");
            CTypeObject cTypeObject8 = cTypeObject4.getField("modification");
            String string = cTypeObject5.getString("US-ASCII", 4);
            int n3 = (int)cTypeObject6.getValue();
            int n4 = (int)cTypeObject7.getValue();
            int n5 = (int)cTypeObject8.getValue();
            DvJavacorePlugin.printWithTag("1DCHEADEREYE", "Header eye catcher  " + string);
            DvJavacorePlugin.printWithTag("1DCHEADERLEN", "Header length       " + n3);
            DvJavacorePlugin.printWithTag("1DCHEADERVER", "Header version      " + n4);
            DvJavacorePlugin.printWithTag("1DCHEADERMOD", "Header modification " + n5);
            DvJavacorePlugin.printWithTag("1DCINTERFACE", "<not yet available>");
            DvJavacorePlugin.printWithTag("1DCARRAYINFO", "<not yet available>");
        }
        catch (Exception exception) {
            DvJavacorePlugin.outputFlush();
            System.out.println("*** Unxpected Exception in doDCSection()");
            exception.printStackTrace();
        }
        DvJavacorePlugin.outputFlush();
    }

    public static void doDGSection() {
        DvJavacoreSov.newSection("DG");
        boolean bl = verbose;
        boolean bl2 = false;
        try {
            Object object;
            String string;
            Object object2;
            Object object3;
            String string2;
            String string3;
            String string4;
            String string5;
            String string6;
            String string7 = "Trace Enabled: " + DvJavacorePlugin.boolFieldToString(traceData.getField("traceEnabled"), "Yes", "No");
            DvJavacorePlugin.printWithTag("1DGTRCENABLED", string7);
            if (string7.equals("Yes")) {
                bl2 = true;
            }
            if ((string6 = "  " + DvJavacorePlugin.boolFieldToString(traceData.getField("traceActive"), "Trace activated", "[Trace NOT activated]")).indexOf("[") == -1 || bl) {
                DvJavacorePlugin.printWithTag("2DGTRCACTIVATE", string6);
            }
            if (string6.indexOf("[") == -1) {
                bl2 = true;
            }
            if ((string5 = "  " + DvJavacorePlugin.boolFieldToString(traceData.getField("traceTerminate"), "Trace terminated", "[Trace NOT terminated]")).indexOf("[") == -1 || bl) {
                DvJavacorePlugin.printWithTag("2DGTRCTERMINATE", string5);
            }
            int n = DvJavacorePlugin.readAnInt(traceData.getField("traceSuspend"));
            String string8 = null;
            if (n == -1) {
                DvJavacorePlugin.printWithTag("2DGTRCSUSPEND", "  ***Error reading Trace suspend flags***");
            } else if (n == 0 && bl) {
                string8 = "  Trace suspend flags:0x" + Long.toHexString(n);
                DvJavacorePlugin.printWithTag("2DGTRCSUSPEND", string8);
            } else if (bl) {
                DvJavacorePlugin.printWithTag("2DGTRCSUSPEND", "  [Trace suspend flags: ZERO]");
            }
            String string9 = "  " + DvJavacorePlugin.boolFieldToString(traceData.getField("traceInitSpec"), "Initialization traced", "[Initialization NOT traced]");
            if (string9.indexOf("[") == -1 || bl) {
                DvJavacorePlugin.printWithTag("2DGTRCJVMINIT", string9);
            }
            if (bl2 || bl) {
                string4 = "  Trace: " + DvJavacorePlugin.boolFieldToString(traceData.getField("externalTrace"), "Ex", "In") + "ternal";
                DvJavacorePlugin.printWithTag("2DGTRCTYPE", string4);
            }
            if (DvJavacorePlugin.getCStringFromPtr(traceData.getField("traceFilename")) != null) {
                string4 = "  Filename: " + DvJavacorePlugin.getCStringFromPtr(traceData.getField("traceFilename"));
                DvJavacorePlugin.printWithTag("2DGTRCFILE", string4);
            } else if (bl) {
                DvJavacorePlugin.printWithTag("2DGTRCFILE", "  [Filename: null]");
            }
            int n2 = DvJavacorePlugin.readAnInt(traceData.getField("lostRecords"));
            if (n2 != 0) {
                String string10 = "  Number of lost trace records: " + n2;
                DvJavacorePlugin.printWithTag("2DGTRCLOST", string10);
            } else if (bl) {
                DvJavacorePlugin.printWithTag("2DGTRCLOST", "  [Number of lost trace records: 0]");
            }
            int n3 = DvJavacorePlugin.readAnInt(traceData.getField("traceWrap"));
            if (n3 != 0) {
                string3 = "  Maximum file size: " + n3;
                DvJavacorePlugin.printWithTag("2DGTRCFILEWRAP", string3);
            } else if (bl) {
                DvJavacorePlugin.printWithTag("2DGTRCFILEWRAP", "  [Maximum file size: 0]");
            }
            string3 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
            int n4 = DvJavacorePlugin.readAnInt(traceData.getField("traceGenerations"));
            int n5 = DvJavacorePlugin.readAnInt(traceData.getField("nextGeneration"));
            String string11 = string3.substring(n5, n5 + 1);
            if (n4 != 0) {
                string2 = "  Number of trace generations: " + n4;
                DvJavacorePlugin.printWithTag("2DGTRCGENERATE", string2);
                String string12 = "  Next trace generation: " + string11;
                DvJavacorePlugin.printWithTag("2DGTRCNEXTGEN", string12);
            } else if (bl) {
                DvJavacorePlugin.printWithTag("2DGTRCGENERATE", "  [Number of trace generations: 0]");
                DvJavacorePlugin.printWithTag("2DGTRCNEXTGEN", "  [Next trace generation: " + string11 + "]");
            }
            if (DvJavacorePlugin.getCStringFromPtr(traceData.getField(DvJavacoreSov.traceData.tracePropFileSpec)) != null) {
                string2 = DvJavacorePlugin.getCStringFromPtr(traceData.getField(DvJavacoreSov.traceData.tracePropFileSpec));
                string2 = "  Property filename: " + string2;
                DvJavacorePlugin.printWithTag("2DGTRCPROPS", string2);
            } else if (bl) {
                DvJavacorePlugin.printWithTag("2DGTRCPROPS", "  [Property filename: null]");
            }
            long l = DvJavacorePlugin.readPtrAsLong(traceData.getField("traceBufferSpec"));
            if (l != 0L) {
                object3 = "  Buffer specification: " + DvJavacorePlugin.getCStringFromPtr(traceData.getField("traceBufferSpec"));
                DvJavacorePlugin.printWithTag("2DGTRCBUFFERS", (String)object3);
            } else if (bl) {
                DvJavacorePlugin.printWithTag("2DGTRCBUFFERS", "  [Buffer specification: null]");
            }
            object3 = traceData.getField("traceGlobal");
            if (DvJavacorePlugin.readPtrAsLong((CTypeObject)object3) != 0L) {
                int n6 = 0;
                int n7 = 0;
                while (DvJavacorePlugin.readPtrAsLong((CTypeObject)object3) != 0L) {
                    ++n6;
                    object2 = ((CTypeObject)object3).deReference().getField("flags");
                    long l2 = DvJavacorePlugin.readAnInt((CTypeObject)object2);
                    if ((l2 & 0x80000000L) != 0L) {
                        ++n7;
                    }
                    object3 = ((CTypeObject)object3).deReference().getField("globalNext");
                }
                object2 = "  Buffers allocated: " + n6;
                DvJavacorePlugin.printWithTag("2DGTRCBUFALLOC", (String)object2);
                string = "  Buffers in use:    " + n7;
                DvJavacorePlugin.printWithTag("2DGTRCBUFUSED", string);
            } else if (bl) {
                DvJavacorePlugin.printWithTag("2DGTRCBUFALLOC", "  [Buffers allocated: 0]");
                DvJavacorePlugin.printWithTag("2DGTRCBUFUSED", "  [Buffers in use:    0]");
            }
            if (DvJavacorePlugin.getCStringFromPtr(traceData.getField("exceptFilename")) != null) {
                String string13 = "  Exception filename: " + DvJavacorePlugin.getCStringFromPtr(traceData.getField("exceptFilename"));
                DvJavacorePlugin.printWithTag("2DGTRCEXCEPTFN", string13);
            } else if (bl) {
                DvJavacorePlugin.printWithTag("2DGTRCEXCEPTFN", "  [Exception filename: null]");
            }
            int n8 = DvJavacorePlugin.readAnInt(traceData.getField("exceptTraceWrap"));
            if (n8 != 0) {
                String string14 = "  Maximum exception file size: " + n8;
                DvJavacorePlugin.printWithTag("2DGTRCEXCPTMAX", string14);
            } else if (bl) {
                DvJavacorePlugin.printWithTag("2DGTRCEXCPTMAX", "  [Maximum exception file size: 0]");
            }
            if (DvJavacorePlugin.getCStringFromPtr(traceData.getField("stateFilename")) != null) {
                String string15 = "  State filename: " + DvJavacorePlugin.getCStringFromPtr(traceData.getField("stateFilename"));
                DvJavacorePlugin.printWithTag("2DGTRCSTATEFN", string15);
            } else if (bl) {
                DvJavacorePlugin.printWithTag("2DGTRCSTATEFN", "  [State filename: null]");
            }
            int n9 = DvJavacorePlugin.readAnInt(traceData.getField("stateTraceWrap"));
            if (n9 != 0) {
                object2 = "  Maximum state file size: " + n9;
                DvJavacorePlugin.printWithTag("2DGTRCSTATEMAX", (String)object2);
            } else if (bl) {
                DvJavacorePlugin.printWithTag("2DGTRCSTATEMAX", "  [Maximum state file size: 0]");
            }
            object2 = traceData.getField("traceApplids");
            if (DvJavacorePlugin.readPtrAsLong((CTypeObject)object2) != 0L) {
                DvJavacorePlugin.printWithTag("2DGTRCAPPLTRC", "  Application trace enabled");
                DvJavacorePlugin.printWithTag("3DGTRCAPPLID", "    ***IBM.WRITEME***");
            } else if (bl) {
                DvJavacorePlugin.printWithTag("2DGTRCAPPLTRC", "  [Application trace NOT enabled]");
                DvJavacorePlugin.printWithTag("3DGTRCAPPLID", "    [***IBM.WRITEME***]");
            }
            if (DvJavacorePlugin.getCStringFromPtr(traceData.getField("traceMethodSpec")) != null) {
                string = "  Method trace specification: " + DvJavacorePlugin.getCStringFromPtr(traceData.getField("traceMethodSpec"));
                DvJavacorePlugin.printWithTag("2DGTRCMETHODS", string);
            } else if (bl) {
                DvJavacorePlugin.printWithTag("2DGTRCMETHODS", "  [Method trace specification: n/a]");
            }
            if (DvJavacorePlugin.readPtrAsLong(traceData.getField("traceListeners")) != 0L) {
                string = "  Trace listener routines:";
                DvJavacorePlugin.printWithTag("2DGTRCLISTEN", string);
                boolean bl3 = false;
                CTypeObject cTypeObject = null;
                if (DvJavacorePlugin.readPtrAsLong(traceData.getField("traceListeners")) == 0L) {
                    bl3 = true;
                } else {
                    cTypeObject = traceData.getField("traceListeners").deReference();
                }
                while (!bl3) {
                    object = Long.toHexString(DvJavacorePlugin.readPtrAsLong(cTypeObject.getField("Trace")));
                    DvJavacorePlugin.printWithTag("3DGTRCLISTENR", "    Listener: 0x" + (String)object);
                    if (DvJavacorePlugin.readPtrAsLong(cTypeObject.getField("next")) == 0L) {
                        bl3 = true;
                        continue;
                    }
                    cTypeObject = cTypeObject.getField("next").deReference();
                }
            } else if (bl) {
                DvJavacorePlugin.printWithTag("2DGTRCLISTEN", "  Trace listener routines: NONE");
            }
            string = DvJavacorePlugin.boolFieldToString(traceData.getField("check_ras_plugin"), "RAS plug-in is in control", "[RAS plug-in is NOT in control]");
            if (string.indexOf("[") == -1 || bl) {
                DvJavacorePlugin.printWithTag("1DGRASPLUGINACT", string);
            }
            if (DvJavacorePlugin.readPtrAsLong(traceData.getField("dumpExits")) != 0L) {
                String string16 = "Dump exit routines:";
                DvJavacorePlugin.printWithTag("1DGDMPEXIT", string16);
                boolean bl4 = false;
                object = null;
                if (DvJavacorePlugin.readPtrAsLong(traceData.getField("dumpExits")) == 0L) {
                    bl4 = true;
                } else {
                    object = traceData.getField("dumpExits").deReference("DgDumpExit");
                }
                while (!bl4) {
                    String string17 = Long.toHexString(DvJavacorePlugin.readPtrAsLong(((CTypeObject)object).getField("exit")));
                    DvJavacorePlugin.printWithTag("2DGTRCLISTENR", "  Exit: 0x" + string17);
                    if (DvJavacorePlugin.readPtrAsLong(((CTypeObject)object).getField("next")) == 0L) {
                        bl4 = true;
                        continue;
                    }
                    object = ((CTypeObject)object).getField("next").deReference("DgDumpExit");
                }
            } else if (bl) {
                DvJavacorePlugin.printWithTag("1DGDMPEXIT", "[Dump exit routines: NONE]");
            }
            String string18 = "Javadump buffer size (allocated): " + DvJavacorePlugin.readAnInt(traceData.getField("printBufferSize"));
            DvJavacorePlugin.printWithTag("1DGJDUMPBUFF", string18);
        }
        catch (Exception exception) {
            DvJavacorePlugin.output.add("*** Exception thrown in doDGSection while processing DG Dump Routine.");
            DvJavacorePlugin.output.add("    " + exception.getMessage());
            DvJavacorePlugin.outputFlush();
            exception.printStackTrace();
        }
        DvJavacorePlugin.outputFlush();
    }

    public static void doSTSection() {
        DvJavacoreSov.newSection("ST");
        String string = "<dummy>";
        try {
            int n;
            CTypeObject cTypeObject;
            long l;
            CTypeObject cTypeObject2;
            CTypeObject cTypeObject3 = stData.getField("st_jab").deReference("StorageJAB");
            if (cTypeObject3 == null) {
                System.out.println("*** Error: storage JAB is null!");
                throw new RuntimeException("Storage JAB is null");
            }
            CTypeObject cTypeObject4 = jvm.getField("jab").deReference("JvmSetAnchorBlock");
            CTypeObject cTypeObject5 = cTypeObject4.getField("xm.resettable");
            String string2 = DvJavacorePlugin.boolFieldToString(cTypeObject5, "Yes", "No");
            DvJavacorePlugin.printWithTag("1STGCMODES", "Resettable GC: " + string2);
            CTypeObject cTypeObject6 = stData.getField("concurrent_execution_mode");
            int n2 = DvJavacorePlugin.readAnInt(cTypeObject6);
            int n3 = 1;
            String string3 = null;
            string3 = n2 != n3 ? "Yes" : "No";
            DvJavacorePlugin.printWithTag("1STGCMODES", "Concurrent GC: " + string3);
            CTypeObject cTypeObject7 = stData.getField("curHeapMin");
            long l2 = DvJavacorePlugin.readPtrAsLong(cTypeObject7);
            DvJavacorePlugin.printWithTag("1STCURHBASE", "Current Heap Base: " + Long.toHexString(l2));
            CTypeObject cTypeObject8 = stData.getField("curHeapMax");
            long l3 = DvJavacorePlugin.readPtrAsLong(cTypeObject8);
            DvJavacorePlugin.printWithTag("1STCURHLIM", "Current Heap Limit: " + Long.toHexString(l3));
            CTypeObject cTypeObject9 = stData.getField("MH_heapbase");
            long l4 = DvJavacorePlugin.readPtrAsLong(cTypeObject9);
            DvJavacorePlugin.printWithTag("1STMWHBASE", "Middleware Heap Base: " + Long.toHexString(l4));
            CTypeObject cTypeObject10 = stData.getField("MH_heaplimit");
            long l5 = DvJavacorePlugin.readPtrAsLong(cTypeObject10);
            DvJavacorePlugin.printWithTag("1STMWHLIM", "Middleware Heap Limit: " + Long.toHexString(l5));
            if (string2.equals("Yes")) {
                cTypeObject2 = stData.getField("TH_heapbase");
                l = DvJavacorePlugin.readPtrAsLong(cTypeObject2);
                DvJavacorePlugin.printWithTag("1STTHBASE", "Transient Heap Base: " + Long.toHexString(l));
            }
            if (string2.equals("Yes")) {
                cTypeObject2 = stData.getField("TH_heaplimit");
                l = DvJavacorePlugin.readPtrAsLong(cTypeObject2);
                DvJavacorePlugin.printWithTag("1STTHLIM", "Transient Heap Limit: " + Long.toHexString(l));
            }
            cTypeObject2 = stData.getField("gcHelpersTarget");
            int n4 = DvJavacorePlugin.readAnInt(cTypeObject2);
            DvJavacorePlugin.printWithTag("1STGCHELPERS", "Number of GC Helper Threads: " + n4);
            CTypeObject cTypeObject11 = cTypeObject3.getField("alloc_2_trace_rate");
            int n5 = DvJavacorePlugin.readAnInt(cTypeObject11);
            DvJavacorePlugin.printWithTag("1STJVMOPTS", "-Xconcurrentlevel: " + n5);
            CTypeObject cTypeObject12 = cTypeObject3.getField("gcConcurrentBKHelpers");
            int n6 = DvJavacorePlugin.readAnInt(cTypeObject12);
            DvJavacorePlugin.printWithTag("1STJVMOPTS", "-Xconcurrentbackground: " + n6);
            if (string3.equals("Yes")) {
                cTypeObject = stData.getField("conctr");
                n = DvJavacorePlugin.readAnInt(cTypeObject);
                DvJavacorePlugin.printWithTag("1STCONCTR", "Concurrent Counter: " + n);
            }
            cTypeObject = stData.getField("gcctr");
            n = DvJavacorePlugin.readAnInt(cTypeObject);
            DvJavacorePlugin.printWithTag("1STGCCTR", "GC Counter: " + n);
            CTypeObject cTypeObject13 = stData.getField("afctr");
            int n7 = DvJavacorePlugin.readAnInt(cTypeObject13);
            DvJavacorePlugin.printWithTag("1STAFCTR", "AF Counter: " + n7);
            CTypeObject cTypeObject14 = stData.getField("FreeObjectCtr");
            int n8 = DvJavacorePlugin.readAnInt(cTypeObject14);
            DvJavacorePlugin.printWithTag("1STHEAPFREE", "Bytes of Heap Space Free: " + n8);
            CTypeObject cTypeObject15 = stData.getField("TotalObjectCtr");
            int n9 = DvJavacorePlugin.readAnInt(cTypeObject15);
            DvJavacorePlugin.printWithTag("1STHEAPALLOC", "Bytes of Heap Space Allocated: " + n9);
            CTypeObject cTypeObject16 = cTypeObject3.getField("SM_base");
            long l6 = DvJavacorePlugin.readPtrAsLong(cTypeObject16);
            DvJavacorePlugin.printWithTag("1STSMBASE", "SM Base: " + Long.toHexString(l6));
            CTypeObject cTypeObject17 = cTypeObject3.getField("SM_end");
            long l7 = DvJavacorePlugin.readPtrAsLong(cTypeObject17);
            DvJavacorePlugin.printWithTag("1STSMEND", "SM End: " + Long.toHexString(l7));
            CTypeObject cTypeObject18 = cTypeObject3.getField("PAM_start");
            long l8 = DvJavacorePlugin.readPtrAsLong(cTypeObject18);
            DvJavacorePlugin.printWithTag("1STSMEND", "PAM Start: " + Long.toHexString(l8));
            CTypeObject cTypeObject19 = cTypeObject3.getField("PAM_end");
            long l9 = DvJavacorePlugin.readPtrAsLong(cTypeObject19);
            DvJavacorePlugin.printWithTag("1STSMEND", "PAM End: " + Long.toHexString(l9));
            CTypeObject cTypeObject20 = stData.getField("compact_action");
            int n10 = DvJavacorePlugin.readAnInt(cTypeObject20);
            DvJavacorePlugin.printWithTag("1STCOMACTION", "Compact Action: " + n10);
        }
        catch (Exception exception) {
            DvJavacorePlugin.output.add("*** Unexpected exception recived during stDumpRoutine processing.");
            DvJavacorePlugin.output.add(exception.getMessage());
            DvJavacorePlugin.outputFlush();
            exception.printStackTrace();
        }
        DvJavacorePlugin.outputFlush();
    }

    public static void doXESection() {
        DvJavacoreSov.newSection("XE");
        try {
            CTypeObject cTypeObject = xeData.getField("common");
            CTypeObject cTypeObject2 = cTypeObject.getField("before_compile_java");
            int n = DvJavacorePlugin.readAnInt(cTypeObject2);
            DvJavacorePlugin.printWithTag("1XETHRESHOLD", "MMI threshold for java methods is set to " + n);
            CTypeObject cTypeObject3 = cTypeObject.getField("compiler_initialized");
            String string = DvJavacorePlugin.boolFieldToString(cTypeObject3, "Yes", "No");
            if (string.equals("Yes")) {
                DvJavacorePlugin.printWithTag("1XEJITINIT", "JIT is initialized");
            } else {
                DvJavacorePlugin.printWithTag("1XEJITNINIT", "JIT is not initialized");
            }
            CTypeObject cTypeObject4 = cTypeObject.getField("do_jvmpi_instruction_events");
            String string2 = DvJavacorePlugin.boolFieldToString(cTypeObject4, "Yes", "No");
            if (string2.equals("Yes")) {
                DvJavacorePlugin.printWithTag("1XEJVMPION", "JVMPI is activated");
            } else {
                DvJavacorePlugin.printWithTag("1XEJVMPIOFF", "JVMPI is not activated");
            }
            CTypeObject cTypeObject5 = xeData.getField("mmi");
            CTypeObject cTypeObject6 = cTypeObject5.getField("before_compile_jni");
            int n2 = DvJavacorePlugin.readAnInt(cTypeObject6);
            DvJavacorePlugin.printWithTag("1XEJNITHRESH", "MMI threshold for JNI methods is set to " + n2);
            CTypeObject cTypeObject7 = cTypeObject5.getField("history_length");
            int n3 = DvJavacorePlugin.readAnInt(cTypeObject7);
            DvJavacorePlugin.printWithTag("1XETRCHIS", "Trace history length is set to " + n3);
            DvJavacorePlugin.printWithTag("1XEJITDUMP", "JIT dump routine is not yet implemented.");
        }
        catch (Exception exception) {
            DvJavacorePlugin.outputFlush();
            System.out.println("*** unexpected Exception received in doXESection()");
            System.out.println("    " + exception.getMessage());
            exception.printStackTrace();
        }
        DvJavacorePlugin.outputFlush();
    }

    public static void doLKSection() {
        DvJavacoreSov.newSection("LK");
        Vector vector = DvObjectsCommands.lkDumpRoutine();
        int n = 0;
        while (n < vector.size()) {
            try {
                DvJavacorePlugin.printWithTag((String)vector.elementAt(n), (String)vector.elementAt(n + 1));
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                DvJavacorePlugin.printWithTag(" error !!!", "ArrayIndexOutOfBoundsException in DvJavaCorePlugin");
                String string = "\n*******************\n";
                string = string + " ArrayIndexOutOfBoundsException produced in  in DvJavaCorePlugin\n" + "*******************\n";
                DvUtils.trace(string, 0, true);
                Dumpviewer.showMessage(string, false);
            }
            n += 2;
        }
        DvJavacorePlugin.outputFlush();
    }

    public static void doXMSection() {
        DvProcess[] dvProcessArray;
        DvDump dvDump = DvConsole.theDump;
        DvJavacoreSov.newSection("XM");
        DvJavacorePlugin.printWithTag("NULL", " ");
        DvJavacorePlugin.printWithTag("1XMEXCPINFO", "Exception Info");
        DvJavacorePlugin.printWithTag("NULL", "--------------");
        DvJavacorePlugin.printWithTag("2XMDUMPINFONA", "Not available");
        DvJavacorePlugin.printWithTag("NULL", " ");
        DvJavacorePlugin.printWithTag("1XMTHDINFO", "Thread Info");
        DvJavacorePlugin.printWithTag("NULL", "-----------");
        DvJavacorePlugin.printWithTag("NULL", " ");
        DvProcess dvProcess = null;
        DvEnvData dvEnvData = null;
        try {
            dvProcess = DvJavacorePlugin.as.getCurrentProcess();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (dvProcess == null) {
            DvJavacorePlugin.printWithTag("2XMFULLTHDDUMP", "Full thread dump Classic VM (<UNSUPPORTED>, native threads)");
        } else {
            String string;
            block28: {
                dvEnvData = dvProcess.getEnvData();
                dvProcessArray = jvm.getField("fullVersion");
                string = null;
                try {
                    string = DvJavacorePlugin.getCStringFromPtr((CTypeObject)dvProcessArray);
                }
                catch (DvAddressException dvAddressException) {
                    if (dvEnvData != null) {
                        string = dvEnvData.javaVersion().trim();
                    }
                    if (string != null && !string.equals("")) break block28;
                    string = "<version not available>";
                }
            }
            DvJavacorePlugin.printWithTag("2XMFULLTHDDUMP", "Full thread dump Classic VM (" + string + ", native threads)");
        }
        DvJavacorePlugin.outputFlush();
        try {
            dvProcessArray = DvJavacorePlugin.as.getProcesses();
            int n = 0;
            while (n < dvProcessArray.length) {
                DvThread[] dvThreadArray = dvProcessArray[n].getThreads();
                int n2 = dvThreadArray.length - 1;
                while (n2 >= 0) {
                    block29: {
                        try {
                            DvThread dvThread = dvThreadArray[n2];
                            long l = -1L;
                            l = Long.parseLong(dvThread.id(), 16);
                            if (dvThread.eeAddress().getAddressAsLong() != 0L) {
                                Object object;
                                CTypeObject cTypeObject = new CTypeObject("execenv", dvThread.eeAddress(), DvJavacorePlugin.as);
                                long l2 = -1L;
                                try {
                                    object = cTypeObject.getField("thread_priority");
                                    l2 = DvJavacorePlugin.readPtrAsLong((CTypeObject)object);
                                }
                                catch (NullPointerException nullPointerException) {
                                    // empty catch block
                                }
                                object = "<unknown>";
                                if (l2 != -1L) {
                                    object = new Long(l2).toString();
                                }
                                if (cTypeObject.getAddr() == 0L || cTypeObject.getAddr() == -1L) break block29;
                                long l3 = DvJavacorePlugin.readPtrAsLong(cTypeObject.getField("thread"));
                                CTypeObject cTypeObject2 = cTypeObject.getField("sys_thr");
                                long l4 = cTypeObject2.getAddr();
                                String string = dvThread.getThreadName(DvJavacorePlugin.as);
                                CTypeObject cTypeObject3 = new CTypeObject("sys_thread", l4, DvJavacorePlugin.as);
                                CTypeObject cTypeObject4 = cTypeObject3.getField("state");
                                int n3 = DvJavacorePlugin.readAnInt(cTypeObject4);
                                String string2 = new String("<" + n3 + ">");
                                DvJavacorePlugin.printWithTag("3XMTHREADINFO", "    \"" + string + "\"" + " (TID:0x" + Long.toHexString(l3) + ", sys_thread_t:0x" + Long.toHexString(l4) + ", state:" + string2 + ", native ID:0x" + Long.toHexString(l) + ") prio=" + (String)object);
                                DvJavacorePlugin.outputFlush();
                                try {
                                    if (dvThread != null && dvThread.getJavaStack() != null) {
                                        int n4 = 0;
                                        while ((long)n4 < dvThread.getJavaStack().getNumFrames()) {
                                            String string3 = dvThread.getJavaStack().getFrame(n4).getName();
                                            if (!string3.startsWith("pseudo frame")) {
                                                DvJavacorePlugin.printWithTag("4XESTACKTRACE", "        at " + string3);
                                            }
                                            ++n4;
                                        }
                                    }
                                }
                                catch (Exception exception) {
                                    DvJavacorePlugin.printWithTag("4XMJAVASTCKEX", "**** Exception <?> received when dumping Java stack.");
                                    DvJavacorePlugin.outputFlush();
                                    exception.printStackTrace();
                                }
                            }
                            try {
                                if (dvThread != null && dvThread.getNativeStack() != null && dvThread.getNativeStack().getNumFrames() > 0L) {
                                    DvJavacorePlugin.printWithTag("3HPNATIVESTACK", "        Native Stack");
                                    DvJavacorePlugin.printWithTag("NULL", "        ------------");
                                    int n5 = 0;
                                    while ((long)n5 < dvThread.getNativeStack().getNumFrames()) {
                                        DvNativeFrame dvNativeFrame = dvThread.getNativeStack().getFrame(n5);
                                        if (DvJavacorePlugin.as.pointerSize() == 4) {
                                            DvJavacorePlugin.printWithTag("4HPTRACEBACK", "        at " + Integer.toHexString((int)dvNativeFrame.getPc()) + " in " + dvNativeFrame.getName());
                                        } else {
                                            DvJavacorePlugin.printWithTag("4HPTRACEBACK", "        at " + Long.toHexString(dvNativeFrame.getPc()) + " in " + dvNativeFrame.getName());
                                        }
                                        ++n5;
                                    }
                                }
                            }
                            catch (Exception exception) {
                                DvJavacorePlugin.printWithTag("4XMNATIVESTCKEX", "**** Exception <?> received when dumping native stack.");
                                DvJavacorePlugin.outputFlush();
                                exception.printStackTrace();
                            }
                        }
                        catch (Exception exception) {
                            DvJavacorePlugin.output.add("*** Exception received processing a thread\n" + exception.getMessage());
                            DvJavacorePlugin.outputFlush();
                            exception.printStackTrace();
                        }
                    }
                    --n2;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            DvJavacorePlugin.output.add("*** Exception received while traversing Thread Stacks\n" + exception.getMessage());
            DvJavacorePlugin.outputFlush();
            exception.printStackTrace();
        }
    }

    public static void doCLSection() {
        Object object;
        Enumeration enumeration;
        String string;
        String string2;
        long l;
        int n;
        String string3;
        DvJavacoreSov.newSection("CL");
        Properties properties = new Properties();
        Hashtable hashtable = new Hashtable();
        Properties properties2 = new Properties();
        Hashtable<String, Integer> hashtable2 = new Hashtable<String, Integer>();
        DvObjectsCommands dvObjectsCommands = DvObjectsCommands.getCurrentInstance();
        DvJavacorePlugin.printWithTag("1CLFLAGOLDJAVA", "Oldjava mode <n/a>");
        DvJavacorePlugin.printWithTag("1CLFLAGBOOTSTRP", "Bootstrapping <n/a>");
        DvJavacorePlugin.printWithTag("1CLFLAGVERBOSE", "Verbose class dependencies <n/a>");
        DvJavacorePlugin.printWithTag("1CLENUMVERIFY", "Class verification <n/a>");
        DvJavacorePlugin.printWithTag("1CLPNTRNAMECLLO", "Namespace to classloader <n/a>");
        DvJavacorePlugin.printWithTag("1CLPNTRCHAINLO", "Start of cache entry pool <n/a>");
        DvJavacorePlugin.printWithTag("1CLPNTRCHFREE", "Start of free cache entries <n/a>");
        DvJavacorePlugin.printWithTag("1CLPNTRMETHODTB", "Location of method table <n/a>");
        DvJavacorePlugin.printWithTag("1CLPNTRANCHRGLN", "Global namespace anchor <n/a>");
        DvJavacorePlugin.printWithTag("1CLPNTRCLSLOADS", "System classloader shadow <n/a>");
        DvJavacorePlugin.printWithTag("1CLPNTRSYSLOADS", "Classloader shadows <n/a>");
        DvJavacorePlugin.printWithTag("1CLPNTRCLSEXT", "Extension loader <n/a>");
        DvJavacorePlugin.outputFlush();
        String[] stringArray = DvClassCommands.classAddressList();
        try {
            DvJavacorePlugin.outputFlush();
            int n2 = 0;
            while (n2 < stringArray.length) {
                string3 = stringArray[n2];
                if (string3 != null) {
                    n = string3.indexOf("0x");
                    if (-1 != n) {
                        string3 = string3.substring(n + 2);
                    }
                    if ((l = DvJavacoreSov.getLoaderFromClass(Long.parseLong(string3, 16))) == -1L) {
                        throw new RuntimeException("getLoaderFromClass returned -1!");
                    }
                    string2 = "0x" + Long.toHexString(l);
                    if (properties.getProperty(string2) == null) {
                        try {
                            string = "<UNKNOWN>";
                            string = string2.equals("0x0") ? "*SYSTEM*" : dvObjectsCommands.getObjectNameAtAddress(l);
                            properties.setProperty(string2, string);
                            properties2.setProperty(string, string2);
                            hashtable.put(string2, new Vector());
                            hashtable2.put(string2, new Integer(0));
                        }
                        catch (Exception exception) {
                            DvJavacorePlugin.output.add("*** Unexpected exception received in new ClassLoader section");
                            DvJavacorePlugin.outputFlush();
                            exception.printStackTrace();
                        }
                    }
                    DvJavacorePlugin.outputFlush();
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            DvJavacorePlugin.outputFlush();
            System.out.println("*** Error: unexpected exception received in doCLSection()");
            exception.printStackTrace();
        }
        try {
            int n3 = 0;
            while (n3 < stringArray.length) {
                string3 = stringArray[n3];
                if (string3 != null) {
                    n = string3.indexOf("0x");
                    if (-1 != n) {
                        string3 = string3.substring(n + 2);
                    }
                    if ((l = DvJavacoreSov.getLoaderFromClass(Long.parseLong(string3, 16))) == -1L) {
                        throw new RuntimeException("getLoaderFromClass returned -1!");
                    }
                    string2 = "0x" + Long.toHexString(l);
                    string = "<NOT A VALID CLASS>";
                    long l2 = Long.parseLong(string3, 16);
                    if (dvObjectsCommands.getObjectNameAtAddress(l2).equals("java/lang/Class")) {
                        string = dvObjectsCommands.getClassNameAtAddress(l2) + "(0x" + string3 + ")";
                    } else {
                        DvJavacorePlugin.output.add("*** Error: address 0x" + string3 + " is not the address of a class!!");
                    }
                    Vector vector = (Vector)hashtable.get(string2);
                    vector.add(string);
                    Integer n4 = (Integer)hashtable2.get(string2);
                    n4 = new Integer(n4 + 1);
                    hashtable2.put(string2, n4);
                    DvJavacorePlugin.outputFlush();
                }
                ++n3;
            }
        }
        catch (Exception exception) {
            DvJavacorePlugin.outputFlush();
            System.out.println("*** Error: exception received in doCLSection() section 3");
            exception.printStackTrace();
        }
        try {
            DvJavacorePlugin.printWithTag("1CLTEXTCLLOS", "Classloader summaries");
            DvJavacorePlugin.printWithTag("1CLTEXTCLLSS", "        12345678: 1=primordial,2=extension,3=shareable,4=middleware,5=system,6=trusted,7=application,8=delegating");
            enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                string3 = (String)enumeration.nextElement();
                String string4 = properties.getProperty(string3);
                String string5 = properties2.getProperty(string4);
                object = (Integer)hashtable2.get(string5);
                if (string4.equals("*SYSTEM*")) {
                    DvJavacorePlugin.printWithTag("2CLTEXTCLLOADER", "        -------- Loader " + string4 + " (" + string5 + ")" + ", Shadow 0x00000000");
                } else {
                    DvJavacorePlugin.printWithTag("2CLTEXTCLLOADER", "        -------- Loader " + string4 + " (" + string5 + ")" + ", Shadow 0x<n/a>, " + "[Parent <n/a>(0x<n/a>)]");
                }
                DvJavacorePlugin.printWithTag("3CLNMBRLOADEDCL", "                Number of loaded classes " + object);
                DvJavacorePlugin.printWithTag("3CLNMBRCACHECLS", "                Number of cached classes <n/a>");
                DvJavacorePlugin.printWithTag("3CLHEXDALLOCTIO", "                Allocation used for loaded classes <n/a>");
                if (string4.equals("*SYSTEM*")) {
                    DvJavacorePlugin.printWithTag("3CLHEXDPCKGEOWN", "                Package owner 0x00000000");
                } else {
                    DvJavacorePlugin.printWithTag("3CLHEXDPCKGEOWN", "                Package owner 0x<n/a>");
                }
                DvJavacorePlugin.outputFlush();
            }
        }
        catch (Exception exception) {
            DvJavacorePlugin.outputFlush();
            System.out.println("*** Error: exception received in doCLSection() section 4");
            exception.printStackTrace();
        }
        try {
            DvJavacorePlugin.printWithTag("1CLTEXTCLLOD", "ClassLoader loaded classes");
            enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                string3 = (String)enumeration.nextElement();
                String string6 = properties.getProperty(string3);
                DvJavacorePlugin.printWithTag("2CLTEXTCLLOAD", "        Loader " + string6 + "(" + string3 + ")");
                Vector vector = (Vector)hashtable.get(string3);
                object = vector.elements();
                while (object.hasMoreElements()) {
                    string2 = (String)object.nextElement();
                    DvJavacorePlugin.printWithTag("3CLTEXTCLASS", "                " + string2);
                }
            }
        }
        catch (Exception exception) {
            DvJavacorePlugin.outputFlush();
            System.out.println("*** Error: exception received in doCLSection() section 5");
            exception.printStackTrace();
        }
        DvJavacorePlugin.outputFlush();
    }

    public static void doENDSection() {
        DvJavacorePlugin.printWithTag("NULL", "---------------------------------------------------------------");
        DvJavacorePlugin.printWithTag("0SECTION", "Javadump End section");
        DvJavacorePlugin.printWithTag("1DGJDUMP", "Javadump Buffer Usage Information");
        DvJavacorePlugin.printWithTag("NULL", "=================================");
        CTypeObject cTypeObject = traceData.getField("printBufferSize");
        if (cTypeObject != null) {
            int n = DvJavacorePlugin.readAnInt(cTypeObject);
            if (n != -1) {
                DvJavacorePlugin.printWithTag("2DGJDUMPALLOC", "Javadump buffer size (allocated): " + n);
            } else {
                DvJavacorePlugin.printWithTag("2DGJDUMPALLOC", "Javadump buffer size (allocated): <ERROR2>");
            }
        } else {
            DvJavacorePlugin.printWithTag("2DGJDUMPALLOC", "Javadump buffer size (allocated): <ERROR1>");
        }
        CTypeObject cTypeObject2 = traceData.getField("printBufferP");
        CTypeObject cTypeObject3 = traceData.getField("printBuffer");
        if (cTypeObject2 == null || cTypeObject3 == null) {
            DvJavacorePlugin.printWithTag("2DGJDUMPUSED", "Javadump buffer size (used)     : <ERROR3>");
        } else {
            long l = DvJavacorePlugin.readPtrAsLong(cTypeObject2);
            long l2 = DvJavacorePlugin.readPtrAsLong(cTypeObject3);
            long l3 = l - l2;
            DvJavacorePlugin.printWithTag("2DGJDUMPUSED", "Javadump buffer size (used)     : " + l3);
        }
        DvJavacorePlugin.printWithTag("NULL", "------------------ END OF DUMP --------------------------------");
        DvJavacorePlugin.outputFlush();
    }

    protected static void initStatics() {
        if (DvJavacorePlugin.noDumpAccessed()) {
            return;
        }
        DvDump dvDump = DvConsole.theDump;
        staticsInitialised = true;
        myThread = (DvThread)DvUtils.getAPT(dvDump, "T");
        ee = new CTypeObject("execenv", myThread.eeAddress(), DvJavacorePlugin.as);
        jvm = ee.getField("jvmP").deReference();
        traceData = new SovTraceObject(DvJavacorePlugin.as);
        xeData = jvm.getField("facade.xe.dataP").deReference("XeData");
        stData = jvm.getField("facade.st.dataP").deReference("STGlobal");
        if (traceData == null) {
            DvJavacorePlugin.outputAdd("*** dgData is NULL ***");
        }
        if (xeData == null) {
            DvJavacorePlugin.outputAdd("*** xeData is NULL ***");
        }
        if (stData == null) {
            DvJavacorePlugin.outputAdd("*** stData is NULL ***");
        }
        DvJavacorePlugin.outputFlush();
    }

    private static long getLoaderFromClass(long l) {
        CTypeObject cTypeObject;
        long l2 = -1L;
        CTypeObject cTypeObject2 = null;
        DvAddress dvAddress = DvJavacorePlugin.as.createAddress(l);
        String string = "Hjava_lang_Class";
        if (DvUtils.checkAddressInDump(dvAddress, DvJavacorePlugin.as) && (cTypeObject2 = DvUtils.formatAddrAsType(DvJavacorePlugin.as, dvAddress, string)) != null && (cTypeObject = cTypeObject2.getField("obj.mirrored_data.loader")) != null) {
            l2 = DvJavacorePlugin.readPtrAsLong(cTypeObject);
        }
        return l2;
    }

    static {
        ptrLength = 4;
        commandsSupported = new String[0];
        mySuffixes = new String[]{"sov"};
    }
}

