/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.plugins;

import com.ibm.jvm.dump.format.CTypeObject;
import com.ibm.jvm.dump.format.Dumpviewer;
import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvAddressException;
import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvConsole;
import com.ibm.jvm.dump.format.DvDump;
import com.ibm.jvm.dump.format.DvLoaded;
import com.ibm.jvm.dump.format.DvMemRanges;
import com.ibm.jvm.dump.format.DvMemoryFind;
import com.ibm.jvm.dump.format.DvModule;
import com.ibm.jvm.dump.format.DvProcess;
import com.ibm.jvm.dump.format.DvRas;
import com.ibm.jvm.dump.format.DvRegister;
import com.ibm.jvm.dump.format.DvThread;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.plugins.CommandPlugin;
import com.ibm.jvm.dump.plugins.DvClassCommands;
import com.ibm.jvm.dump.plugins.DvJavacorePlugin;
import com.ibm.jvm.dump.plugins.DvObjectsCommands;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class DvBaseCommands
extends CommandPlugin {
    private static String thisName = "com.ibm.jvm.dump.plugins.DvBaseCommands";
    private static String prevVerb = null;
    private static String prevModifier = null;
    private static String prevParms = null;
    private static String prevSeperator = null;
    public static DvBaseCommands selfRef;
    static DvMemoryFind dvMemoryFind;
    private static String[] commandsSupported;

    public DvBaseCommands() {
        selfRef = this;
        if (DvConsole.bGuiRequested) {
            Dumpviewer.savedDvbc = this;
        }
    }

    public String pluginName() {
        return "Base Support commands Plugin";
    }

    private void setDump(String string, Vector vector) {
        Object object;
        Object object2;
        boolean bl = false;
        String string2 = DvUtils.getValue("WorkDir");
        File file = new File(string);
        if (!file.exists()) {
            vector.add("\nERROR - Dump file " + file + " does not exist");
        } else {
            object2 = file.getName();
            file = null == string2 ? new File(string + ".nidx") : new File(string2 + (String)object2 + ".nidx");
            if (file.exists()) {
                if (file.canWrite()) {
                    vector.add("Existing names index file found.");
                    bl = true;
                } else {
                    vector.add("\n*** ERROR - Existing names index is read-only.");
                    vector.add("File permissions do not permit opening of the dump.");
                    vector.add("The dump must be on a read-write drive and directory or");
                    vector.add(" \"Set Workdir\" can be used to direct index file output.");
                }
            } else {
                try {
                    object = new PrintWriter(new BufferedWriter(new FileWriter(file)));
                    ((PrintWriter)object).println("TEST");
                    ((PrintWriter)object).close();
                    file.delete();
                    bl = true;
                    vector.add("Confirmed that permissions allow names index file to be written.");
                }
                catch (IOException iOException) {
                    vector.add("\n*** ERROR - Unable to write names index file " + file);
                    vector.add("File permissions do not permit opening of the dump.");
                    vector.add("The dump must be on a read-write drive and directory or");
                    vector.add(" \"Set Workdir\" can be used to direct index file output.");
                }
            }
        }
        if (bl) {
            object2 = DvUtils.findDumpPlugin(string);
            if (object2 != null) {
                DvAddressSpace[] dvAddressSpaceArray;
                vector.add("Dump successfully opened\n\n");
                DvConsole.setTheDump((DvDump)object2, vector, string);
                DvUtils.setValue("DUMP", string);
                object = DvUtils.getSuffix();
                if (null != object) {
                    dvAddressSpaceArray = "Dv" + (String)object + ".properties";
                    vector.add("Suffix established as " + (String)object);
                    vector.add("   Will now attempt load of " + (String)dvAddressSpaceArray);
                    vector.add("   to find supplemental command plugins\n");
                    DvConsole.supplementalP = DvUtils.findPropertiesFile("Dv" + (String)object + ".properties");
                    if (null != DvConsole.supplementalP) {
                        String string3 = DvUtils.getSuppProperty("CommandPlugins");
                        vector.add("\n" + (String)dvAddressSpaceArray + " found \n");
                        if (null != string3) {
                            DvConsole.commandPlugins = DvUtils.findCommandPlugins(true, vector);
                            DvConsole.refreshCommands();
                        }
                    } else {
                        vector.add("\n !!! " + (String)dvAddressSpaceArray + " not found !!!");
                        vector.add(" !!! Previously loaded plugins remain in place.\n");
                    }
                } else {
                    vector.add("Suffix was null - command plugins might need hand loading");
                    vector.add("   \"Dis pl verbose\" will show what plugins and commands available\n");
                }
                dvAddressSpaceArray = ((DvDump)object2).getAddressSpaces();
                DvConsole.setTheDump((DvDump)object2, vector, string);
                DvUtils.setValue("DUMP", string);
            } else {
                vector.add("Dump open failure!!!!");
            }
        }
    }

    private void setOutput(String string) {
        if (string.trim().equals("*")) {
            PrintStream printStream = DvConsole.getOriginal_output();
            System.setOut(printStream);
            this.cpr.output(" Output stream redirected to original (System.out)");
            DvConsole.echoOn = false;
        } else {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string, true);
                PrintStream printStream = new PrintStream(fileOutputStream, true);
                System.setOut(printStream);
                this.cpr.output(" Output stream: " + string);
                DvConsole.echoOn = true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.cpr.output(" Invalid output stream: " + string);
            }
            catch (SecurityException securityException) {
                this.cpr.output(" Unable to write to: " + string);
            }
        }
    }

    private void setError(String string) {
        if (string.trim().equals("*")) {
            PrintStream printStream = DvConsole.getOriginal_error();
            System.setErr(printStream);
            this.cpr.output(" Error stream redirected to original (System.err)");
        } else {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string, true);
                PrintStream printStream = new PrintStream(fileOutputStream, true);
                System.setErr(printStream);
                this.cpr.output(" Error stream: " + string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.cpr.output(" Invalid error stream: " + string);
            }
            catch (SecurityException securityException) {
                this.cpr.output(" Unable to write to: " + string);
            }
        }
    }

    private String setWorkDir(String string, String string2) {
        String string3;
        block11: {
            string3 = null;
            try {
                File file = new File(string);
                if (file.exists()) {
                    if (file.isDirectory()) {
                        if (file.canWrite()) {
                            try {
                                File file2 = File.createTempFile("DvC", null, file);
                                file2.deleteOnExit();
                                string3 = string;
                                String string4 = System.getProperty("file.separator");
                                if (!string3.endsWith(string4)) {
                                    string3 = string3 + string4;
                                }
                                this.cpr.output(" " + string2 + " set to: " + string3);
                            }
                            catch (IOException iOException) {
                                this.cpr.output(" !!!Error: " + string + " is not a writeable directory");
                            }
                        } else {
                            this.cpr.output(" !!!Error: " + string + " is not a writeable directory");
                        }
                    } else {
                        this.cpr.output(" !!!Error: " + string + " is not a directory");
                    }
                    break block11;
                }
                this.cpr.output(" !!!Error: " + string + " does not exist");
            }
            catch (SecurityException securityException) {
                this.cpr.output(" !!!Error: " + string + " not accessible (SecurityException)");
            }
            catch (Exception exception) {
                this.cpr.output(" !!!Error: " + string + " invalid ( " + exception.toString() + ")");
            }
        }
        return string3;
    }

    private void setTrace(String string) {
        if (null == string) {
            if (DvUtils.isTraceOn()) {
                this.cpr.output("Trace is curently ON");
            } else {
                this.cpr.output("Trace is curently OFF");
            }
        } else if (string.toUpperCase().equals("ON")) {
            this.cpr.output(" Setting trace ON");
            DvUtils.enableConsoleTrace(true);
        } else if (string.toUpperCase().equals("OFF")) {
            this.cpr.output(" Setting trace OFF");
            DvUtils.enableConsoleTrace(false);
        } else {
            this.cpr.output(" What does \"" + string + "\" mean?");
        }
    }

    public void displayMMAP() {
        String string = null;
        DvDump dvDump = DvConsole.theDump;
        string = "\nMemory Map Table\n================\n";
        DvAddressSpace[] dvAddressSpaceArray = dvDump.getAddressSpaces();
        int n = 0;
        while (n < dvAddressSpaceArray.length) {
            string = string + "\n\n AddressSpace: " + dvAddressSpaceArray[n].id() + "\n";
            DvMemRanges[] dvMemRangesArray = dvAddressSpaceArray[n].getMemRanges();
            if (null != dvMemRangesArray) {
                String[] stringArray = new String[dvMemRangesArray.length];
                String string2 = null;
                long[] lArray = new long[dvMemRangesArray.length];
                int n2 = 0;
                while (n2 < dvMemRangesArray.length) {
                    string2 = dvMemRangesArray[n2].addressStart().convertToHex();
                    string = string + "\nAddress:" + dvMemRangesArray[n2].addressStart().convertToHex() + "   " + "Length :" + dvMemRangesArray[n2].length();
                    ++n2;
                }
            } else {
                string = string + "No memory ranges known for this address space\n";
            }
            ++n;
        }
        this.cpr.output(string);
        this.forcedEnd = true;
    }

    public String[] getSyntax() {
        return commandsSupported;
    }

    public void displayProcess() {
        Vector<Object> vector = new Vector<Object>();
        String string = null;
        Vector vector2 = new Vector();
        vector.add("\nProcess Information\n===================");
        try {
            string = this.paramString.toUpperCase().trim();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        DvDump dvDump = DvConsole.theDump;
        int n = dvDump.getArchitecture();
        try {
            vector.add("Architecture: " + DvDump.ARCHITECTURE_DESCRIPTION[n]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            vector.add("Architecture: Unexpected architecture value(" + n + ")");
        }
        DvAddressSpace[] dvAddressSpaceArray = dvDump.getAddressSpaces();
        String string2 = DvUtils.getValue("PID");
        int n2 = 0;
        while (n2 < dvAddressSpaceArray.length) {
            DvProcess[] dvProcessArray = dvAddressSpaceArray[n2].getProcesses();
            int n3 = 0;
            while (n3 < dvProcessArray.length) {
                if (null != string && string.equals("*") || null == string && dvProcessArray[n3].id().equals(string2)) {
                    Object object;
                    vector.add("\n\nAddressSpace: " + dvAddressSpaceArray[n2].id() + "   Process: " + dvProcessArray[n3].id());
                    vector.add("Signal      : " + dvProcessArray[n3].getSignal() + "............\n");
                    DvThread[] dvThreadArray = dvProcessArray[n3].getThreads();
                    int n4 = 0;
                    while (n4 < dvThreadArray.length) {
                        if (!dvThreadArray[n4].isJava()) {
                            vector.add("Thread: " + dvThreadArray[n4].id() + "  Not a java thread");
                        } else {
                            object = dvThreadArray[n4].id();
                            vector.add(" Thread: " + DvUtils.rJustify("0x" + (String)object, 10) + "  ExecEnv: 0x" + DvUtils.rJustifyZ(dvThreadArray[n4].eeAddress().convertToHex(), 0) + "  Thread name: " + dvThreadArray[n4].getThreadName(dvAddressSpaceArray[n2]));
                        }
                        ++n4;
                    }
                    this.addEnvironment(dvDump, dvAddressSpaceArray[n2], vector);
                    object = null;
                    try {
                        object = dvProcessArray[n3].getLoaded();
                    }
                    catch (Error error) {
                        // empty catch block
                    }
                    if (null != object) {
                        vector.add(object);
                    } else {
                        vector.add(" ===================================================\n --- No loaded information for this process ---\n ===================================================");
                    }
                }
                ++n3;
            }
            ++n2;
        }
        vector.add("\n");
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addEnvironment(DvDump dvDump, DvAddressSpace dvAddressSpace, Vector vector) {
        try {
            DvDump dvDump2 = dvDump;
            DvRas dvRas = dvDump.getRas();
            vector.add("\nEnvironment Variables\n=====================\n");
            CTypeObject cTypeObject = new CTypeObject("jvm_ras_t", dvRas.jvmRas, dvAddressSpace);
            DvAddress dvAddress = new DvAddress(cTypeObject.getField("ras.data.envPtr").getValue());
            DvAddress dvAddress2 = null;
            if (dvAddress.getAddressAsLong() != 0L) {
                dvAddress2 = dvAddressSpace.readPointer(dvAddress);
            } else {
                vector.add("\n    **** No environment variables found  ****");
            }
            while (dvAddress2 != null) {
                if (dvAddress2.getAddressAsLong() == 0L) {
                    return;
                }
                String string = DvUtils.getStringFromBytes(dvAddressSpace.readBytes(dvAddress2, 1024L));
                if (dvDump2.getSystemType() == 4) {
                    byte[] byArray = dvAddressSpace.readBytes(dvAddress2, 1024L);
                    int n = 0;
                    while (n < 1024 && byArray[n] != 0) {
                        ++n;
                    }
                    byte[] byArray2 = new byte[n];
                    System.arraycopy(byArray, 0, byArray2, 0, n);
                    string = new String(byArray2, "Cp1047");
                }
                dvAddress.offsetBy(dvAddressSpace.pointerSize());
                vector.add(string);
                dvAddress2 = dvAddressSpace.readPointer(dvAddress);
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void displaySystem() {
        Vector vector = new Vector();
        this.displaySystem(vector);
    }

    public void displaySystem(Vector vector) {
        DvDump dvDump = DvConsole.theDump;
        vector.add("\n   System Summary\n   ==============\n");
        vector.add("fullVersion: " + DvConsole.fullVersion);
        int n = dvDump.getArchitecture();
        try {
            vector.add("  " + DvDump.ARCHITECTURE_DESCRIPTION[n]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            vector.add("  " + DvDump.ARCHITECTURE_DESCRIPTION[0] + " (" + n + ")");
        }
        DvAddressSpace[] dvAddressSpaceArray = dvDump.getAddressSpaces();
        int n2 = dvAddressSpaceArray.length;
        vector.add("  Number of Address Spaces: " + n2);
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n3 += dvAddressSpaceArray[n4].getProcesses().length;
            ++n4;
        }
        vector.add("  Number of Processes     : " + n3);
        int n5 = dvDump.getSystemType();
        try {
            vector.add("  System                  : " + DvDump.SYSTEM_DESCRIPTION[n5]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            vector.add("  System                  : " + DvDump.SYSTEM_DESCRIPTION[0] + " (" + n5 + ")");
        }
        int n6 = dvDump.getSubSystemType();
        try {
            vector.add("  SubSystem               : " + DvDump.SUBSYS_DESCRIPTION[n6]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            vector.add("  SubSystem               : " + DvDump.SUBSYS_DESCRIPTION[0] + " (" + n6 + ")");
        }
        vector.add("  Processor (number)      : ?(?)");
        vector.add("  Processor subtype       : ?");
        vector.add("  Current process id      : ?");
        vector.add("  Number of JVMs found    : " + DvConsole.getJvmsInDump().size());
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    public void displayMemory() {
        Vector vector = new Vector();
        this.displayMemory(vector);
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    public void displayMemory(Vector vector) {
        Integer n;
        long l;
        Object object;
        Object object2;
        DvAddressSpace dvAddressSpace;
        String string;
        String string2;
        block45: {
            DvUtils.writetoTrace(" Entry: displayMemory (" + this.paramString + ")");
            string2 = null;
            String string3 = null;
            Vector<String> vector2 = new Vector<String>();
            try {
                string3 = this.paramString.toUpperCase().trim();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (!this.validateDisDump(string3, vector)) {
                this.forcedEnd = true;
                return;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
            string = null;
            if (stringTokenizer.countTokens() != 0) {
                string = stringTokenizer.nextToken();
            }
            if (null != string) {
                vector2.add(string);
                while (stringTokenizer.hasMoreTokens()) {
                    vector2.add(stringTokenizer.nextToken());
                }
            }
            if (vector2.size() == 1) {
                vector2.add("256");
            }
            if (vector2.size() == 3) {
                string2 = (String)vector2.elementAt(2);
            }
            dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A");
            if ('@' == string.charAt(0)) {
                byte[] byArray;
                String string4 = string.substring(1);
                long l2 = 0L;
                try {
                    l2 = DvUtils.hexToLong(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    vector.add("Invalid Address Specified");
                    return;
                }
                object2 = DvConsole.theDump;
                object = dvAddressSpace.createAddress(l2);
                byte[] byArray2 = null;
                if (DvUtils.is64BitSystem(((DvDump)object2).getArchitecture())) {
                    try {
                        byArray2 = dvAddressSpace.readBytes((DvAddress)object, 8L);
                    }
                    catch (DvAddressException dvAddressException) {
                        // empty catch block
                    }
                    if (byArray2 != null && 8 == byArray2.length && !DvUtils.isBigEndian(((DvDump)object2).getArchitecture())) {
                        byArray = DvUtils.convertToBigEndian(byArray2);
                        string = DvUtils.bytesToHexString(byArray);
                    }
                } else {
                    try {
                        byArray2 = dvAddressSpace.readBytes((DvAddress)object, 4L);
                    }
                    catch (DvAddressException dvAddressException) {
                        // empty catch block
                    }
                    if (byArray2 != null && 4 == byArray2.length && !DvUtils.isBigEndian(((DvDump)object2).getArchitecture())) {
                        byArray = DvUtils.convertToBigEndian(byArray2);
                        string = DvUtils.bytesToHexString(byArray);
                    }
                }
                if (byArray2 == null) {
                    vector.add("Not a viewable address following @");
                    return;
                }
            }
            string = DvUtils.remove0x(string);
            try {
                l = DvUtils.hexToLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                vector.add("Invalid Address Specified");
                return;
            }
            try {
                n = new Integer((String)vector2.elementAt(1));
            }
            catch (Exception exception) {
                n = new Integer(256);
            }
            object2 = dvAddressSpace.createAddress(l);
            object = null;
            try {
                object = dvAddressSpace.readBytes((DvAddress)object2, (long)n.intValue());
                if (object == null || ((Object)object).length >= n) break block45;
                boolean bl = false;
                int n2 = n - ((Object)object).length;
                while (!bl) {
                    byte[] byArray = null;
                    try {
                        byArray = dvAddressSpace.readBytes(new DvAddress(l + (long)((Object)object).length), (long)n2);
                    }
                    catch (DvAddressException dvAddressException) {
                        bl = true;
                    }
                    if (null != byArray) {
                        byte[] byArray3 = new byte[((Object)object).length + byArray.length];
                        int n3 = 0;
                        while (n3 < ((Object)object).length) {
                            byArray3[n3] = (byte)object[n3];
                            ++n3;
                        }
                        int n4 = 0;
                        while (n4 < byArray.length) {
                            byArray3[n4 + ((Object)object).length] = byArray[n4];
                            ++n4;
                        }
                        object = byArray3;
                        n2 = n - ((Object)object).length;
                        if (n2 > 0) continue;
                        bl = true;
                        continue;
                    }
                    bl = true;
                }
            }
            catch (DvAddressException dvAddressException) {
                DvUtils.writetoTrace(" Exception: " + dvAddressException.toString());
            }
        }
        if (object == null) {
            vector.add("Not a viewable address \nNote: this might be a viewable address in a different address space\n      If multiple address spaces are present in this dump. Use dis mmap\n      to check whether there is a memory range covering this address");
            return;
        }
        DvConsole.setLastDisMem(string, n);
        if (string2 == null || string2.equals("A") || string2.equals("E")) {
            Vector vector3 = this.formatMemory(l, (byte[])object, 4 == DvConsole.theDump.getSystemType(), string2);
            if (null != vector3) {
                vector.add(vector3);
            }
        } else {
            if (string2.equals("I")) {
                int n5 = 0;
                try {
                    n5 = dvAddressSpace.readInt((DvAddress)object2);
                }
                catch (DvAddressException dvAddressException) {
                    // empty catch block
                }
                vector.add(" Memory as Integer: " + n5);
            }
            if (string2.equals("L")) {
                long l3 = 0L;
                try {
                    l3 = dvAddressSpace.readLong((DvAddress)object2);
                }
                catch (DvAddressException dvAddressException) {
                    // empty catch block
                }
                vector.add(" Memory as Long: " + l3);
            }
            DvDump dvDump = DvConsole.theDump;
            if (string2.equals("P")) {
                try {
                    long l4 = true == DvUtils.is64BitSystem(dvDump.getArchitecture()) ? dvAddressSpace.readLong((DvAddress)object2) : (long)dvAddressSpace.readInt((DvAddress)object2);
                    vector.add(" Memory as Pointer: " + Long.toHexString(l4));
                }
                catch (DvAddressException dvAddressException) {
                    // empty catch block
                }
            }
        }
        DvUtils.writetoTrace(" Exit: displayMemory (" + this.paramString + ")");
    }

    public void displayInt() {
        String string = this.paramString;
        this.setParamString(this.paramString + ",4,I");
        this.displayMemory();
        this.setParamString(string);
    }

    public void displayLong() {
        String string = this.paramString;
        this.setParamString(this.paramString + ",8,L");
        this.displayMemory();
        this.setParamString(string);
    }

    public void displayPtr() {
        String string = this.paramString;
        this.setParamString(this.paramString + ",8,P");
        this.displayMemory();
        this.setParamString(string);
    }

    public String help() {
        return null;
    }

    public String help(String string) {
        return null;
    }

    public String[] guiPopupSyntax() {
        return null;
    }

    public void displayHelp() {
        Object object;
        String string;
        Vector<Object> vector = new Vector<Object>();
        if (null == this.verbModifier) {
            string = "GeneralHelp";
        } else {
            object = this.verbModifier.toUpperCase();
            if (((String)object).equals("D") || ((String)object).equals("DISPLAY") || ((String)object).equals("DISP")) {
                object = new String("DIS");
            }
            if (((String)object).equals("S")) {
                object = new String("SET");
            }
            string = ((String)object).toUpperCase() + "Help";
        }
        vector.add(DvUtils.getMultiplePropertyValues(string, "DvBaseCommands.properties"));
        if (null == this.verbModifier) {
            object = DvConsole.getCommandPluginVector();
            int n = 0;
            while (n < ((Vector)object).size()) {
                CommandPlugin commandPlugin = (CommandPlugin)((Vector)object).get(n);
                Class<?> clazz = commandPlugin.getClass();
                try {
                    Method method = clazz.getMethod("getGenericHelp", null);
                    try {
                        Object object2 = method.invoke(null, null);
                        if (object2 != null) {
                            vector.add(object2);
                        }
                    }
                    catch (InvocationTargetException invocationTargetException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {}
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                ++n;
            }
        }
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    public void setValue() {
        Vector<String> vector = new Vector<String>();
        if (null == this.paramString && this.verbModifier.toUpperCase().equals("FORMATFILE") && this.seperator.equals("=")) {
            this.paramString = "";
        }
        if (null == this.paramString) {
            if (null != this.seperator && this.seperator.equals("=")) {
                DvUtils.setValue(this.verbModifier, "");
            } else if (this.verbModifier.toUpperCase().equals("TRACE")) {
                this.setTrace(this.paramString);
            } else if (null == this.seperator || this.seperator.equals(" ")) {
                vector.add(" " + this.verbModifier + "=" + DvUtils.getValue(this.verbModifier));
            } else {
                vector.add("\n *** ERROR ***\nInvalid seperator between verb and modifier (" + this.seperator + ")\n" + " *** ERROR ***\n\n");
            }
        } else {
            if (this.verbModifier.toUpperCase().equals("DUMP")) {
                this.setDump(this.paramString, vector);
            }
            if (this.verbModifier.toUpperCase().equals("OUTPUT") || this.verbModifier.toUpperCase().equals("OUT")) {
                this.verbModifier = "OUTPUT";
                this.setOutput(this.paramString);
            }
            if (this.verbModifier.toUpperCase().equals("ERROR") || this.verbModifier.toUpperCase().equals("ERR")) {
                this.verbModifier = "ERROR";
                this.setError(this.paramString);
            }
            if (this.verbModifier.toUpperCase().equals("TRACE")) {
                this.setTrace(this.paramString);
            }
            if (this.verbModifier.toUpperCase().equals("FORCE")) {
                if (this.paramString.toUpperCase().equals("TRUE")) {
                    DvUtils.setForce(true);
                } else if (this.paramString.toUpperCase().equals("FALSE")) {
                    DvUtils.setForce(false);
                } else {
                    vector.add("\n *** ERROR ***\nFORCE must be TRUE or FALSE\n *** ERROR ***\n\n");
                }
            }
            if (this.verbModifier.toUpperCase().equals("WORKDIR")) {
                this.paramString = this.setWorkDir(this.paramString, "working directory");
            }
            if (this.verbModifier.toUpperCase().equals("DUMPDIR")) {
                this.paramString = this.setWorkDir(this.paramString, "original dump directory");
            }
            if (this.verbModifier.toUpperCase().equals("SDFFDIR")) {
                this.paramString = this.setWorkDir(this.paramString, "SDFF header directory");
            }
            if (this.verbModifier.toUpperCase().equals("LIBDIR")) {
                this.paramString = this.setWorkDir(this.paramString, "library extract directory");
            }
            DvUtils.setValue(this.verbModifier, this.paramString);
            if (this.verbModifier.toUpperCase().equals("FORMATFILE")) {
                if (!DvUtils.loadFormatFile(vector)) {
                    DvUtils.setValue(this.verbModifier, null);
                } else if (null != DvConsole.theDump) {
                    vector.add("\nSanity check being redriven for new formatfile\n");
                    this.doSanityCheck(vector, false);
                }
            }
        }
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    public void showSettings() {
        String string = null;
        String string2 = "\nCurrent Settings\n================";
        Enumeration enumeration = DvUtils.getPropertyNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            string2 = string2 + "\n" + string + " = " + DvUtils.getValue(string);
        }
        this.cpr.output(string2);
        this.forcedEnd = true;
    }

    public void displayThread() {
        Vector<String> vector = new Vector<String>();
        DvDump dvDump = DvConsole.theDump;
        String string = DvUtils.getValue("THREAD");
        String string2 = DvUtils.getValue("ASID");
        String string3 = DvUtils.getValue("PID");
        if (null == this.paramString) {
            if (null == string || string.equals("-1") || string.equals("")) {
                vector.add(" THREAD value not good (use SET THREAD=)");
            } else {
                vector.add("\n    ASID: " + string2 + " PROCESS: " + string3 + " THREAD: " + string + "\n");
                this.cpr.output(vector);
                this.displayThread(string2, string3, string);
            }
        } else {
            vector.add("\n    ASID: " + string2 + " PROCESS: " + string3 + " THREAD: All of them\n");
            this.cpr.output(vector);
            this.displayThread(string2, string3, this.paramString);
        }
        vector.add("\n");
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    private void displayThread(String string, String string2, String string3) {
        Vector<String> vector = new Vector<String>();
        if (!string3.equals("*")) {
            vector.add("\nInfo for thread - " + string3);
            vector.add("==============================================");
        }
        DvDump dvDump = DvConsole.theDump;
        if (null == string || null == string2 || string.equals("-1") || string2.equals("-1") || string.equals("") || string2.equals("")) {
            vector.add(" ASID/PID values not good (use SET ASID/PID=)");
        } else {
            DvProcess dvProcess = null;
            DvThread dvThread = null;
            DvAddressSpace dvAddressSpace = DvUtils.findAsid(dvDump, string);
            if (null != dvAddressSpace && null != (dvProcess = DvUtils.findProc(dvDump, string2, dvAddressSpace))) {
                if (string3.equals("*")) {
                    DvThread[] dvThreadArray = dvProcess.getThreads();
                    if (null != dvThreadArray) {
                        int n = 0;
                        while (n < dvThreadArray.length) {
                            if (dvThreadArray[n].isJava()) {
                                this.displayThread(string, string2, dvThreadArray[n].id());
                            } else {
                                vector.add("\nInfo for thread " + dvThreadArray[n].id() + "\n=======================================" + "\n    Not a java thread\n" + " --- nothing to report ---\n");
                            }
                            ++n;
                        }
                    }
                } else {
                    dvThread = DvUtils.findThread(dvDump, string3, dvAddressSpace, dvProcess);
                    if (null != dvThread) {
                        if (dvThread.isJava()) {
                            vector.add("  Name   : " + dvThread.getThreadName(dvAddressSpace));
                            vector.add("  Id     : " + dvThread.id());
                            vector.add("      Use \"dis ns\" and \"dis js\" to display stacks");
                            vector.add("  ExecEnv: " + dvThread.eeAddress().convertToHex());
                            vector.add("  jvmP   : 0x" + Long.toHexString(DvUtils.jvmFromExecenv(dvAddressSpace, dvThread.eeAddress())));
                            DvRegister[] dvRegisterArray = null;
                            try {
                                dvRegisterArray = dvThread.getRegisters();
                            }
                            catch (Error error) {
                                // empty catch block
                            }
                            if (null == dvRegisterArray) {
                                vector.add("\n  --- No register data for this thread --- \n");
                            } else {
                                int n = 0;
                                while (n < dvRegisterArray.length) {
                                    vector.add(dvRegisterArray[n].getStringValue());
                                    ++n;
                                }
                            }
                            byte[] byArray = dvThread.getMetadata();
                            if (null != byArray) {
                                String string4 = new String(byArray);
                                vector.add("\n\tMetadata: " + string4 + "\n");
                            }
                        } else {
                            vector.add("\n    Not a java thread\n --- nothing to report ---\n");
                        }
                    } else {
                        vector.add(" ASID/PROC/THREAD combination invalid. (" + string + " : " + string2 + " : " + string3 + " )");
                    }
                }
            }
        }
        this.cpr.output(vector);
    }

    private boolean validateDisDump(String string, Vector vector) {
        boolean bl = false;
        if (string == null) {
            vector.add("No parameters passed");
        } else {
            Vector<String> vector2 = new Vector<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            String string2 = null;
            if (stringTokenizer.countTokens() != 0) {
                string2 = stringTokenizer.nextToken();
            }
            if (null != string2) {
                vector2.add(string2);
                while (stringTokenizer.hasMoreTokens()) {
                    vector2.add(stringTokenizer.nextToken());
                }
            }
            if (vector2.size() < 1 || vector2.size() > 3) {
                vector.add("Too few or too many parameters");
            } else if (vector2.size() == 3) {
                String string3 = (String)vector2.elementAt(2);
                if (string3.toUpperCase().equals("P") || string3.toUpperCase().equals("L") || string3.toUpperCase().equals("A") || string3.toUpperCase().equals("E") || string3.toUpperCase().equals("I")) {
                    bl = true;
                } else {
                    vector.add("\nLast parameter is not P(ointer),L(ong),I(nteger),A(scii) or E(bcdic)\n");
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    private Vector formatMemory(long l, byte[] byArray, boolean bl, String string) {
        DvUtils.writetoTrace(" Entry: formatMemory");
        String string2 = "0000000000000000";
        boolean bl2 = false;
        boolean bl3 = false;
        String string3 = DvUtils.getValue("FORMATAS");
        int n = 8;
        if (DvUtils.is64BitSystem(DvConsole.theDump.getArchitecture())) {
            n = 16;
        }
        if (null != string3) {
            if ((string3 = string3.toUpperCase()).startsWith("E")) {
                bl2 = true;
            }
            if (string3.startsWith("A")) {
                bl3 = true;
            }
        }
        if (null != string) {
            if (string.equals("A")) {
                bl3 = true;
                bl2 = false;
            }
            if (string.equals("E")) {
                bl3 = false;
                bl2 = true;
            }
        }
        String string4 = "| ";
        Vector<String> vector = new Vector<String>();
        String string5 = Long.toHexString(l);
        if (string5.length() < n) {
            string5 = string2.substring(0, n - string5.length()) + string5;
        }
        String string6 = new String("\n" + string5 + ": ");
        int n2 = 120;
        int n3 = Integer.MAX_VALUE;
        boolean bl4 = DvUtils.isConsoleOutput();
        if (bl4) {
            n2 = DvUtils.getPropertyInt("WIDTH");
            n3 = DvUtils.getPropertyInt("LINES");
        }
        int n4 = 16;
        if (n2 > 140) {
            n4 = 32;
        }
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 1;
        while (n7 < byArray.length) {
            n5 = byArray[n7];
            if (n5 < 0) {
                n5 += 256;
            }
            string6 = string6 + DvUtils.byteToHex.substring(2 * n5, 2 * n5 + 2);
            string4 = false == bl && false == bl2 || true == bl3 ? string4 + DvUtils.byteToAscii.substring(n5, n5 + 1) : string4 + DvUtils.byteToEbcdic.substring(n5, n5 + 1);
            if (0 == n8 % 4) {
                string6 = string6 + " ";
            }
            if (n4 == n8) {
                string6 = string6 + string4;
                string4 = "| ";
                n8 = 0;
                vector.add(string6);
                ++n6;
                string5 = Long.toHexString(l += (long)n4);
                if (string5.length() < n) {
                    string5 = string2.substring(0, n - string5.length()) + string5;
                }
                string6 = new String(string5 + ": ");
            }
            if (n6 == n3) {
                this.cpr.output(vector);
                n6 = 0;
                vector.clear();
                if (this.forcedEnd) {
                    return null;
                }
            }
            ++n7;
            ++n8;
        }
        if (!vector.isEmpty() && bl4) {
            this.cpr.output(vector);
        }
        DvUtils.writetoTrace(" Exit: formatMemory");
        if (bl4) {
            return null;
        }
        return vector;
    }

    public void findInMemory() {
        this.findInMemory(false);
    }

    public void findInMemory(boolean bl) {
        long l = 0L;
        long l2 = -1L;
        boolean bl2 = false;
        int n = 256;
        int n2 = 1;
        boolean bl3 = false;
        int n3 = 1;
        String string = "1";
        boolean bl4 = false;
        Vector<Object> vector = new Vector<Object>();
        DvDump dvDump = DvConsole.theDump;
        if (null == this.verbModifier) {
            bl4 = true;
            this.doFindHelp(vector);
        } else {
            int n4;
            int n5;
            int n6;
            int n7;
            boolean bl5 = false;
            if (4 == dvDump.getSystemType()) {
                bl5 = true;
            }
            DvAddressSpace dvAddressSpace = DvUtils.findAsid(dvDump, DvUtils.getValue("ASID"));
            String string2 = null;
            if (null != this.paramString) {
                this.verbModifier = this.verbModifierForFind;
            }
            String string3 = new String(this.verbModifier);
            if (null == this.verbModifier) {
                this.doFindHelp(vector);
            } else if (this.verbModifier.startsWith("\"")) {
                n7 = this.verbModifier.lastIndexOf("\"");
                if (0 == n7) {
                    vector.add("\nInvalid command structure: missing end quote\n");
                    bl4 = true;
                } else {
                    if (n7 + 1 != this.verbModifier.length()) {
                        string2 = string3.substring(n7 + 1);
                    }
                    string3 = string3.substring(1, n7);
                }
            } else {
                n7 = this.verbModifier.indexOf(",");
                if (-1 != n7) {
                    string2 = string3.substring(n7);
                    string3 = string3.substring(0, n7);
                }
            }
            if (!bl4 && string3.toUpperCase().startsWith("0X")) {
                if (2 < string3.length()) {
                    bl3 = true;
                    string3 = DvUtils.remove0x(string3);
                    string3.trim();
                    if (1 == string3.length() % 2) {
                        string3 = "0" + string3;
                    }
                    n7 = 0;
                    while (n7 < string3.length()) {
                        n6 = DvUtils.hexValue(string3.charAt(n7));
                        if (n6 == -1) {
                            bl4 = true;
                        }
                        ++n7;
                    }
                    if (bl4) {
                        vector.add("\nInvalid hex value: 0x" + string3 + "\n");
                    }
                } else {
                    vector.add("\nInvalid command structure:" + string3 + "\n");
                    bl4 = true;
                }
            }
            if (!bl4 && bl) {
                bl3 = true;
                n7 = 0;
                while (n7 < string3.length()) {
                    n6 = DvUtils.hexValue(string3.charAt(n7));
                    if (n6 == -1) {
                        bl4 = true;
                    }
                    ++n7;
                }
                if (bl4) {
                    vector.add("\nInvalid hex value: 0x" + string3 + "\n");
                }
            }
            if (!bl4 && bl) {
                int n8;
                n7 = DvUtils.is64BitSystem(dvDump.getArchitecture()) ? 1 : 0;
                n6 = DvUtils.isBigEndian(dvDump.getArchitecture());
                n5 = string3.length();
                if (n7 != 0) {
                    if (n5 > 16) {
                        bl4 = true;
                    }
                    if (n5 < 16) {
                        n8 = 0;
                        while (n8 < 16 - n5) {
                            string3 = "0" + string3;
                            ++n8;
                        }
                    }
                } else {
                    if (n5 > 8) {
                        bl4 = true;
                    }
                    if (n5 < 8) {
                        n8 = 0;
                        while (n8 < 8 - n5) {
                            string3 = "0" + string3;
                            ++n8;
                        }
                    }
                }
                if (bl4) {
                    vector.add("\nAddress is too long: " + string3 + "\n");
                }
                if (!bl4 && 0 == n6) {
                    if (n7 != 0) {
                        String[] stringArray = new String[8];
                        n4 = 0;
                        while (n4 < 8) {
                            stringArray[n4] = string3.substring(n4 * 2, (n4 + 1) * 2);
                            ++n4;
                        }
                        string3 = stringArray[7] + stringArray[6] + stringArray[5] + stringArray[4] + stringArray[3] + stringArray[2] + stringArray[1] + stringArray[0];
                    } else {
                        String[] stringArray = new String[4];
                        n4 = 0;
                        while (n4 < 4) {
                            stringArray[n4] = string3.substring(n4 * 2, (n4 + 1) * 2);
                            ++n4;
                        }
                        string3 = stringArray[3] + stringArray[2] + stringArray[1] + stringArray[0];
                    }
                }
            }
            Vector<String> vector2 = new Vector<String>();
            if (!bl4 && null != string2) {
                n6 = 0;
                while (0 == n6) {
                    n5 = string2.indexOf(",,");
                    if (-1 == n5) {
                        n6 = 1;
                        continue;
                    }
                    string2 = string2.substring(0, n5 + 1) + " " + string2.substring(n5 + 1);
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                int n9 = stringTokenizer.countTokens();
                if (0 != n9) {
                    n4 = 0;
                    while (n4 < n9) {
                        vector2.add(stringTokenizer.nextToken().trim());
                        ++n4;
                    }
                }
                if (n9 > 5) {
                    vector.add("\nInvalid command structure: too many parameters\n");
                    bl4 = true;
                }
            }
            if (!bl4 && 0 != vector2.size()) {
                String string4;
                String string5;
                String string6;
                String string7 = (String)vector2.get(0);
                if (0 != string7.length()) {
                    try {
                        l = DvUtils.hexToLong(string7);
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl4 = true;
                        vector.add("Invalid parameter:" + string7);
                    }
                }
                if (1 < vector2.size() && 0 != (string6 = (String)vector2.get(1)).length()) {
                    try {
                        l2 = DvUtils.hexToLong(string6);
                        DvAddress dvAddress = dvAddressSpace.createAddress(l);
                        DvAddress dvAddress2 = dvAddressSpace.createAddress(l2);
                        if (1 == dvAddress2.compare(dvAddress)) {
                            bl4 = true;
                            vector.add("End address:" + string6 + " is lower than start address:" + string7);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl4 = true;
                        vector.add("Invalid parameter:" + string6);
                    }
                }
                if (2 < vector2.size() && (string5 = (String)vector2.get(2)).length() != 0) {
                    try {
                        n2 = Integer.parseInt(string5);
                        if (1 > n2 || 256 < n2) {
                            bl4 = true;
                            vector.add("Invalid boundary parameter (between 1 and 256 are valid) :" + string5);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl4 = true;
                        vector.add("Invalid boundary parameter:" + string5);
                    }
                }
                if (3 < vector2.size() && (string4 = (String)vector2.get(3)).length() != 0) {
                    try {
                        n = Integer.parseInt(string4);
                        if (16 > n) {
                            bl4 = true;
                            vector.add("Invalid print length parameter (less than 16) :" + string4);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl4 = true;
                        vector.add("Invalid print length parameter:" + string4);
                    }
                }
                if (4 < vector2.size() && (string = (String)vector2.get(4)).length() != 0) {
                    try {
                        n3 = Integer.parseInt(string);
                        if (n3 > 100 || n3 < 1) {
                            bl4 = true;
                            vector.add("Invalid find limit (>100 or <1) :" + string);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl4 = true;
                        vector.add("Invalid find limit:" + string);
                    }
                }
            }
            boolean bl6 = false;
            String string8 = DvUtils.getValue("FINDMODE");
            if (null != string8 && string8.toUpperCase().startsWith("V")) {
                bl6 = true;
            }
            if (!bl4) {
                Object object;
                int n10;
                byte[] byArray;
                if (bl3) {
                    byArray = new byte[string3.length() / 2];
                    n10 = 0;
                    while (n10 < byArray.length) {
                        String string9 = string3.substring(n10 * 2, n10 * 2 + 2);
                        int n11 = Integer.parseInt(string9, 16);
                        if (n11 > 127) {
                            n11 -= 256;
                        }
                        string9 = String.valueOf(n11);
                        byArray[n10] = Byte.parseByte(string9);
                        ++n10;
                    }
                } else {
                    byArray = new byte[string3.length()];
                    n10 = 0;
                    boolean bl7 = false;
                    String string10 = DvUtils.getValue("FORMATAS");
                    if (null != string10) {
                        if ((string10 = string10.toUpperCase()).startsWith("E")) {
                            n10 = 1;
                        }
                        if (string10.startsWith("A")) {
                            bl7 = true;
                        }
                    }
                    if (bl5 && !bl7 || 1 == n10) {
                        try {
                            byArray = string3.getBytes("Cp1047");
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            DvUtils.trace("Its an unsuported encodingCp1047", 0, true);
                        }
                    } else {
                        byArray = string3.getBytes();
                    }
                }
                DvAddress dvAddress = dvAddressSpace.createAddress(l);
                DvAddress dvAddress3 = dvAddressSpace.createAddress(l2);
                Vector vector3 = DvUtils.findInMemory(dvDump, byArray, dvAddress, dvAddress3, n2, n3, bl2);
                if (vector3.size() == n3) {
                    vector.add("  Note: your search result limit was " + n3 + " ... there may be more results\n");
                }
                if (1 < vector3.size()) {
                    int n12 = 0;
                    while (n12 < vector3.size()) {
                        object = (DvAddress)vector3.elementAt(n12);
                        vector.add("#" + n12 + ": " + ((DvAddress)object).convertToHex());
                        ++n12;
                    }
                }
                if (0 != vector3.size()) {
                    DvAddress dvAddress4 = (DvAddress)vector3.elementAt(vector3.size() - 1);
                    object = string3;
                    if (bl3) {
                        object = "0x" + (String)object;
                    }
                    DvAddress dvAddress5 = dvAddressSpace.createAddress(dvAddress4.getAddressAsLong());
                    try {
                        dvAddress5.offsetBy(n2);
                    }
                    catch (DvAddressException dvAddressException) {
                        // empty catch block
                    }
                    object = (String)object + "," + dvAddress5.convertToHex() + ",";
                    object = (String)object + dvAddress3.convertToHex() + "," + n2 + ",";
                    object = (String)object + n + "," + string;
                    DvUtils.setValue("FINDNEXT", (String)object);
                    byte[] byArray2 = null;
                    try {
                        byArray2 = dvAddressSpace.readBytes(dvAddress4, (long)n);
                    }
                    catch (DvAddressException dvAddressException) {
                        // empty catch block
                    }
                    Vector vector4 = this.formatMemory(dvAddress4.getAddressAsLong(), byArray2, bl5, null);
                    if (null != vector4) {
                        vector.add(vector4);
                    }
                    vector.add("  Tip 1: Use FINDNEXT (FN) command to progress through them");
                    vector.add("  Tip 2: Use \"SET FINDMODE=V\" to do automatic WHATIS\n");
                    if (bl6) {
                        Vector vector5 = new Vector();
                        int n13 = 0;
                        while (n13 < vector3.size()) {
                            DvAddress dvAddress6 = (DvAddress)vector3.elementAt(n13);
                            vector.add("whatis " + dvAddress6.convertToHex() + " :");
                            vector5.clear();
                            this.whatIs(vector5, dvAddress6.convertToHex());
                            int n14 = vector5.size();
                            if (n14 > 0) {
                                int n15 = 0;
                                while (n15 < n14) {
                                    vector.add(vector5.get(n15));
                                    ++n15;
                                }
                            }
                            ++n13;
                        }
                    }
                } else {
                    vector.add(" \n No occurrence of search string found. \n Note: Check case. \"SET FORMATAS=A\" can be used to \n force ASCII search on EBCDIC dump (and vice versa). \n Note: You can use \" SET FINDMODE=V\" to cause find to \n issue a WHATIS against each found memory position.");
                }
                vector.add(" Find finished...\n");
            }
        }
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    private void doFindHelp(Vector vector) {
        Vector vector2 = DvUtils.getMultiplePropertyValues("FINDHelp", "DvBaseCommands.properties");
        if (vector2.size() != 0) {
            vector.add(vector2);
        }
    }

    public void doSetHelp() {
        Vector vector = DvUtils.getMultiplePropertyValues("SETHelp", "DvBaseCommands.properties");
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    public void doDisplayHelp() {
        Vector vector = DvUtils.getMultiplePropertyValues("DISHelp", "DvBaseCommands.properties");
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    public void findNext() {
        String string;
        this.verbModifier = string = DvUtils.getValue("FINDNEXT");
        this.verbModifierForFind = string;
        this.findInMemory();
    }

    public void findPointer() {
        this.findInMemory(true);
    }

    public void displaySpaces() {
        DvDump dvDump = DvConsole.theDump;
        Vector<String> vector = new Vector<String>();
        DvAddressSpace[] dvAddressSpaceArray = dvDump.getAddressSpaces();
        vector.add("\n\n");
        int n = 0;
        while (n < dvAddressSpaceArray.length) {
            vector.add("Address Space: " + dvAddressSpaceArray[n].id());
            DvProcess[] dvProcessArray = dvAddressSpaceArray[n].getProcesses();
            int n2 = 0;
            while (n2 < dvProcessArray.length) {
                vector.add(" Process: " + dvProcessArray[n2].id());
                DvThread[] dvThreadArray = dvProcessArray[n2].getThreads();
                int n3 = 0;
                while (n3 < dvThreadArray.length) {
                    if (dvThreadArray[n3].isJava()) {
                        vector.add("  Thread (java): id=" + dvThreadArray[n3].id() + " ee=0x" + Long.toHexString(dvThreadArray[n3].eeAddress().getAddressAsLong()) + " jvm=0x" + Long.toHexString(DvUtils.jvmFromExecenv(dvAddressSpaceArray[n], dvThreadArray[n3].eeAddress())) + " name=" + dvThreadArray[n3].getThreadName(dvAddressSpaceArray[n]));
                    } else {
                        vector.add("  Thread: " + dvThreadArray[n3].id() + " (non-java) ");
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    public void setThread() {
        if (null == this.paramString) {
            this.paramString = "";
        }
        DvUtils.writetoTrace(" Entry: setThread() " + this.paramString);
        StringTokenizer stringTokenizer = new StringTokenizer(this.paramString);
        String string = null;
        if (stringTokenizer.countTokens() != 0) {
            string = stringTokenizer.nextToken();
            boolean bl = false;
            String string2 = DvUtils.getValue("PID");
            String string3 = DvUtils.getValue("ASID");
            String string4 = DvUtils.getValue("THREAD");
            if (string4.toUpperCase().equals(string.toUpperCase())) {
                this.cpr.output("Thread is already \"" + string4 + "\"!");
            } else {
                Object[] objectArray;
                this.cpr.output("Trying to change thread from \"" + DvUtils.getValue("THREAD") + "\" to \"" + this.paramString + "\"");
                DvDump dvDump = DvConsole.theDump;
                Object object = null;
                DvAddressSpace dvAddressSpace = null;
                DvAddressSpace[] dvAddressSpaceArray = dvDump.getAddressSpaces();
                int n = 0;
                while (n < dvAddressSpaceArray.length && !bl) {
                    if (string3.equals(dvAddressSpaceArray[n].id())) {
                        dvAddressSpace = dvAddressSpaceArray[n];
                        objectArray = dvAddressSpace.getProcesses();
                        int n2 = 0;
                        while (n2 < objectArray.length && !bl) {
                            if (((DvProcess)objectArray[n2]).id().equals(string2)) {
                                bl = true;
                                object = objectArray[n2];
                            }
                            ++n2;
                        }
                    }
                    ++n;
                }
                if (bl) {
                    objectArray = ((DvProcess)object).getThreads();
                    DvThread dvThread = DvUtils.getThread((DvProcess)object, string);
                    if (null != dvThread) {
                        if (dvThread.isJava()) {
                            DvUtils.setValue("THREAD", dvThread.id());
                            this.cpr.output("Changed thread to \"" + string + "\"");
                            this.jvmSetChange(dvAddressSpace, dvAddressSpace, (DvProcess)object, dvThread);
                        } else {
                            this.cpr.output(" \"" + string + "\" is not a Java thread - request ignored\n" + "   Use \"dis as\" to show valid address " + "space/process combinations ");
                        }
                    } else {
                        this.cpr.output(" \"" + string + "\" is not a valid thread in current address space/process!\n" + "   Use \"dis as\" to show valid address space/process combinations ");
                    }
                } else {
                    this.cpr.output("Failure trying to change thread from \"" + DvUtils.getValue("THREAD") + "\" to \"" + this.paramString + "\"");
                }
            }
        }
        this.forcedEnd = true;
        DvUtils.writetoTrace(" Exit: setThread() ");
    }

    private void jvmSetChange(DvAddressSpace dvAddressSpace, DvAddressSpace dvAddressSpace2, DvProcess dvProcess, DvThread dvThread) {
        String string = DvUtils.getValue("THREAD");
        if (!DvUtils.sameJvm(dvAddressSpace, DvUtils.getThread(dvProcess, string), dvAddressSpace2, dvThread)) {
            DvUtils.writetoTrace("   (jvmSetChange) ... changed to a different jvm ");
            DvObjectsCommands.heapsNeedRetraversal();
        } else {
            DvUtils.writetoTrace("   (jvmSetChange)... same jvm as previous thread");
        }
    }

    public void setCurrentJvm() {
        if (null == this.paramString) {
            this.paramString = "";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.paramString);
        String string = null;
        if (stringTokenizer.countTokens() != 0) {
            string = stringTokenizer.nextToken();
            string = DvUtils.remove0x(string);
            boolean bl = false;
            try {
                long l = Long.parseLong(string, 16);
                String string2 = DvUtils.getValue("CURRJVM");
                long l2 = -1L;
                if (null != string2 && !string2.equals("-1")) {
                    l2 = DvUtils.hexToLong(string2);
                }
                if (l2 == l) {
                    this.cpr.output(" \"" + string + "\" is already the current jvm" + "\nHint: can use \"SET\" to display available jvms");
                } else {
                    Vector vector = DvConsole.getJvmsInDump();
                    int n = 0;
                    while (n < vector.size() && !bl) {
                        long l3 = (Long)vector.get(n);
                        if (l == l3) {
                            DvUtils.setValue("CURRJVM", Long.toHexString(l));
                            bl = true;
                            DvAddressSpace dvAddressSpace = DvConsole.getJvmsInDumpAs(n);
                            DvUtils.setValue("ASID", dvAddressSpace.id());
                            DvUtils.setValue("PID", dvAddressSpace.getCurrentProcess().id());
                            DvThread dvThread = DvConsole.getFirstThreadForJVM(n);
                            CTypeObject cTypeObject = DvUtils.formatAddrAsType(dvAddressSpace, new DvAddress(l), "Jvm");
                            if (null != cTypeObject) {
                                DvUtils.setValue("THREAD", dvThread.id());
                                DvUtils.setupJVMHints(cTypeObject, l, dvAddressSpace);
                                DvUtils.setValue("CURRJVM", Long.toHexString(l));
                                DvObjectsCommands.heapsNeedRetraversal();
                                DvClassCommands dvClassCommands = DvClassCommands.getCurrentInstance();
                                dvClassCommands.reset();
                                DvObjectsCommands dvObjectsCommands = DvObjectsCommands.getCurrentInstance();
                                dvObjectsCommands.reset();
                                DvJavacorePlugin.reInitialize();
                            } else {
                                this.cpr.output(" Error: Unable to format Jvm!\n Definitely a glitch worthy of investigation\n Jvm not changed !!");
                            }
                        }
                        ++n;
                    }
                    if (!bl) {
                        this.cpr.output(" \"" + string + "\" is not a known jvm" + "\nHint: can use \"SET\" to display available jvms");
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.cpr.output(" \"" + string + "\" is not a valid hex address" + "\nHint: can use \"SET JVM=$JVM#x\" where x is the index");
            }
        } else {
            this.cpr.output("Need to say what JVM required!\nHint: can use \"SET JVM=$JVM#x\" where x is the index");
        }
        this.forcedEnd = true;
    }

    public void setPID() {
        if (null == this.paramString) {
            this.paramString = "";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.paramString);
        String string = null;
        if (stringTokenizer.countTokens() != 0) {
            string = stringTokenizer.nextToken();
            boolean bl = false;
            String string2 = DvUtils.getValue("PID");
            String string3 = DvUtils.getValue("ASID");
            if (string2.toUpperCase().equals(string.toUpperCase())) {
                this.cpr.output("Process id is already \"" + string2 + "\"!");
            } else {
                this.cpr.output("Trying to change process id from \"" + DvUtils.getValue("PID") + "\" to \"" + string + "\"");
                DvDump dvDump = DvConsole.theDump;
                DvProcess[] dvProcessArray = null;
                DvAddressSpace dvAddressSpace = null;
                DvAddressSpace[] dvAddressSpaceArray = dvDump.getAddressSpaces();
                int n = 0;
                while (n < dvAddressSpaceArray.length && !bl) {
                    if (string3.equals(dvAddressSpaceArray[n].id())) {
                        dvAddressSpace = dvAddressSpaceArray[n];
                        dvProcessArray = dvAddressSpace.getProcesses();
                        bl = true;
                    }
                    ++n;
                }
                if (null == dvProcessArray) {
                    this.cpr.output(" \"" + string + "\" is not a valid process in current address space!\n" + "   Use \"dis as\" to show valid address space/process combinations ");
                } else {
                    bl = false;
                    int n2 = 0;
                    while (n2 < dvProcessArray.length && !bl) {
                        if (string.toUpperCase().equals(dvProcessArray[n2].id().toUpperCase())) {
                            this.cpr.output("Changed process id to \"" + string + "\"");
                            DvUtils.setValue("PID", dvProcessArray[n2].id());
                            if (0 == dvProcessArray[n2].getThreads().length) {
                                DvUtils.setValue("THREAD", "-1");
                            } else {
                                DvThread dvThread = dvProcessArray[n2].getThreads()[0];
                                this.jvmSetChange(dvAddressSpace, dvAddressSpace, dvProcessArray[n2], dvThread);
                                DvUtils.setValue("THREAD", dvProcessArray[n2].getThreads()[0].id());
                            }
                            bl = true;
                        }
                        ++n2;
                    }
                    if (!bl) {
                        this.cpr.output(" \"" + string + "\" is not a valid process in current address space!\n" + "   Use \"dis as\" to show valid address space/process combinations ");
                    }
                }
            }
        } else {
            this.cpr.output("Need to say what process required!");
        }
        this.forcedEnd = true;
    }

    public void setASID() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.paramString);
        String string = null;
        if (stringTokenizer.countTokens() != 0) {
            string = stringTokenizer.nextToken();
            boolean bl = false;
            String string2 = DvUtils.getValue("ASID");
            DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A");
            DvProcess dvProcess = (DvProcess)DvUtils.getAPT(DvConsole.theDump, "P");
            if (string2.toUpperCase().equals(string.toUpperCase())) {
                this.cpr.output("Address space is already \"" + string2 + "\"!");
            } else {
                this.cpr.output("Trying to change address space id from \"" + string2 + "\" to \"" + string + "\"");
                DvDump dvDump = DvConsole.theDump;
                DvAddressSpace dvAddressSpace2 = null;
                DvAddressSpace[] dvAddressSpaceArray = dvDump.getAddressSpaces();
                int n = 0;
                int n2 = 0;
                while (n2 < dvAddressSpaceArray.length && !bl) {
                    if (dvAddressSpaceArray[n2].id().toUpperCase().equals(string.toUpperCase())) {
                        bl = true;
                        dvAddressSpace2 = dvAddressSpaceArray[n2];
                        n = n2;
                    }
                    ++n2;
                }
                if (!bl) {
                    this.cpr.output(" \"" + string + "\" is not a valid address space!\n" + "   Use \"dis as\" to show valid address spaces");
                } else {
                    DvUtils.setValue("ASID", dvAddressSpaceArray[n].id());
                    this.cpr.output("Changed address space id to \"" + string + "\"");
                    DvProcess[] dvProcessArray = dvAddressSpaceArray[n].getProcesses();
                    if (0 == dvProcessArray.length) {
                        DvUtils.setValue("PID", "-1");
                        DvUtils.setValue("THREAD", "-1");
                    } else {
                        bl = false;
                        n = 0;
                        while (n < dvProcessArray.length && !bl) {
                            DvThread[] dvThreadArray = dvProcessArray[n].getThreads();
                            int n3 = 0;
                            while (n3 < dvThreadArray.length && !bl) {
                                if (dvThreadArray[n3].isJava()) {
                                    DvUtils.setValue("PID", dvProcessArray[n].id());
                                    this.jvmSetChange(dvAddressSpace, dvAddressSpace2, dvProcess, dvThreadArray[n3]);
                                    DvUtils.setValue("THREAD", dvThreadArray[n3].id());
                                    bl = true;
                                }
                                ++n3;
                            }
                            ++n;
                        }
                        if (!bl) {
                            DvUtils.setValue("PID", dvProcessArray[0].id());
                            DvUtils.setValue("THREAD", "-1");
                        }
                    }
                }
            }
        } else {
            this.cpr.output("Need to say what address space required!");
        }
        this.forcedEnd = true;
    }

    public void reset() {
        prevVerb = null;
        prevModifier = null;
        prevParms = null;
        prevSeperator = null;
    }

    public void whatIs() {
        Vector vector = new Vector();
        this.whatIs(vector);
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    private void whatIs(Vector vector, String string) {
        String string2 = this.verbModifier;
        this.verbModifier = string;
        this.whatIs(vector);
        this.verbModifier = string2;
    }

    public void whatIs(Vector vector) {
        DvAddress dvAddress = null;
        if (null == this.verbModifier) {
            Vector vector2 = DvUtils.getMultiplePropertyValues("WhatIs", "DvBaseCommands.properties");
            vector.add(vector2);
        } else {
            String string = this.verbModifier.toUpperCase();
            boolean bl = false;
            long l = 0L;
            if (this.verbModifier.toUpperCase().startsWith("0X")) {
                string = DvUtils.remove0x(string);
            }
            try {
                l = Long.parseLong(string, 16);
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (bl) {
                vector.add(" Its an address");
                dvAddress = new DvAddress(l);
            }
            DvDump dvDump = DvConsole.theDump;
            Vector vector3 = DvConsole.getCommandPluginVector();
            int n = 0;
            while (n < vector3.size()) {
                CommandPlugin commandPlugin = (CommandPlugin)vector3.get(n);
                String string2 = commandPlugin.whatIs(dvAddress, this.verbModifier, dvDump);
                if (null != string2) {
                    vector.add(string2);
                }
                ++n;
            }
        }
    }

    public String whatIs(DvAddress dvAddress, String string, DvDump dvDump) {
        String string2 = "";
        if (null != dvAddress) {
            Object object;
            Object object2;
            if (dvDump != null) {
                object2 = (DvProcess)DvUtils.getAPT(dvDump, "P");
                object = ((DvProcess)object2).getThreads();
                boolean bl = false;
                int n = 0;
                while (n < ((DvThread[])object).length && !bl) {
                    if (string.equals(object[n].id()) || string.toUpperCase().equals(("0X" + object[n].id()).toUpperCase())) {
                        string2 = string2 + " Its a known thread id in Process " + ((DvProcess)object2).id() + "\n";
                        bl = true;
                    }
                    ++n;
                }
                bl = false;
                try {
                    String string3 = DvUtils.remove0x(string);
                    long l = Long.parseLong(string3, 16);
                    int n2 = 0;
                    while (n2 < ((DvThread[])object).length && !bl) {
                        if (l == ((DvThread)object[n2]).eeAddress().getAddressAsLong()) {
                            string2 = string2 + " Its a known execenv in Process " + ((DvProcess)object2).id() + "\n";
                            bl = true;
                        }
                        ++n2;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (dvDump != null) {
                object2 = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
                if (DvUtils.checkAddressInDump(dvAddress, (DvAddressSpace)object2)) {
                    string2 = string2 + " Address \"" + string + "\" is present in this dump";
                    object = (DvProcess)DvUtils.getAPT(dvDump, "P");
                    if (null != object) {
                        DvModule[] dvModuleArray;
                        DvLoaded dvLoaded = null;
                        try {
                            dvLoaded = ((DvProcess)object).getLoaded();
                        }
                        catch (Error error) {
                            // empty catch block
                        }
                        if (null != dvLoaded && null != (dvModuleArray = dvLoaded.getModules())) {
                            long l = dvAddress.getAddressAsLong();
                            int n = 0;
                            while (n < dvModuleArray.length) {
                                long l2 = dvModuleArray[n].address().getAddressAsLong();
                                long l3 = dvModuleArray[n].size();
                                if (l >= l2 && l <= l2 + l3) {
                                    string2 = string2 + "\n\tand is offset 0x" + Long.toHexString(l - l2) + " within module " + dvModuleArray[n].name();
                                    n = dvModuleArray.length;
                                }
                                ++n;
                            }
                        }
                    }
                } else {
                    string2 = string2 + " Address \"" + string + "\" is not an address present in this dump";
                }
            } else {
                string2 = string2 + " Cannot check address \"" + string + "\" as no dump identified yet";
            }
        } else {
            string2 = " Currently whatis only understands addresses";
        }
        return string2;
    }

    public static String asidState() {
        DvDump dvDump = DvConsole.theDump;
        int n = dvDump.getArchitecture();
        String string = "";
        string = -1 == n ? "Unknown bitness" : "arch= " + Dumpviewer.convertArchitecture(n) + "   ";
        string = string + "dump=" + DvUtils.getValue("DUMP") + "   ";
        string = string + "jvm=0x" + DvUtils.getValue("CURRJVM") + "  ";
        string = string + "thread=" + DvUtils.getValue("THREAD") + "  ";
        string = string + "as=" + DvUtils.getValue("ASID") + "  ";
        string = string + "proc=" + DvUtils.getValue("PID");
        return string;
    }

    public String r(String string, int n) {
        String string2 = "                            ";
        return n > string.length() ? string2.substring(0, n - string.length()) + string : string;
    }

    public void doSanityCheck() {
        boolean bl = false;
        Vector<String> vector = new Vector<String>();
        if (this.verbModifier != null) {
            if (-1 != "VERBOSE".indexOf(this.verbModifier.toUpperCase().trim())) {
                bl = true;
            } else {
                vector.add(" SANCHK didn't understand the verb modidifier \"" + this.verbModifier + "\"");
            }
        }
        this.doSanityCheck(vector, bl);
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    public boolean doSanityCheck(Vector vector, boolean bl) {
        DvUtils.writetoTrace("DvBaseCommands:doSanityCheck (Vector, boolean) entry");
        String string = ": Sanity check passed";
        String string2 = ": Sanity check failed - details follow ...";
        boolean bl2 = true;
        Vector vector2 = DvConsole.getCommandPluginVector();
        vector.add("\n Sanchk calls each loaded plugin that has implemented the");
        vector.add(" sanitycheck method - if the sanity check fails then details");
        vector.add(" are shown. To force detail use \"sanchk verbose\".\n");
        int n = 0;
        while (n < vector2.size()) {
            CommandPlugin commandPlugin = (CommandPlugin)vector2.get(n);
            Vector vector3 = new Vector();
            boolean bl3 = commandPlugin.sanityCheck(vector3);
            String string3 = commandPlugin.getClass().getName();
            if (!bl3) {
                bl2 = false;
            }
            if (bl3 && vector3.size() != 0) {
                vector.add(string3 + string);
                if (bl) {
                    vector.add(vector3);
                    vector.add("\n");
                }
            } else if (!bl3) {
                vector.add(string3 + string2);
                vector.add(vector3);
                vector.add("\n");
            }
            ++n;
        }
        DvUtils.writetoTrace("DvBaseCommands:doSanityCheck (Vector, boolean) exit");
        return bl2;
    }

    public void displayPlugins() {
        boolean bl = false;
        Vector vector = new Vector();
        if (null != this.paramString && (this.paramString.toUpperCase().equals("V") || this.paramString.toUpperCase().equals("VERBOSE"))) {
            bl = true;
        }
        this.displayPlugins(vector, bl);
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    public void displayPlugins(Vector vector, boolean bl) {
        Vector vector2 = DvConsole.getCommandPluginVector();
        int n = 0;
        while (n < vector2.size()) {
            CommandPlugin commandPlugin = (CommandPlugin)vector2.get(n);
            Class<?> clazz = commandPlugin.getClass();
            vector.add("\n" + clazz.getName() + " : " + commandPlugin.pluginName());
            String[] stringArray = commandPlugin.getSyntax();
            if (bl) {
                int n2 = 0;
                while (n2 < stringArray.length) {
                    String string = "";
                    StringTokenizer stringTokenizer = new StringTokenizer(stringArray[n2], ",");
                    String string2 = "";
                    int n3 = 0;
                    while (n3 < 5) {
                        string2 = stringTokenizer.nextToken();
                        ++n3;
                    }
                    try {
                        Method method = clazz.getDeclaredMethod(string2, new Class[0]);
                    }
                    catch (Exception exception) {
                        string = "  *** \"public void " + string2 + "()\" was not found in class!";
                    }
                    vector.add(stringArray[n2] + string);
                    ++n2;
                }
            }
            ++n;
        }
    }

    public void deletePlugin() {
        Vector<String> vector = new Vector<String>();
        if (null == this.paramString) {
            vector.add(" No plugin name specified");
        } else {
            String string = this.validPlugin(this.paramString.toUpperCase());
            if (null != string && -1 == this.paramString.toUpperCase().indexOf("DVBASECOMMANDS")) {
                Vector vector2 = DvConsole.getCommandPluginVector();
                int n = this.getPluginIndex(string);
                vector2.remove(n);
                DvConsole.refreshCommands();
                vector.add("\n Plugin \"" + string + "\" deleted successfully\n");
            } else {
                vector.add(" Plugin name invalid or un-deletable");
            }
        }
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    public void addPlugin() {
        Vector<String> vector = new Vector<String>();
        if (null == this.paramString) {
            vector.add(" No plugin name specified");
        } else {
            String string = this.validPlugin(this.paramString.toUpperCase());
            if (null == string) {
                Vector vector2 = DvUtils.findCommandClasses(this.paramString, vector);
                if (0 == vector2.size()) {
                    vector.add("\n Unable to add \"" + this.paramString + "\"\n     - must be full class name and correct case\n");
                } else {
                    Vector vector3 = DvConsole.getCommandPluginVector();
                    vector3.add(vector2.get(0));
                    DvConsole.refreshCommands();
                    vector.add("\n Plugin \"" + this.paramString + "\" successfully added\n");
                }
            } else {
                vector.add(" Plugin already exists");
            }
        }
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    private String validPlugin(String string) {
        Vector vector = DvConsole.getCommandPluginVector();
        int n = 0;
        while (n < vector.size()) {
            CommandPlugin commandPlugin = (CommandPlugin)vector.get(n);
            Class<?> clazz = commandPlugin.getClass();
            String string2 = clazz.getName().toUpperCase();
            int n2 = string2.indexOf(string);
            if (-1 != n2) {
                if (0 == n2) {
                    if (string2.equals(string)) {
                        return new String(clazz.getName());
                    }
                    return null;
                }
                if (string2.charAt(n2 - 1) == '.' && n2 + string.length() == string2.length()) {
                    return new String(clazz.getName());
                }
            }
            ++n;
        }
        return null;
    }

    private int getPluginIndex(String string) {
        int n = -1;
        Vector vector = DvConsole.getCommandPluginVector();
        int n2 = 0;
        while (n2 < vector.size()) {
            CommandPlugin commandPlugin = (CommandPlugin)vector.get(n2);
            Class<?> clazz = commandPlugin.getClass();
            String string2 = clazz.getName();
            if (string2.equals(string)) {
                return n2;
            }
            ++n2;
        }
        return n;
    }

    static {
        commandsSupported = new String[]{"SET,S, , ,showSettings", "SET,S,?,?,doSetHelp", "SET,S,*,*,setValue", "SET,S,THREAD,THREAD,setThread,Y,N", "SET,S,ASID,ASID,setASID,Y,N", "SET,S,PID,PID,setPID,Y,N", "SET,S,CURRJVM,JVM,setCurrentJvm,Y,N", "DISPLAY,D,AS,A,displaySpaces,Y,N", "DISP,DIS,AS,A,displaySpaces,Y,N", "DISPLAY,D,SYSTEM,SYS,displaySystem,Y,N", "DISP,DIS,SYSTEM,SYS,displaySystem,Y,N", "DISPLAY,D,SYSTEM,S,displaySystem,Y,N", "DISP,DIS,SYSTEM,S,displaySystem,Y,N", "DISPLAY,D,MMAP,MM,displayMMAP,Y,N", "DISP,DIS,MMAP,MM,displayMMAP,Y,N", "DISPLAY,D,MEMORY,M,displayMemory,Y,N", "DISP,DIS,MEMORY,M,displayMemory,Y,N", "DISPLAY,D,MEMORY,MEM,displayMemory,Y,N", "DISP,DIS,MEMORY,MEM,displayMemory,Y,N", "DISPLAY,D,THREAD,T,displayThread,Y,N", "DISP,DIS,THREAD,T,displayThread,Y,N", "DISPLAY,D,THR,TH,displayThread,Y,N", "DISP,DIS,THR,TH,displayThread,Y,N", "DISPLAY,D,INT,I,displayInt,Y,N", "DISP,DIS,INT,I,displayInt,Y,N", "DISPLAY,D,LONG,L,displayLong,Y,N", "DISP,DIS,LONG,L,displayLong,Y,N", "DISPLAY,D,POINTER,P,displayPtr,Y,N", "DISP,DIS,POINTER,P,displayPtr,Y,N", "DISPLAY,D,POINTER,PTR,displayPtr,Y,N", "DISP,DIS,POINTER,PTR,displayPtr,Y,N", "DISPLAY,D,PROCESS,PROC,displayProcess,Y,N", "DISP,DIS,PROCESS,PROC,displayProcess,Y,N", "DISP,DIS,h,?,doDisplayHelp,N,N", "DISPLAY,D,h,?,doDisplayHelp,N,N", "HELP,?, , ,displayHelp", "HELP,H, , ,displayHelp", "HELP,?,*,*,displayHelp", "HELP,H,*,*,displayHelp", "FINDNEXT,FN, , ,findNext,Y,N", "FINDPTR,FP,*,*,findPointer,Y,N", "FIND,F,*,*,findInMemory,Y,N", "SANITYCHECK,SANCHK,*,*,doSanityCheck,Y,N", "WHATIS,W,*,*,whatIs,Y,N", "DIS,D,PLUGINS,PL,displayPlugins,N,N", "DISP,DISPLAY,PLUGINS,PL,displayPlugins,N,N", "DEL,DELETE,PLUGIN,PL,deletePlugin,N,N", "REM,REMOVE,PLUGIN,PL,deletePlugin,N,N", "ADD,ADD,PLUGIN,PL,addPlugin,N,N"};
    }
}

