/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.extract;

import com.ibm.jvm.dump.extract.Extract;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.sdff.Sdff;
import java.io.RandomAccessFile;

public class Main {
    static int trace = 0;
    RandomAccessFile file = null;
    private static String coreName;
    private static String sdffName;
    private static String exeName;
    private static boolean headerOnly;

    private static void help() {
        System.out.println("JVMRAS015: Usage: jextract [options] [-o outFilename] [-f executablePathName] coreFilename");
        System.out.println("where options include:");
        System.out.println("\t-verbose:  enable verbose output");
        System.out.println("\t-? -help   print this help message");
        System.out.println("\t-Xt[level] set trace level (0-3)");
        System.out.println("\t-Xheader   generate only SDFF header");
        System.out.println("\t-Xfv:nnn   generate SDFF in format version nnn");
        int n = 0;
        while (n <= 2) {
            System.out.println("\t\t" + n + " : " + Sdff.FORMAT_DESCRIPTION[n]);
            ++n;
        }
        System.out.println("\t-Xheader is only valid with format version 0");
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        int n = 0;
        int n2 = 2;
        if (stringArray.length > 0) {
            int n3 = 0;
            while (n3 < stringArray.length) {
                if (!stringArray[n3].startsWith("-")) {
                    if (coreName == null) {
                        coreName = stringArray[n3];
                    } else {
                        Main.help();
                    }
                } else if (stringArray[n3].startsWith("-o")) {
                    if (n3 == stringArray.length - 1 || stringArray[n3 + 1].startsWith("-")) {
                        Main.help();
                    }
                    sdffName = stringArray[n3 + 1];
                    ++n3;
                } else if (stringArray[n3].startsWith("-f")) {
                    if (n3 == stringArray.length - 1 || stringArray[n3 + 1].startsWith("-")) {
                        Main.help();
                    }
                    exeName = stringArray[n3 + 1];
                    ++n3;
                } else if (stringArray[n3].startsWith("-verbose")) {
                    if (n < 1) {
                        n = 1;
                    }
                    DvUtils.setVerbose(true);
                } else if (stringArray[n3].startsWith("-Xt")) {
                    String string = stringArray[n3].substring(stringArray[n3].length() - 1);
                    try {
                        n = Integer.parseInt(string.trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println("JVMRAS016: Can't understand '" + string + "'.");
                        Main.help();
                    }
                    if (n < 0 || n > 3) {
                        System.err.println("JVMRAS017: Invalid trace level.");
                        Main.help();
                    }
                } else if (stringArray[n3].startsWith("-Xheader")) {
                    headerOnly = true;
                } else if (stringArray[n3].startsWith("-Xfv:")) {
                    int n4 = Integer.parseInt(stringArray[n3].substring(5));
                    if (n4 >= 0 && n4 <= 2) {
                        n2 = n4;
                    } else {
                        System.err.println("JVMRAS024: Invalid format version.");
                        Main.help();
                    }
                } else {
                    System.err.println("JVMRAS018: Invalid option '" + stringArray[n3] + "'.");
                    Main.help();
                }
                ++n3;
            }
        }
        if (coreName == null) {
            System.err.println("JVMRAS019: Core file not specified.");
            Main.help();
        }
        if (sdffName == null) {
            sdffName = coreName.toUpperCase().endsWith(".DMP") ? coreName.substring(0, coreName.length() - 4) + ".sdff" : coreName + ".sdff";
        }
        if (n2 != 0 && headerOnly) {
            System.err.println("JVMRAS025: You may not specify header only with the new formats.");
            Main.help();
            return;
        }
        if (n2 == 2) {
            n2 = 1;
        }
        if (n > 0) {
            DvUtils.trace("trace level set to " + n, 0, true);
        }
        new Extract(n, coreName, sdffName, exeName, headerOnly, n2, true);
    }

    static {
        headerOnly = false;
    }
}

