/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.font;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.lang.ref.SoftReference;
import sun.awt.font.StandardGlyphVector;

public final class AdvanceCache {
    private Font font;
    private FontRenderContext frc;
    private LineMetrics lineMetrics;
    private float[] latinAdvances;
    private float[] kanaAdvances;
    private float cjkAdvance;
    private float cjkFullAdvance;
    private float cjkHalfAdvance;
    private float[] latin1GlyphInfo;
    private float[] kanaGlyphInfo;
    private float[] missingGlyphInfo;
    private float missingGlyphAdvance;
    private static final char KANA_MIN = '\u3040';
    private static final char KANA_LIM = '\u3100';
    private static final char CJK_SAMPLE1 = '\u4e9e';
    private static final char CJK_SAMPLE2 = '\u4e9a';
    private static final char CJK_SAMPLE3 = '\u4e9c';
    private static final char CJK_MIN = '\u3200';
    private static final char CJK_LIM = '\u9fb0';
    private static final char CJKFULL_SAMPLE = '\uff01';
    private static final char CJKFULL1_MIN = '\uff00';
    private static final char CJKFULL1_LIM = '\uff5f';
    private static final char CJKFULL2_MIN = '\uffe0';
    private static final char CJKFULL2_LIM = '\uffe7';
    private static final char CJKHALF_SAMPLE = '\uff61';
    private static final char CJKHALF_MIN = '\uff61';
    private static final char CJKHALF_LIM = '\uff9e';
    private static final char KSYL_SAMPLE = '\uac00';
    private static final char KSYL_MIN = '\uac00';
    private static final char KSYL_MAX = '\ud7a0';
    private static final int CACHE_SIZE = 30;
    private static SoftReference[] cache = new SoftReference[30];
    private static int cacheNum;
    private static boolean enabled;
    private static String latin1;
    private static String kana;
    static int statCount;
    static int statTest;
    static int statMiss;
    static int statFlush;
    static int statFlushDelta;
    static int statLastFlushCount;

    private boolean equals(Font font, FontRenderContext fontRenderContext) {
        return this.font.equals(font) && this.frc.equals(fontRenderContext);
    }

    public static boolean supportsText(char[] cArray, int n, int n2) {
        if (!enabled) {
            return false;
        }
        int n3 = n;
        while (n3 < n2) {
            char c = cArray[n3];
            if (!(c < '\u0100' || c >= '\u3040' && c < '\u3100' || c >= '\u3200' && c < '\u9fb0')) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static boolean supportsText(char[] cArray) {
        return AdvanceCache.supportsText(cArray, 0, cArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static AdvanceCache get(Font var0, FontRenderContext var1_1) {
        if (!AdvanceCache.enabled) {
            return null;
        }
        var2_2 = AdvanceCache.cache;
        synchronized (AdvanceCache.cache) {
            block10: {
                ++AdvanceCache.statCount;
                var3_3 = 0;
                while (var3_3 < AdvanceCache.cacheNum) {
                    var4_4 /* !! */  = (SoftReference[])AdvanceCache.cache[var3_3].get();
                    if (var4_4 /* !! */  == null) {
                        ++AdvanceCache.statFlush;
                        AdvanceCache.statFlushDelta = AdvanceCache.statCount - AdvanceCache.statLastFlushCount;
                        AdvanceCache.statLastFlushCount = AdvanceCache.statCount;
                        AdvanceCache.cache = new SoftReference[30];
                        AdvanceCache.cacheNum = 0;
                        break;
                    }
                    ++AdvanceCache.statTest;
                    if (super.equals(var0, var1_1)) {
                        if (var3_3 > 0) {
                            var5_5 = AdvanceCache.cache[var3_3];
                            while (var3_3 > 0) {
                                AdvanceCache.cache[var3_3--] = AdvanceCache.cache[var3_3];
                            }
                            AdvanceCache.cache[0] = var5_5;
                        }
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return var4_4 /* !! */ ;
                    }
                    ++var3_3;
                }
                ++AdvanceCache.statMiss;
                if (var3_3 != AdvanceCache.cache.length) ** GOTO lbl36
                var4_4 /* !! */  = new SoftReference[AdvanceCache.cache.length + 30];
                System.arraycopy(AdvanceCache.cache, 0, var4_4 /* !! */ , 1, AdvanceCache.cache.length);
                AdvanceCache.cache = var4_4 /* !! */ ;
                break block10;
lbl-1000:
                // 1 sources

                {
                    AdvanceCache.cache[var3_3 + 1] = AdvanceCache.cache[var3_3];
lbl36:
                    // 2 sources

                    ** while (--var3_3 >= 0)
                }
            }
            var4_4 /* !! */  = new AdvanceCache(var0, var1_1);
            AdvanceCache.cache[0] = new SoftReference<SoftReference[]>(var4_4 /* !! */ );
            ++AdvanceCache.cacheNum;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return var4_4 /* !! */ ;
        }
    }

    private void initLatinAdvances() {
        StandardGlyphVector standardGlyphVector = new StandardGlyphVector(this.font, latin1, this.frc);
        this.latin1GlyphInfo = standardGlyphVector.getGlyphInfo();
        this.latinAdvances = new float[256];
        int n = 0;
        int n2 = 0;
        while (n < this.latinAdvances.length) {
            this.latinAdvances[n] = this.latin1GlyphInfo[n2 + 2];
            int n3 = n2 + 4;
            this.latin1GlyphInfo[n3] = this.latin1GlyphInfo[n3] - this.latin1GlyphInfo[n2];
            int n4 = n2 + 6;
            this.latin1GlyphInfo[n4] = this.latin1GlyphInfo[n4] + this.latin1GlyphInfo[n2 + 4];
            int n5 = n2 + 7;
            this.latin1GlyphInfo[n5] = this.latin1GlyphInfo[n5] + this.latin1GlyphInfo[n2 + 5];
            ++n;
            n2 += 8;
        }
        this.latinAdvances[13] = 0.0f;
        this.latinAdvances[10] = 0.0f;
        this.latinAdvances[9] = 0.0f;
    }

    private void initKanaAdvances() {
        int n;
        StandardGlyphVector standardGlyphVector = new StandardGlyphVector(this.font, kana, this.frc);
        this.kanaGlyphInfo = standardGlyphVector.getGlyphInfo();
        int n2 = this.font.getMissingGlyphCode();
        this.kanaAdvances = new float[kana.length()];
        int n3 = 0;
        int n4 = 0;
        while (n3 < this.kanaAdvances.length) {
            this.kanaAdvances[n3] = this.kanaGlyphInfo[n4 + 2];
            int n5 = n4 + 4;
            this.kanaGlyphInfo[n5] = this.kanaGlyphInfo[n5] - this.kanaGlyphInfo[n4];
            int n6 = n4 + 6;
            this.kanaGlyphInfo[n6] = this.kanaGlyphInfo[n6] + this.kanaGlyphInfo[n4 + 4];
            int n7 = n4 + 7;
            this.kanaGlyphInfo[n7] = this.kanaGlyphInfo[n7] + this.kanaGlyphInfo[n4 + 5];
            ++n3;
            n4 += 8;
        }
        int n8 = n = 192;
        if (standardGlyphVector.getGlyphCode(n) == n2) {
            if (standardGlyphVector.getGlyphCode(n + 3) != n2) {
                n8 = n + 3;
            } else if (standardGlyphVector.getGlyphCode(n + 4) != n2) {
                n8 = n + 4;
            }
        }
        this.cjkAdvance = this.kanaAdvances[n8];
        if (n8 != n) {
            System.arraycopy(this.kanaGlyphInfo, n8 * 8, this.kanaGlyphInfo, n * 8, 8);
        }
        this.cjkFullAdvance = this.kanaAdvances[n + 1];
        this.cjkHalfAdvance = this.kanaAdvances[n + 2];
    }

    private void initMissingGlyphInfo() {
        int[] nArray = new int[]{this.font.getMissingGlyphCode()};
        StandardGlyphVector standardGlyphVector = new StandardGlyphVector(this.font, nArray, this.frc);
        this.missingGlyphInfo = standardGlyphVector.getGlyphInfo();
        this.missingGlyphInfo[4] = this.missingGlyphInfo[4] - this.missingGlyphInfo[0];
        this.missingGlyphInfo[6] = this.missingGlyphInfo[6] + this.missingGlyphInfo[4];
        this.missingGlyphInfo[7] = this.missingGlyphInfo[7] + this.missingGlyphInfo[5];
        this.missingGlyphAdvance = this.missingGlyphInfo[2];
    }

    private AdvanceCache(Font font, FontRenderContext fontRenderContext) {
        this.font = font;
        this.frc = fontRenderContext;
        this.initLatinAdvances();
        this.initKanaAdvances();
        this.initMissingGlyphInfo();
        this.lineMetrics = font.getLineMetrics(latin1, fontRenderContext);
    }

    public LineMetrics getLineMetrics() {
        return this.lineMetrics;
    }

    public float getAdvance(char c) {
        if (c < '\u0100') {
            return this.latinAdvances[c];
        }
        if (c >= '\u3040' && c < '\u3100') {
            return this.kanaAdvances[c - 12352];
        }
        if (c >= '\u3200' && c < '\u9fb0') {
            return this.font.canDisplay(c) ? this.cjkAdvance : this.missingGlyphAdvance;
        }
        if (c >= '\uff61' && c < '\uff9e') {
            return this.font.canDisplay(c) ? this.cjkHalfAdvance : this.missingGlyphAdvance;
        }
        if (c >= '\uff00' && c < '\uff5f') {
            return this.font.canDisplay(c) ? this.cjkFullAdvance : this.missingGlyphAdvance;
        }
        if (c >= '\uffe0' && c < '\uffe7') {
            return this.font.canDisplay(c) ? this.cjkFullAdvance : this.missingGlyphAdvance;
        }
        throw new IndexOutOfBoundsException("no advance for char " + Integer.toHexString(c));
    }

    public float getAdvance(String string) {
        return this.getAdvance(string.toCharArray());
    }

    public float getAdvance(char[] cArray) {
        return this.getAdvance(cArray, 0, cArray.length);
    }

    public float getAdvance(char[] cArray, int n, int n2) {
        float f = 0.0f;
        int n3 = n;
        while (n3 < n2) {
            char c = cArray[n3];
            if (c < '\u0100') {
                f += this.latinAdvances[c];
            } else if (c >= '\u3040' && c < '\u3100') {
                f += this.kanaAdvances[c - 12352];
            } else if (c >= '\u3200' && c < '\u9fb0') {
                f += this.font.canDisplay(c) ? this.cjkAdvance : this.missingGlyphAdvance;
            } else if (c >= '\uff61' && c < '\uff9e') {
                f += this.font.canDisplay(c) ? this.cjkHalfAdvance : this.missingGlyphAdvance;
            } else if (c >= '\uff00' && c < '\uff5f') {
                f += this.font.canDisplay(c) ? this.cjkFullAdvance : this.missingGlyphAdvance;
            } else if (c >= '\uffe0' && c < '\uffe7') {
                f += this.font.canDisplay(c) ? this.cjkFullAdvance : this.missingGlyphAdvance;
            } else {
                throw new IndexOutOfBoundsException("no advance for char " + Integer.toHexString(c));
            }
            ++n3;
        }
        return f;
    }

    public Rectangle2D getLogicalBounds(String string) {
        return this.getLogicalBounds(string.toCharArray());
    }

    public Rectangle2D getLogicalBounds(char[] cArray) {
        return this.getLogicalBounds(cArray, 0, cArray.length);
    }

    public Rectangle2D getLogicalBounds(char[] cArray, int n, int n2) {
        float f = this.getAdvance(cArray, n, n2);
        return new Rectangle2D.Float(0.0f, -this.lineMetrics.getAscent(), f, this.lineMetrics.getHeight());
    }

    public Rectangle2D getVisualBounds(String string) {
        return this.getVisualBounds(string.toCharArray());
    }

    public Rectangle2D getVisualBounds(char[] cArray) {
        return this.getVisualBounds(cArray, 0, cArray.length);
    }

    public Rectangle2D getVisualBounds(char[] cArray, int n, int n2) {
        float f = Float.MAX_VALUE;
        float f2 = Float.MAX_VALUE;
        float f3 = Float.MIN_VALUE;
        float f4 = Float.MIN_VALUE;
        float f5 = 0.0f;
        float[] fArray = null;
        int n3 = 0;
        int n4 = n;
        while (n4 < n2) {
            int n5 = cArray[n4];
            if (n5 < 256) {
                n3 = n5;
                fArray = this.latin1GlyphInfo;
            } else if (n5 >= 12352 && n5 < 12544) {
                n3 = n5 - 12352;
                fArray = this.kanaGlyphInfo;
            } else if (n5 >= 12800 && n5 < 40880) {
                if (this.font.canDisplay((char)n5)) {
                    n3 = 192;
                    fArray = this.kanaGlyphInfo;
                } else {
                    n3 = 0;
                    fArray = this.missingGlyphInfo;
                }
            } else if (n5 >= 65377 && n5 < 65438) {
                if (this.font.canDisplay((char)n5)) {
                    n3 = 193;
                    fArray = this.kanaGlyphInfo;
                } else {
                    n3 = 0;
                    fArray = this.missingGlyphInfo;
                }
            } else if (n5 >= 65280 && n5 < 65375) {
                if (this.font.canDisplay((char)n5)) {
                    n3 = 194;
                    fArray = this.kanaGlyphInfo;
                } else {
                    n3 = 0;
                    fArray = this.missingGlyphInfo;
                }
            } else if (n5 >= 65504 && n5 < 65511) {
                if (this.font.canDisplay((char)n5)) {
                    n3 = 194;
                    fArray = this.kanaGlyphInfo;
                } else {
                    n3 = 0;
                    fArray = this.missingGlyphInfo;
                }
            } else {
                throw new IndexOutOfBoundsException("no advance for char " + Integer.toHexString(n5));
            }
            float f6 = f5 + fArray[(n3 *= 8) + 4];
            float f7 = fArray[n3 + 5];
            float f8 = f5 + fArray[n3 + 6];
            float f9 = fArray[n3 + 7];
            if (f8 > f6 && f9 > f7) {
                if (f6 < f) {
                    f = f6;
                }
                if (f7 < f2) {
                    f2 = f7;
                }
                if (f8 > f3) {
                    f3 = f8;
                }
                if (f9 > f4) {
                    f4 = f9;
                }
            }
            f5 += fArray[n3 + 2];
            ++n4;
        }
        return new Rectangle2D.Float(f, f2, f3 - f, f4 - f2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getStats(int[] nArray) {
        SoftReference[] softReferenceArray = cache;
        synchronized (cache) {
            nArray[0] = statCount;
            nArray[1] = statTest;
            nArray[2] = statMiss;
            nArray[3] = statFlush;
            nArray[4] = statFlushDelta;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    static {
        enabled = true;
        char[] cArray = new char[256];
        int n = 0;
        while (n < cArray.length) {
            cArray[n] = (char)n;
            ++n;
        }
        cArray[13] = 32;
        cArray[10] = 32;
        cArray[9] = 32;
        latin1 = new String(cArray);
        int n2 = 192;
        cArray = new char[n2 + 5];
        int n3 = 0;
        while (n3 < n2) {
            cArray[n3] = (char)(12352 + n3);
            ++n3;
        }
        cArray[n2] = 20126;
        cArray[n2 + 1] = 65281;
        cArray[n2 + 2] = 65377;
        cArray[n2 + 3] = 20122;
        cArray[n2 + 4] = 20124;
        kana = new String(cArray);
        try {
            String string = System.getProperty("sun.awt.font.advancecache");
            if (string != null && string.equals("off")) {
                enabled = false;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        statCount = 0;
        statTest = 0;
        statMiss = 0;
        statFlush = 0;
        statFlushDelta = 0;
        statLastFlushCount = 0;
    }
}

