/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.PathPlaceHolder;
import javax.swing.tree.RowMapper;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class DefaultTreeSelectionModel
implements Cloneable,
Serializable,
TreeSelectionModel {
    public static final String SELECTION_MODE_PROPERTY = "selectionMode";
    protected SwingPropertyChangeSupport changeSupport;
    protected TreePath[] selection;
    protected EventListenerList listenerList = new EventListenerList();
    protected transient RowMapper rowMapper;
    protected DefaultListSelectionModel listSelectionModel = new DefaultListSelectionModel();
    protected int selectionMode = 4;
    protected TreePath leadPath;
    protected int leadIndex = -1;
    protected int leadRow = -1;
    private Hashtable uniquePaths = new Hashtable();
    private Hashtable lastPaths = new Hashtable();
    private TreePath[] tempPaths = new TreePath[1];
    static /* synthetic */ Class class$javax$swing$event$TreeSelectionListener;

    public void setRowMapper(RowMapper rowMapper) {
        this.rowMapper = rowMapper;
        this.resetRowSelection();
    }

    public RowMapper getRowMapper() {
        return this.rowMapper;
    }

    public void setSelectionMode(int n) {
        int n2 = this.selectionMode;
        this.selectionMode = n;
        if (this.selectionMode != 1 && this.selectionMode != 2 && this.selectionMode != 4) {
            this.selectionMode = 4;
        }
        if (n2 != this.selectionMode && this.changeSupport != null) {
            this.changeSupport.firePropertyChange(SELECTION_MODE_PROPERTY, new Integer(n2), new Integer(this.selectionMode));
        }
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionPath(TreePath treePath) {
        if (treePath == null) {
            this.setSelectionPaths(null);
        } else {
            TreePath[] treePathArray = new TreePath[]{treePath};
            this.setSelectionPaths(treePathArray);
        }
    }

    public void setSelectionPaths(TreePath[] treePathArray) {
        int n;
        TreePath[] treePathArray2 = treePathArray;
        int n2 = treePathArray2 == null ? 0 : treePathArray2.length;
        if (n2 + (n = this.selection == null ? 0 : this.selection.length) != 0) {
            Object object;
            TreePath[] treePathArray3;
            if (this.selectionMode == 1) {
                if (n2 > 1) {
                    treePathArray2 = new TreePath[]{treePathArray[0]};
                    n2 = 1;
                }
            } else if (this.selectionMode == 2 && n2 > 0 && !this.arePathsContiguous(treePathArray2)) {
                treePathArray2 = new TreePath[]{treePathArray[0]};
                n2 = 1;
            }
            int n3 = 0;
            TreePath treePath = this.leadPath;
            Vector<PathPlaceHolder> vector = new Vector<PathPlaceHolder>(n2 + n);
            this.lastPaths.clear();
            this.leadPath = null;
            int n4 = 0;
            while (n4 < n2) {
                if (treePathArray2[n4] != null && this.lastPaths.get(treePathArray2[n4]) == null) {
                    ++n3;
                    this.lastPaths.put(treePathArray2[n4], Boolean.TRUE);
                    if (this.uniquePaths.get(treePathArray2[n4]) == null) {
                        vector.addElement(new PathPlaceHolder(treePathArray2[n4], true));
                    }
                    this.leadPath = treePathArray2[n4];
                }
                ++n4;
            }
            if (n3 == 0) {
                treePathArray3 = null;
            } else if (n3 != n2) {
                object = this.lastPaths.keys();
                treePathArray3 = new TreePath[n3];
                n3 = 0;
                while (object.hasMoreElements()) {
                    treePathArray3[n3++] = (TreePath)object.nextElement();
                }
            } else {
                treePathArray3 = new TreePath[treePathArray2.length];
                System.arraycopy(treePathArray2, 0, treePathArray3, 0, treePathArray2.length);
            }
            int n5 = 0;
            while (n5 < n) {
                if (this.selection[n5] != null && this.lastPaths.get(this.selection[n5]) == null) {
                    vector.addElement(new PathPlaceHolder(this.selection[n5], false));
                }
                ++n5;
            }
            this.selection = treePathArray3;
            object = this.uniquePaths;
            this.uniquePaths = this.lastPaths;
            this.lastPaths = object;
            this.lastPaths.clear();
            if (this.selection != null) {
                this.insureUniqueness();
            }
            this.updateLeadIndex();
            this.resetRowSelection();
            if (vector.size() > 0) {
                this.notifyPathChange(vector, treePath);
            }
        }
    }

    public void addSelectionPath(TreePath treePath) {
        if (treePath != null) {
            TreePath[] treePathArray = new TreePath[]{treePath};
            this.addSelectionPaths(treePathArray);
        }
    }

    public void addSelectionPaths(TreePath[] treePathArray) {
        int n;
        int n2 = n = treePathArray == null ? 0 : treePathArray.length;
        if (n > 0) {
            if (this.selectionMode == 1) {
                this.setSelectionPaths(treePathArray);
            } else if (this.selectionMode == 2 && !this.canPathsBeAdded(treePathArray)) {
                if (this.arePathsContiguous(treePathArray)) {
                    this.setSelectionPaths(treePathArray);
                } else {
                    TreePath[] treePathArray2 = new TreePath[]{treePathArray[0]};
                    this.setSelectionPaths(treePathArray2);
                }
            } else {
                TreePath treePath = this.leadPath;
                Vector<PathPlaceHolder> vector = null;
                int n3 = this.selection == null ? 0 : this.selection.length;
                this.lastPaths.clear();
                int n4 = 0;
                int n5 = 0;
                while (n4 < n) {
                    if (treePathArray[n4] != null) {
                        if (this.uniquePaths.get(treePathArray[n4]) == null) {
                            ++n5;
                            if (vector == null) {
                                vector = new Vector<PathPlaceHolder>();
                            }
                            vector.addElement(new PathPlaceHolder(treePathArray[n4], true));
                            this.uniquePaths.put(treePathArray[n4], Boolean.TRUE);
                            this.lastPaths.put(treePathArray[n4], Boolean.TRUE);
                        }
                        this.leadPath = treePathArray[n4];
                    }
                    ++n4;
                }
                if (this.leadPath == null) {
                    this.leadPath = treePath;
                }
                if (n5 > 0) {
                    TreePath[] treePathArray3 = new TreePath[n3 + n5];
                    if (n3 > 0) {
                        System.arraycopy(this.selection, 0, treePathArray3, 0, n3);
                    }
                    if (n5 != treePathArray.length) {
                        Enumeration enumeration = this.lastPaths.keys();
                        n4 = n3;
                        while (enumeration.hasMoreElements()) {
                            treePathArray3[n4++] = (TreePath)enumeration.nextElement();
                        }
                    } else {
                        System.arraycopy(treePathArray, 0, treePathArray3, n3, n5);
                    }
                    this.selection = treePathArray3;
                    this.insureUniqueness();
                    this.updateLeadIndex();
                    this.resetRowSelection();
                    this.notifyPathChange(vector, treePath);
                } else {
                    this.leadPath = treePath;
                }
                this.lastPaths.clear();
            }
        }
    }

    public void removeSelectionPath(TreePath treePath) {
        if (treePath != null) {
            TreePath[] treePathArray = new TreePath[]{treePath};
            this.removeSelectionPaths(treePathArray);
        }
    }

    public void removeSelectionPaths(TreePath[] treePathArray) {
        if (treePathArray != null && this.selection != null && treePathArray.length > 0) {
            if (!this.canPathsBeRemoved(treePathArray)) {
                this.clearSelection();
            } else {
                Vector<PathPlaceHolder> vector = null;
                int n = treePathArray.length - 1;
                while (n >= 0) {
                    if (treePathArray[n] != null && this.uniquePaths.get(treePathArray[n]) != null) {
                        if (vector == null) {
                            vector = new Vector<PathPlaceHolder>(treePathArray.length);
                        }
                        this.uniquePaths.remove(treePathArray[n]);
                        vector.addElement(new PathPlaceHolder(treePathArray[n], false));
                    }
                    --n;
                }
                if (vector != null) {
                    int n2 = vector.size();
                    TreePath treePath = this.leadPath;
                    if (n2 == this.selection.length) {
                        this.selection = null;
                    } else {
                        Enumeration enumeration = this.uniquePaths.keys();
                        int n3 = 0;
                        this.selection = new TreePath[this.selection.length - n2];
                        while (enumeration.hasMoreElements()) {
                            this.selection[n3++] = (TreePath)enumeration.nextElement();
                        }
                    }
                    this.leadPath = this.leadPath != null && this.uniquePaths.get(this.leadPath) == null ? (this.selection != null ? this.selection[this.selection.length - 1] : null) : (this.selection != null ? this.selection[this.selection.length - 1] : null);
                    this.updateLeadIndex();
                    this.resetRowSelection();
                    this.notifyPathChange(vector, treePath);
                }
            }
        }
    }

    public TreePath getSelectionPath() {
        if (this.selection != null) {
            return this.selection[0];
        }
        return null;
    }

    public TreePath[] getSelectionPaths() {
        if (this.selection != null) {
            int n = this.selection.length;
            TreePath[] treePathArray = new TreePath[n];
            System.arraycopy(this.selection, 0, treePathArray, 0, n);
            return treePathArray;
        }
        return null;
    }

    public int getSelectionCount() {
        return this.selection == null ? 0 : this.selection.length;
    }

    public boolean isPathSelected(TreePath treePath) {
        return treePath != null ? this.uniquePaths.get(treePath) != null : false;
    }

    public boolean isSelectionEmpty() {
        return this.selection == null;
    }

    public void clearSelection() {
        if (this.selection != null) {
            int n = this.selection.length;
            boolean[] blArray = new boolean[n];
            int n2 = 0;
            while (n2 < n) {
                blArray[n2] = false;
                ++n2;
            }
            TreeSelectionEvent treeSelectionEvent = new TreeSelectionEvent((Object)this, this.selection, blArray, this.leadPath, null);
            this.leadPath = null;
            this.leadRow = -1;
            this.leadIndex = -1;
            this.uniquePaths.clear();
            this.selection = null;
            this.resetRowSelection();
            this.fireValueChanged(treeSelectionEvent);
        }
    }

    public void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.listenerList.add(class$javax$swing$event$TreeSelectionListener == null ? (class$javax$swing$event$TreeSelectionListener = DefaultTreeSelectionModel.class$("javax.swing.event.TreeSelectionListener")) : class$javax$swing$event$TreeSelectionListener, treeSelectionListener);
    }

    public void removeTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.listenerList.remove(class$javax$swing$event$TreeSelectionListener == null ? (class$javax$swing$event$TreeSelectionListener = DefaultTreeSelectionModel.class$("javax.swing.event.TreeSelectionListener")) : class$javax$swing$event$TreeSelectionListener, treeSelectionListener);
    }

    public TreeSelectionListener[] getTreeSelectionListeners() {
        return (TreeSelectionListener[])this.listenerList.getListeners(class$javax$swing$event$TreeSelectionListener == null ? (class$javax$swing$event$TreeSelectionListener = DefaultTreeSelectionModel.class$("javax.swing.event.TreeSelectionListener")) : class$javax$swing$event$TreeSelectionListener);
    }

    protected void fireValueChanged(TreeSelectionEvent treeSelectionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$TreeSelectionListener == null ? DefaultTreeSelectionModel.class$("javax.swing.event.TreeSelectionListener") : class$javax$swing$event$TreeSelectionListener)) {
                ((TreeSelectionListener)objectArray[n + 1]).valueChanged(treeSelectionEvent);
            }
            n -= 2;
        }
    }

    public EventListener[] getListeners(Class clazz) {
        return this.listenerList.getListeners(clazz);
    }

    public int[] getSelectionRows() {
        if (this.rowMapper != null && this.selection != null) {
            int[] nArray = this.rowMapper.getRowsForPaths(this.selection);
            if (nArray != null) {
                int n = 0;
                int n2 = nArray.length - 1;
                while (n2 >= 0) {
                    if (nArray[n2] == -1) {
                        ++n;
                    }
                    --n2;
                }
                if (n > 0) {
                    if (n == nArray.length) {
                        nArray = null;
                    } else {
                        int[] nArray2 = new int[nArray.length - n];
                        int n3 = nArray.length - 1;
                        int n4 = 0;
                        while (n3 >= 0) {
                            if (nArray[n3] != -1) {
                                nArray2[n4++] = nArray[n3];
                            }
                            --n3;
                        }
                        nArray = nArray2;
                    }
                }
            }
            return nArray;
        }
        return null;
    }

    public int getMinSelectionRow() {
        return this.listSelectionModel.getMinSelectionIndex();
    }

    public int getMaxSelectionRow() {
        return this.listSelectionModel.getMaxSelectionIndex();
    }

    public boolean isRowSelected(int n) {
        return this.listSelectionModel.isSelectedIndex(n);
    }

    public void resetRowSelection() {
        this.listSelectionModel.clearSelection();
        if (this.selection != null && this.rowMapper != null) {
            boolean bl = false;
            int[] nArray = this.rowMapper.getRowsForPaths(this.selection);
            int n = 0;
            int n2 = this.selection.length;
            while (n < n2) {
                int n3 = nArray[n];
                if (n3 != -1) {
                    this.listSelectionModel.addSelectionInterval(n3, n3);
                }
                ++n;
            }
            if (this.leadIndex != -1 && nArray != null) {
                this.leadRow = nArray[this.leadIndex];
            } else if (this.leadPath != null) {
                this.tempPaths[0] = this.leadPath;
                nArray = this.rowMapper.getRowsForPaths(this.tempPaths);
                this.leadRow = nArray != null ? nArray[0] : -1;
            } else {
                this.leadRow = -1;
            }
            this.insureRowContinuity();
        } else {
            this.leadRow = -1;
        }
    }

    public int getLeadSelectionRow() {
        return this.leadRow;
    }

    public TreePath getLeadSelectionPath() {
        return this.leadPath;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners();
    }

    protected void insureRowContinuity() {
        if (this.selectionMode == 2 && this.selection != null && this.rowMapper != null) {
            DefaultListSelectionModel defaultListSelectionModel = this.listSelectionModel;
            int n = defaultListSelectionModel.getMinSelectionIndex();
            if (n != -1) {
                int n2 = n;
                int n3 = defaultListSelectionModel.getMaxSelectionIndex();
                while (n2 <= n3) {
                    if (!defaultListSelectionModel.isSelectedIndex(n2)) {
                        if (n2 != n) {
                            TreePath[] treePathArray = new TreePath[n2 - n];
                            int[] nArray = this.rowMapper.getRowsForPaths(this.selection);
                            int n4 = 0;
                            while (n4 < nArray.length) {
                                if (nArray[n4] < n2) {
                                    treePathArray[nArray[n4] - n] = this.selection[n4];
                                }
                                ++n4;
                            }
                            this.setSelectionPaths(treePathArray);
                            break;
                        }
                        this.clearSelection();
                    }
                    ++n2;
                }
            }
        } else if (this.selectionMode == 1 && this.selection != null && this.selection.length > 1) {
            this.setSelectionPath(this.selection[0]);
        }
    }

    protected boolean arePathsContiguous(TreePath[] treePathArray) {
        if (this.rowMapper == null || treePathArray.length < 2) {
            return true;
        }
        BitSet bitSet = new BitSet(32);
        int n = treePathArray.length;
        int n2 = 0;
        TreePath[] treePathArray2 = new TreePath[]{treePathArray[0]};
        int n3 = this.rowMapper.getRowsForPaths(treePathArray2)[0];
        int n4 = 0;
        while (n4 < n) {
            if (treePathArray[n4] != null) {
                treePathArray2[0] = treePathArray[n4];
                int[] nArray = this.rowMapper.getRowsForPaths(treePathArray2);
                if (nArray == null) {
                    return false;
                }
                int n5 = nArray[0];
                if (n5 == -1 || n5 < n3 - n || n5 > n3 + n) {
                    return false;
                }
                if (n5 < n3) {
                    n3 = n5;
                }
                if (!bitSet.get(n5)) {
                    bitSet.set(n5);
                    ++n2;
                }
            }
            ++n4;
        }
        int n6 = n2 + n3;
        n4 = n3;
        while (n4 < n6) {
            if (!bitSet.get(n4)) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    protected boolean canPathsBeAdded(TreePath[] treePathArray) {
        int n;
        if (treePathArray == null || treePathArray.length == 0 || this.rowMapper == null || this.selection == null || this.selectionMode == 4) {
            return true;
        }
        BitSet bitSet = new BitSet();
        DefaultListSelectionModel defaultListSelectionModel = this.listSelectionModel;
        int n2 = defaultListSelectionModel.getMinSelectionIndex();
        int n3 = defaultListSelectionModel.getMaxSelectionIndex();
        TreePath[] treePathArray2 = new TreePath[1];
        if (n2 != -1) {
            n = n2;
            while (n <= n3) {
                if (defaultListSelectionModel.isSelectedIndex(n)) {
                    bitSet.set(n);
                }
                ++n;
            }
        } else {
            treePathArray2[0] = treePathArray[0];
            n2 = n3 = this.rowMapper.getRowsForPaths(treePathArray2)[0];
        }
        n = treePathArray.length - 1;
        while (n >= 0) {
            if (treePathArray[n] != null) {
                treePathArray2[0] = treePathArray[n];
                int[] nArray = this.rowMapper.getRowsForPaths(treePathArray2);
                if (nArray == null) {
                    return false;
                }
                int n4 = nArray[0];
                n2 = Math.min(n4, n2);
                n3 = Math.max(n4, n3);
                if (n4 == -1) {
                    return false;
                }
                bitSet.set(n4);
            }
            --n;
        }
        n = n2;
        while (n <= n3) {
            if (!bitSet.get(n)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected boolean canPathsBeRemoved(TreePath[] treePathArray) {
        if (this.rowMapper == null || this.selection == null || this.selectionMode == 4) {
            return true;
        }
        BitSet bitSet = new BitSet();
        int n = treePathArray.length;
        int n2 = -1;
        int n3 = 0;
        TreePath[] treePathArray2 = new TreePath[1];
        this.lastPaths.clear();
        int n4 = 0;
        while (n4 < n) {
            if (treePathArray[n4] != null) {
                this.lastPaths.put(treePathArray[n4], Boolean.TRUE);
            }
            ++n4;
        }
        n4 = this.selection.length - 1;
        while (n4 >= 0) {
            if (this.lastPaths.get(this.selection[n4]) == null) {
                treePathArray2[0] = this.selection[n4];
                int[] nArray = this.rowMapper.getRowsForPaths(treePathArray2);
                if (nArray != null && nArray[0] != -1 && !bitSet.get(nArray[0])) {
                    ++n3;
                    n2 = n2 == -1 ? nArray[0] : Math.min(n2, nArray[0]);
                    bitSet.set(nArray[0]);
                }
            }
            --n4;
        }
        this.lastPaths.clear();
        if (n3 > 1) {
            n4 = n2 + n3 - 1;
            while (n4 >= n2) {
                if (!bitSet.get(n4)) {
                    return false;
                }
                --n4;
            }
        }
        return true;
    }

    protected void notifyPathChange(Vector vector, TreePath treePath) {
        int n = vector.size();
        boolean[] blArray = new boolean[n];
        TreePath[] treePathArray = new TreePath[n];
        int n2 = 0;
        while (n2 < n) {
            PathPlaceHolder pathPlaceHolder = (PathPlaceHolder)vector.elementAt(n2);
            blArray[n2] = pathPlaceHolder.isNew;
            treePathArray[n2] = pathPlaceHolder.path;
            ++n2;
        }
        TreeSelectionEvent treeSelectionEvent = new TreeSelectionEvent((Object)this, treePathArray, blArray, treePath, this.leadPath);
        this.fireValueChanged(treeSelectionEvent);
    }

    protected void updateLeadIndex() {
        if (this.leadPath != null) {
            if (this.selection == null) {
                this.leadPath = null;
                this.leadRow = -1;
                this.leadIndex = -1;
            } else {
                this.leadIndex = -1;
                this.leadRow = -1;
                int n = this.selection.length - 1;
                while (n >= 0) {
                    if (this.selection[n] == this.leadPath) {
                        this.leadIndex = n;
                        break;
                    }
                    --n;
                }
            }
        } else {
            this.leadIndex = -1;
        }
    }

    protected void insureUniqueness() {
    }

    public String toString() {
        int n = this.getSelectionCount();
        StringBuffer stringBuffer = new StringBuffer();
        int[] nArray = this.rowMapper != null ? this.rowMapper.getRowsForPaths(this.selection) : null;
        stringBuffer.append(this.getClass().getName() + " " + this.hashCode() + " [ ");
        int n2 = 0;
        while (n2 < n) {
            if (nArray != null) {
                stringBuffer.append(this.selection[n2].toString() + "@" + Integer.toString(nArray[n2]) + " ");
            } else {
                stringBuffer.append(this.selection[n2].toString() + " ");
            }
            ++n2;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultTreeSelectionModel defaultTreeSelectionModel = (DefaultTreeSelectionModel)super.clone();
        defaultTreeSelectionModel.changeSupport = null;
        if (this.selection != null) {
            int n = this.selection.length;
            defaultTreeSelectionModel.selection = new TreePath[n];
            System.arraycopy(this.selection, 0, defaultTreeSelectionModel.selection, 0, n);
        }
        defaultTreeSelectionModel.listenerList = new EventListenerList();
        defaultTreeSelectionModel.listSelectionModel = (DefaultListSelectionModel)this.listSelectionModel.clone();
        defaultTreeSelectionModel.uniquePaths = new Hashtable();
        defaultTreeSelectionModel.lastPaths = new Hashtable();
        defaultTreeSelectionModel.tempPaths = new TreePath[1];
        return defaultTreeSelectionModel;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Object[] objectArray = this.rowMapper != null && this.rowMapper instanceof Serializable ? new Object[]{"rowMapper", this.rowMapper} : new Object[]{};
        objectOutputStream.writeObject(objectArray);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Object[] objectArray = (Object[])objectInputStream.readObject();
        if (objectArray.length > 0 && objectArray[0].equals("rowMapper")) {
            this.rowMapper = (RowMapper)objectArray[1];
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

