/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.ListModel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxButton;
import javax.swing.plaf.metal.MetalComboBoxEditor;
import javax.swing.plaf.metal.MetalComboBoxIcon;

public class MetalComboBoxUI
extends BasicComboBoxUI {
    private ActionListener editorActionListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalComboBoxUI();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
    }

    protected ComboBoxEditor createEditor() {
        return new MetalComboBoxEditor.UIResource();
    }

    protected ComboPopup createPopup() {
        return new MetalComboPopup(this.comboBox);
    }

    protected KeyListener createKeyListener() {
        return new NoSelectKeyHandler();
    }

    protected void selectNextPossibleValue() {
        int n = this.listBox.getSelectedIndex();
        if (n < this.comboBox.getModel().getSize() - 1) {
            this.listBox.setSelectedIndex(n + 1);
            this.listBox.ensureIndexIsVisible(n + 1);
            this.comboBox.repaint();
        }
    }

    protected void selectPreviousPossibleValue() {
        int n = this.listBox.getSelectedIndex();
        if (n > 0) {
            this.listBox.setSelectedIndex(n - 1);
            this.listBox.ensureIndexIsVisible(n - 1);
            this.comboBox.repaint();
        }
    }

    protected JButton createArrowButton() {
        MetalComboBoxButton metalComboBoxButton = new MetalComboBoxButton(this.comboBox, new MetalComboBoxIcon(), this.comboBox.isEditable(), this.currentValuePane, this.listBox);
        metalComboBoxButton.setMargin(new Insets(0, 1, 1, 3));
        return metalComboBoxButton;
    }

    public PropertyChangeListener createPropertyChangeListener() {
        return new MetalPropertyChangeListener();
    }

    protected void editablePropertyChanged(PropertyChangeEvent propertyChangeEvent) {
    }

    protected LayoutManager createLayoutManager() {
        return new MetalComboBoxLayoutManager();
    }

    public void layoutComboBox(Container container, MetalComboBoxLayoutManager metalComboBoxLayoutManager) {
        if (this.comboBox.isEditable()) {
            metalComboBoxLayoutManager.superLayout(container);
        } else if (this.arrowButton != null) {
            Insets insets = this.comboBox.getInsets();
            int n = this.comboBox.getWidth();
            int n2 = this.comboBox.getHeight();
            this.arrowButton.setBounds(insets.left, insets.top, n - (insets.left + insets.right), n2 - (insets.top + insets.bottom));
        }
    }

    protected void removeListeners() {
        if (this.propertyChangeListener != null) {
            this.comboBox.removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    public void configureEditor() {
        super.configureEditor();
        if (this.editorActionListener == null) {
            this.editorActionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (MetalComboBoxUI.this.isPopupVisible(MetalComboBoxUI.this.comboBox)) {
                        MetalComboBoxUI.this.comboBox.setSelectedIndex(MetalComboBoxUI.this.listBox.getSelectedIndex());
                    }
                }
            };
            this.comboBox.getEditor().addActionListener(this.editorActionListener);
        }
    }

    public void unconfigureEditor() {
        super.unconfigureEditor();
        if (this.editorActionListener != null) {
            this.comboBox.getEditor().removeActionListener(this.editorActionListener);
            this.editorActionListener = null;
        }
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        Dimension dimension = null;
        if (!this.comboBox.isEditable() && this.arrowButton != null && this.arrowButton instanceof MetalComboBoxButton) {
            MetalComboBoxButton metalComboBoxButton = (MetalComboBoxButton)this.arrowButton;
            Insets insets = metalComboBoxButton.getInsets();
            Insets insets2 = this.comboBox.getInsets();
            dimension = this.getDisplaySize();
            dimension.width += insets2.left + insets2.right;
            dimension.width += insets.left + insets.right;
            dimension.width += insets.right + metalComboBoxButton.getComboIcon().getIconWidth();
            dimension.height += insets2.top + insets2.bottom;
            dimension.height += insets.top + insets.bottom;
        } else if (this.comboBox.isEditable() && this.arrowButton != null && this.editor != null) {
            dimension = super.getMinimumSize(jComponent);
            Insets insets = this.arrowButton.getMargin();
            dimension.height += insets.top + insets.bottom;
            dimension.width += insets.left + insets.right;
        } else {
            dimension = super.getMinimumSize(jComponent);
        }
        this.cachedMinimumSize.setSize(dimension.width, dimension.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(this.cachedMinimumSize);
    }

    public class MetalComboPopup
    extends BasicComboPopup {
        public MetalComboPopup(JComboBox jComboBox) {
            super(jComboBox);
        }

        public void delegateFocus(MouseEvent mouseEvent) {
            super.delegateFocus(mouseEvent);
        }
    }

    public class MetalComboBoxLayoutManager
    extends BasicComboBoxUI.ComboBoxLayoutManager {
        public void layoutContainer(Container container) {
            MetalComboBoxUI.this.layoutComboBox(container, this);
        }

        public void superLayout(Container container) {
            super.layoutContainer(container);
        }
    }

    public class MetalPropertyChangeListener
    extends BasicComboBoxUI.PropertyChangeHandler {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            super.propertyChange(propertyChangeEvent);
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("editable")) {
                MetalComboBoxButton metalComboBoxButton = (MetalComboBoxButton)MetalComboBoxUI.this.arrowButton;
                metalComboBoxButton.setIconOnly(MetalComboBoxUI.this.comboBox.isEditable());
                MetalComboBoxUI.this.comboBox.repaint();
            } else if (string.equals("background")) {
                Color color = (Color)propertyChangeEvent.getNewValue();
                MetalComboBoxUI.this.arrowButton.setBackground(color);
                MetalComboBoxUI.this.listBox.setBackground(color);
            } else if (string.equals("foreground")) {
                Color color = (Color)propertyChangeEvent.getNewValue();
                MetalComboBoxUI.this.arrowButton.setForeground(color);
                MetalComboBoxUI.this.listBox.setForeground(color);
            }
        }
    }

    private class NoSelectKeyHandler
    extends KeyAdapter {
        private NoSelectKeyHandler() {
        }

        private int selectionForKey(char c) {
            String string;
            int n;
            int n2;
            int n3 = -1;
            Object object = MetalComboBoxUI.this.listBox.getSelectedValue();
            ListModel listModel = MetalComboBoxUI.this.listBox.getModel();
            if (object != null) {
                n2 = 0;
                n = listModel.getSize();
                while (n2 < n) {
                    if (object == listModel.getElementAt(n2)) {
                        n3 = n2;
                        break;
                    }
                    ++n2;
                }
            }
            String string2 = ("" + c).toLowerCase();
            c = string2.charAt(0);
            n2 = ++n3;
            n = listModel.getSize();
            while (n2 < n) {
                if (listModel.getElementAt(n2) != null && listModel.getElementAt(n2).toString() != null && (string = listModel.getElementAt(n2).toString().toLowerCase()).length() > 0 && string.charAt(0) == c) {
                    return n2;
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < n3) {
                if (listModel.getElementAt(n2) != null && listModel.getElementAt(n2).toString() != null && (string = listModel.getElementAt(n2).toString().toLowerCase()).length() > 0 && string.charAt(0) == c) {
                    return n2;
                }
                ++n2;
            }
            return -1;
        }

        private boolean selectWithKeyCharNoAction(char c) {
            int n = this.selectionForKey(c);
            if (n != -1) {
                MetalComboBoxUI.this.comboBox.setPopupVisible(true);
                MetalComboBoxUI.this.listBox.setSelectedIndex(n);
                MetalComboBoxUI.this.listBox.ensureIndexIsVisible(n);
                return true;
            }
            return false;
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (MetalComboBoxUI.this.comboBox.isEnabled() && !MetalComboBoxUI.this.isNavigationKey(keyEvent.getKeyCode()) && this.isTypeAheadKey(keyEvent)) {
                if (MetalComboBoxUI.this.comboBox.getKeySelectionManager() != null) {
                    if (MetalComboBoxUI.this.comboBox.selectWithKeyChar(keyEvent.getKeyChar())) {
                        keyEvent.consume();
                    }
                } else if (this.selectWithKeyCharNoAction(keyEvent.getKeyChar())) {
                    keyEvent.consume();
                }
            }
        }

        boolean isTypeAheadKey(KeyEvent keyEvent) {
            return !keyEvent.isAltDown() && !keyEvent.isControlDown() && !keyEvent.isMetaDown();
        }
    }
}

