/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Vector;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;
import javax.sound.sampled.spi.AudioFileWriter;
import javax.sound.sampled.spi.FormatConversionProvider;
import javax.sound.sampled.spi.MixerProvider;

public class AudioSystem {
    public static final int NOT_SPECIFIED = -1;
    private static final String defaultServicesClassName = "com.sun.media.sound.DefaultServices";
    private static final String jdk13ServicesClassName = "com.sun.media.sound.JDK13Services";
    private static final String servicesMethodName = "getProviders";
    private static final Class[] servicesParamTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = AudioSystem.class$("java.lang.String")) : class$java$lang$String};
    private static final boolean DEBUG = false;
    static /* synthetic */ Class class$java$lang$String;

    private AudioSystem() {
    }

    public static Mixer.Info[] getMixerInfo() {
        Vector vector = AudioSystem.getMixerProviders();
        Vector<Mixer.Info> vector2 = new Vector<Mixer.Info>();
        int n = vector.size() - 1;
        while (n >= 0) {
            Mixer.Info[] infoArray = ((MixerProvider)vector.elementAt(n)).getMixerInfo();
            int n2 = 0;
            while (n2 < infoArray.length) {
                vector2.addElement(infoArray[n2]);
                ++n2;
            }
            --n;
        }
        Mixer.Info[] infoArray = new Mixer.Info[vector2.size()];
        n = 0;
        while (n < infoArray.length) {
            infoArray[n] = (Mixer.Info)vector2.elementAt(n);
            ++n;
        }
        return infoArray;
    }

    public static Mixer getMixer(Mixer.Info info) {
        Object var1_1 = null;
        Vector vector = AudioSystem.getMixerProviders();
        int n = vector.size() - 1;
        while (n >= 0) {
            try {
                return ((MixerProvider)vector.elementAt(n)).getMixer(info);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            --n;
        }
        if (info == null) {
            int n2 = vector.size() - 1;
            while (n2 >= 0) {
                try {
                    MixerProvider mixerProvider = (MixerProvider)vector.elementAt(n2);
                    Mixer.Info[] infoArray = mixerProvider.getMixerInfo();
                    int n3 = 0;
                    while (n3 < infoArray.length) {
                        try {
                            return mixerProvider.getMixer(infoArray[n3]);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            ++n3;
                        }
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                --n2;
            }
        }
        throw new IllegalArgumentException("Mixer not supported: " + (info != null ? info.toString() : "null"));
    }

    public static Line.Info[] getSourceLineInfo(Line.Info info) {
        Vector<Line.Info> vector = new Vector<Line.Info>();
        Object var4_2 = null;
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        int n = 0;
        while (n < infoArray.length) {
            Mixer mixer = AudioSystem.getMixer(infoArray[n]);
            Line.Info[] infoArray2 = mixer.getSourceLineInfo(info);
            int n2 = 0;
            while (n2 < infoArray2.length) {
                vector.addElement(infoArray2[n2]);
                ++n2;
            }
            ++n;
        }
        Line.Info[] infoArray3 = new Line.Info[vector.size()];
        int n3 = 0;
        while (n3 < infoArray3.length) {
            infoArray3[n3] = (Line.Info)vector.elementAt(n3);
            ++n3;
        }
        return infoArray3;
    }

    public static Line.Info[] getTargetLineInfo(Line.Info info) {
        Vector<Line.Info> vector = new Vector<Line.Info>();
        Object var4_2 = null;
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        int n = 0;
        while (n < infoArray.length) {
            Mixer mixer = AudioSystem.getMixer(infoArray[n]);
            Line.Info[] infoArray2 = mixer.getTargetLineInfo(info);
            int n2 = 0;
            while (n2 < infoArray2.length) {
                vector.addElement(infoArray2[n2]);
                ++n2;
            }
            ++n;
        }
        Line.Info[] infoArray3 = new Line.Info[vector.size()];
        int n3 = 0;
        while (n3 < infoArray3.length) {
            infoArray3[n3] = (Line.Info)vector.elementAt(n3);
            ++n3;
        }
        return infoArray3;
    }

    public static boolean isLineSupported(Line.Info info) {
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        int n = 0;
        while (n < infoArray.length) {
            Mixer mixer;
            if (infoArray[n] != null && (mixer = AudioSystem.getMixer(infoArray[n])).isLineSupported(info)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static Line getLine(Line.Info info) throws LineUnavailableException {
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        LineUnavailableException lineUnavailableException = null;
        int n = 0;
        while (n < infoArray.length) {
            Mixer mixer = AudioSystem.getMixer(infoArray[n]);
            if (mixer.isLineSupported(info)) {
                try {
                    return mixer.getLine(info);
                }
                catch (LineUnavailableException lineUnavailableException2) {
                    lineUnavailableException = lineUnavailableException2;
                }
            }
            ++n;
        }
        if (lineUnavailableException != null) {
            throw lineUnavailableException;
        }
        throw new IllegalArgumentException("No line matching " + info.toString() + " is supported.");
    }

    public static AudioFormat.Encoding[] getTargetEncodings(AudioFormat.Encoding encoding) {
        FormatConversionProvider[] formatConversionProviderArray = AudioSystem.getFormatConversionProviders();
        Vector<AudioFormat.Encoding[]> vector = new Vector<AudioFormat.Encoding[]>();
        int n = 0;
        int n2 = 0;
        AudioFormat.Encoding[] encodingArray = null;
        int n3 = 0;
        while (n3 < formatConversionProviderArray.length) {
            if (formatConversionProviderArray[n3].isSourceEncodingSupported(encoding)) {
                encodingArray = formatConversionProviderArray[n3].getTargetEncodings();
                n += encodingArray.length;
                vector.addElement(encodingArray);
            }
            ++n3;
        }
        AudioFormat.Encoding[] encodingArray2 = new AudioFormat.Encoding[n];
        int n4 = 0;
        while (n4 < vector.size()) {
            encodingArray = (AudioFormat.Encoding[])vector.elementAt(n4);
            int n5 = 0;
            while (n5 < encodingArray.length) {
                encodingArray2[n2++] = encodingArray[n5];
                ++n5;
            }
            ++n4;
        }
        return encodingArray2;
    }

    public static AudioFormat.Encoding[] getTargetEncodings(AudioFormat audioFormat) {
        FormatConversionProvider[] formatConversionProviderArray = AudioSystem.getFormatConversionProviders();
        Vector<AudioFormat.Encoding[]> vector = new Vector<AudioFormat.Encoding[]>();
        int n = 0;
        int n2 = 0;
        AudioFormat.Encoding[] encodingArray = null;
        int n3 = 0;
        while (n3 < formatConversionProviderArray.length) {
            encodingArray = formatConversionProviderArray[n3].getTargetEncodings(audioFormat);
            n += encodingArray.length;
            vector.addElement(encodingArray);
            ++n3;
        }
        AudioFormat.Encoding[] encodingArray2 = new AudioFormat.Encoding[n];
        int n4 = 0;
        while (n4 < vector.size()) {
            encodingArray = (AudioFormat.Encoding[])vector.elementAt(n4);
            int n5 = 0;
            while (n5 < encodingArray.length) {
                encodingArray2[n2++] = encodingArray[n5];
                ++n5;
            }
            ++n4;
        }
        return encodingArray2;
    }

    public static boolean isConversionSupported(AudioFormat.Encoding encoding, AudioFormat audioFormat) {
        FormatConversionProvider[] formatConversionProviderArray = AudioSystem.getFormatConversionProviders();
        int n = 0;
        while (n < formatConversionProviderArray.length) {
            if (formatConversionProviderArray[n].isConversionSupported(encoding, audioFormat)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static AudioInputStream getAudioInputStream(AudioFormat.Encoding encoding, AudioInputStream audioInputStream) {
        FormatConversionProvider[] formatConversionProviderArray = AudioSystem.getFormatConversionProviders();
        int n = formatConversionProviderArray.length - 1;
        while (n >= 0) {
            if (formatConversionProviderArray[n].isConversionSupported(encoding, audioInputStream.getFormat())) {
                return formatConversionProviderArray[n].getAudioInputStream(encoding, audioInputStream);
            }
            --n;
        }
        throw new IllegalArgumentException("Unsupported conversion: " + encoding + " from " + audioInputStream.getFormat());
    }

    public static AudioFormat[] getTargetFormats(AudioFormat.Encoding encoding, AudioFormat audioFormat) {
        FormatConversionProvider[] formatConversionProviderArray = AudioSystem.getFormatConversionProviders();
        Vector<AudioFormat[]> vector = new Vector<AudioFormat[]>();
        int n = 0;
        int n2 = 0;
        AudioFormat[] audioFormatArray = null;
        int n3 = 0;
        while (n3 < formatConversionProviderArray.length) {
            audioFormatArray = formatConversionProviderArray[n3].getTargetFormats(encoding, audioFormat);
            n += audioFormatArray.length;
            vector.addElement(audioFormatArray);
            ++n3;
        }
        AudioFormat[] audioFormatArray2 = new AudioFormat[n];
        int n4 = 0;
        while (n4 < vector.size()) {
            audioFormatArray = (AudioFormat[])vector.elementAt(n4);
            int n5 = 0;
            while (n5 < audioFormatArray.length) {
                audioFormatArray2[n2++] = audioFormatArray[n5];
                ++n5;
            }
            ++n4;
        }
        return audioFormatArray2;
    }

    public static boolean isConversionSupported(AudioFormat audioFormat, AudioFormat audioFormat2) {
        FormatConversionProvider[] formatConversionProviderArray = AudioSystem.getFormatConversionProviders();
        int n = 0;
        while (n < formatConversionProviderArray.length) {
            if (formatConversionProviderArray[n].isConversionSupported(audioFormat, audioFormat2)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static AudioInputStream getAudioInputStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
        if (audioInputStream.getFormat().matches(audioFormat)) {
            return audioInputStream;
        }
        FormatConversionProvider[] formatConversionProviderArray = AudioSystem.getFormatConversionProviders();
        int n = formatConversionProviderArray.length - 1;
        while (n >= 0) {
            if (formatConversionProviderArray[n].isConversionSupported(audioFormat, audioInputStream.getFormat())) {
                return formatConversionProviderArray[n].getAudioInputStream(audioFormat, audioInputStream);
            }
            --n;
        }
        throw new IllegalArgumentException("Unsupported conversion: " + audioFormat + " from " + audioInputStream.getFormat());
    }

    public static AudioFileFormat getAudioFileFormat(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        AudioFileReader[] audioFileReaderArray = AudioSystem.getAudioFileReaders();
        AudioFileFormat audioFileFormat = null;
        int n = audioFileReaderArray.length - 1;
        while (n >= 0) {
            try {
                audioFileFormat = audioFileReaderArray[n].getAudioFileFormat(inputStream);
                break;
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                --n;
            }
        }
        if (audioFileFormat == null) {
            throw new UnsupportedAudioFileException("file is not a supported file type");
        }
        return audioFileFormat;
    }

    public static AudioFileFormat getAudioFileFormat(URL uRL) throws UnsupportedAudioFileException, IOException {
        AudioFileReader[] audioFileReaderArray = AudioSystem.getAudioFileReaders();
        AudioFileFormat audioFileFormat = null;
        int n = audioFileReaderArray.length - 1;
        while (n >= 0) {
            try {
                audioFileFormat = audioFileReaderArray[n].getAudioFileFormat(uRL);
                break;
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                --n;
            }
        }
        if (audioFileFormat == null) {
            throw new UnsupportedAudioFileException("file is not a supported file type");
        }
        return audioFileFormat;
    }

    public static AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        AudioFileReader[] audioFileReaderArray = AudioSystem.getAudioFileReaders();
        AudioFileFormat audioFileFormat = null;
        int n = audioFileReaderArray.length - 1;
        while (n >= 0) {
            try {
                audioFileFormat = audioFileReaderArray[n].getAudioFileFormat(file);
                break;
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                --n;
            }
        }
        if (audioFileFormat == null) {
            throw new UnsupportedAudioFileException("file is not a supported file type");
        }
        return audioFileFormat;
    }

    public static AudioInputStream getAudioInputStream(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        AudioFileReader[] audioFileReaderArray = AudioSystem.getAudioFileReaders();
        AudioInputStream audioInputStream = null;
        int n = audioFileReaderArray.length - 1;
        while (n >= 0) {
            try {
                audioInputStream = audioFileReaderArray[n].getAudioInputStream(inputStream);
                break;
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                --n;
            }
        }
        if (audioInputStream == null) {
            throw new UnsupportedAudioFileException("could not get audio input stream from input stream");
        }
        return audioInputStream;
    }

    public static AudioInputStream getAudioInputStream(URL uRL) throws UnsupportedAudioFileException, IOException {
        AudioFileReader[] audioFileReaderArray = AudioSystem.getAudioFileReaders();
        AudioInputStream audioInputStream = null;
        int n = audioFileReaderArray.length - 1;
        while (n >= 0) {
            try {
                audioInputStream = audioFileReaderArray[n].getAudioInputStream(uRL);
                break;
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                --n;
            }
        }
        if (audioInputStream == null) {
            throw new UnsupportedAudioFileException("could not get audio input stream from input URL");
        }
        return audioInputStream;
    }

    public static AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        AudioFileReader[] audioFileReaderArray = AudioSystem.getAudioFileReaders();
        AudioInputStream audioInputStream = null;
        int n = audioFileReaderArray.length - 1;
        while (n >= 0) {
            try {
                audioInputStream = audioFileReaderArray[n].getAudioInputStream(file);
                break;
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                --n;
            }
        }
        if (audioInputStream == null) {
            throw new UnsupportedAudioFileException("could not get audio input stream from input file");
        }
        return audioInputStream;
    }

    public static AudioFileFormat.Type[] getAudioFileTypes() {
        AudioFileWriter[] audioFileWriterArray = AudioSystem.getAudioFileWriters();
        AudioFileFormat.Type[][] typeArrayArray = new AudioFileFormat.Type[audioFileWriterArray.length][];
        AudioFileFormat.Type[] typeArray = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < audioFileWriterArray.length) {
            typeArrayArray[n3] = audioFileWriterArray[n3].getAudioFileTypes();
            n += typeArrayArray[n3].length;
            ++n3;
        }
        typeArray = new AudioFileFormat.Type[n];
        int n4 = 0;
        while (n4 < audioFileWriterArray.length) {
            int n5 = 0;
            while (n5 < typeArrayArray[n4].length) {
                typeArray[n2] = typeArrayArray[n4][n5];
                ++n2;
                ++n5;
            }
            ++n4;
        }
        return typeArray;
    }

    public static boolean isFileTypeSupported(AudioFileFormat.Type type) {
        AudioFileWriter[] audioFileWriterArray = AudioSystem.getAudioFileWriters();
        boolean bl = false;
        int n = 0;
        while (n < audioFileWriterArray.length) {
            bl = audioFileWriterArray[n].isFileTypeSupported(type);
            if (bl) {
                return bl;
            }
            ++n;
        }
        return bl;
    }

    public static AudioFileFormat.Type[] getAudioFileTypes(AudioInputStream audioInputStream) {
        AudioFileWriter[] audioFileWriterArray = AudioSystem.getAudioFileWriters();
        AudioFileFormat.Type[][] typeArrayArray = new AudioFileFormat.Type[audioFileWriterArray.length][];
        AudioFileFormat.Type[] typeArray = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < audioFileWriterArray.length) {
            typeArrayArray[n3] = audioFileWriterArray[n3].getAudioFileTypes(audioInputStream);
            n += typeArrayArray[n3].length;
            ++n3;
        }
        typeArray = new AudioFileFormat.Type[n];
        int n4 = 0;
        while (n4 < audioFileWriterArray.length) {
            int n5 = 0;
            while (n5 < typeArrayArray[n4].length) {
                typeArray[n2] = typeArrayArray[n4][n5];
                ++n2;
                ++n5;
            }
            ++n4;
        }
        return typeArray;
    }

    public static boolean isFileTypeSupported(AudioFileFormat.Type type, AudioInputStream audioInputStream) {
        AudioFileWriter[] audioFileWriterArray = AudioSystem.getAudioFileWriters();
        boolean bl = false;
        int n = 0;
        while (n < audioFileWriterArray.length) {
            bl = audioFileWriterArray[n].isFileTypeSupported(type, audioInputStream);
            if (bl) {
                return bl;
            }
            ++n;
        }
        return bl;
    }

    public static int write(AudioInputStream audioInputStream, AudioFileFormat.Type type, OutputStream outputStream) throws IOException {
        AudioFileWriter[] audioFileWriterArray = AudioSystem.getAudioFileWriters();
        int n = 0;
        boolean bl = false;
        int n2 = audioFileWriterArray.length - 1;
        while (n2 >= 0) {
            try {
                n = audioFileWriterArray[n2].write(audioInputStream, type, outputStream);
                bl = true;
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                --n2;
            }
        }
        if (!bl) {
            throw new IllegalArgumentException("could not write audio file: file type not supported: " + type);
        }
        return n;
    }

    public static int write(AudioInputStream audioInputStream, AudioFileFormat.Type type, File file) throws IOException {
        AudioFileWriter[] audioFileWriterArray = AudioSystem.getAudioFileWriters();
        int n = 0;
        boolean bl = false;
        int n2 = audioFileWriterArray.length - 1;
        while (n2 >= 0) {
            try {
                n = audioFileWriterArray[n2].write(audioInputStream, type, file);
                bl = true;
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                --n2;
            }
        }
        if (!bl) {
            throw new IllegalArgumentException("could not write audio file: file type not supported: " + type);
        }
        return n;
    }

    private static Vector getMixerProviders() {
        Vector vector = null;
        try {
            Class.forName("sun.misc.Service");
            vector = AudioSystem.getJDK13Services("javax.sound.sampled.spi.MixerProvider");
        }
        catch (Exception exception) {
            vector = AudioSystem.getDefaultServices("javax.sound.sampled.spi.MixerProvider");
        }
        return vector;
    }

    private static FormatConversionProvider[] getFormatConversionProviders() {
        Vector vector = new Vector();
        try {
            Class.forName("sun.misc.Service");
            vector = AudioSystem.getJDK13Services("javax.sound.sampled.spi.FormatConversionProvider");
        }
        catch (Exception exception) {
            vector = AudioSystem.getDefaultServices("javax.sound.sampled.spi.FormatConversionProvider");
        }
        FormatConversionProvider[] formatConversionProviderArray = new FormatConversionProvider[vector.size()];
        int n = 0;
        while (n < formatConversionProviderArray.length) {
            formatConversionProviderArray[n] = (FormatConversionProvider)vector.elementAt(n);
            ++n;
        }
        return formatConversionProviderArray;
    }

    private static AudioFileReader[] getAudioFileReaders() {
        Vector vector = new Vector();
        try {
            Class.forName("sun.misc.Service");
            vector = AudioSystem.getJDK13Services("javax.sound.sampled.spi.AudioFileReader");
        }
        catch (Exception exception) {
            vector = AudioSystem.getDefaultServices("javax.sound.sampled.spi.AudioFileReader");
        }
        AudioFileReader[] audioFileReaderArray = new AudioFileReader[vector.size()];
        int n = 0;
        while (n < audioFileReaderArray.length) {
            audioFileReaderArray[n] = (AudioFileReader)vector.elementAt(n);
            ++n;
        }
        return audioFileReaderArray;
    }

    private static AudioFileWriter[] getAudioFileWriters() {
        Vector vector = new Vector();
        try {
            Class.forName("sun.misc.Service");
            vector = AudioSystem.getJDK13Services("javax.sound.sampled.spi.AudioFileWriter");
        }
        catch (Exception exception) {
            vector = AudioSystem.getDefaultServices("javax.sound.sampled.spi.AudioFileWriter");
        }
        AudioFileWriter[] audioFileWriterArray = new AudioFileWriter[vector.size()];
        int n = 0;
        while (n < audioFileWriterArray.length) {
            audioFileWriterArray[n] = (AudioFileWriter)vector.elementAt(n);
            ++n;
        }
        return audioFileWriterArray;
    }

    private static Vector getJDK13Services(String string) {
        Vector vector = null;
        try {
            Class<?> clazz = Class.forName(jdk13ServicesClassName);
            Method method = clazz.getMethod(servicesMethodName, servicesParamTypes);
            Object[] objectArray = new Object[]{string};
            vector = (Vector)method.invoke(clazz, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            vector = new Vector();
        }
        catch (ClassNotFoundException classNotFoundException) {
            vector = new Vector();
        }
        catch (IllegalAccessException illegalAccessException) {
            vector = new Vector();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            vector = new Vector();
        }
        return vector;
    }

    private static Vector getDefaultServices(String string) {
        Vector vector = null;
        try {
            Class<?> clazz = Class.forName(defaultServicesClassName);
            Method method = clazz.getMethod(servicesMethodName, servicesParamTypes);
            Object[] objectArray = new Object[]{string};
            vector = (Vector)method.invoke(clazz, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            vector = new Vector();
        }
        catch (ClassNotFoundException classNotFoundException) {
            vector = new Vector();
        }
        catch (IllegalAccessException illegalAccessException) {
            vector = new Vector();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            vector = new Vector();
        }
        return vector;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

