/*
 * Decompiled with CFR 0.152.
 */
package javax.print.attribute.standard;

import javax.print.attribute.DocAttribute;
import javax.print.attribute.PrintJobAttribute;
import javax.print.attribute.PrintRequestAttribute;

public final class MediaPrintableArea
implements DocAttribute,
PrintRequestAttribute,
PrintJobAttribute {
    private int x;
    private int y;
    private int w;
    private int h;
    private int units;
    public static final int INCH = 25400;
    public static final int MM = 1000;
    static /* synthetic */ Class class$javax$print$attribute$standard$MediaPrintableArea;

    public MediaPrintableArea(float f, float f2, float f3, float f4, int n) {
        if ((double)f < 0.0 || (double)f2 < 0.0 || (double)f3 <= 0.0 || (double)f4 <= 0.0 || n < 1) {
            throw new IllegalArgumentException("0 or negative value argument");
        }
        this.x = (int)(f * (float)n + 0.5f);
        this.y = (int)(f2 * (float)n + 0.5f);
        this.w = (int)(f3 * (float)n + 0.5f);
        this.h = (int)(f4 * (float)n + 0.5f);
    }

    public MediaPrintableArea(int n, int n2, int n3, int n4, int n5) {
        if (n < 0 || n2 < 0 || n3 <= 0 || n4 <= 0 || n5 < 1) {
            throw new IllegalArgumentException("0 or negative value argument");
        }
        this.x = n * n5;
        this.y = n2 * n5;
        this.w = n3 * n5;
        this.h = n4 * n5;
    }

    public float[] getPrintableArea(int n) {
        return new float[]{this.getX(n), this.getY(n), this.getWidth(n), this.getHeight(n)};
    }

    public float getX(int n) {
        return MediaPrintableArea.convertFromMicrometers(this.x, n);
    }

    public float getY(int n) {
        return MediaPrintableArea.convertFromMicrometers(this.y, n);
    }

    public float getWidth(int n) {
        return MediaPrintableArea.convertFromMicrometers(this.w, n);
    }

    public float getHeight(int n) {
        return MediaPrintableArea.convertFromMicrometers(this.h, n);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof MediaPrintableArea) {
            MediaPrintableArea mediaPrintableArea = (MediaPrintableArea)object;
            if (this.x == mediaPrintableArea.x && this.y == mediaPrintableArea.y && this.w == mediaPrintableArea.w && this.h == mediaPrintableArea.h) {
                bl = true;
            }
        }
        return bl;
    }

    public final Class getCategory() {
        return class$javax$print$attribute$standard$MediaPrintableArea == null ? (class$javax$print$attribute$standard$MediaPrintableArea = MediaPrintableArea.class$("javax.print.attribute.standard.MediaPrintableArea")) : class$javax$print$attribute$standard$MediaPrintableArea;
    }

    public final String getName() {
        return "media-printable-area";
    }

    public String toString(int n, String string) {
        if (string == null) {
            string = "";
        }
        float[] fArray = this.getPrintableArea(n);
        String string2 = "(" + fArray[0] + "," + fArray[1] + ")->(" + fArray[2] + "," + fArray[3] + ")";
        return string2 + string;
    }

    public String toString() {
        return this.toString(1000, "mm");
    }

    public int hashCode() {
        return this.x + 37 * this.y + 43 * this.w + 47 * this.h;
    }

    private static float convertFromMicrometers(int n, int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("units is < 1");
        }
        return (float)n / (float)n2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

