/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;

public abstract class PackedColorModel
extends ColorModel {
    int[] maskArray;
    int[] maskOffsets;
    float[] scaleFactors;

    public PackedColorModel(ColorSpace colorSpace, int n, int[] nArray, int n2, boolean bl, int n3, int n4) {
        super(n, PackedColorModel.createBitsArray(nArray, n2), colorSpace, n2 != 0, bl, n3, n4);
        if (n < 1 || n > 32) {
            throw new IllegalArgumentException("Number of bits must be between 1 and 32.");
        }
        this.maskArray = new int[this.numComponents];
        this.maskOffsets = new int[this.numComponents];
        this.scaleFactors = new float[this.numComponents];
        int n5 = 0;
        while (n5 < this.numColorComponents) {
            this.DecomposeMask(nArray[n5], n5, colorSpace.getName(n5));
            ++n5;
        }
        if (n2 != 0) {
            this.DecomposeMask(n2, this.numColorComponents, "alpha");
            if (this.nBits[this.numComponents - 1] == 1) {
                this.transparency = 2;
            }
        }
    }

    public PackedColorModel(ColorSpace colorSpace, int n, int n2, int n3, int n4, int n5, boolean bl, int n6, int n7) {
        super(n, PackedColorModel.createBitsArray(n2, n3, n4, n5), colorSpace, n5 != 0, bl, n6, n7);
        if (colorSpace.getType() != 5) {
            throw new IllegalArgumentException("ColorSpace must be TYPE_RGB.");
        }
        this.maskArray = new int[this.numComponents];
        this.maskOffsets = new int[this.numComponents];
        this.scaleFactors = new float[this.numComponents];
        this.DecomposeMask(n2, 0, "red");
        this.DecomposeMask(n3, 1, "green");
        this.DecomposeMask(n4, 2, "blue");
        if (n5 != 0) {
            this.DecomposeMask(n5, 3, "alpha");
            if (this.nBits[3] == 1) {
                this.transparency = 2;
            }
        }
    }

    public final int getMask(int n) {
        return this.maskArray[n];
    }

    public final int[] getMasks() {
        return (int[])this.maskArray.clone();
    }

    private void DecomposeMask(int n, int n2, String string) {
        int n3 = 0;
        int n4 = this.nBits[n2];
        this.maskArray[n2] = n;
        if (n != 0) {
            while ((n & 1) == 0) {
                n >>>= 1;
                ++n3;
            }
        }
        if (n3 + n4 > this.pixel_bits) {
            throw new IllegalArgumentException(string + " mask " + Integer.toHexString(this.maskArray[n2]) + " overflows pixel (expecting " + this.pixel_bits + " bits");
        }
        this.maskOffsets[n2] = n3;
        this.scaleFactors[n2] = n4 == 0 ? 256.0f : 255.0f / (float)((1 << n4) - 1);
    }

    public SampleModel createCompatibleSampleModel(int n, int n2) {
        return new SinglePixelPackedSampleModel(this.transferType, n, n2, this.maskArray);
    }

    public boolean isCompatibleSampleModel(SampleModel sampleModel) {
        if (!(sampleModel instanceof SinglePixelPackedSampleModel)) {
            return false;
        }
        if (this.numComponents != sampleModel.getNumBands()) {
            return false;
        }
        if (sampleModel.getTransferType() != this.transferType) {
            return false;
        }
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
        int[] nArray = singlePixelPackedSampleModel.getBitMasks();
        if (nArray.length != this.maskArray.length) {
            return false;
        }
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] != this.maskArray[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public WritableRaster getAlphaRaster(WritableRaster writableRaster) {
        if (!this.hasAlpha()) {
            return null;
        }
        int n = writableRaster.getMinX();
        int n2 = writableRaster.getMinY();
        int[] nArray = new int[]{writableRaster.getNumBands() - 1};
        return writableRaster.createWritableChild(n, n2, writableRaster.getWidth(), writableRaster.getHeight(), n, n2, nArray);
    }

    public boolean equals(Object object) {
        if (!(object instanceof PackedColorModel)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        PackedColorModel packedColorModel = (PackedColorModel)object;
        int n = packedColorModel.getNumComponents();
        if (n != this.numComponents) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (this.maskArray[n2] != packedColorModel.getMask(n2)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static final int[] createBitsArray(int[] nArray, int n) {
        int n2 = nArray.length;
        int n3 = n == 0 ? 0 : 1;
        int[] nArray2 = new int[n2 + n3];
        int n4 = 0;
        while (n4 < n2) {
            nArray2[n4] = PackedColorModel.countBits(nArray[n4]);
            if (nArray2[n4] < 0) {
                throw new IllegalArgumentException("Noncontiguous color mask (" + Integer.toHexString(nArray[n4]) + "at index " + n4);
            }
            ++n4;
        }
        if (n != 0) {
            nArray2[n2] = PackedColorModel.countBits(n);
            if (nArray2[n2] < 0) {
                throw new IllegalArgumentException("Noncontiguous alpha mask (" + Integer.toHexString(n));
            }
        }
        return nArray2;
    }

    private static final int[] createBitsArray(int n, int n2, int n3, int n4) {
        int[] nArray = new int[3 + (n4 == 0 ? 0 : 1)];
        nArray[0] = PackedColorModel.countBits(n);
        nArray[1] = PackedColorModel.countBits(n2);
        nArray[2] = PackedColorModel.countBits(n3);
        if (nArray[0] < 0) {
            throw new IllegalArgumentException("Noncontiguous red mask (" + Integer.toHexString(n));
        }
        if (nArray[1] < 0) {
            throw new IllegalArgumentException("Noncontiguous green mask (" + Integer.toHexString(n2));
        }
        if (nArray[2] < 0) {
            throw new IllegalArgumentException("Noncontiguous blue mask (" + Integer.toHexString(n3));
        }
        if (n4 != 0) {
            nArray[3] = PackedColorModel.countBits(n4);
            if (nArray[3] < 0) {
                throw new IllegalArgumentException("Noncontiguous alpha mask (" + Integer.toHexString(n4));
            }
        }
        return nArray;
    }

    private static final int countBits(int n) {
        int n2 = 0;
        if (n != 0) {
            while ((n & 1) == 0) {
                n >>>= 1;
            }
            while ((n & 1) == 1) {
                n >>>= 1;
                ++n2;
            }
        }
        if (n != 0) {
            return -1;
        }
        return n2;
    }
}

