/*
 * Decompiled with CFR 0.152.
 */
package java.awt.color;

import java.awt.color.CMMException;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_Profile;
import sun.awt.color.ICC_Transform;

public class ICC_ColorSpace
extends ColorSpace {
    static final long serialVersionUID = 3455889114070431483L;
    private ICC_Profile thisProfile;
    private float[] minVal;
    private float[] maxVal;
    private float[] diffMinMax;
    private float[] invDiffMinMax;
    private boolean needScaleInit = true;
    private transient ICC_Transform this2srgb;
    private transient ICC_Transform srgb2this;
    private transient ICC_Transform this2xyz;
    private transient ICC_Transform xyz2this;

    public ICC_ColorSpace(ICC_Profile iCC_Profile) {
        super(iCC_Profile.getColorSpaceType(), iCC_Profile.getNumComponents());
        int n = iCC_Profile.getProfileClass();
        if (n != 0 && n != 1 && n != 2 && n != 4 && n != 6) {
            throw new IllegalArgumentException("Invalid profile type");
        }
        this.thisProfile = iCC_Profile;
        this.setMinMax();
    }

    public ICC_Profile getProfile() {
        return this.thisProfile;
    }

    public float[] toRGB(float[] fArray) {
        Object object;
        if (this.this2srgb == null) {
            ICC_Transform[] iCC_TransformArray = new ICC_Transform[2];
            object = (ICC_ColorSpace)ColorSpace.getInstance(1000);
            iCC_TransformArray[0] = new ICC_Transform(this.thisProfile, -1, 1);
            iCC_TransformArray[1] = new ICC_Transform(((ICC_ColorSpace)object).getProfile(), -1, 2);
            this.this2srgb = new ICC_Transform(iCC_TransformArray);
            if (this.needScaleInit) {
                this.setComponentScaling();
            }
        }
        int n = this.getNumComponents();
        object = new short[n];
        int n2 = 0;
        while (n2 < n) {
            object[n2] = (short)((fArray[n2] - this.minVal[n2]) * this.invDiffMinMax[n2] + 0.5f);
            ++n2;
        }
        object = this.this2srgb.colorConvert((short[])object, null);
        float[] fArray2 = new float[3];
        int n3 = 0;
        while (n3 < 3) {
            fArray2[n3] = (float)(object[n3] & 0xFFFF) / 65535.0f;
            ++n3;
        }
        return fArray2;
    }

    public float[] fromRGB(float[] fArray) {
        ICC_Transform[] iCC_TransformArray;
        if (this.srgb2this == null) {
            iCC_TransformArray = new ICC_Transform[2];
            ICC_ColorSpace iCC_ColorSpace = (ICC_ColorSpace)ColorSpace.getInstance(1000);
            iCC_TransformArray[0] = new ICC_Transform(iCC_ColorSpace.getProfile(), -1, 1);
            iCC_TransformArray[1] = new ICC_Transform(this.thisProfile, -1, 2);
            this.srgb2this = new ICC_Transform(iCC_TransformArray);
            if (this.needScaleInit) {
                this.setComponentScaling();
            }
        }
        iCC_TransformArray = (ICC_Transform[])new short[3];
        int n = 0;
        while (n < 3) {
            iCC_TransformArray[n] = (ICC_Transform)((short)(fArray[n] * 65535.0f + 0.5f));
            ++n;
        }
        iCC_TransformArray = (ICC_Transform[])this.srgb2this.colorConvert((short[])iCC_TransformArray, null);
        int n2 = this.getNumComponents();
        float[] fArray2 = new float[n2];
        int n3 = 0;
        while (n3 < n2) {
            fArray2[n3] = (float)(iCC_TransformArray[n3] & 0xFFFF) / 65535.0f * this.diffMinMax[n3] + this.minVal[n3];
            ++n3;
        }
        return fArray2;
    }

    public float[] toCIEXYZ(float[] fArray) {
        Object object;
        if (this.this2xyz == null) {
            ICC_Transform[] iCC_TransformArray = new ICC_Transform[2];
            object = (ICC_ColorSpace)ColorSpace.getInstance(1001);
            try {
                iCC_TransformArray[0] = new ICC_Transform(this.thisProfile, 1, 1);
            }
            catch (CMMException cMMException) {
                iCC_TransformArray[0] = new ICC_Transform(this.thisProfile, -1, 1);
            }
            iCC_TransformArray[1] = new ICC_Transform(((ICC_ColorSpace)object).getProfile(), -1, 2);
            this.this2xyz = new ICC_Transform(iCC_TransformArray);
            if (this.needScaleInit) {
                this.setComponentScaling();
            }
        }
        int n = this.getNumComponents();
        object = new short[n];
        int n2 = 0;
        while (n2 < n) {
            object[n2] = (short)((fArray[n2] - this.minVal[n2]) * this.invDiffMinMax[n2] + 0.5f);
            ++n2;
        }
        object = this.this2xyz.colorConvert((short[])object, null);
        float f = 1.9999695f;
        float[] fArray2 = new float[3];
        int n3 = 0;
        while (n3 < 3) {
            fArray2[n3] = (float)(object[n3] & 0xFFFF) / 65535.0f * f;
            ++n3;
        }
        return fArray2;
    }

    public float[] fromCIEXYZ(float[] fArray) {
        ICC_Transform[] iCC_TransformArray;
        if (this.xyz2this == null) {
            iCC_TransformArray = new ICC_Transform[2];
            ICC_ColorSpace iCC_ColorSpace = (ICC_ColorSpace)ColorSpace.getInstance(1001);
            iCC_TransformArray[0] = new ICC_Transform(iCC_ColorSpace.getProfile(), -1, 1);
            try {
                iCC_TransformArray[1] = new ICC_Transform(this.thisProfile, 1, 2);
            }
            catch (CMMException cMMException) {
                iCC_TransformArray[1] = new ICC_Transform(this.thisProfile, -1, 2);
            }
            this.xyz2this = new ICC_Transform(iCC_TransformArray);
            if (this.needScaleInit) {
                this.setComponentScaling();
            }
        }
        iCC_TransformArray = (ICC_Transform[])new short[3];
        float f = 1.9999695f;
        float f2 = 65535.0f / f;
        int n = 0;
        while (n < 3) {
            iCC_TransformArray[n] = (ICC_Transform)((short)(fArray[n] * f2 + 0.5f));
            ++n;
        }
        iCC_TransformArray = (ICC_Transform[])this.xyz2this.colorConvert((short[])iCC_TransformArray, null);
        int n2 = this.getNumComponents();
        float[] fArray2 = new float[n2];
        int n3 = 0;
        while (n3 < n2) {
            fArray2[n3] = (float)(iCC_TransformArray[n3] & 0xFFFF) / 65535.0f * this.diffMinMax[n3] + this.minVal[n3];
            ++n3;
        }
        return fArray2;
    }

    public float getMinValue(int n) {
        if (n < 0 || n > this.getNumComponents() - 1) {
            throw new IllegalArgumentException("Component index out of range: + component");
        }
        return this.minVal[n];
    }

    public float getMaxValue(int n) {
        if (n < 0 || n > this.getNumComponents() - 1) {
            throw new IllegalArgumentException("Component index out of range: + component");
        }
        return this.maxVal[n];
    }

    private void setMinMax() {
        int n = this.getNumComponents();
        int n2 = this.getType();
        this.minVal = new float[n];
        this.maxVal = new float[n];
        if (n2 == 1) {
            this.minVal[0] = 0.0f;
            this.maxVal[0] = 100.0f;
            this.minVal[1] = -128.0f;
            this.maxVal[1] = 127.0f;
            this.minVal[2] = -128.0f;
            this.maxVal[2] = 127.0f;
        } else if (n2 == 0) {
            this.minVal[2] = 0.0f;
            this.minVal[1] = 0.0f;
            this.minVal[0] = 0.0f;
            this.maxVal[2] = 1.9999695f;
            this.maxVal[1] = 1.9999695f;
            this.maxVal[0] = 1.9999695f;
        } else {
            int n3 = 0;
            while (n3 < n) {
                this.minVal[n3] = 0.0f;
                this.maxVal[n3] = 1.0f;
                ++n3;
            }
        }
    }

    private void setComponentScaling() {
        int n = this.getNumComponents();
        this.diffMinMax = new float[n];
        this.invDiffMinMax = new float[n];
        int n2 = 0;
        while (n2 < n) {
            this.minVal[n2] = this.getMinValue(n2);
            this.maxVal[n2] = this.getMaxValue(n2);
            this.diffMinMax[n2] = this.maxVal[n2] - this.minVal[n2];
            this.invDiffMinMax[n2] = 65535.0f / this.diffMinMax[n2];
            ++n2;
        }
        this.needScaleInit = false;
    }
}

