/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractLine;
import com.sun.media.sound.AbstractMixer;
import com.sun.media.sound.Platform;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineUnavailableException;

abstract class AbstractDataLine
extends AbstractLine
implements DataLine {
    protected AudioFormat defaultFormat;
    protected int defaultBufferSize;
    protected AudioFormat format;
    protected int bufferSize;
    protected boolean running = false;
    private boolean started = false;
    private boolean active = false;

    protected AbstractDataLine(DataLine.Info info, AbstractMixer abstractMixer, Control[] controlArray) {
        this(info, abstractMixer, controlArray, new AudioFormat(44100.0f, 16, 2, true, Platform.isBigEndian()), 88200);
    }

    protected AbstractDataLine(DataLine.Info info, AbstractMixer abstractMixer, Control[] controlArray, AudioFormat audioFormat, int n) {
        super(info, abstractMixer, controlArray);
        this.defaultFormat = audioFormat;
        this.defaultBufferSize = n;
        this.format = this.defaultFormat;
        this.bufferSize = this.defaultBufferSize;
    }

    private static boolean isPCM(AudioFormat audioFormat) {
        return audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED) || audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(AudioFormat audioFormat, int n) throws LineUnavailableException {
        AbstractMixer abstractMixer = this.mixer;
        synchronized (abstractMixer) {
            if (!this.isOpen()) {
                if (AbstractDataLine.isPCM(audioFormat) && (audioFormat.getSampleRate() == -1.0f || audioFormat.getFrameRate() == -1.0f || audioFormat.getSampleSizeInBits() == -1 || audioFormat.getFrameSize() == -1)) {
                    throw new IllegalArgumentException("pcm format has NOT_SPECIFIED field");
                }
                this.mixer.open(this);
                try {
                    this.implOpen(audioFormat, n);
                    this.setOpen(true);
                }
                catch (LineUnavailableException lineUnavailableException) {
                    this.mixer.close(this);
                    throw lineUnavailableException;
                }
            } else {
                if (!audioFormat.matches(this.getFormat())) {
                    throw new IllegalStateException("Line is already open with format " + this.getFormat() + " and bufferSize " + this.getBufferSize());
                }
                if (n > 0) {
                    this.setBufferSize(n);
                }
            }
        }
    }

    public void open(AudioFormat audioFormat) throws LineUnavailableException {
        this.open(audioFormat, -1);
    }

    public int available() {
        return 0;
    }

    public void drain() {
    }

    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        AbstractMixer abstractMixer = this.mixer;
        synchronized (abstractMixer) {
            if (this.isOpen() && !this.isStartedRunning()) {
                this.mixer.start(this);
                this.implStart();
                this.running = true;
            }
        }
        AbstractDataLine abstractDataLine = this;
        synchronized (abstractDataLine) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        AbstractMixer abstractMixer = this.mixer;
        synchronized (abstractMixer) {
            if (this.isOpen() && this.isStartedRunning()) {
                this.implStop();
                this.mixer.stop(this);
                this.running = false;
                if (this.started && !this.isActive()) {
                    this.setStarted(false);
                }
            }
        }
        AbstractDataLine abstractDataLine = this;
        synchronized (abstractDataLine) {
            this.notifyAll();
        }
    }

    public boolean isRunning() {
        return this.started;
    }

    public boolean isActive() {
        return this.active;
    }

    public long getMicrosecondPosition() {
        long l = -1L;
        int n = this.getFramePosition();
        if (n != -1) {
            l = (long)((double)n * 1000000.0 / (double)this.getFormat().getFrameRate());
        }
        return l;
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public int setBufferSize(int n) {
        return this.getBufferSize();
    }

    public float getLevel() {
        return -1.0f;
    }

    protected boolean isStartedRunning() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setActive(boolean bl) {
        AbstractDataLine abstractDataLine = this;
        synchronized (abstractDataLine) {
            if (this.active != bl) {
                this.active = bl;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setStarted(boolean bl) {
        boolean bl2 = false;
        int n = this.getFramePosition();
        AbstractDataLine abstractDataLine = this;
        synchronized (abstractDataLine) {
            if (this.started != bl) {
                this.started = bl;
                bl2 = true;
            }
        }
        if (bl2) {
            if (bl) {
                this.sendEvents(new LineEvent(this, LineEvent.Type.START, n));
            } else {
                this.sendEvents(new LineEvent(this, LineEvent.Type.STOP, n));
            }
        }
    }

    protected void setEOM() {
        this.setStarted(false);
    }

    public void open() throws LineUnavailableException {
        this.open(this.format, this.bufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        AbstractMixer abstractMixer = this.mixer;
        synchronized (abstractMixer) {
            if (this.isOpen()) {
                this.stop();
                this.setOpen(false);
                this.implClose();
                this.mixer.close(this);
                this.format = this.defaultFormat;
                this.bufferSize = this.defaultBufferSize;
            }
        }
    }

    abstract void implOpen(AudioFormat var1, int var2) throws LineUnavailableException;

    abstract void implClose();

    abstract void implStart();

    abstract void implStop();
}

