/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.LazyActionMap;
import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthLookAndFeel;
import com.sun.java.swing.plaf.gtk.SynthPainter;
import com.sun.java.swing.plaf.gtk.SynthStyle;
import com.sun.java.swing.plaf.gtk.SynthUI;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.UIResource;

class SynthSplitPaneUI
extends SplitPaneUI
implements SynthUI {
    private static final String NON_CONTINUOUS_DIVIDER = "nonContinuousDivider";
    protected static int KEYBOARD_DIVIDER_MOVE_OFFSET = 3;
    protected JSplitPane splitPane;
    protected Divider divider;
    protected PropertyChangeListener propertyChangeListener;
    protected FocusListener focusListener;
    private static Set managingFocusForwardTraversalKeys;
    private static Set managingFocusBackwardTraversalKeys;
    protected int dividerSize;
    protected Component nonContinuousLayoutDivider;
    protected boolean draggingHW;
    protected int beginDragDividerLocation;
    private int orientation;
    private int lastDragLocation;
    private boolean continuousLayout;
    private boolean dividerKeyboardResize;
    private boolean dividerLocationIsSet;
    private boolean rememberPaneSizes;
    boolean painted;
    boolean ignoreDividerLocationChange;
    private SynthStyle style;
    private SynthStyle dividerStyle;
    private int oneTouchSize;
    private int oneTouchOffset;
    private static final Cursor horizontalCursor;
    private static final Cursor verticalCursor;
    private static final Cursor defaultCursor;
    static /* synthetic */ Class class$com$sun$java$swing$plaf$gtk$SynthSplitPaneUI;
    static /* synthetic */ Class class$com$sun$java$swing$plaf$gtk$SynthContext;
    static /* synthetic */ Class class$javax$swing$JSplitPane;

    SynthSplitPaneUI() {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthSplitPaneUI();
    }

    public static void loadActionMap(ActionMap actionMap) {
        actionMap.put("negativeIncrement", new KeyboardUpLeftAction());
        actionMap.put("positiveIncrement", new KeyboardDownRightAction());
        actionMap.put("selectMin", new KeyboardHomeAction());
        actionMap.put("selectMax", new KeyboardEndAction());
        actionMap.put("startResize", new KeyboardResizeToggleAction());
        actionMap.put("toggleFocus", new ToggleSideFocusAction());
        actionMap.put("focusOutForward", new MoveFocusOutAction(1));
        actionMap.put("focusOutBackward", new MoveFocusOutAction(-1));
    }

    public void installUI(JComponent jComponent) {
        this.splitPane = (JSplitPane)jComponent;
        this.dividerLocationIsSet = false;
        this.dividerKeyboardResize = false;
        this.installComponents();
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
        this.setLastDragLocation(-1);
    }

    protected void installComponents() {
        this.divider = new Divider(this.splitPane);
        this.splitPane.add((Component)this.divider, "divider");
    }

    protected void installDefaults() {
        this.setOrientation(this.splitPane.getOrientation());
        this.setContinuousLayout(this.splitPane.isContinuousLayout());
        this.fetchStyle(this.splitPane);
        this.resetLayoutManager();
        if (this.nonContinuousLayoutDivider == null) {
            this.setNonContinuousLayoutDivider(this.createDefaultNonContinuousLayoutDivider(), true);
        } else {
            this.setNonContinuousLayoutDivider(this.nonContinuousLayoutDivider, true);
        }
        if (managingFocusForwardTraversalKeys == null) {
            managingFocusForwardTraversalKeys = new TreeSet();
            managingFocusForwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 0));
        }
        this.splitPane.setFocusTraversalKeys(0, managingFocusForwardTraversalKeys);
        if (managingFocusBackwardTraversalKeys == null) {
            managingFocusBackwardTraversalKeys = new TreeSet();
            managingFocusBackwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 1));
        }
        this.splitPane.setFocusTraversalKeys(1, managingFocusBackwardTraversalKeys);
    }

    private void fetchStyle(JSplitPane jSplitPane) {
        SynthContext synthContext = this.getContext((JComponent)jSplitPane, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle) {
            jSplitPane.setDividerSize(((Number)this.style.get(synthContext, "SplitPaneDivider.size")).intValue());
            this.divider.setDividerSize(jSplitPane.getDividerSize());
        }
        synthContext.dispose();
        synthContext = this.getContext(jSplitPane, Region.SPLIT_PANE_DIVIDER, 1);
        this.dividerStyle = SynthLookAndFeel.updateStyle(synthContext, this);
        this.divider.setOpaque(this.dividerStyle.isOpaque(synthContext));
        this.oneTouchSize = this.dividerStyle.getInt(synthContext, "SplitPaneDivider.oneTouchButtonSize", 6);
        this.oneTouchOffset = this.dividerStyle.getInt(synthContext, "SplitPaneDivider.oneTouchOffset", 6);
        synthContext.dispose();
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.splitPane.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((this.focusListener = this.createFocusListener()) != null) {
            this.splitPane.addFocusListener(this.focusListener);
        }
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.splitPane, 1, inputMap);
        LazyActionMap.installLazyActionMap(this.splitPane, class$com$sun$java$swing$plaf$gtk$SynthSplitPaneUI == null ? (class$com$sun$java$swing$plaf$gtk$SynthSplitPaneUI = SynthSplitPaneUI.class$("com.sun.java.swing.plaf.gtk.SynthSplitPaneUI")) : class$com$sun$java$swing$plaf$gtk$SynthSplitPaneUI, "SplitPane.actionMap");
    }

    InputMap getInputMap(int n) {
        if (n == 1) {
            SynthContext synthContext = this.getContext((JComponent)this.splitPane, 1);
            InputMap inputMap = (InputMap)synthContext.getStyle().get(synthContext, "SplitPane.ancestorInputMap");
            synthContext.dispose();
            return inputMap;
        }
        return null;
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallComponents();
        this.dividerLocationIsSet = false;
        this.dividerKeyboardResize = false;
        this.splitPane = null;
    }

    private void uninstallComponents() {
        if (this.nonContinuousLayoutDivider != null) {
            this.splitPane.remove(this.nonContinuousLayoutDivider);
        }
        this.splitPane.remove(this.divider);
        this.divider = null;
    }

    protected void uninstallDefaults() {
        if (this.splitPane.getLayout() instanceof UIResource) {
            this.splitPane.setLayout(null);
        }
        SynthContext synthContext = this.getContext((JComponent)this.splitPane, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
        synthContext = this.getContext(this.splitPane, Region.SPLIT_PANE_DIVIDER, 1);
        this.dividerStyle.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.dividerStyle = null;
        this.nonContinuousLayoutDivider = null;
        this.setNonContinuousLayoutDivider(null);
        this.splitPane.setFocusTraversalKeys(0, null);
        this.splitPane.setFocusTraversalKeys(1, null);
    }

    protected void uninstallListeners() {
        if (this.propertyChangeListener != null) {
            this.splitPane.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
        if (this.focusListener != null) {
            this.splitPane.removeFocusListener(this.focusListener);
            this.focusListener = null;
        }
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.splitPane, null);
        SwingUtilities.replaceUIInputMap(this.splitPane, 1, null);
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n) {
        return SynthContext.getContext(class$com$sun$java$swing$plaf$gtk$SynthContext == null ? (class$com$sun$java$swing$plaf$gtk$SynthContext = SynthSplitPaneUI.class$("com.sun.java.swing.plaf.gtk.SynthContext")) : class$com$sun$java$swing$plaf$gtk$SynthContext, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n);
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    private SynthContext getContext(JComponent jComponent, Region region) {
        return this.getContext(jComponent, region, this.getComponentState(jComponent, region));
    }

    private SynthContext getContext(JComponent jComponent, Region region, int n) {
        return SynthContext.getContext(class$com$sun$java$swing$plaf$gtk$SynthContext == null ? (class$com$sun$java$swing$plaf$gtk$SynthContext = SynthSplitPaneUI.class$("com.sun.java.swing.plaf.gtk.SynthContext")) : class$com$sun$java$swing$plaf$gtk$SynthContext, jComponent, region, this.style, n);
    }

    private int getComponentState(JComponent jComponent, Region region) {
        int n = SynthLookAndFeel.getComponentState(jComponent);
        if (this.divider.isMouseOver()) {
            n |= 2;
        }
        return n;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyHandler();
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n) {
        this.orientation = n;
    }

    public boolean isContinuousLayout() {
        return this.continuousLayout;
    }

    public void setContinuousLayout(boolean bl) {
        this.continuousLayout = bl;
    }

    public int getLastDragLocation() {
        return this.lastDragLocation;
    }

    public void setLastDragLocation(int n) {
        this.lastDragLocation = n;
    }

    int getKeyboardMoveIncrement() {
        return KEYBOARD_DIVIDER_MOVE_OFFSET;
    }

    protected Component createDefaultNonContinuousLayoutDivider() {
        return new Canvas(){

            public void paint(Graphics graphics) {
                SynthSplitPaneUI.this.paintDragDivider(graphics, 0, 0, this.getWidth(), this.getHeight());
            }
        };
    }

    protected void setNonContinuousLayoutDivider(Component component) {
        this.setNonContinuousLayoutDivider(component, true);
    }

    protected void setNonContinuousLayoutDivider(Component component, boolean bl) {
        this.rememberPaneSizes = bl;
        if (this.nonContinuousLayoutDivider != null && this.splitPane != null) {
            this.splitPane.remove(this.nonContinuousLayoutDivider);
        }
        this.nonContinuousLayoutDivider = component;
    }

    private void addHeavyweightDivider() {
        if (this.nonContinuousLayoutDivider != null && this.splitPane != null) {
            Component component = this.splitPane.getLeftComponent();
            Component component2 = this.splitPane.getRightComponent();
            int n = this.splitPane.getDividerLocation();
            if (component != null) {
                this.splitPane.setLeftComponent(null);
            }
            if (component2 != null) {
                this.splitPane.setRightComponent(null);
            }
            this.splitPane.remove(this.divider);
            this.splitPane.add(this.nonContinuousLayoutDivider, NON_CONTINUOUS_DIVIDER, this.splitPane.getComponentCount());
            this.splitPane.setLeftComponent(component);
            this.splitPane.setRightComponent(component2);
            this.splitPane.add((Component)this.divider, "divider");
            if (this.rememberPaneSizes) {
                this.splitPane.setDividerLocation(n);
            }
        }
    }

    public Component getNonContinuousLayoutDivider() {
        return this.nonContinuousLayoutDivider;
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }

    public void resetToPreferredSizes(JSplitPane jSplitPane) {
        if (this.splitPane != null) {
            LayoutManager layoutManager = jSplitPane.getLayout();
            if (layoutManager instanceof SplitPaneLayoutManager) {
                ((SplitPaneLayoutManager)layoutManager).resetToPreferredSizes();
            }
            this.splitPane.revalidate();
            this.splitPane.repaint();
        }
    }

    public void setDividerLocation(JSplitPane jSplitPane, int n) {
        if (!this.ignoreDividerLocationChange) {
            this.dividerLocationIsSet = true;
            this.splitPane.revalidate();
            this.splitPane.repaint();
        } else {
            this.ignoreDividerLocationChange = false;
        }
    }

    public int getDividerLocation(JSplitPane jSplitPane) {
        if (this.orientation == 1) {
            return this.divider.getX();
        }
        return this.divider.getY();
    }

    public int getMinimumDividerLocation(JSplitPane jSplitPane) {
        int n = 0;
        Component component = this.splitPane.getLeftComponent();
        if (component != null && component.isVisible()) {
            Insets insets = this.splitPane.getInsets();
            Dimension dimension = component.getMinimumSize();
            n = this.orientation == 1 ? dimension.width : dimension.height;
            if (insets != null) {
                n = this.orientation == 1 ? (n += insets.left) : (n += insets.top);
            }
        }
        return n;
    }

    public int getMaximumDividerLocation(JSplitPane jSplitPane) {
        Dimension dimension = this.splitPane.getSize();
        int n = 0;
        Component component = this.splitPane.getRightComponent();
        if (component != null) {
            Insets insets = this.splitPane.getInsets();
            Dimension dimension2 = new Dimension(0, 0);
            if (component.isVisible()) {
                dimension2 = component.getMinimumSize();
            }
            n = this.orientation == 1 ? dimension.width - dimension2.width : dimension.height - dimension2.height;
            n -= this.dividerSize;
            if (insets != null) {
                n = this.orientation == 1 ? (n -= insets.right) : (n -= insets.top);
            }
        }
        return Math.max(this.getMinimumDividerLocation(this.splitPane), n);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
        if (!this.painted && this.splitPane.getDividerLocation() < 0) {
            this.ignoreDividerLocationChange = true;
            this.splitPane.setDividerLocation(this.getDividerLocation(this.splitPane));
        }
        this.painted = true;
    }

    private void paintDragDivider(Graphics graphics, int n, int n2, int n3, int n4) {
        SynthContext synthContext = this.getContext((JComponent)this.splitPane, Region.SPLIT_PANE_DIVIDER);
        synthContext.setComponentState((synthContext.getComponentState() | 2) ^ 2 | 4);
        SynthPainter synthPainter = (SynthPainter)synthContext.getStyle().get(synthContext, "SplitPane.dragPainter");
        if (synthPainter != null) {
            synthPainter.paint(synthContext, "foreground", graphics, n, n2, n3, n4);
        }
        synthContext.dispose();
    }

    public void finishedPaintingChildren(JSplitPane jSplitPane, Graphics graphics) {
        if (jSplitPane == this.splitPane && this.getLastDragLocation() != -1 && !this.isContinuousLayout() && !this.draggingHW) {
            if (this.orientation == 1) {
                this.paintDragDivider(graphics, this.getLastDragLocation(), 0, this.dividerSize - 1, this.splitPane.getHeight() - 1);
            } else {
                this.paintDragDivider(graphics, 0, this.lastDragLocation, this.splitPane.getWidth() - 1, this.dividerSize - 1);
            }
        }
    }

    protected void resetLayoutManager() {
        SplitPaneLayoutManager splitPaneLayoutManager = this.orientation == 1 ? new SplitPaneLayoutManager(0) : new SplitPaneLayoutManager(1);
        this.splitPane.setLayout(splitPaneLayoutManager);
        splitPaneLayoutManager.updateComponents();
        this.splitPane.revalidate();
        this.splitPane.repaint();
    }

    protected void startDragging() {
        ComponentPeer componentPeer;
        Component component = this.splitPane.getLeftComponent();
        Component component2 = this.splitPane.getRightComponent();
        this.beginDragDividerLocation = this.getDividerLocation(this.splitPane);
        this.draggingHW = false;
        if (component != null && (componentPeer = component.getPeer()) != null && !(componentPeer instanceof LightweightPeer)) {
            this.draggingHW = true;
        } else if (component2 != null && (componentPeer = component2.getPeer()) != null && !(componentPeer instanceof LightweightPeer)) {
            this.draggingHW = true;
        }
        if (this.orientation == 1) {
            this.setLastDragLocation(this.divider.getBounds().x);
            this.dividerSize = this.divider.getSize().width;
            if (!this.isContinuousLayout() && this.draggingHW) {
                this.nonContinuousLayoutDivider.setBounds(this.getLastDragLocation(), 0, this.dividerSize, this.splitPane.getHeight());
                this.addHeavyweightDivider();
            }
        } else {
            this.setLastDragLocation(this.divider.getBounds().y);
            this.dividerSize = this.divider.getSize().height;
            if (!this.isContinuousLayout() && this.draggingHW) {
                this.nonContinuousLayoutDivider.setBounds(0, this.getLastDragLocation(), this.splitPane.getWidth(), this.dividerSize);
                this.addHeavyweightDivider();
            }
        }
    }

    protected void dragDividerTo(int n) {
        if (this.getLastDragLocation() != n) {
            if (this.isContinuousLayout()) {
                this.splitPane.setDividerLocation(n);
                this.setLastDragLocation(n);
            } else {
                int n2 = this.getLastDragLocation();
                this.setLastDragLocation(n);
                if (this.orientation == 1) {
                    if (this.draggingHW) {
                        this.nonContinuousLayoutDivider.setLocation(this.getLastDragLocation(), 0);
                    } else {
                        int n3 = this.splitPane.getHeight();
                        this.splitPane.repaint(n2, 0, this.dividerSize, n3);
                        this.splitPane.repaint(n, 0, this.dividerSize, n3);
                    }
                } else if (this.draggingHW) {
                    this.nonContinuousLayoutDivider.setLocation(0, this.getLastDragLocation());
                } else {
                    int n4 = this.splitPane.getWidth();
                    this.splitPane.repaint(0, n2, n4, this.dividerSize);
                    this.splitPane.repaint(0, n, n4, this.dividerSize);
                }
            }
        }
    }

    protected void finishDraggingTo(int n) {
        this.dragDividerTo(n);
        this.setLastDragLocation(-1);
        if (!this.isContinuousLayout()) {
            Component component = this.splitPane.getLeftComponent();
            Rectangle rectangle = component.getBounds();
            if (this.draggingHW) {
                if (this.orientation == 1) {
                    this.nonContinuousLayoutDivider.setLocation(-this.dividerSize, 0);
                } else {
                    this.nonContinuousLayoutDivider.setLocation(0, -this.dividerSize);
                }
                this.splitPane.remove(this.nonContinuousLayoutDivider);
            }
            this.splitPane.setDividerLocation(n);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        horizontalCursor = Cursor.getPredefinedCursor(11);
        verticalCursor = Cursor.getPredefinedCursor(9);
        defaultCursor = Cursor.getPredefinedCursor(0);
    }

    private class Divider
    extends JComponent
    implements PropertyChangeListener {
        protected DragController dragger;
        protected int dividerSize = 0;
        protected Component hiddenDivider;
        protected MouseHandler mouseHandler;
        private boolean mouseOver;

        public Divider(JSplitPane jSplitPane) {
            this.setLayout(new DividerLayout());
            int n = jSplitPane.getOrientation();
            this.setCursor(n == 1 ? horizontalCursor : verticalCursor);
            this.mouseHandler = new MouseHandler();
            jSplitPane.addMouseListener(this.mouseHandler);
            jSplitPane.addMouseMotionListener(this.mouseHandler);
            this.addMouseListener(this.mouseHandler);
            this.addMouseMotionListener(this.mouseHandler);
            jSplitPane.addPropertyChangeListener(this);
        }

        public String getUIClassID() {
            return "SplitPaneDividerUI";
        }

        public void setDividerSize(int n) {
            this.dividerSize = n;
        }

        public int getDividerSize() {
            return this.dividerSize;
        }

        public Dimension getPreferredSize() {
            if (SynthSplitPaneUI.this.orientation == 1) {
                return new Dimension(this.getDividerSize(), 1);
            }
            return new Dimension(1, this.getDividerSize());
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public boolean isMouseOver() {
            return this.mouseOver;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() == SynthSplitPaneUI.this.splitPane && propertyChangeEvent.getPropertyName().equals("orientation")) {
                SynthSplitPaneUI.this.orientation = SynthSplitPaneUI.this.splitPane.getOrientation();
                this.setCursor(SynthSplitPaneUI.this.orientation == 1 ? horizontalCursor : verticalCursor);
                this.revalidate();
            }
        }

        public void paintComponent(Graphics graphics) {
            SynthContext synthContext = SynthSplitPaneUI.this.getContext(SynthSplitPaneUI.this.splitPane, Region.SPLIT_PANE_DIVIDER);
            Rectangle rectangle = this.getBounds();
            rectangle.y = 0;
            rectangle.x = 0;
            SynthLookAndFeel.updateSubregion(synthContext, graphics, rectangle);
            SynthPainter synthPainter = (SynthPainter)synthContext.getStyle().get(synthContext, "foreground");
            if (synthPainter != null) {
                synthPainter.paint(synthContext, "foreground", graphics, 0, 0, this.getWidth(), this.getHeight());
            }
            synthContext.dispose();
        }

        private int mapDirection(boolean bl) {
            if (bl) {
                if (SynthSplitPaneUI.this.splitPane.getOrientation() == 1) {
                    return 7;
                }
                return 1;
            }
            if (SynthSplitPaneUI.this.splitPane.getOrientation() == 1) {
                return 3;
            }
            return 5;
        }

        protected class DividerLayout
        implements LayoutManager {
            protected DividerLayout() {
            }

            public void layoutContainer(Container container) {
            }

            public Dimension minimumLayoutSize(Container container) {
                int n;
                if (container != Divider.this || ((Divider)Divider.this).SynthSplitPaneUI.this.splitPane == null) {
                    return new Dimension(0, 0);
                }
                Insets insets = Divider.this.getInsets();
                int n2 = n = Divider.this.getDividerSize();
                if (SynthSplitPaneUI.this.orientation == 0) {
                    if (insets != null) {
                        n2 += insets.top + insets.bottom;
                    }
                    n = 1;
                } else {
                    if (insets != null) {
                        n += insets.left + insets.right;
                    }
                    n2 = 1;
                }
                return new Dimension(n, n2);
            }

            public Dimension preferredLayoutSize(Container container) {
                return this.minimumLayoutSize(container);
            }

            public void removeLayoutComponent(Component component) {
            }

            public void addLayoutComponent(String string, Component component) {
            }
        }

        protected class VerticalDragController
        extends DragController {
            protected VerticalDragController(MouseEvent mouseEvent) {
                super(mouseEvent);
                JSplitPane jSplitPane = SynthSplitPaneUI.this.getSplitPane();
                Component component = jSplitPane.getLeftComponent();
                Component component2 = jSplitPane.getRightComponent();
                this.initialX = Divider.this.getLocation().y;
                this.offset = mouseEvent.getSource() == Divider.this ? mouseEvent.getY() : mouseEvent.getY() - this.initialX;
                if (component == null || component2 == null || this.offset < -1 || this.offset > Divider.this.getSize().height) {
                    this.maxX = -1;
                } else {
                    Insets insets = jSplitPane.getInsets();
                    if (component.isVisible()) {
                        this.minX = component.getMinimumSize().height;
                        if (insets != null) {
                            this.minX += insets.top;
                        }
                    } else {
                        this.minX = 0;
                    }
                    if (component2.isVisible()) {
                        int n = insets != null ? insets.bottom : 0;
                        this.maxX = Math.max(0, jSplitPane.getSize().height - (Divider.this.getSize().height + n) - component2.getMinimumSize().height);
                    } else {
                        int n = insets != null ? insets.bottom : 0;
                        this.maxX = Math.max(0, jSplitPane.getSize().height - (Divider.this.getSize().height + n));
                    }
                    if (this.maxX < this.minX) {
                        this.maxX = 0;
                        this.minX = 0;
                    }
                }
            }

            protected int getNeededLocation(int n, int n2) {
                int n3 = Math.min(this.maxX, Math.max(this.minX, n2 - this.offset));
                return n3;
            }

            protected int positionForMouseEvent(MouseEvent mouseEvent) {
                int n = mouseEvent.getSource() == Divider.this ? mouseEvent.getY() + Divider.this.getLocation().y : mouseEvent.getY();
                n = Math.min(this.maxX, Math.max(this.minX, n - this.offset));
                return n;
            }
        }

        protected class DragController {
            int initialX;
            int maxX;
            int minX;
            int offset;

            protected DragController(MouseEvent mouseEvent) {
                JSplitPane jSplitPane = SynthSplitPaneUI.this.getSplitPane();
                Component component = jSplitPane.getLeftComponent();
                Component component2 = jSplitPane.getRightComponent();
                this.initialX = Divider.this.getLocation().x;
                this.offset = mouseEvent.getSource() == Divider.this ? mouseEvent.getX() : mouseEvent.getX() - this.initialX;
                if (component == null || component2 == null || this.offset < -1 || this.offset >= Divider.this.getSize().width) {
                    this.maxX = -1;
                } else {
                    Insets insets = jSplitPane.getInsets();
                    if (component.isVisible()) {
                        this.minX = component.getMinimumSize().width;
                        if (insets != null) {
                            this.minX += insets.left;
                        }
                    } else {
                        this.minX = 0;
                    }
                    if (component2.isVisible()) {
                        int n = insets != null ? insets.right : 0;
                        this.maxX = Math.max(0, jSplitPane.getSize().width - (Divider.this.getSize().width + n) - component2.getMinimumSize().width);
                    } else {
                        int n = insets != null ? insets.right : 0;
                        this.maxX = Math.max(0, jSplitPane.getSize().width - (Divider.this.getSize().width + n));
                    }
                    if (this.maxX < this.minX) {
                        this.maxX = 0;
                        this.minX = 0;
                    }
                }
            }

            protected boolean isValid() {
                return this.maxX > 0;
            }

            protected int positionForMouseEvent(MouseEvent mouseEvent) {
                int n = mouseEvent.getSource() == Divider.this ? mouseEvent.getX() + Divider.this.getLocation().x : mouseEvent.getX();
                n = Math.min(this.maxX, Math.max(this.minX, n - this.offset));
                return n;
            }

            protected int getNeededLocation(int n, int n2) {
                int n3 = Math.min(this.maxX, Math.max(this.minX, n - this.offset));
                return n3;
            }

            protected void continueDrag(int n, int n2) {
                SynthSplitPaneUI.this.dragDividerTo(this.getNeededLocation(n, n2));
            }

            protected void continueDrag(MouseEvent mouseEvent) {
                SynthSplitPaneUI.this.dragDividerTo(this.positionForMouseEvent(mouseEvent));
            }

            protected void completeDrag(int n, int n2) {
                SynthSplitPaneUI.this.finishDraggingTo(this.getNeededLocation(n, n2));
            }

            protected void completeDrag(MouseEvent mouseEvent) {
                SynthSplitPaneUI.this.finishDraggingTo(this.positionForMouseEvent(mouseEvent));
            }
        }

        protected class MouseHandler
        extends MouseAdapter
        implements MouseMotionListener {
            protected MouseHandler() {
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if ((mouseEvent.getSource() == Divider.this || mouseEvent.getSource() == ((Divider)Divider.this).SynthSplitPaneUI.this.splitPane) && Divider.this.dragger == null && ((Divider)Divider.this).SynthSplitPaneUI.this.splitPane.isEnabled()) {
                    Component component = SynthSplitPaneUI.this.getNonContinuousLayoutDivider();
                    if (Divider.this.hiddenDivider != component) {
                        if (Divider.this.hiddenDivider != null) {
                            Divider.this.hiddenDivider.removeMouseListener(this);
                            Divider.this.hiddenDivider.removeMouseMotionListener(this);
                        }
                        Divider.this.hiddenDivider = component;
                        if (Divider.this.hiddenDivider != null) {
                            Divider.this.hiddenDivider.addMouseMotionListener(this);
                            Divider.this.hiddenDivider.addMouseListener(this);
                        }
                    }
                    if (((Divider)Divider.this).SynthSplitPaneUI.this.splitPane.getLeftComponent() != null && ((Divider)Divider.this).SynthSplitPaneUI.this.splitPane.getRightComponent() != null) {
                        Divider.this.dragger = SynthSplitPaneUI.this.orientation == 1 ? new DragController(mouseEvent) : new VerticalDragController(mouseEvent);
                        if (!Divider.this.dragger.isValid()) {
                            Divider.this.dragger = null;
                        } else {
                            SynthSplitPaneUI.this.startDragging();
                            Divider.this.dragger.continueDrag(mouseEvent);
                        }
                    }
                    mouseEvent.consume();
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (Divider.this.dragger != null) {
                    if (mouseEvent.getSource() == ((Divider)Divider.this).SynthSplitPaneUI.this.splitPane) {
                        Divider.this.dragger.completeDrag(mouseEvent.getX(), mouseEvent.getY());
                    } else if (mouseEvent.getSource() == Divider.this) {
                        Point point = Divider.this.getLocation();
                        Divider.this.dragger.completeDrag(mouseEvent.getX() + point.x, mouseEvent.getY() + point.y);
                    } else if (mouseEvent.getSource() == Divider.this.hiddenDivider) {
                        Point point = Divider.this.hiddenDivider.getLocation();
                        int n = mouseEvent.getX() + point.x;
                        int n2 = mouseEvent.getY() + point.y;
                        Divider.this.dragger.completeDrag(n, n2);
                    }
                    Divider.this.dragger = null;
                    mouseEvent.consume();
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                if (mouseEvent.getSource() == Divider.this) {
                    Divider.this.mouseOver = true;
                    Divider.this.repaint();
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                if (mouseEvent.getSource() == Divider.this) {
                    Divider.this.mouseOver = false;
                    Divider.this.repaint();
                }
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                if (Divider.this.dragger != null) {
                    if (mouseEvent.getSource() == ((Divider)Divider.this).SynthSplitPaneUI.this.splitPane) {
                        Divider.this.dragger.continueDrag(mouseEvent.getX(), mouseEvent.getY());
                    } else if (mouseEvent.getSource() == Divider.this) {
                        Point point = Divider.this.getLocation();
                        Divider.this.dragger.continueDrag(mouseEvent.getX() + point.x, mouseEvent.getY() + point.y);
                    } else if (mouseEvent.getSource() == Divider.this.hiddenDivider) {
                        Point point = Divider.this.hiddenDivider.getLocation();
                        int n = mouseEvent.getX() + point.x;
                        int n2 = mouseEvent.getY() + point.y;
                        Divider.this.dragger.continueDrag(n, n2);
                    }
                    mouseEvent.consume();
                }
            }

            public void mouseMoved(MouseEvent mouseEvent) {
            }
        }
    }

    private class SplitPaneLayoutManager
    implements LayoutManager2,
    UIResource {
        protected int[] sizes;
        protected Component[] components;
        private int lastSplitPaneSize;
        private boolean doReset;
        private int axis;

        SplitPaneLayoutManager(int n) {
            this.axis = n;
            this.components = new Component[3];
            this.components[2] = null;
            this.components[1] = null;
            this.components[0] = null;
            this.sizes = new int[3];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void layoutContainer(Container container) {
            int n;
            Dimension dimension;
            Dimension dimension2 = container.getSize();
            if (dimension2.height <= 0 || dimension2.width <= 0) {
                this.lastSplitPaneSize = 0;
                return;
            }
            int n2 = SynthSplitPaneUI.this.splitPane.getDividerLocation();
            Insets insets = SynthSplitPaneUI.this.splitPane.getInsets();
            int n3 = this.getAvailableSize(dimension2, insets);
            int n4 = this.getSizeForPrimaryAxis(dimension2);
            int n5 = SynthSplitPaneUI.this.getDividerLocation(SynthSplitPaneUI.this.splitPane);
            int n6 = this.getSizeForPrimaryAxis(insets, true);
            Dimension dimension3 = dimension = this.components[2] == null ? null : this.components[2].getPreferredSize();
            if (this.doReset && !SynthSplitPaneUI.this.dividerLocationIsSet || n2 < 0) {
                this.resetToPreferredSizes(n3);
            } else if (this.lastSplitPaneSize <= 0 || n3 == this.lastSplitPaneSize || !SynthSplitPaneUI.this.painted || dimension != null && this.getSizeForPrimaryAxis(dimension) != this.sizes[2]) {
                this.sizes[2] = dimension != null ? this.getSizeForPrimaryAxis(dimension) : 0;
                this.setDividerLocation(n2 - n6, n3);
                SynthSplitPaneUI.this.dividerLocationIsSet = false;
            } else if (n3 != this.lastSplitPaneSize) {
                this.distributeSpace(n3 - this.lastSplitPaneSize, true);
            }
            this.doReset = false;
            SynthSplitPaneUI.this.dividerLocationIsSet = false;
            this.lastSplitPaneSize = n3;
            int n7 = this.getInitialLocation(insets);
            int n8 = 0;
            while (n8 < 3) {
                if (this.components[n8] != null && this.components[n8].isVisible()) {
                    this.setComponentToSize(this.components[n8], this.sizes[n8], n7, insets, dimension2);
                    n7 += this.sizes[n8];
                }
                switch (n8) {
                    case 0: {
                        n8 = 2;
                        break;
                    }
                    case 2: {
                        n8 = 1;
                        break;
                    }
                    case 1: {
                        n8 = 3;
                    }
                }
            }
            if (SynthSplitPaneUI.this.painted && (n = SynthSplitPaneUI.this.getDividerLocation(SynthSplitPaneUI.this.splitPane)) != n2 - n6) {
                int n9 = SynthSplitPaneUI.this.splitPane.getLastDividerLocation();
                SynthSplitPaneUI.this.ignoreDividerLocationChange = true;
                try {
                    SynthSplitPaneUI.this.splitPane.setDividerLocation(n);
                    SynthSplitPaneUI.this.splitPane.setLastDividerLocation(n9);
                    Object var15_14 = null;
                    SynthSplitPaneUI.this.ignoreDividerLocationChange = false;
                }
                catch (Throwable throwable) {
                    Object var15_15 = null;
                    SynthSplitPaneUI.this.ignoreDividerLocationChange = false;
                    throw throwable;
                }
            }
        }

        public void addLayoutComponent(String string, Component component) {
            boolean bl = true;
            if (string != null) {
                if (string.equals("divider")) {
                    this.components[2] = component;
                    this.sizes[2] = this.getSizeForPrimaryAxis(component.getPreferredSize());
                } else if (string.equals("left") || string.equals("top")) {
                    this.components[0] = component;
                    this.sizes[0] = 0;
                } else if (string.equals("right") || string.equals("bottom")) {
                    this.components[1] = component;
                    this.sizes[1] = 0;
                } else if (!string.equals(SynthSplitPaneUI.NON_CONTINUOUS_DIVIDER)) {
                    bl = false;
                }
            } else {
                bl = false;
            }
            if (!bl) {
                throw new IllegalArgumentException("cannot add to layout: unknown constraint: " + string);
            }
            this.doReset = true;
        }

        public Dimension minimumLayoutSize(Container container) {
            int n = 0;
            int n2 = 0;
            Insets insets = SynthSplitPaneUI.this.splitPane.getInsets();
            int n3 = 0;
            while (n3 < 3) {
                if (this.components[n3] != null) {
                    Dimension dimension = this.components[n3].getMinimumSize();
                    int n4 = this.getSizeForSecondaryAxis(dimension);
                    n += this.getSizeForPrimaryAxis(dimension);
                    if (n4 > n2) {
                        n2 = n4;
                    }
                }
                ++n3;
            }
            if (insets != null) {
                n += this.getSizeForPrimaryAxis(insets, true) + this.getSizeForPrimaryAxis(insets, false);
                n2 += this.getSizeForSecondaryAxis(insets, true) + this.getSizeForSecondaryAxis(insets, false);
            }
            if (this.axis == 0) {
                return new Dimension(n, n2);
            }
            return new Dimension(n2, n);
        }

        public Dimension preferredLayoutSize(Container container) {
            int n = 0;
            int n2 = 0;
            Insets insets = SynthSplitPaneUI.this.splitPane.getInsets();
            int n3 = 0;
            while (n3 < 3) {
                if (this.components[n3] != null) {
                    Dimension dimension = this.components[n3].getPreferredSize();
                    int n4 = this.getSizeForSecondaryAxis(dimension);
                    n += this.getSizeForPrimaryAxis(dimension);
                    if (n4 > n2) {
                        n2 = n4;
                    }
                }
                ++n3;
            }
            if (insets != null) {
                n += this.getSizeForPrimaryAxis(insets, true) + this.getSizeForPrimaryAxis(insets, false);
                n2 += this.getSizeForSecondaryAxis(insets, true) + this.getSizeForSecondaryAxis(insets, false);
            }
            if (this.axis == 0) {
                return new Dimension(n, n2);
            }
            return new Dimension(n2, n);
        }

        public void removeLayoutComponent(Component component) {
            int n = 0;
            while (n < 3) {
                if (this.components[n] == component) {
                    this.components[n] = null;
                    this.sizes[n] = 0;
                    this.doReset = true;
                }
                ++n;
            }
        }

        public void addLayoutComponent(Component component, Object object) {
            if (object != null && !(object instanceof String)) {
                throw new IllegalArgumentException("cannot add to layout: constraint must be a string (or null)");
            }
            this.addLayoutComponent((String)object, component);
        }

        public float getLayoutAlignmentX(Container container) {
            return 0.0f;
        }

        public float getLayoutAlignmentY(Container container) {
            return 0.0f;
        }

        public void invalidateLayout(Container container) {
        }

        public Dimension maximumLayoutSize(Container container) {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        public void resetToPreferredSizes() {
            this.doReset = true;
        }

        protected void resetSizeAt(int n) {
            this.sizes[n] = 0;
            this.doReset = true;
        }

        protected void setSizes(int[] nArray) {
            System.arraycopy(nArray, 0, this.sizes, 0, 3);
        }

        protected int[] getSizes() {
            int[] nArray = new int[3];
            System.arraycopy(this.sizes, 0, nArray, 0, 3);
            return nArray;
        }

        protected int getPreferredSizeOfComponent(Component component) {
            return this.getSizeForPrimaryAxis(component.getPreferredSize());
        }

        int getMinimumSizeOfComponent(Component component) {
            return this.getSizeForPrimaryAxis(component.getMinimumSize());
        }

        protected int getSizeOfComponent(Component component) {
            return this.getSizeForPrimaryAxis(component.getSize());
        }

        protected int getAvailableSize(Dimension dimension, Insets insets) {
            if (insets == null) {
                return this.getSizeForPrimaryAxis(dimension);
            }
            return this.getSizeForPrimaryAxis(dimension) - (this.getSizeForPrimaryAxis(insets, true) + this.getSizeForPrimaryAxis(insets, false));
        }

        protected int getInitialLocation(Insets insets) {
            if (insets != null) {
                return this.getSizeForPrimaryAxis(insets, true);
            }
            return 0;
        }

        protected void setComponentToSize(Component component, int n, int n2, Insets insets, Dimension dimension) {
            if (insets != null) {
                if (this.axis == 0) {
                    component.setBounds(n2, insets.top, n, dimension.height - (insets.top + insets.bottom));
                } else {
                    component.setBounds(insets.left, n2, dimension.width - (insets.left + insets.right), n);
                }
            } else if (this.axis == 0) {
                component.setBounds(n2, 0, n, dimension.height);
            } else {
                component.setBounds(0, n2, dimension.width, n);
            }
        }

        int getSizeForPrimaryAxis(Dimension dimension) {
            if (this.axis == 0) {
                return dimension.width;
            }
            return dimension.height;
        }

        int getSizeForSecondaryAxis(Dimension dimension) {
            if (this.axis == 0) {
                return dimension.height;
            }
            return dimension.width;
        }

        int getSizeForPrimaryAxis(Insets insets, boolean bl) {
            if (this.axis == 0) {
                if (bl) {
                    return insets.left;
                }
                return insets.right;
            }
            if (bl) {
                return insets.top;
            }
            return insets.bottom;
        }

        int getSizeForSecondaryAxis(Insets insets, boolean bl) {
            if (this.axis == 0) {
                if (bl) {
                    return insets.top;
                }
                return insets.bottom;
            }
            if (bl) {
                return insets.left;
            }
            return insets.right;
        }

        protected void updateComponents() {
            Component component = SynthSplitPaneUI.this.splitPane.getLeftComponent();
            if (this.components[0] != component) {
                this.components[0] = component;
                this.sizes[0] = component == null ? 0 : -1;
            }
            if (this.components[1] != (component = SynthSplitPaneUI.this.splitPane.getRightComponent())) {
                this.components[1] = component;
                this.sizes[1] = component == null ? 0 : -1;
            }
            Component[] componentArray = SynthSplitPaneUI.this.splitPane.getComponents();
            Component component2 = this.components[2];
            this.components[2] = null;
            int n = componentArray.length - 1;
            while (n >= 0) {
                if (componentArray[n] != this.components[0] && componentArray[n] != this.components[1] && componentArray[n] != SynthSplitPaneUI.this.nonContinuousLayoutDivider) {
                    if (component2 != componentArray[n]) {
                        this.components[2] = componentArray[n];
                        break;
                    }
                    this.components[2] = component2;
                    break;
                }
                --n;
            }
            this.sizes[2] = this.components[2] == null ? 0 : this.getSizeForPrimaryAxis(this.components[2].getPreferredSize());
        }

        void setDividerLocation(int n, int n2) {
            boolean bl = this.components[0] != null && this.components[0].isVisible();
            boolean bl2 = this.components[1] != null && this.components[1].isVisible();
            boolean bl3 = this.components[2] != null && this.components[2].isVisible();
            int n3 = n2;
            if (bl3) {
                n3 -= this.sizes[2];
            }
            n = Math.max(0, Math.min(n, n3));
            if (bl) {
                if (bl2) {
                    this.sizes[0] = n;
                    this.sizes[1] = n3 - n;
                } else {
                    this.sizes[0] = n3;
                    this.sizes[1] = 0;
                }
            } else if (bl2) {
                this.sizes[1] = n3;
                this.sizes[0] = 0;
            }
        }

        int[] getPreferredSizes() {
            int[] nArray = new int[3];
            int n = 0;
            while (n < 3) {
                nArray[n] = this.components[n] != null && this.components[n].isVisible() ? this.getPreferredSizeOfComponent(this.components[n]) : -1;
                ++n;
            }
            return nArray;
        }

        int[] getMinimumSizes() {
            int[] nArray = new int[3];
            int n = 0;
            while (n < 2) {
                nArray[n] = this.components[n] != null && this.components[n].isVisible() ? this.getMinimumSizeOfComponent(this.components[n]) : -1;
                ++n;
            }
            nArray[2] = this.components[2] != null ? this.getMinimumSizeOfComponent(this.components[2]) : -1;
            return nArray;
        }

        void resetToPreferredSizes(int n) {
            int[] nArray = this.getPreferredSizes();
            int n2 = 0;
            int n3 = 0;
            while (n3 < 3) {
                if (nArray[n3] != -1) {
                    n2 += nArray[n3];
                }
                ++n3;
            }
            if (n2 > n) {
                nArray = this.getMinimumSizes();
                n2 = 0;
                int n4 = 0;
                while (n4 < 3) {
                    if (nArray[n4] != -1) {
                        n2 += nArray[n4];
                    }
                    ++n4;
                }
            }
            this.setSizes(nArray);
            this.distributeSpace(n - n2, false);
        }

        void distributeSpace(int n, boolean bl) {
            boolean bl2;
            boolean bl3 = this.components[0] != null && this.components[0].isVisible();
            boolean bl4 = bl2 = this.components[1] != null && this.components[1].isVisible();
            if (bl) {
                if (bl3 && this.getSizeForPrimaryAxis(this.components[0].getSize()) == 0) {
                    bl3 = false;
                    if (bl2 && this.getSizeForPrimaryAxis(this.components[1].getSize()) == 0) {
                        bl3 = true;
                    }
                } else if (bl2 && this.getSizeForPrimaryAxis(this.components[1].getSize()) == 0) {
                    bl2 = false;
                }
            }
            if (bl3 && bl2) {
                boolean bl5;
                double d = SynthSplitPaneUI.this.splitPane.getResizeWeight();
                int n2 = (int)(d * (double)n);
                int n3 = n - n2;
                this.sizes[0] = this.sizes[0] + n2;
                this.sizes[1] = this.sizes[1] + n3;
                int n4 = this.getMinimumSizeOfComponent(this.components[0]);
                int n5 = this.getMinimumSizeOfComponent(this.components[1]);
                boolean bl6 = this.sizes[0] >= n4;
                boolean bl7 = bl5 = this.sizes[1] >= n5;
                if (!bl6 && !bl5) {
                    if (this.sizes[0] < 0) {
                        this.sizes[1] = this.sizes[1] + this.sizes[0];
                        this.sizes[0] = 0;
                    } else if (this.sizes[1] < 0) {
                        this.sizes[0] = this.sizes[0] + this.sizes[1];
                        this.sizes[1] = 0;
                    }
                } else if (!bl6) {
                    if (this.sizes[1] - (n4 - this.sizes[0]) < n5) {
                        if (this.sizes[0] < 0) {
                            this.sizes[1] = this.sizes[1] + this.sizes[0];
                            this.sizes[0] = 0;
                        }
                    } else {
                        this.sizes[1] = this.sizes[1] - (n4 - this.sizes[0]);
                        this.sizes[0] = n4;
                    }
                } else if (!bl5) {
                    if (this.sizes[0] - (n5 - this.sizes[1]) < n4) {
                        if (this.sizes[1] < 0) {
                            this.sizes[0] = this.sizes[0] + this.sizes[1];
                            this.sizes[1] = 0;
                        }
                    } else {
                        this.sizes[0] = this.sizes[0] - (n5 - this.sizes[1]);
                        this.sizes[1] = n5;
                    }
                }
                if (this.sizes[0] < 0) {
                    this.sizes[0] = 0;
                }
                if (this.sizes[1] < 0) {
                    this.sizes[1] = 0;
                }
            } else if (bl3) {
                this.sizes[0] = Math.max(0, this.sizes[0] + n);
            } else if (bl2) {
                this.sizes[1] = Math.max(0, this.sizes[1] + n);
            }
        }
    }

    static class MoveFocusOutAction
    extends AbstractAction {
        private int direction;

        public MoveFocusOutAction(int n) {
            this.direction = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JSplitPane jSplitPane = (JSplitPane)actionEvent.getSource();
            Container container = jSplitPane.getFocusCycleRootAncestor();
            FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
            Component component = this.direction > 0 ? focusTraversalPolicy.getComponentAfter(container, jSplitPane) : focusTraversalPolicy.getComponentBefore(container, jSplitPane);
            HashSet<Component> hashSet = new HashSet<Component>();
            if (jSplitPane.isAncestorOf(component)) {
                do {
                    hashSet.add(component);
                    container = component.getFocusCycleRootAncestor();
                    focusTraversalPolicy = container.getFocusTraversalPolicy();
                    Component component2 = component = this.direction > 0 ? focusTraversalPolicy.getComponentAfter(container, component) : focusTraversalPolicy.getComponentBefore(container, component);
                } while (jSplitPane.isAncestorOf(component) && !hashSet.contains(component));
            }
            if (component != null && !jSplitPane.isAncestorOf(component)) {
                component.requestFocus();
            }
        }
    }

    static class ToggleSideFocusAction
    extends AbstractAction {
        ToggleSideFocusAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JSplitPane jSplitPane = (JSplitPane)actionEvent.getSource();
            Component component = jSplitPane.getLeftComponent();
            Component component2 = jSplitPane.getRightComponent();
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Component component3 = keyboardFocusManager.getFocusOwner();
            Component component4 = this.getNextSide(jSplitPane, component3);
            if (component4 != null) {
                if (component3 != null && (SwingUtilities.isDescendingFrom(component3, component) && SwingUtilities.isDescendingFrom(component4, component) || SwingUtilities.isDescendingFrom(component3, component2) && SwingUtilities.isDescendingFrom(component4, component2))) {
                    return;
                }
                SynthLookAndFeel.compositeRequestFocus(component4);
            }
        }

        private Component getNextSide(JSplitPane jSplitPane, Component component) {
            Component component2 = jSplitPane.getLeftComponent();
            Component component3 = jSplitPane.getRightComponent();
            Component component4 = null;
            if (component != null && SwingUtilities.isDescendingFrom(component, component2) && component3 != null && (component4 = this.getFirstAvailableComponent(component3)) != null) {
                return component4;
            }
            JSplitPane jSplitPane2 = (JSplitPane)SwingUtilities.getAncestorOfClass(class$javax$swing$JSplitPane == null ? (class$javax$swing$JSplitPane = SynthSplitPaneUI.class$("javax.swing.JSplitPane")) : class$javax$swing$JSplitPane, jSplitPane);
            if (jSplitPane2 != null) {
                component4 = this.getNextSide(jSplitPane2, component);
            } else {
                component4 = this.getFirstAvailableComponent(component2);
                if (component4 == null) {
                    component4 = this.getFirstAvailableComponent(component3);
                }
            }
            return component4;
        }

        private Component getFirstAvailableComponent(Component component) {
            if (component != null && component instanceof JSplitPane) {
                JSplitPane jSplitPane = (JSplitPane)component;
                Component component2 = this.getFirstAvailableComponent(jSplitPane.getLeftComponent());
                component = component2 != null ? component2 : this.getFirstAvailableComponent(jSplitPane.getRightComponent());
            }
            return component;
        }
    }

    static class KeyboardResizeToggleAction
    extends AbstractAction {
        KeyboardResizeToggleAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JSplitPane jSplitPane = (JSplitPane)actionEvent.getSource();
            SynthSplitPaneUI synthSplitPaneUI = (SynthSplitPaneUI)jSplitPane.getUI();
            if (!synthSplitPaneUI.dividerKeyboardResize) {
                jSplitPane.requestFocus();
            } else {
                JSplitPane jSplitPane2 = (JSplitPane)SwingUtilities.getAncestorOfClass(class$javax$swing$JSplitPane == null ? (class$javax$swing$JSplitPane = SynthSplitPaneUI.class$("javax.swing.JSplitPane")) : class$javax$swing$JSplitPane, jSplitPane);
                if (jSplitPane2 != null) {
                    jSplitPane2.requestFocus();
                }
            }
        }
    }

    static class KeyboardEndAction
    extends AbstractAction {
        KeyboardEndAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JSplitPane jSplitPane = (JSplitPane)actionEvent.getSource();
            SynthSplitPaneUI synthSplitPaneUI = (SynthSplitPaneUI)jSplitPane.getUI();
            if (synthSplitPaneUI.dividerKeyboardResize) {
                int n;
                Insets insets = jSplitPane.getInsets();
                int n2 = insets != null ? insets.bottom : 0;
                int n3 = n = insets != null ? insets.right : 0;
                if (synthSplitPaneUI.orientation == 0) {
                    jSplitPane.setDividerLocation(jSplitPane.getHeight() - n2);
                } else {
                    jSplitPane.setDividerLocation(jSplitPane.getWidth() - n);
                }
            }
        }
    }

    static class KeyboardHomeAction
    extends AbstractAction {
        KeyboardHomeAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JSplitPane jSplitPane = (JSplitPane)actionEvent.getSource();
            SynthSplitPaneUI synthSplitPaneUI = (SynthSplitPaneUI)jSplitPane.getUI();
            if (synthSplitPaneUI.dividerKeyboardResize) {
                jSplitPane.setDividerLocation(0);
            }
        }
    }

    static class KeyboardDownRightAction
    extends AbstractAction {
        KeyboardDownRightAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JSplitPane jSplitPane = (JSplitPane)actionEvent.getSource();
            SynthSplitPaneUI synthSplitPaneUI = (SynthSplitPaneUI)jSplitPane.getUI();
            if (synthSplitPaneUI.dividerKeyboardResize) {
                jSplitPane.setDividerLocation(synthSplitPaneUI.getDividerLocation(jSplitPane) + synthSplitPaneUI.getKeyboardMoveIncrement());
            }
        }
    }

    static class KeyboardUpLeftAction
    extends AbstractAction {
        KeyboardUpLeftAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JSplitPane jSplitPane = (JSplitPane)actionEvent.getSource();
            SynthSplitPaneUI synthSplitPaneUI = (SynthSplitPaneUI)jSplitPane.getUI();
            if (synthSplitPaneUI.dividerKeyboardResize) {
                jSplitPane.setDividerLocation(Math.max(0, synthSplitPaneUI.getDividerLocation(jSplitPane) - synthSplitPaneUI.getKeyboardMoveIncrement()));
            }
        }
    }

    class FocusHandler
    extends FocusAdapter {
        FocusHandler() {
        }

        public void focusGained(FocusEvent focusEvent) {
            SynthSplitPaneUI.this.dividerKeyboardResize = true;
            SynthSplitPaneUI.this.splitPane.repaint();
        }

        public void focusLost(FocusEvent focusEvent) {
            SynthSplitPaneUI.this.dividerKeyboardResize = false;
            SynthSplitPaneUI.this.splitPane.repaint();
        }
    }

    class PropertyHandler
    implements PropertyChangeListener {
        PropertyHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() == SynthSplitPaneUI.this.splitPane) {
                String string = propertyChangeEvent.getPropertyName();
                if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
                    SynthSplitPaneUI.this.fetchStyle((JSplitPane)propertyChangeEvent.getSource());
                }
                if (string.equals("orientation")) {
                    SynthSplitPaneUI.this.orientation = SynthSplitPaneUI.this.splitPane.getOrientation();
                    SynthSplitPaneUI.this.resetLayoutManager();
                } else if (string.equals("continuousLayout")) {
                    SynthSplitPaneUI.this.setContinuousLayout(SynthSplitPaneUI.this.splitPane.isContinuousLayout());
                    if (!SynthSplitPaneUI.this.isContinuousLayout()) {
                        if (SynthSplitPaneUI.this.nonContinuousLayoutDivider == null) {
                            SynthSplitPaneUI.this.setNonContinuousLayoutDivider(SynthSplitPaneUI.this.createDefaultNonContinuousLayoutDivider(), true);
                        } else if (SynthSplitPaneUI.this.nonContinuousLayoutDivider.getParent() == null) {
                            SynthSplitPaneUI.this.setNonContinuousLayoutDivider(SynthSplitPaneUI.this.nonContinuousLayoutDivider, true);
                        }
                    }
                } else if (string.equals("dividerSize")) {
                    SynthSplitPaneUI.this.divider.setDividerSize(SynthSplitPaneUI.this.splitPane.getDividerSize());
                    SynthSplitPaneUI.this.dividerSize = SynthSplitPaneUI.this.divider.getDividerSize();
                    SynthSplitPaneUI.this.splitPane.revalidate();
                    SynthSplitPaneUI.this.splitPane.repaint();
                }
            }
        }
    }
}

