/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.kerberos;

import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.EncryptionKey;
import com.ibm.security.krb5.KrbException;
import com.ibm.security.krb5.PrincipalName;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import javax.security.auth.kerberos.KerberosPrincipal;

class KeyImpl
implements SecretKey,
Destroyable,
Serializable {
    private transient byte[] keyBytes;
    private transient int keyType;
    private transient boolean destroyed = false;

    public KeyImpl(byte[] keyBytes, int keyType) {
        this.keyBytes = (byte[])keyBytes.clone();
        this.keyType = keyType;
    }

    public KeyImpl(KerberosPrincipal principal, char[] password, String algorithm) {
        try {
            PrincipalName princ = new PrincipalName(principal.getName());
            String passStr = new String(password);
            int algorithmType = 0;
            algorithmType = algorithm.equalsIgnoreCase("3DES") ? 16 : (algorithm.equalsIgnoreCase("DES") ? 3 : (algorithm.equalsIgnoreCase("RC4") ? 23 : (algorithm.equalsIgnoreCase("null") ? 0 : 0)));
            EncryptionKey key = null;
            key = algorithmType != 0 ? new EncryptionKey(passStr, princ.getSalt(), algorithmType) : new EncryptionKey(passStr, princ.getSalt());
            this.keyBytes = key.getBytes();
            this.keyType = key.getEType();
        }
        catch (KrbException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public final int getKeyType() {
        if (this.destroyed) {
            throw new IllegalStateException("This key is no longer valid");
        }
        return this.keyType;
    }

    public final String getAlgorithm() {
        return this.getAlgorithmName(this.keyType);
    }

    private String getAlgorithmName(int eType) {
        if (this.destroyed) {
            throw new IllegalStateException("This key is no longer valid");
        }
        if (eType == 0) {
            return "NULL";
        }
        if (eType == 1 || eType == 3) {
            return "DES";
        }
        if (eType == 16) {
            return "3DES";
        }
        if (eType == 23 || eType == 24) {
            return "RC4";
        }
        return "NULL";
    }

    public final String getFormat() {
        if (this.destroyed) {
            throw new IllegalStateException("This key is no longer valid");
        }
        return "RAW";
    }

    public final byte[] getEncoded() {
        if (this.destroyed) {
            throw new IllegalStateException("This key is no longer valid");
        }
        return (byte[])this.keyBytes.clone();
    }

    public void destroy() throws DestroyFailedException {
        if (!this.destroyed) {
            Arrays.fill(this.keyBytes, (byte)0);
            this.destroyed = true;
        }
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    private synchronized void writeObject(ObjectOutputStream ois) throws IOException {
        if (this.destroyed) {
            throw new IOException("This key is no longer valid");
        }
        try {
            ois.writeObject(new EncryptionKey(this.keyType, this.keyBytes).asn1Encode());
        }
        catch (Asn1Exception ae) {
            throw new IOException(ae.getMessage());
        }
    }

    private synchronized void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        try {
            EncryptionKey encKey = new EncryptionKey(new DerValue((byte[])ois.readObject()));
            this.keyType = encKey.getEType();
            this.keyBytes = encKey.getBytes();
        }
        catch (Asn1Exception ae) {
            throw new IOException(ae.getMessage());
        }
    }

    public String toString() {
        HexDumpEncoder hd = new HexDumpEncoder();
        return new String("EncryptionKey: keyType=" + this.keyType + " keyBytes (hex dump)=" + (this.keyBytes == null || this.keyBytes.length == 0 ? " Empty Key" : '\n' + hd.encode(this.keyBytes) + '\n'));
    }
}

