/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.basic;

import com.ibm.gsk.ikeyman.basic.BERObject;
import com.ibm.gsk.ikeyman.basic.CMSKeyDatabase;
import com.ibm.gsk.ikeyman.basic.CMSKeyDatabaseException;
import com.ibm.gsk.ikeyman.basic.DNItem;
import com.ibm.gsk.ikeyman.basic.EncryptedPrivateKeyInfoItem;
import com.ibm.gsk.ikeyman.basic.KMSystem;
import com.ibm.gsk.ikeyman.basic.KMUtil;
import com.ibm.gsk.ikeyman.basic.KeyDatabase;
import com.ibm.gsk.ikeyman.basic.KeyDatabaseException;
import com.ibm.gsk.ikeyman.basic.KeyDatabaseOperator;
import com.ibm.gsk.ikeyman.basic.KeyItem;
import com.ibm.gsk.ikeyman.basic.PrivateKeyInfoItem;
import java.io.File;
import java.util.Vector;

public class WEBDBKeyDatabase
extends KeyDatabase
implements KeyDatabaseOperator {
    private CMSKeyDatabase cmsKeyDbCopy;

    public static native boolean c_IsPasswordRequired(String var0);

    public WEBDBKeyDatabase() {
        this.type = 2;
        this.op = this;
        this.cmsKeyDbCopy = this.getTmpCMSKeyDatabaseCopy();
    }

    public WEBDBKeyDatabase(KeyDatabase keyDatabase) {
        super(keyDatabase);
        this.type = 2;
        this.op = this;
        this.cmsKeyDbCopy = this.getTmpCMSKeyDatabaseCopy();
    }

    public WEBDBKeyDatabase(String string, String string2) {
        super(2, string, string2);
        this.op = this;
        this.cmsKeyDbCopy = this.getTmpCMSKeyDatabaseCopy();
    }

    public WEBDBKeyDatabase(String string, String string2, long l) {
        super(2, string, string2, l);
        this.op = this;
        this.cmsKeyDbCopy = this.getTmpCMSKeyDatabaseCopy();
    }

    public WEBDBKeyDatabase(String string) {
        super(2, string);
        this.op = this;
    }

    public static boolean isPasswordNeeded(String string) {
        return WEBDBKeyDatabase.c_IsPasswordRequired(string);
    }

    private CMSKeyDatabase getTmpCMSKeyDatabaseCopy() {
        String string = KMUtil.getTmpFileName(this.keyDbFileName, "_tmp" + KeyDatabase.DEFAULT_KEYDB_NAME_EXT_CMS, ".rdb");
        if (string == null) {
            string = this.getKeyDbFileNameWithType(1);
        }
        return new CMSKeyDatabase(string, this.keyDbPwd, this.keyDbPwdExpireTime);
    }

    public CMSKeyDatabase getCMSKeyDatabaseCopy() {
        return this.cmsKeyDbCopy;
    }

    public void create() throws CMSKeyDatabaseException {
        this.cmsKeyDbCopy.create();
        this.makeCopyFromKdb(this.cmsKeyDbCopy);
    }

    public void open() throws CMSKeyDatabaseException {
        this.cmsKeyDbCopy.makeCopyFromKyr(this);
        this.cmsKeyDbCopy.open();
        this.copyKeyLabelLists(this.cmsKeyDbCopy);
    }

    public void close() {
        String string;
        File file;
        String string2;
        File file2;
        File file3 = new File(this.cmsKeyDbCopy.getKeyDbFileName());
        if (file3.exists()) {
            file3.delete();
        }
        if ((file2 = new File(string2 = KMUtil.changeFileNameExtension(this.cmsKeyDbCopy.getKeyDbFileName(), KeyDatabase.DEFAULT_KEYDB_NAME_EXT_CMS, ".rdb"))).exists()) {
            file2.delete();
        }
        if ((file = new File(string = KMUtil.changeFileNameExtension(this.cmsKeyDbCopy.getKeyDbFileName(), KeyDatabase.DEFAULT_KEYDB_NAME_EXT_CMS, ".crl"))).exists()) {
            file.delete();
        }
    }

    public void save() {
    }

    public void makeCopyFromKdb(CMSKeyDatabase cMSKeyDatabase) throws CMSKeyDatabaseException {
        String string = KMUtil.getTmpFileName(this.keyDbFileName, "_tmp");
        int n = CMSKeyDatabase.c_Kdb2Kyr(cMSKeyDatabase.getKeyDbFileName(), cMSKeyDatabase.getKeyDbPwd(), string, this.keyDbPwd);
        File file = new File(string);
        File file2 = new File(this.keyDbFileName);
        if (n != 0) {
            if (file.exists()) {
                file.delete();
            }
            throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_KDB2KYR"));
        }
        file2.delete();
        file.renameTo(file2);
        this.buildKeyLabelList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void reCreate(KeyDatabase keyDatabase) throws CMSKeyDatabaseException {
        if (this.keyDbFileName == null || this.keyDbFileName.equals(keyDatabase.getKeyDbFileName())) {
            throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_INVALID_FILE_NAME"));
        }
        KeyDatabaseOperator keyDatabaseOperator = (KeyDatabaseOperator)((Object)keyDatabase);
        try {
            if (this.type != keyDatabase.getType()) {
                if (keyDatabase.getType() == 3) {
                    this.cmsKeyDbCopy.reCreate(keyDatabase);
                    this.reCreate(this.cmsKeyDbCopy);
                    return;
                } else {
                    if (keyDatabase.getType() != 1) throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_INVALID_TYPE"));
                    int n = CMSKeyDatabase.c_Kdb2Kyr(keyDatabase.getKeyDbFileName(), keyDatabase.getKeyDbPwd(), this.keyDbFileName, this.keyDbPwd);
                    if (n != 0) {
                        throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_KDB2KYR"));
                    }
                    this.copyKeyLabelLists(keyDatabase);
                }
                return;
            } else {
                File file;
                File file2;
                String string = "temp.kdb";
                String string2 = "0909";
                int n = CMSKeyDatabase.c_Kyr2Kdb(keyDatabase.getKeyDbFileName(), keyDatabase.getKeyDbPwd(), string, string2);
                n = CMSKeyDatabase.c_Kdb2Kyr(string, string2, this.keyDbFileName, this.keyDbPwd);
                this.cmsKeyDbCopy = this.getTmpCMSKeyDatabaseCopy();
                this.copyKeyLabelLists(keyDatabase);
                File file3 = new File(string);
                if (file3.exists()) {
                    file3.delete();
                }
                if ((file2 = new File("temp.crl")).exists()) {
                    file2.delete();
                }
                if (!(file = new File("temp.rdb")).exists()) return;
                file.delete();
            }
            return;
        }
        catch (CMSKeyDatabaseException cMSKeyDatabaseException) {
            throw cMSKeyDatabaseException;
        }
        catch (KeyDatabaseException keyDatabaseException) {
            throw new CMSKeyDatabaseException();
        }
    }

    private void reCreateOld(KeyDatabase keyDatabase) throws CMSKeyDatabaseException {
        if (this.keyDbFileName == null) {
            throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_INVALID_FILE_NAME"));
        }
        KeyDatabaseOperator keyDatabaseOperator = (KeyDatabaseOperator)((Object)keyDatabase);
        try {
            if (keyDatabase.getType() == 3) {
                this.cmsKeyDbCopy.reCreate(keyDatabase);
                this.reCreate(this.cmsKeyDbCopy);
            } else if (this.keyDbFileName.equals(keyDatabase.getKeyDbFileName()) && this.type != keyDatabase.getType()) {
                if (keyDatabase.getType() == 1) {
                    String string = KMUtil.getTmpFileName(this.keyDbFileName, "_tmp");
                    int n = CMSKeyDatabase.c_Kdb2Kyr(keyDatabase.getKeyDbFileName(), keyDatabase.getKeyDbPwd(), string, this.keyDbPwd);
                    File file = new File(string);
                    File file2 = new File(this.keyDbFileName);
                    if (n != 0) {
                        if (file.exists()) {
                            file.delete();
                        }
                        throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_KDB2KYR"));
                    }
                    file2.delete();
                    file.renameTo(file2);
                } else {
                    Vector<KeyItem> vector = new Vector<KeyItem>();
                    KeyItem keyItem = keyDatabaseOperator.getFirstKeyItem();
                    while (keyItem != null) {
                        vector.addElement(keyItem);
                        keyItem = keyDatabaseOperator.getNextKeyItem();
                    }
                    File file = new File(this.keyDbFileName);
                    file.delete();
                    this.create();
                    int n = vector.size();
                    int n2 = 0;
                    while (n2 < n) {
                        this.insertKey((KeyItem)vector.elementAt(n2));
                        ++n2;
                    }
                }
                this.copyKeyLabelLists(keyDatabase);
            } else if (!this.keyDbFileName.equals(keyDatabase.getKeyDbFileName())) {
                if (keyDatabase.getType() == 1) {
                    int n = CMSKeyDatabase.c_Kdb2Kyr(keyDatabase.getKeyDbFileName(), keyDatabase.getKeyDbPwd(), this.keyDbFileName, this.keyDbPwd);
                    if (n != 0) {
                        throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_KDB2KYR"));
                    }
                } else {
                    this.create();
                    KeyItem keyItem = keyDatabaseOperator.getFirstKeyItem();
                    while (keyItem != null) {
                        this.insertKey(keyItem);
                        keyItem = keyDatabaseOperator.getNextKeyItem();
                    }
                }
                this.copyKeyLabelLists(keyDatabase);
            } else {
                this.copyKeyLabelLists(keyDatabase);
            }
        }
        catch (CMSKeyDatabaseException cMSKeyDatabaseException) {
            throw cMSKeyDatabaseException;
        }
        catch (KeyDatabaseException keyDatabaseException) {
            throw new CMSKeyDatabaseException();
        }
    }

    public void changeKeyDbPwd(String string, long l) throws CMSKeyDatabaseException {
        this.changeKeyDbPwd(null, string, l);
    }

    public void changeKeyDbPwd(String string, String string2, long l) throws CMSKeyDatabaseException {
        this.cmsKeyDbCopy.changeKeyDbPwd(string, string2, l);
        this.keyDbPwd = string2;
        this.keyDbPwdExpireTime = l;
        this.makeCopyFromKdb(this.cmsKeyDbCopy);
    }

    public void createNewSelfSignedCertificate(int n, String string, boolean bl, int n2, DNItem dNItem, int n3, String string2, boolean bl2) throws CMSKeyDatabaseException {
        this.cmsKeyDbCopy.createNewSelfSignedCertificate(n, string, bl, n2, dNItem, n3, string2, bl2);
        this.makeCopyFromKdb(this.cmsKeyDbCopy);
    }

    public void createNewSelfSignedCertificate(int n, String string, boolean bl, int n2, DNItem dNItem, int n3, int n4, String string2, boolean bl2, Vector vector) throws CMSKeyDatabaseException {
        this.cmsKeyDbCopy.createNewSelfSignedCertificate(n, string, bl, n2, dNItem, n3, n4, string2, bl2, vector);
        this.makeCopyFromKdb(this.cmsKeyDbCopy);
    }

    public void createNewCertRequest(String string, int n, DNItem dNItem, String string2, boolean bl) throws CMSKeyDatabaseException {
        this.cmsKeyDbCopy.createNewCertRequest(string, n, dNItem, string2, bl);
        this.makeCopyFromKdb(this.cmsKeyDbCopy);
    }

    public void createNewCertRequest(String string, int n, DNItem dNItem, int n2, String string2, boolean bl, Vector vector) throws CMSKeyDatabaseException {
        this.cmsKeyDbCopy.createNewCertRequest(string, n, dNItem, n2, string2, bl, vector);
        this.makeCopyFromKdb(this.cmsKeyDbCopy);
    }

    public boolean isPrivateKeyPresent(String string) {
        return this.cmsKeyDbCopy.isPrivateKeyPresent(string);
    }

    public void buildKeyLabelList() throws CMSKeyDatabaseException {
        this.cmsKeyDbCopy.buildKeyLabelList();
        this.copyKeyLabelLists(this.cmsKeyDbCopy);
    }

    public void classifyKeyLabels() {
        this.myCertLabelList = null;
        this.caCertLabelList = null;
        if (this.keyLabelList == null) {
            return;
        }
        int n = this.keyLabelList.size();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)this.keyLabelList.elementAt(n2);
            if (this.isPrivateKeyPresent(string)) {
                this.addMyCertLabel(string);
            } else {
                this.addCaCertLabel(string);
            }
            ++n2;
        }
    }

    public void refreshKeyLabelList() throws CMSKeyDatabaseException {
        this.cmsKeyDbCopy.refreshKeyLabelList();
        this.copyKeyLabelLists(this.cmsKeyDbCopy);
    }

    public KeyItem getKeyItemByLabel(String string) throws CMSKeyDatabaseException {
        return this.cmsKeyDbCopy.getKeyItemByLabel(string);
    }

    public KeyItem[] getKeyItemListByLabel(String string) throws CMSKeyDatabaseException {
        return this.cmsKeyDbCopy.getKeyItemListByLabel(string);
    }

    public Vector getKeyItemsByPublicKey(BERObject bERObject) throws CMSKeyDatabaseException {
        return this.cmsKeyDbCopy.getKeyItemsByPublicKey(bERObject);
    }

    public KeyItem getDefaultKeyItem() throws CMSKeyDatabaseException {
        return this.cmsKeyDbCopy.getDefaultKeyItem();
    }

    public synchronized KeyItem getFirstKeyItem() throws CMSKeyDatabaseException {
        return this.cmsKeyDbCopy.getFirstKeyItem();
    }

    public synchronized KeyItem getNextKeyItem() throws CMSKeyDatabaseException {
        return this.cmsKeyDbCopy.getNextKeyItem();
    }

    public void deleteKeyByLabel(String string) throws CMSKeyDatabaseException {
        this.cmsKeyDbCopy.deleteKeyByLabel(string);
        this.makeCopyFromKdb(this.cmsKeyDbCopy);
    }

    public void insertKey(KeyItem keyItem) throws CMSKeyDatabaseException {
        this.cmsKeyDbCopy.insertKey(keyItem);
        this.makeCopyFromKdb(this.cmsKeyDbCopy);
    }

    public void setDefaultKey(String string) throws CMSKeyDatabaseException {
        this.cmsKeyDbCopy.setDefaultKey(string);
        this.makeCopyFromKdb(this.cmsKeyDbCopy);
    }

    public void setKeyTrust(String string, boolean bl) throws CMSKeyDatabaseException {
        this.cmsKeyDbCopy.setKeyTrust(string, bl);
        this.makeCopyFromKdb(this.cmsKeyDbCopy);
    }

    public void exportToPFXFile(String string, String string2, String[] stringArray) throws CMSKeyDatabaseException {
        this.cmsKeyDbCopy.exportToPFXFile(string, string2, stringArray);
    }

    public void importFromPFXFile(String string, String string2) throws CMSKeyDatabaseException {
        this.cmsKeyDbCopy.importFromPFXFile(string, string2);
        this.makeCopyFromKdb(this.cmsKeyDbCopy);
    }

    public void receiveCertificate(String string, boolean bl, boolean bl2) throws CMSKeyDatabaseException {
        this.cmsKeyDbCopy.receiveCertificate(string, bl, bl2);
        this.makeCopyFromKdb(this.cmsKeyDbCopy);
    }

    public void addCACertificate(String string, String string2, boolean bl) throws CMSKeyDatabaseException {
        this.cmsKeyDbCopy.addCACertificate(string, string2, bl);
        this.makeCopyFromKdb(this.cmsKeyDbCopy);
    }

    public void extractCertificate(String string, String string2, boolean bl) throws CMSKeyDatabaseException {
        this.cmsKeyDbCopy.extractCertificate(string, string2, bl);
    }

    public void extractCertificateRequest(String string, String string2) throws CMSKeyDatabaseException {
        this.cmsKeyDbCopy.extractCertificateRequest(string, string2);
    }

    public void extractCertificateRequest(String string, int n, String string2) throws CMSKeyDatabaseException {
        this.cmsKeyDbCopy.extractCertificateRequest(string, n, string2);
    }

    public PrivateKeyInfoItem decryptPrivateKey(EncryptedPrivateKeyInfoItem encryptedPrivateKeyInfoItem) throws CMSKeyDatabaseException {
        return this.cmsKeyDbCopy.decryptPrivateKey(encryptedPrivateKeyInfoItem);
    }

    public EncryptedPrivateKeyInfoItem encryptPrivateKey(PrivateKeyInfoItem privateKeyInfoItem) throws CMSKeyDatabaseException {
        return this.cmsKeyDbCopy.encryptPrivateKey(privateKeyInfoItem);
    }

    public void addSiteCertificate(String string, String string2, boolean bl) throws CMSKeyDatabaseException {
        throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_OP_NULL"));
    }

    public String toString() {
        return this.paramString();
    }

    public String paramString() {
        return super.paramString() + ", cmsKeyDbCopy=" + this.cmsKeyDbCopy;
    }
}

