/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs7;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcs7.AuthenticatedData;
import com.ibm.security.pkcs7.Content;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.Data;
import com.ibm.security.pkcs7.DigestedData;
import com.ibm.security.pkcs7.EncryptedData;
import com.ibm.security.pkcs7.EnvelopedData;
import com.ibm.security.pkcs7.PKCS7;
import com.ibm.security.pkcs7.SignedAndEnvelopedData;
import com.ibm.security.pkcs7.SignedData;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.pkcsutil.SmudgedBytes;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.KeySpec;
import java.util.StringTokenizer;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.SecretKeySpec;

public final class EncryptedContentInfo
extends PKCSDerObject
implements Cloneable {
    private static final byte TAG_ENCRYPTED_CONTENT = 0;
    private ObjectIdentifier contentType;
    private AlgorithmId contentEncryptionAlgorithm;
    private byte[] encryptedContent;
    private SmudgedBytes encryptionKeyBytes;
    private static final String MODE_AND_PADDING = "/CBC/PKCS5Padding";
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs7.EncryptedContentInfo";

    public EncryptedContentInfo(byte[] byArray) throws IOException {
        super(byArray);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "EncryptedContentInfo", (Object)byArray);
            debug.exit(16384L, className, "EncryptedContentInfo");
        }
    }

    public EncryptedContentInfo(byte[] byArray, String string) throws IOException {
        super(byArray, string);
        if (debug != null) {
            debug.entry(16384L, className, "EncryptedContentInfo", byArray, string);
            debug.exit(16384L, className, "EncryptedContentInfo");
        }
    }

    public EncryptedContentInfo(ObjectIdentifier objectIdentifier, AlgorithmId algorithmId, byte[] byArray) {
        if (debug != null) {
            Object[] objectArray = new Object[]{objectIdentifier, algorithmId, byArray};
            debug.entry(16384L, (Object)className, "EncryptedContentInfo", objectArray);
        }
        this.contentType = objectIdentifier;
        this.contentEncryptionAlgorithm = algorithmId;
        this.encryptedContent = byArray;
        if (debug != null) {
            debug.exit(16384L, className, "EncryptedContentInfo");
        }
    }

    public EncryptedContentInfo(ObjectIdentifier objectIdentifier, AlgorithmId algorithmId, byte[] byArray, String string) {
        super(string);
        if (debug != null) {
            Object[] objectArray = new Object[]{objectIdentifier, algorithmId, byArray, string};
            debug.entry(16384L, (Object)className, "EncryptedContentInfo", objectArray);
        }
        this.contentType = objectIdentifier;
        this.contentEncryptionAlgorithm = algorithmId;
        this.encryptedContent = byArray;
        if (debug != null) {
            debug.exit(16384L, className, "EncryptedContentInfo");
        }
    }

    public EncryptedContentInfo(ContentInfo contentInfo, String string, int n, String string2) throws PKCSException, IOException {
        super(string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{contentInfo, string, new Integer(n), string2};
            debug.entry(16384L, (Object)className, "EncryptedContentInfo", objectArray);
        }
        this.encrypt(contentInfo, string, n);
        if (debug != null) {
            debug.exit(16384L, className, "EncryptedContentInfo");
        }
    }

    public EncryptedContentInfo(ContentInfo contentInfo, String string, int n) throws PKCSException, IOException {
        if (debug != null) {
            Object[] objectArray = new Object[]{contentInfo, string, new Integer(n)};
            debug.entry(16384L, (Object)className, "EncryptedContentInfo", objectArray);
        }
        this.encrypt(contentInfo, string, n);
        if (debug != null) {
            debug.exit(16384L, className, "EncryptedContentInfo");
        }
    }

    public EncryptedContentInfo(ContentInfo contentInfo, String string, byte[] byArray) throws PKCSException, IOException {
        if (debug != null) {
            Object[] objectArray = new Object[]{contentInfo, string, byArray};
            debug.entry(16384L, (Object)className, "EncryptedContentInfo", objectArray);
        }
        this.encrypt(contentInfo, string, byArray);
        if (debug != null) {
            debug.exit(16384L, className, "EncryptedContentInfo");
        }
    }

    public EncryptedContentInfo(ContentInfo contentInfo, String string, byte[] byArray, String string2) throws PKCSException, IOException {
        super(string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{contentInfo, string, byArray, string2};
            debug.entry(16384L, (Object)className, "EncryptedContentInfo", objectArray);
        }
        this.encrypt(contentInfo, string, byArray);
        if (debug != null) {
            debug.exit(16384L, className, "EncryptedContentInfo");
        }
    }

    public EncryptedContentInfo(String string, boolean bl) throws IOException {
        super(string, bl);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl)};
            debug.entry(16384L, (Object)className, "EncryptedContentInfo", objectArray);
            debug.exit(16384L, className, "EncryptedContentInfo");
        }
    }

    public EncryptedContentInfo(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl), string2};
            debug.entry(16384L, (Object)className, "EncryptedContentInfo", objectArray);
            debug.exit(16384L, className, "EncryptedContentInfo");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putOID(this.contentType);
        this.contentEncryptionAlgorithm.encode(derOutputStream);
        if (this.encryptedContent != null) {
            DerOutputStream derOutputStream3 = new DerOutputStream();
            derOutputStream3.putOctetString(this.encryptedContent);
            derOutputStream.writeImplicit(DerValue.createTag((byte)-128, false, (byte)0), derOutputStream3);
        }
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        DerValue derValue2;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "EncryptedContentInfo parsing error.");
            }
            throw new IOException("EncryptedContentInfo parsing error.");
        }
        this.contentType = derValue.getData().getOID();
        DerValue derValue3 = derValue.getData().getDerValue();
        this.contentEncryptionAlgorithm = AlgorithmId.parse(derValue3);
        if (derValue.getData().available() != 0 && (derValue2 = derValue.getData().getDerValue()).isContextSpecific((byte)0)) {
            if (derValue2.isConstructed()) {
                byte[] byArray = derValue2.getData().toByteArray();
                this.encryptedContent = PKCS7.stripOctetTags(byArray);
            } else {
                derValue2.resetTag((byte)4);
                this.encryptedContent = derValue2.getOctetString();
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    public boolean equals(Object object) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (!(object instanceof EncryptedContentInfo)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (object == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(true));
            }
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            ((EncryptedContentInfo)object).encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", exception);
                debug.exit(16384L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }

    public String toString() {
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        String string = "PKCS7 EncryptedContentInfo:\r\n";
        string = string + "\tcontentType: " + this.contentType;
        string = string + "\r\n\tcontentEncryptionAlgorithm: " + this.contentEncryptionAlgorithm;
        string = this.encryptedContent != null ? string + "\r\n\tencryptedDigest: \r\n" + hexDumpEncoder.encodeBuffer(this.encryptedContent) + "\r\n" : string + "\r\n\tencryptedContent: null";
        return string;
    }

    private void encrypt(ContentInfo contentInfo, String string, int n) throws PKCSException, IOException {
        Cipher cipher;
        Object object;
        AlgorithmId algorithmId;
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{contentInfo, string, new Integer(n)};
            debug.entry(8192L, (Object)className, "encrypt", objectArray);
        }
        Object[] objectArray2 = objectArray = EncryptedContentInfo.getAlgorithm(string);
        if (objectArray.equalsIgnoreCase("AES")) {
            if (n != 128 && n != 192 && n != 256) {
                throw new IllegalArgumentException("Invalid key size " + n + ". Must be 128, " + "192 or 256 for AES key");
            }
            switch (n) {
                case 128: {
                    objectArray2 = "AES128";
                    break;
                }
                case 192: {
                    objectArray2 = "AES192";
                    break;
                }
                case 256: {
                    objectArray2 = "AES256";
                    break;
                }
            }
        }
        try {
            algorithmId = AlgorithmId.get((String)objectArray2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (debug != null) {
                debug.exception(8192L, className, "encrypt", noSuchAlgorithmException);
            }
            throw new IllegalArgumentException("Unsupported algorithm " + (String)objectArray + ". Must be one of AES, DES, DESede or RC2.");
        }
        this.contentType = contentInfo.getContentType();
        DerOutputStream derOutputStream = new DerOutputStream();
        contentInfo.getContent().encode(derOutputStream);
        DerValue derValue = new DerValue(derOutputStream.toByteArray());
        byte[] byArray = derValue.getData().toByteArray();
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance((String)objectArray);
            keyGenerator.init(n);
            SecretKey secretKey = keyGenerator.generateKey();
            this.setEncryptionKeyBytes(secretKey.getEncoded());
            object = (String)objectArray + MODE_AND_PADDING;
            cipher = this.provider != null ? Cipher.getInstance((String)object, this.provider) : Cipher.getInstance((String)object);
            cipher.init(1, secretKey);
            this.encryptedContent = cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(8192L, className, "encrypt", exception);
            }
            throw new PKCSException(exception, "Error encrypting contents (" + exception.toString() + ")");
        }
        object = cipher.getParameters();
        byte[] byArray2 = null;
        if (object != null) {
            byArray2 = ((AlgorithmParameters)object).getEncoded();
        }
        try {
            algorithmId = AlgorithmId.get((String)objectArray2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (debug != null) {
                debug.exception(8192L, className, "encrypt", noSuchAlgorithmException);
            }
            throw new IllegalArgumentException("Unsupported algorithm " + (String)objectArray + ". Must be one of DES, DESede or RC2.");
        }
        ObjectIdentifier objectIdentifier = algorithmId.getOID();
        this.contentEncryptionAlgorithm = byArray2 != null ? new AlgorithmId(objectIdentifier, byArray2, this.provider) : new AlgorithmId(objectIdentifier, this.provider);
        if (debug != null) {
            debug.exit(8192L, className, "encrypt");
        }
    }

    private void encrypt(ContentInfo contentInfo, String string, byte[] byArray) throws PKCSException, IOException {
        SecretKey secretKey;
        Object object;
        Object object2;
        ObjectIdentifier objectIdentifier;
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{contentInfo, string, byArray};
            debug.entry(8192L, (Object)className, "encrypt", objectArray);
        }
        Object object3 = objectArray = EncryptedContentInfo.getAlgorithm(string);
        if (objectArray.equalsIgnoreCase("AES")) {
            if (byArray.length != 16 && byArray.length != 24 && byArray.length != 32) {
                throw new IllegalArgumentException("Invalid key size " + byArray.length + ". Must be 128, " + "192 or 256 for AES key");
            }
            switch (byArray.length) {
                case 128: {
                    object3 = "AES128";
                    break;
                }
                case 192: {
                    object3 = "AES192";
                    break;
                }
                case 256: {
                    object3 = "AES256";
                    break;
                }
            }
        }
        try {
            AlgorithmId algorithmId = AlgorithmId.get((String)object3);
            objectIdentifier = algorithmId.getOID();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (debug != null) {
                debug.exception(8192L, className, "encrypt", noSuchAlgorithmException);
            }
            throw new IllegalArgumentException("Unsupported algorithm " + (String)objectArray + ". Must be one of AES, DES, DESede or RC2.");
        }
        this.contentType = contentInfo.getContentType();
        DerOutputStream derOutputStream = new DerOutputStream();
        contentInfo.getContent().encode(derOutputStream);
        DerValue derValue = new DerValue(derOutputStream.toByteArray());
        byte[] byArray2 = derValue.getData().toByteArray();
        try {
            if (objectIdentifier.equals(AlgorithmId.DESCBC_oid)) {
                object2 = new DESKeySpec(byArray);
                object = this.provider != null ? SecretKeyFactory.getInstance(string, this.provider) : SecretKeyFactory.getInstance(string);
                secretKey = ((SecretKeyFactory)object).generateSecret((KeySpec)object2);
            } else if (objectIdentifier.equals(AlgorithmId.tripleDESCBC_oid)) {
                object2 = new DESedeKeySpec(byArray);
                object = this.provider != null ? SecretKeyFactory.getInstance(string, this.provider) : SecretKeyFactory.getInstance(string);
                secretKey = ((SecretKeyFactory)object).generateSecret((KeySpec)object2);
            } else {
                object2 = new SecretKeySpec(byArray, "RC2");
                object = this.provider != null ? SecretKeyFactory.getInstance(string, this.provider) : SecretKeyFactory.getInstance(string);
                secretKey = ((SecretKeyFactory)object).generateSecret((KeySpec)object2);
            }
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(8192L, className, "encrypt", exception);
            }
            throw new PKCSException(exception, "Key generation error (" + exception.toString() + ")");
        }
        try {
            object2 = (String)objectArray + MODE_AND_PADDING;
            object = this.provider != null ? Cipher.getInstance((String)object2, this.provider) : Cipher.getInstance((String)object2);
            ((Cipher)object).init(1, secretKey);
            this.encryptedContent = ((Cipher)object).doFinal(byArray2);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(8192L, className, "encrypt", exception);
            }
            throw new PKCSException(exception, "Error encrypting contents (" + exception.toString() + ")");
        }
        object2 = ((Cipher)object).getParameters();
        byte[] byArray3 = null;
        if (object2 != null) {
            byArray3 = ((AlgorithmParameters)object2).getEncoded();
        }
        this.contentEncryptionAlgorithm = byArray3 != null ? new AlgorithmId(objectIdentifier, byArray3, this.provider) : new AlgorithmId(objectIdentifier, this.provider);
        if (debug != null) {
            debug.exit(8192L, className, "encrypt");
        }
    }

    public ContentInfo decrypt(byte[] byArray) throws IOException, PKCSException {
        byte[] byArray2;
        Object object;
        Object object2;
        Object object3;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decrypt", (Object)byArray);
        }
        if (this.encryptedContent == null) {
            if (debug != null) {
                debug.text(16384L, className, "decrypt", "No content to decrypt.");
            }
            throw new PKCSException("No content to decrypt.");
        }
        String string = this.contentEncryptionAlgorithm.getName();
        ObjectIdentifier objectIdentifier = this.contentEncryptionAlgorithm.getOID();
        if (!(objectIdentifier.equals(AlgorithmId.DESCBC_oid) || objectIdentifier.equals(AlgorithmId.tripleDESCBC_oid) || objectIdentifier.equals(AlgorithmId.RC2CBC_oid) || objectIdentifier.equals(AlgorithmId.AES128CBC_oid) || objectIdentifier.equals(AlgorithmId.AES192CBC_oid) || objectIdentifier.equals(AlgorithmId.AES256CBC_oid))) {
            if (debug != null) {
                debug.text(16384L, className, "decrypt", "Unsupported decryption algorithm: " + string + ". Must be one of DES, DESede or RC2.");
            }
            throw new IllegalArgumentException("Unsupported decryption algorithm: " + string + ". Must be one of AES, DES, DESede or RC2.");
        }
        try {
            if (objectIdentifier.equals(AlgorithmId.DESCBC_oid)) {
                object3 = new DESKeySpec(byArray);
                object2 = this.provider != null ? SecretKeyFactory.getInstance(string, this.provider) : SecretKeyFactory.getInstance(string);
                object = ((SecretKeyFactory)object2).generateSecret((KeySpec)object3);
            } else if (objectIdentifier.equals(AlgorithmId.tripleDESCBC_oid)) {
                object3 = new DESedeKeySpec(byArray);
                object2 = this.provider != null ? SecretKeyFactory.getInstance(string, this.provider) : SecretKeyFactory.getInstance(string);
                object = ((SecretKeyFactory)object2).generateSecret((KeySpec)object3);
            } else if (objectIdentifier.equals(AlgorithmId.RC2CBC_oid)) {
                object3 = new SecretKeySpec(byArray, "RC2");
                object2 = this.provider != null ? SecretKeyFactory.getInstance(string, this.provider) : SecretKeyFactory.getInstance(string);
                object = ((SecretKeyFactory)object2).generateSecret((KeySpec)object3);
            } else {
                object3 = new SecretKeySpec(byArray, "AES");
                string = "AES";
                object2 = this.provider != null ? SecretKeyFactory.getInstance(string, this.provider) : SecretKeyFactory.getInstance(string);
                object = ((SecretKeyFactory)object2).generateSecret((KeySpec)object3);
            }
            object3 = this.contentEncryptionAlgorithm.getParameters();
            AlgorithmParameters algorithmParameters = this.provider != null ? AlgorithmParameters.getInstance(string, this.provider) : AlgorithmParameters.getInstance(string);
            algorithmParameters.init((byte[])object3);
            String string2 = string + MODE_AND_PADDING;
            Cipher cipher = null;
            cipher = this.provider != null ? Cipher.getInstance(string2, this.provider) : Cipher.getInstance(string2);
            cipher.init(2, (Key)object, algorithmParameters);
            byArray2 = cipher.doFinal(this.encryptedContent);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "decrypt", exception);
            }
            throw new PKCSException(exception, "Content decryption error (" + exception.toString() + ")");
        }
        object = new DerOutputStream();
        if (this.contentType.equals(PKCSOID.DATA_OID)) {
            ((DerOutputStream)object).write((byte)4, byArray2);
            object2 = new Data(((ByteArrayOutputStream)object).toByteArray(), this.provider);
        } else {
            ((DerOutputStream)object).write((byte)48, byArray2);
            object3 = new DerValue(((ByteArrayOutputStream)object).toByteArray());
            if (this.contentType.equals(PKCSOID.SIGNED_DATA_OID)) {
                object2 = new SignedData(((DerValue)object3).toByteArray(), this.provider);
            } else if (this.contentType.equals(PKCSOID.ENVELOPED_DATA_OID)) {
                object2 = new EnvelopedData(((DerValue)object3).toByteArray(), this.provider);
            } else if (this.contentType.equals(PKCSOID.SIGNED_AND_ENVELOPED_DATA_OID)) {
                object2 = new SignedAndEnvelopedData(((DerValue)object3).toByteArray(), this.provider);
            } else if (this.contentType.equals(PKCSOID.DIGESTED_DATA_OID)) {
                object2 = new DigestedData(((DerValue)object3).toByteArray(), this.provider);
            } else if (this.contentType.equals(PKCSOID.ENCRYPTED_DATA_OID)) {
                object2 = new EncryptedData(((DerValue)object3).toByteArray(), this.provider);
            } else if (this.contentType.equals(PKCSOID.AUTHENTICATED_DATA_OID)) {
                object2 = new AuthenticatedData(((DerValue)object3).toByteArray(), this.provider);
            } else {
                if (debug != null) {
                    debug.text(16384L, className, "decrypt", "Unrecognized content type");
                }
                throw new IllegalArgumentException("Unrecognized content type");
            }
        }
        object3 = new ContentInfo((Content)object2);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "decrypt", object3);
        }
        return object3;
    }

    public AlgorithmId getContentEncryptionAlgorithm() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getContentEncryptionAlgorithm");
        }
        if (this.contentEncryptionAlgorithm == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContentEncryptionAlgorithm", null);
            }
            return null;
        }
        AlgorithmId algorithmId = new AlgorithmId(this.contentEncryptionAlgorithm.getOID(), this.contentEncryptionAlgorithm.getParameters(), this.provider);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getContentEncryptionAlgorithm", algorithmId);
        }
        return algorithmId;
    }

    public ObjectIdentifier getContentType() {
        if (debug != null) {
            debug.entry(16384L, className, "getContentType");
            debug.exit(16384L, (Object)className, "getContentType", this.contentType);
        }
        return this.contentType;
    }

    public byte[] getEncryptedContent() {
        if (debug != null) {
            debug.entry(16384L, className, "getEncryptedContent");
            debug.exit(16384L, (Object)className, "getEncryptedContent", this.encryptedContent.clone());
        }
        return (byte[])this.encryptedContent.clone();
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            EncryptedContentInfo encryptedContentInfo = new EncryptedContentInfo(derOutputStream.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", encryptedContentInfo);
            }
            return encryptedContentInfo;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", exception);
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    public byte[] getEncryptionKey() {
        if (debug != null) {
            debug.entry(16384L, className, "getEncryptionKey");
        }
        if (this.encryptionKeyBytes == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getEncryptionKey", null);
            }
            return null;
        }
        byte[] byArray = this.getEncryptionKeyBytes();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getEncryptionKey", byArray.clone());
        }
        return (byte[])byArray.clone();
    }

    static String getAlgorithm(String string) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getAlgorithm", string);
        }
        if (string == null) {
            if (debug != null) {
                debug.text(16384L, className, "getAlgorithm", "No algorithm given");
            }
            throw new IllegalArgumentException("No algorithm given");
        }
        int n = 0;
        String[] stringArray = new String[3];
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        try {
            while (stringTokenizer.hasMoreTokens() && n < 3) {
                stringArray[n++] = stringTokenizer.nextToken();
            }
            if (n == 0 || n == 2 || stringTokenizer.hasMoreTokens()) {
                if (debug != null) {
                    debug.text(16384L, className, "getAlgorithm", "Wrong algorithm format - too many tokens");
                }
                throw new IllegalArgumentException("Wrong algorithm format");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (debug != null) {
                debug.exception(16384L, className, "getAlgorithm", illegalArgumentException);
                debug.text(16384L, className, "setAlgorithm", "Wrong algorithm format");
            }
            throw new IllegalArgumentException("Wrong algorithm format");
        }
        if (!(stringArray[0].equalsIgnoreCase("DES") || stringArray[0].equalsIgnoreCase("tripleDES") || stringArray[0].equalsIgnoreCase("DESede") || stringArray[0].equalsIgnoreCase("3DES") || stringArray[0].equalsIgnoreCase("RC2") || stringArray[0].equalsIgnoreCase("AES"))) {
            if (debug != null) {
                debug.text(16384L, className, "getAlgorithm", "Unsupported encryption algorithm: " + stringArray[0] + ". Must be one of DES, DESede or RC2.");
            }
            throw new IllegalArgumentException("Unsupported encryption algorithm: " + stringArray[0] + ". Must be one of AES, DES, DESede or RC2.");
        }
        if (stringArray[1] != null) {
            if (!stringArray[1].equalsIgnoreCase("CBC") && debug != null) {
                debug.text(16384L, className, "getAlgorithm", "Unsupported encryption mode: " + stringArray[1] + ". Must be CBC.");
            }
            throw new IllegalArgumentException("Unsupported encryption mode: " + stringArray[1] + ". Must be CBC.");
        }
        if (stringArray[2] != null) {
            if (!stringArray[2].equalsIgnoreCase("PKCS5Padding") && debug != null) {
                debug.text(16384L, className, "getAlgorithm", "Unsupported encryption padding: " + stringArray[2] + ". Must be PKCS5Padding.");
            }
            throw new IllegalArgumentException("Unsupported encryption padding: " + stringArray[2] + ". Must be PKCS5Padding.");
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getAlgorithm", stringArray[0]);
        }
        return stringArray[0];
    }

    private void setEncryptionKeyBytes(byte[] byArray) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setEncryptionKeyBytes", (Object)byArray);
        }
        this.encryptionKeyBytes = new SmudgedBytes(byArray, this.provider);
        if (debug != null) {
            debug.exit(8192L, className, "setEncryptionKeyBytes");
        }
    }

    private byte[] getEncryptionKeyBytes() {
        if (debug != null) {
            debug.entry(8192L, className, "getEncryptionKeyBytes");
        }
        if (this.encryptionKeyBytes == null) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "getEncryptionKeyBytes", null);
            }
            return null;
        }
        byte[] byArray = this.encryptionKeyBytes.getClearText();
        if (debug != null) {
            debug.exit(8192L, (Object)className, "getAlgorithm", byArray);
        }
        return byArray;
    }

    protected void finalize() {
        this.encryptionKeyBytes = null;
    }
}

