/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs12;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs12.PKCS12Utils;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Arrays;

public final class PKCS12 {
    static final String MAC_ALGORITHM = "SHA1";
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs12.PKCS12";
    public static final byte KEY_ID = 1;
    public static final byte IV_ID = 2;
    public static final byte MAC_ID = 3;
    public static final int NO_ENCRYPT = 1;
    public static final int PASSWD_ENCRYPT = 2;
    public static final int PUBKEY_ENCRYPT = 3;

    private PKCS12() {
    }

    private PKCS12(String string) {
    }

    public static byte[] genKey(byte by, String string, char[] cArray, byte[] byArray, int n, int n2) throws NoSuchAlgorithmException {
        if (debug != null) {
            Object[] objectArray = new Object[]{new Byte(by), string, cArray, byArray, new Integer(n), new Integer(n2)};
            debug.entry(49152L, (Object)className, "genKey", objectArray);
            debug.exit(49152L, className, "genKey");
        }
        return PKCS12.genKey(by, string, cArray, byArray, n, n2, null);
    }

    public static byte[] genKey(byte by, String string, char[] cArray, byte[] byArray, int n, int n2, String string2) throws NoSuchAlgorithmException {
        int n3;
        int n4;
        if (debug != null) {
            Object[] objectArray = new Object[]{new Byte(by), string, cArray, byArray, new Integer(n), new Integer(n2), string2};
            debug.entry(49152L, (Object)className, "genKey", objectArray);
        }
        if (by != 1 && by != 2 && by != 3) {
            if (debug != null) {
                debug.text(49152L, className, "genKey", "Illegal identifier byte: " + by + ". Must be one of 1, 2 or 3.");
            }
            throw new IllegalArgumentException("Illegal identifier byte: " + by + ". Must be one of 1, 2 or 3.");
        }
        if (string == null || string.length() == 0) {
            if (debug != null) {
                debug.text(49152L, className, "genKey", "No digest algorithm specified.");
            }
            throw new IllegalArgumentException("No digest algorithm specified.");
        }
        if (n <= 0) {
            if (debug != null) {
                debug.text(49152L, className, "genKey", "Iterations must be greater than zero.");
            }
            throw new IllegalArgumentException("Iterations must be greater than zero.");
        }
        if (n2 <= 0) {
            if (debug != null) {
                debug.text(49152L, className, "genKey", "Keybits must be greater than zero.");
            }
            throw new IllegalArgumentException("Keybits must be greater than zero.");
        }
        if (string.equalsIgnoreCase("SHA") || string.equalsIgnoreCase(MAC_ALGORITHM) || string.equalsIgnoreCase("SHA-1")) {
            n4 = 20;
            n3 = 64;
        } else if (string.equalsIgnoreCase("MD2") || string.equalsIgnoreCase("MD5")) {
            n4 = 16;
            n3 = 64;
        } else {
            if (debug != null) {
                debug.text(49152L, className, "genKey", "Unsupported digest algorithm: " + string + ".  Must be one of SHA, MD2 or MD5.");
            }
            throw new IllegalArgumentException("Unsupported digest algorithm: " + string + ".  Must be one of SHA, MD2 or MD5.");
        }
        byte[] byArray2 = PKCS12Utils.ascii2bmp(cArray);
        MessageDigest messageDigest = null;
        if (string2 != null) {
            try {
                messageDigest = MessageDigest.getInstance(string, string2);
            }
            catch (NoSuchProviderException noSuchProviderException) {
                if (debug != null) {
                    debug.text(49152L, className, "genKey", "provider " + string2 + " not found");
                }
                throw new IllegalArgumentException("provider " + string2 + " not found");
            }
        } else {
            messageDigest = MessageDigest.getInstance(string);
        }
        int n5 = PKCS12.roundup(n2, n4) / n4;
        byte[] byArray3 = new byte[n3];
        int n6 = PKCS12.roundup(byArray.length, n3);
        int n7 = PKCS12.roundup(byArray2.length, n3);
        byte[] byArray4 = new byte[n6 + n7];
        byte[] byArray5 = new byte[n2];
        Arrays.fill(byArray3, by);
        PKCS12.concat(byArray, byArray4, 0, n6);
        PKCS12.concat(byArray2, byArray4, n6, n7);
        byte[] byArray6 = new byte[n3];
        byte[] byArray7 = new byte[n3];
        int n8 = 0;
        while (true) {
            messageDigest.update(byArray3);
            messageDigest.update(byArray4);
            byte[] byArray8 = messageDigest.digest();
            for (int i = 1; i < n; ++i) {
                byArray8 = messageDigest.digest(byArray8);
            }
            System.arraycopy(byArray8, 0, byArray5, n4 * n8, Math.min(n2, n4));
            if (n8 + 1 == n5) break;
            PKCS12.concat(byArray8, byArray6, 0, byArray6.length);
            BigInteger bigInteger = new BigInteger(1, byArray6).add(BigInteger.ONE);
            for (int i = 0; i < byArray4.length; i += n3) {
                if (byArray7.length != n3) {
                    byArray7 = new byte[n3];
                }
                System.arraycopy(byArray4, i, byArray7, 0, n3);
                BigInteger bigInteger2 = new BigInteger(1, byArray7);
                bigInteger2 = bigInteger2.add(bigInteger);
                byArray7 = bigInteger2.toByteArray();
                int n9 = byArray7.length - n3;
                if (n9 >= 0) {
                    System.arraycopy(byArray7, n9, byArray4, i, n3);
                    continue;
                }
                if (n9 >= 0) continue;
                Arrays.fill(byArray4, i, i + -n9, (byte)0);
                System.arraycopy(byArray7, 0, byArray4, i + -n9, byArray7.length);
            }
            ++n8;
            n2 -= n4;
        }
        Arrays.fill(byArray2, (byte)0);
        if (debug != null) {
            debug.exit(49152L, (Object)className, "genKey", byArray5);
        }
        return byArray5;
    }

    private static int roundup(int n, int n2) {
        if (debug != null) {
            debug.entry(49152L, className, "roundup", new Integer(n), new Integer(n2));
            debug.exit(49152L, (Object)className, "roundup", (n + (n2 - 1)) / n2 * n2);
        }
        return (n + (n2 - 1)) / n2 * n2;
    }

    private static void concat(byte[] byArray, byte[] byArray2, int n, int n2) {
        int n3 = n2 / byArray.length;
        if (debug != null) {
            Object[] objectArray = new Object[]{byArray, byArray2, new Integer(n), new Integer(n2)};
            debug.entry(49152L, (Object)className, "concat", objectArray);
        }
        int n4 = 0;
        int n5 = 0;
        while (n4 < n3) {
            System.arraycopy(byArray, 0, byArray2, n5 + n, byArray.length);
            ++n4;
            n5 += byArray.length;
        }
        System.arraycopy(byArray, 0, byArray2, n5 + n, n2 - n5);
        if (debug != null) {
            debug.exit(49152L, className, "concat");
        }
    }
}

