/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pkcs11;

import com.ibm.pkcs11.PKCS11;

public class PKCS11SlotInfo {
    public static final int TOKEN_PRESENT = 1;
    public static final int REMOVABLE_DEVICE = 2;
    public static final int HW_SLOT = 4;
    static int[] flagList = new int[]{1, 2, 4};
    static String[] flagNames = new String[]{"TOKEN_PRESENT", "REMOVABLE_DEVICE", "HW_SLOT"};
    private String description;
    private String manufacturer;
    private int flags;
    private int hardwareVersion;
    private int firmwareVersion;

    public PKCS11SlotInfo(String string, String string2, int n, int n2, int n3) {
        this.description = string;
        this.manufacturer = string2;
        this.flags = n;
        this.hardwareVersion = n2;
        this.firmwareVersion = n3;
    }

    public String description() {
        return this.description;
    }

    public String manufacturer() {
        return this.manufacturer;
    }

    public int flags() {
        return this.flags;
    }

    public int hardwareVersion() {
        return this.hardwareVersion;
    }

    public int firmwareVersion() {
        return this.firmwareVersion;
    }

    public boolean tokenPresent() {
        return (this.flags & 1) != 0;
    }

    public boolean removableDevice() {
        return (this.flags & 2) != 0;
    }

    public boolean hardwareSlot() {
        return (this.flags & 4) != 0;
    }

    public String toString() {
        return "PKCS11SlotInfo:\n    Description:       " + this.description + "\n    Manufacturer:      " + this.manufacturer + "\n    Flags:             " + this.flagsToString(" | ") + "\n    Hardware version:  " + PKCS11.versionString(this.hardwareVersion) + "\n    Firmware version:  " + PKCS11.versionString(this.firmwareVersion);
    }

    public String flagsToString(String string) {
        return PKCS11.flagsToString(this.flags, flagList, flagNames, string);
    }
}

