/*
 * Decompiled with CFR 0.152.
 */
package sun.text.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import sun.misc.Launcher;
import sun.security.action.GetPropertyAction;

public class LocaleData {
    private static Vector classPathSegments;
    private static Locale[] localeList;
    private static final String PACKAGE = "sun.text.resources";
    private static final String PREFIX = "LocaleElements_";
    private static final char ZIPSEPARATOR = '/';
    static /* synthetic */ Class class$sun$text$resources$LocaleData;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Locale[] getAvailableLocales(String string) {
        Locale[] localeArray;
        if (localeList == null) {
            localeArray = class$sun$text$resources$LocaleData == null ? (class$sun$text$resources$LocaleData = LocaleData.class$("sun.text.resources.LocaleData")) : class$sun$text$resources$LocaleData;
            synchronized (localeArray) {
                if (localeList == null) {
                    localeList = LocaleData.createLocaleList();
                }
            }
        }
        localeArray = new Locale[localeList.length];
        System.arraycopy(localeList, 0, localeArray, 0, localeList.length);
        return localeArray;
    }

    public static ResourceBundle getLocaleElements(Locale locale) {
        return LocaleData.getBundle("sun.text.resources.LocaleElements", locale);
    }

    public static ResourceBundle getDateFormatZoneData(Locale locale) {
        return LocaleData.getBundle("sun.text.resources.DateFormatZoneData", locale);
    }

    private static ResourceBundle getBundle(final String string, final Locale locale) {
        return (ResourceBundle)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ResourceBundle.getBundle(string, locale);
            }
        });
    }

    private static Locale[] createLocaleList() {
        Object object;
        int n;
        int n2;
        Object object2;
        Object object3;
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("sun.boot.class.path"));
        String string2 = (String)AccessController.doPrivileged(new GetPropertyAction("java.class.path"));
        if (string2 != null && string2.length() != 0) {
            string = string + File.pathSeparator + string2;
        }
        while (string != null && string.length() != 0) {
            int n3 = string.lastIndexOf(File.pathSeparatorChar);
            object3 = string.substring(n3 + 1);
            string = n3 == -1 ? null : string.substring(0, n3);
            classPathSegments.insertElementAt(object3, 0);
        }
        ClassLoader classLoader = Launcher.getLauncher().getClassLoader();
        object3 = (URLClassLoader)classLoader.getParent();
        URL[] uRLArray = ((URLClassLoader)object3).getURLs();
        int n4 = 0;
        while (n4 < uRLArray.length) {
            block16: {
                try {
                    object2 = new URI(uRLArray[n4].toString());
                    classPathSegments.insertElementAt(((URI)object2).getPath(), 0);
                }
                catch (URISyntaxException uRISyntaxException) {
                    if ($assertionsDisabled) break block16;
                    throw new AssertionError();
                }
            }
            ++n4;
        }
        object2 = (String[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return LocaleData.getClassList(LocaleData.PACKAGE, LocaleData.PREFIX);
            }
        });
        int n5 = PREFIX.length();
        Locale[] localeArray = new Locale[((String[])object2).length];
        int n6 = 0;
        while (n6 < ((Object)object2).length) {
            n2 = 0;
            n = ((String)object2[n6]).indexOf(95, n5);
            object = "";
            String string3 = "";
            String string4 = "";
            if (n == -1) {
                object = ((String)object2[n6]).substring(n5);
            } else {
                object = ((String)object2[n6]).substring(n5, n);
                n2 = ((String)object2[n6]).indexOf(95, n + 1);
                if (n2 == -1) {
                    string3 = ((String)object2[n6]).substring(n + 1);
                } else {
                    string3 = ((String)object2[n6]).substring(n + 1, n2);
                    if (n2 < ((String)object2[n6]).length()) {
                        string4 = ((String)object2[n6]).substring(n2 + 1);
                    }
                }
            }
            localeArray[n6] = new Locale((String)object, string3, string4);
            ++n6;
        }
        n2 = 1;
        while (n2 != 0) {
            n2 = 0;
            n = 0;
            while (n < ((Object)object2).length - 1) {
                if (localeArray[n].getLanguage().compareTo(localeArray[n + 1].getLanguage()) > 0) {
                    object = localeArray[n];
                    localeArray[n] = localeArray[n + 1];
                    localeArray[n + 1] = object;
                    n2 = 1;
                } else if (localeArray[n].getLanguage().equals(localeArray[n + 1].getLanguage()) && localeArray[n].getCountry().compareTo(localeArray[n + 1].getCountry()) > 0) {
                    object = localeArray[n];
                    localeArray[n] = localeArray[n + 1];
                    localeArray[n + 1] = object;
                    n2 = 1;
                }
                ++n;
            }
        }
        return localeArray;
    }

    private static String[] getClassList(String string, String string2) {
        Object object;
        Vector vector = new Vector();
        String string3 = string.replace('.', File.separatorChar) + File.separatorChar;
        String string4 = string.replace('.', '/') + '/';
        int n = 0;
        while (n < classPathSegments.size()) {
            object = (String)classPathSegments.elementAt(n);
            File file = new File((String)object);
            if (file.exists()) {
                String string5;
                File file2;
                if (file.isFile()) {
                    LocaleData.scanFile(file, string4, vector, string2);
                } else if (file.isDirectory() && (file2 = new File(string5 = object.endsWith(File.separator) ? (String)object + string3 : (String)object + File.separatorChar + string3)).exists() && file2.isDirectory()) {
                    LocaleData.scanDir(file2, vector, string2);
                }
            }
            ++n;
        }
        object = new String[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    private static void addClass(String string, Vector vector, String string2) {
        if (string != null && string.startsWith(string2) && !vector.contains(string)) {
            vector.addElement(string);
        }
    }

    private static String midString(String string, String string2, String string3) {
        String string4 = string.startsWith(string2) && string.endsWith(string3) ? string.substring(string2.length(), string.length() - string3.length()) : null;
        return string4;
    }

    private static void scanDir(File file, Vector vector, String string) {
        String[] stringArray = file.list();
        int n = 0;
        while (n < stringArray.length) {
            LocaleData.addClass(LocaleData.midString(stringArray[n], "", ".class"), vector, string);
            ++n;
        }
    }

    private static void scanFile(File file, String string, Vector vector, String string2) {
        try {
            ZipEntry zipEntry;
            ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(file));
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string3 = zipEntry.getName();
                if (!string3.startsWith(string) || !string3.endsWith(".class")) continue;
                LocaleData.addClass(LocaleData.midString(string3, string, ".class"), vector, string2);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("file not found:" + fileNotFoundException);
        }
        catch (IOException iOException) {
            System.out.println("file IO Exception:" + iOException);
        }
        catch (Exception exception) {
            System.out.println("Exception:" + exception);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$sun$text$resources$LocaleData == null ? (class$sun$text$resources$LocaleData = LocaleData.class$("sun.text.resources.LocaleData")) : class$sun$text$resources$LocaleData).desiredAssertionStatus();
        classPathSegments = new Vector();
    }
}

