/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.math.BigInteger;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;

public class Debug {
    private String prefix;
    private static String args = (String)AccessController.doPrivileged(new GetPropertyAction("java.security.debug"));

    public static void Help() {
        System.err.println();
        System.err.println("all          turn on all debugging");
        System.err.println("access       print all checkPermission results");
        System.err.println("algorithm    print all algorithm requests");
        System.err.println("combiner     SubjectDomainCombiner debugging");
        System.err.println("jar          jar verification");
        System.err.println("logincontext login context results");
        System.err.println("policy       loading and granting");
        System.err.println("provider     security provider debugging");
        System.err.println("scl          permissions SecureClassLoader assigns");
        System.err.println();
        System.err.println("The following can be used with access:");
        System.err.println();
        System.err.println("stack     include stack trace");
        System.err.println("domain    dumps all domains in context");
        System.err.println("failure   before throwing exception, dump stack");
        System.err.println("          and domain that didn't have permission");
        System.err.println();
        System.err.println("The following can be used with any of the above:");
        System.err.println("thread    add thread id information");
        System.err.println();
        System.err.println("Note: Separate multiple options with a comma");
        System.exit(0);
    }

    public static Debug getInstance(String string) {
        return Debug.getInstance(string, string);
    }

    public static Debug getInstance(String string, String string2) {
        if (Debug.isOn(string)) {
            Debug debug = new Debug();
            debug.prefix = string2;
            return debug;
        }
        return null;
    }

    public static boolean isOn(String string) {
        if (args == null) {
            return false;
        }
        if (args.indexOf("all") != -1) {
            return true;
        }
        return args.indexOf(string) != -1;
    }

    public void println(String string) {
        if (Debug.isOn("thread")) {
            System.err.println(this.prefix + ": (" + Thread.currentThread() + ") " + string);
        } else {
            System.err.println(this.prefix + ": " + string);
        }
    }

    public void println() {
        if (Debug.isOn("thread")) {
            System.err.println(this.prefix + ": (" + Thread.currentThread() + ")");
        } else {
            System.err.println(this.prefix + ":");
        }
    }

    public static void println(String string, String string2) {
        if (Debug.isOn("thread")) {
            System.err.println(string + ": (" + Thread.currentThread() + ") " + string2);
        } else {
            System.err.println(string + ": " + string2);
        }
    }

    public void printStackTrace(Throwable throwable) {
        if (Debug.isOn("stack")) {
            int n;
            Throwable throwable2;
            Throwable throwable3;
            if (throwable == null) {
                throwable3 = new Throwable("stack trace ...");
                throwable2 = null;
                n = 2;
            } else {
                throwable3 = throwable;
                throwable2 = throwable.getCause();
                n = 0;
            }
            StackTraceElement[] stackTraceElementArray = throwable3.getStackTrace();
            int n2 = n;
            while (n2 < stackTraceElementArray.length) {
                this.println("   " + stackTraceElementArray[n2]);
                ++n2;
            }
            if (throwable2 != null) {
                this.println();
                this.println("cause: " + throwable2);
                this.printStackTrace(throwable2);
            }
        }
    }

    public static String toHexString(BigInteger bigInteger) {
        String string = bigInteger.toString(16);
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        if (string.startsWith("-")) {
            stringBuffer.append("   -");
            string = string.substring(1);
        } else {
            stringBuffer.append("    ");
        }
        if (string.length() % 2 != 0) {
            string = "0" + string;
        }
        int n = 0;
        while (n < string.length()) {
            stringBuffer.append(string.substring(n, n + 2));
            if ((n += 2) == string.length()) continue;
            if (n % 64 == 0) {
                stringBuffer.append("\n    ");
                continue;
            }
            if (n % 8 != 0) continue;
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public static String toHexString(byte[] byArray) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(cArray[byArray[n] >> 4 & 0xF]);
            stringBuffer.append(cArray[byArray[n] & 0xF]);
            ++n;
        }
        return stringBuffer.toString();
    }

    static {
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("java.security.auth.debug"));
        if (args == null) {
            args = string;
        } else if (string != null) {
            args = args + "," + string;
        }
        if (args != null && (args = args.toLowerCase()).equals("help")) {
            Debug.Help();
        }
    }
}

