/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import sun.nio.ch.DirectBuffer;
import sun.nio.ch.IOVecWrapper;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.Util;

class IOUtil {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$sun$nio$ch$IOUtil;

    private IOUtil() {
    }

    private static int remaining(ByteBuffer[] byteBufferArray) {
        int n = byteBufferArray.length;
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            if (byteBufferArray[n2].hasRemaining()) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private static ByteBuffer[] skipBufs(ByteBuffer[] byteBufferArray, int n) {
        int n2 = byteBufferArray.length - n;
        ByteBuffer[] byteBufferArray2 = new ByteBuffer[n2];
        int n3 = 0;
        while (n3 < n2) {
            byteBufferArray2[n3] = byteBufferArray[n3 + n];
            ++n3;
        }
        return byteBufferArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int write(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, long l, NativeDispatcher nativeDispatcher, Object object) throws IOException {
        int n;
        if (byteBuffer instanceof DirectBuffer) {
            return IOUtil.writeFromNativeBuffer(fileDescriptor, byteBuffer, l, nativeDispatcher, object);
        }
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.limit();
        if (!$assertionsDisabled && n2 > n3) {
            throw new AssertionError();
        }
        int n4 = n2 <= n3 ? n3 - n2 : 0;
        ByteBuffer byteBuffer2 = null;
        try {
            byteBuffer2 = Util.getTemporaryDirectBuffer(n4);
            byteBuffer2.put(byteBuffer);
            byteBuffer2.flip();
            byteBuffer.position(n2);
            int n5 = IOUtil.writeFromNativeBuffer(fileDescriptor, byteBuffer2, l, nativeDispatcher, object);
            if (n5 > 0) {
                byteBuffer.position(n2 + n5);
            }
            n = n5;
            Object var13_11 = null;
        }
        catch (Throwable throwable) {
            Object var13_12 = null;
            Util.releaseTemporaryDirectBuffer(byteBuffer2);
            throw throwable;
        }
        Util.releaseTemporaryDirectBuffer(byteBuffer2);
        return n;
    }

    private static int writeFromNativeBuffer(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, long l, NativeDispatcher nativeDispatcher, Object object) throws IOException {
        int n = byteBuffer.position();
        int n2 = byteBuffer.limit();
        if (!$assertionsDisabled && n > n2) {
            throw new AssertionError();
        }
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = 0;
        if (n3 == 0) {
            return 0;
        }
        n4 = l != -1L ? nativeDispatcher.pwrite(fileDescriptor, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n, n3, l, object) : nativeDispatcher.write(fileDescriptor, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n, n3);
        if (n4 > 0) {
            byteBuffer.position(n + n4);
        }
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long write(FileDescriptor fileDescriptor, ByteBuffer[] byteBufferArray, NativeDispatcher nativeDispatcher) throws IOException {
        int n = IOUtil.remaining(byteBufferArray);
        if (n < 0) {
            return 0L;
        }
        if (n > 0) {
            byteBufferArray = IOUtil.skipBufs(byteBufferArray, n);
        }
        int n2 = byteBufferArray.length;
        int n3 = 0;
        ByteBuffer[] byteBufferArray2 = new ByteBuffer[n2];
        int n4 = 0;
        while (n4 < n2) {
            if (!(byteBufferArray[n4] instanceof DirectBuffer)) {
                ByteBuffer byteBuffer;
                int n5 = byteBufferArray[n4].position();
                int n6 = byteBufferArray[n4].limit();
                if (!$assertionsDisabled && n5 > n6) {
                    throw new AssertionError();
                }
                int n7 = n5 <= n6 ? n6 - n5 : 0;
                byteBufferArray2[n4] = byteBuffer = ByteBuffer.allocateDirect(n7);
                byteBuffer.put(byteBufferArray[n4]);
                byteBufferArray[n4].position(n5);
                byteBuffer.flip();
            } else {
                byteBufferArray2[n4] = byteBufferArray[n4];
            }
            ++n4;
        }
        IOVecWrapper iOVecWrapper = null;
        long l = 0L;
        try {
            iOVecWrapper = new IOVecWrapper(n2);
            int n8 = 0;
            while (n8 < n2) {
                ByteBuffer byteBuffer = byteBufferArray2[n8];
                long l2 = byteBuffer.position();
                long l3 = (long)byteBuffer.limit() - l2;
                n3 = (int)((long)n3 + l3);
                iOVecWrapper.putBase(n8, ((DirectBuffer)((Object)byteBuffer)).address() + l2);
                iOVecWrapper.putLen(n8, l3);
                ++n8;
            }
            l = nativeDispatcher.writev(fileDescriptor, iOVecWrapper.address, n2);
            Object var18_21 = null;
            iOVecWrapper.free();
        }
        catch (Throwable throwable) {
            Object var18_22 = null;
            iOVecWrapper.free();
            throw throwable;
        }
        long l4 = l;
        int n9 = 0;
        while (n9 < n2) {
            int n10;
            ByteBuffer byteBuffer = byteBufferArray[n9];
            int n11 = byteBuffer.position();
            int n12 = byteBuffer.limit();
            if (!$assertionsDisabled && n11 > n12) {
                throw new AssertionError();
            }
            int n13 = n10 = n11 <= n12 ? n12 - n11 : n12;
            if (l >= (long)n10) {
                l -= (long)n10;
            } else {
                if (l <= 0L) break;
                if (!$assertionsDisabled && (long)n11 + l >= Integer.MAX_VALUE) {
                    throw new AssertionError();
                }
                int n14 = (int)((long)n11 + l);
                byteBuffer.position(n14);
                break;
            }
            int n15 = n11 + n10;
            byteBuffer.position(n15);
            ++n9;
        }
        return l4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int read(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, long l, NativeDispatcher nativeDispatcher, Object object) throws IOException {
        int n;
        if (byteBuffer.isReadOnly()) {
            throw new IllegalArgumentException("Read-only buffer");
        }
        if (byteBuffer instanceof DirectBuffer) {
            return IOUtil.readIntoNativeBuffer(fileDescriptor, byteBuffer, l, nativeDispatcher, object);
        }
        ByteBuffer byteBuffer2 = null;
        try {
            byteBuffer2 = Util.getTemporaryDirectBuffer(byteBuffer.remaining());
            int n2 = IOUtil.readIntoNativeBuffer(fileDescriptor, byteBuffer2, l, nativeDispatcher, object);
            byteBuffer2.flip();
            if (n2 > 0) {
                byteBuffer.put(byteBuffer2);
            }
            n = n2;
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            Util.releaseTemporaryDirectBuffer(byteBuffer2);
            throw throwable;
        }
        Util.releaseTemporaryDirectBuffer(byteBuffer2);
        return n;
    }

    private static int readIntoNativeBuffer(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, long l, NativeDispatcher nativeDispatcher, Object object) throws IOException {
        int n;
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.limit();
        if (!$assertionsDisabled && n2 > n3) {
            throw new AssertionError();
        }
        int n4 = n = n2 <= n3 ? n3 - n2 : 0;
        if (n == 0) {
            return 0;
        }
        int n5 = 0;
        n5 = l != -1L ? nativeDispatcher.pread(fileDescriptor, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n2, n, l, object) : nativeDispatcher.read(fileDescriptor, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n2, n);
        if (n5 > 0) {
            byteBuffer.position(n2 + n5);
        }
        return n5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long read(FileDescriptor fileDescriptor, ByteBuffer[] byteBufferArray, NativeDispatcher nativeDispatcher) throws IOException {
        int n = IOUtil.remaining(byteBufferArray);
        if (n < 0) {
            return 0L;
        }
        if (n > 0) {
            byteBufferArray = IOUtil.skipBufs(byteBufferArray, n);
        }
        int n2 = byteBufferArray.length;
        ByteBuffer[] byteBufferArray2 = new ByteBuffer[n2];
        int n3 = 0;
        while (n3 < n2) {
            if (byteBufferArray[n3].isReadOnly()) {
                throw new IllegalArgumentException("Read-only buffer");
            }
            byteBufferArray2[n3] = !(byteBufferArray[n3] instanceof DirectBuffer) ? ByteBuffer.allocateDirect(byteBufferArray[n3].remaining()) : byteBufferArray[n3];
            ++n3;
        }
        IOVecWrapper iOVecWrapper = null;
        long l = 0L;
        try {
            iOVecWrapper = new IOVecWrapper(n2);
            int n4 = 0;
            while (n4 < n2) {
                ByteBuffer byteBuffer = byteBufferArray2[n4];
                long l2 = byteBuffer.position();
                long l3 = byteBuffer.remaining();
                iOVecWrapper.putBase(n4, ((DirectBuffer)((Object)byteBuffer)).address() + l2);
                iOVecWrapper.putLen(n4, l3);
                ++n4;
            }
            l = nativeDispatcher.readv(fileDescriptor, iOVecWrapper.address, n2);
            Object var17_16 = null;
            iOVecWrapper.free();
        }
        catch (Throwable throwable) {
            Object var17_17 = null;
            iOVecWrapper.free();
            throw throwable;
        }
        long l4 = l;
        int n5 = 0;
        while (n5 < n2) {
            int n6;
            ByteBuffer byteBuffer = byteBufferArray2[n5];
            int n7 = byteBuffer.position();
            int n8 = byteBuffer.remaining();
            if (l >= (long)n8) {
                l -= (long)n8;
            } else {
                if (l <= 0L) break;
                if (!$assertionsDisabled && (long)n7 + l >= Integer.MAX_VALUE) {
                    throw new AssertionError();
                }
                n6 = (int)((long)n7 + l);
                byteBuffer.position(n6);
                break;
            }
            n6 = n7 + n8;
            byteBuffer.position(n6);
            ++n5;
        }
        int n9 = 0;
        while (n9 < n2) {
            if (!(byteBufferArray[n9] instanceof DirectBuffer)) {
                byteBufferArray2[n9].flip();
                byteBufferArray[n9].put(byteBufferArray2[n9]);
            }
            ++n9;
        }
        return l4;
    }

    static FileDescriptor newFD(int n) {
        FileDescriptor fileDescriptor = new FileDescriptor();
        IOUtil.setfdVal(fileDescriptor, n);
        return fileDescriptor;
    }

    static native boolean randomBytes(byte[] var0);

    static native void initPipe(int[] var0, boolean var1);

    static native boolean drain(int var0) throws IOException;

    static native void configureBlocking(FileDescriptor var0, boolean var1) throws IOException;

    static native int fdVal(FileDescriptor var0);

    static native int fd2Val(FileDescriptor var0);

    static native int boundfdVal(FileDescriptor var0);

    static native int fdinuseVal(FileDescriptor var0);

    static native void setfdVal(FileDescriptor var0, int var1);

    static native void setfd2Val(FileDescriptor var0, int var1);

    static native void initIDs();

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$sun$nio$ch$IOUtil == null ? (class$sun$nio$ch$IOUtil = IOUtil.class$("sun.nio.ch.IOUtil")) : class$sun$nio$ch$IOUtil).desiredAssertionStatus();
        Util.load();
    }
}

