/*
 * Decompiled with CFR 0.152.
 */
package java.text;

final class DigitList
implements Cloneable {
    public static final int MAX_COUNT = 19;
    public static final int DBL_DIG = 17;
    public int decimalAt = 0;
    public int count = 0;
    public char[] digits = new char[19];
    private static final char[] LONG_MIN_REP = "9223372036854775808".toCharArray();
    private StringBuffer tempBuffer;

    DigitList() {
    }

    boolean isZero() {
        int n = 0;
        while (n < this.count) {
            if (this.digits[n] != '0') {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void clear() {
        this.decimalAt = 0;
        this.count = 0;
    }

    public void append(char c) {
        if (this.count < 19) {
            this.digits[this.count++] = c;
        }
    }

    public final double getDouble() {
        if (this.count == 0) {
            return 0.0;
        }
        StringBuffer stringBuffer = this.getStringBuffer();
        stringBuffer.append('.').append(this.digits, 0, this.count);
        stringBuffer.append('E');
        stringBuffer.append(this.decimalAt);
        return Double.parseDouble(stringBuffer.toString());
    }

    public final long getLong() {
        if (this.count == 0) {
            return 0L;
        }
        if (this.isLongMIN_VALUE()) {
            return Long.MIN_VALUE;
        }
        StringBuffer stringBuffer = this.getStringBuffer();
        stringBuffer.append(this.digits, 0, this.count);
        int n = this.count;
        while (n < this.decimalAt) {
            stringBuffer.append('0');
            ++n;
        }
        return Long.parseLong(stringBuffer.toString());
    }

    boolean fitsIntoLong(boolean bl, boolean bl2) {
        while (this.count > 0 && this.digits[this.count - 1] == '0') {
            --this.count;
        }
        if (this.count == 0) {
            return bl || bl2;
        }
        if (this.decimalAt < this.count || this.decimalAt > 19) {
            return false;
        }
        if (this.decimalAt < 19) {
            return true;
        }
        int n = 0;
        while (n < this.count) {
            char c = this.digits[n];
            char c2 = LONG_MIN_REP[n];
            if (c > c2) {
                return false;
            }
            if (c < c2) {
                return true;
            }
            ++n;
        }
        if (this.count < this.decimalAt) {
            return true;
        }
        return !bl;
    }

    public final void set(double d, int n) {
        this.set(d, n, true);
    }

    /*
     * Unable to fully structure code
     */
    final void set(double var1_1, int var3_2, boolean var4_3) {
        if (var1_1 == 0.0) {
            var1_1 = 0.0;
        }
        var5_4 = Double.toString(var1_1).toCharArray();
        this.decimalAt = -1;
        this.count = 0;
        var6_5 = 0;
        var7_6 = 0;
        var8_7 = false;
        var9_8 = 0;
        while (var9_8 < var5_4.length) {
            if ((var10_9 = var5_4[var9_8++]) == '.') {
                this.decimalAt = this.count;
                continue;
            }
            if (var10_9 == 'e' || var10_9 == 'E') {
                var6_5 = DigitList.parseInt(var5_4, var9_8);
                break;
            }
            if (this.count >= 19) continue;
            if (!var8_7) {
                v0 = var8_7 = var10_9 != '0';
                if (!var8_7 && this.decimalAt != -1) {
                    ++var7_6;
                }
            }
            if (!var8_7) continue;
            this.digits[this.count++] = var10_9;
        }
        if (this.decimalAt == -1) {
            this.decimalAt = this.count;
        }
        if (var8_7) {
            this.decimalAt += var6_5 - var7_6;
        }
        if (!var4_3) ** GOTO lbl42
        if (-this.decimalAt > var3_2) {
            this.count = 0;
            return;
        }
        if (-this.decimalAt != var3_2) ** GOTO lbl42
        if (this.shouldRoundUp(0)) {
            this.count = 1;
            ++this.decimalAt;
            this.digits[0] = 49;
        } else {
            this.count = 0;
        }
        return;
lbl-1000:
        // 1 sources

        {
            --this.count;
lbl42:
            // 3 sources

            ** while (this.count > 1 && this.digits[this.count - 1] == '0')
        }
lbl43:
        // 1 sources

        this.round(var4_3 != false ? var3_2 + this.decimalAt : var3_2);
    }

    private final void round(int n) {
        if (n >= 0 && n < this.count) {
            if (this.shouldRoundUp(n)) {
                do {
                    if (--n < 0) {
                        this.digits[0] = 49;
                        ++this.decimalAt;
                        n = 0;
                        break;
                    }
                    int n2 = n;
                    this.digits[n2] = (char)(this.digits[n2] + '\u0001');
                } while (this.digits[n] > '9');
                ++n;
            }
            this.count = n;
            while (this.count > 1 && this.digits[this.count - 1] == '0') {
                --this.count;
            }
        }
    }

    private boolean shouldRoundUp(int n) {
        boolean bl = false;
        if (n < this.count) {
            if (this.digits[n] > '5') {
                return true;
            }
            if (this.digits[n] == '5') {
                int n2 = n + 1;
                while (n2 < this.count) {
                    if (this.digits[n2] != '0') {
                        return true;
                    }
                    ++n2;
                }
                return n > 0 && this.digits[n - 1] % 2 != 0;
            }
        }
        return false;
    }

    public final void set(long l) {
        this.set(l, 0);
    }

    public final void set(long l, int n) {
        if (l <= 0L) {
            if (l == Long.MIN_VALUE) {
                this.count = 19;
                this.decimalAt = 19;
                System.arraycopy(LONG_MIN_REP, 0, this.digits, 0, this.count);
            } else {
                this.count = 0;
                this.decimalAt = 0;
            }
        } else {
            int n2 = 19;
            while (l > 0L) {
                this.digits[--n2] = (char)(48L + l % 10L);
                l /= 10L;
            }
            this.decimalAt = 19 - n2;
            int n3 = 18;
            while (this.digits[n3] == '0') {
                --n3;
            }
            this.count = n3 - n2 + 1;
            System.arraycopy(this.digits, n2, this.digits, 0, this.count);
        }
        if (n > 0) {
            this.round(n);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DigitList)) {
            return false;
        }
        DigitList digitList = (DigitList)object;
        if (this.count != digitList.count || this.decimalAt != digitList.decimalAt) {
            return false;
        }
        int n = 0;
        while (n < this.count) {
            if (this.digits[n] != digitList.digits[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        int n = this.decimalAt;
        int n2 = 0;
        while (n2 < this.count) {
            n = n * 37 + this.digits[n2];
            ++n2;
        }
        return n;
    }

    public Object clone() {
        try {
            DigitList digitList = (DigitList)super.clone();
            char[] cArray = new char[this.digits.length];
            System.arraycopy(this.digits, 0, cArray, 0, this.digits.length);
            digitList.digits = cArray;
            return digitList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    private boolean isLongMIN_VALUE() {
        if (this.decimalAt != this.count || this.count != 19) {
            return false;
        }
        int n = 0;
        while (n < this.count) {
            if (this.digits[n] != LONG_MIN_REP[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static final int parseInt(char[] cArray, int n) {
        boolean bl = true;
        char c = cArray[n];
        if (c == '-') {
            bl = false;
            ++n;
        } else if (c == '+') {
            ++n;
        }
        int n2 = 0;
        while (n < cArray.length) {
            if ((c = cArray[n++]) < '0' || c > '9') break;
            n2 = n2 * 10 + (c - 48);
        }
        return bl ? n2 : -n2;
    }

    public String toString() {
        if (this.isZero()) {
            return "0";
        }
        StringBuffer stringBuffer = this.getStringBuffer();
        stringBuffer.append("0.").append(this.digits, 0, this.count);
        stringBuffer.append("x10^");
        stringBuffer.append(this.decimalAt);
        return stringBuffer.toString();
    }

    private StringBuffer getStringBuffer() {
        if (this.tempBuffer == null) {
            this.tempBuffer = new StringBuffer(19);
        } else {
            this.tempBuffer.setLength(0);
        }
        return this.tempBuffer;
    }
}

