/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Currency;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import sun.text.resources.LocaleData;

public final class DecimalFormatSymbols
implements Cloneable,
Serializable {
    private char zeroDigit;
    private char groupingSeparator;
    private char decimalSeparator;
    private char perMill;
    private char percent;
    private char digit;
    private char patternSeparator;
    private String infinity;
    private String NaN;
    private char minusSign;
    private String currencySymbol;
    private String intlCurrencySymbol;
    private char monetarySeparator;
    private char exponential;
    private Locale locale;
    private transient Currency currency;
    static final long serialVersionUID = 5772796243397350300L;
    private static final int currentSerialVersion = 2;
    private int serialVersionOnStream = 2;
    private static final Hashtable cachedLocaleData = new Hashtable(3);

    public DecimalFormatSymbols() {
        this.initialize(Locale.getDefault());
    }

    public DecimalFormatSymbols(Locale locale) {
        this.initialize(locale);
    }

    public char getZeroDigit() {
        return this.zeroDigit;
    }

    public void setZeroDigit(char c) {
        this.zeroDigit = c;
    }

    public char getGroupingSeparator() {
        return this.groupingSeparator;
    }

    public void setGroupingSeparator(char c) {
        this.groupingSeparator = c;
    }

    public char getDecimalSeparator() {
        return this.decimalSeparator;
    }

    public void setDecimalSeparator(char c) {
        this.decimalSeparator = c;
    }

    public char getPerMill() {
        return this.perMill;
    }

    public void setPerMill(char c) {
        this.perMill = c;
    }

    public char getPercent() {
        return this.percent;
    }

    public void setPercent(char c) {
        this.percent = c;
    }

    public char getDigit() {
        return this.digit;
    }

    public void setDigit(char c) {
        this.digit = c;
    }

    public char getPatternSeparator() {
        return this.patternSeparator;
    }

    public void setPatternSeparator(char c) {
        this.patternSeparator = c;
    }

    public String getInfinity() {
        return this.infinity;
    }

    public void setInfinity(String string) {
        this.infinity = string;
    }

    public String getNaN() {
        return this.NaN;
    }

    public void setNaN(String string) {
        this.NaN = string;
    }

    public char getMinusSign() {
        return this.minusSign;
    }

    public void setMinusSign(char c) {
        this.minusSign = c;
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public void setCurrencySymbol(String string) {
        this.currencySymbol = string;
    }

    public String getInternationalCurrencySymbol() {
        return this.intlCurrencySymbol;
    }

    public void setInternationalCurrencySymbol(String string) {
        block2: {
            this.intlCurrencySymbol = string;
            this.currency = null;
            if (string == null) break block2;
            try {
                this.currency = Currency.getInstance(string);
                this.currencySymbol = this.currency.getSymbol();
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        if (currency == null) {
            throw new NullPointerException();
        }
        this.currency = currency;
        this.intlCurrencySymbol = currency.getCurrencyCode();
        this.currencySymbol = currency.getSymbol(this.locale);
    }

    public char getMonetaryDecimalSeparator() {
        return this.monetarySeparator;
    }

    public void setMonetaryDecimalSeparator(char c) {
        this.monetarySeparator = c;
    }

    char getExponentialSymbol() {
        return this.exponential;
    }

    void setExponentialSymbol(char c) {
        this.exponential = c;
    }

    public Object clone() {
        try {
            return (DecimalFormatSymbols)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DecimalFormatSymbols decimalFormatSymbols = (DecimalFormatSymbols)object;
        return this.zeroDigit == decimalFormatSymbols.zeroDigit && this.groupingSeparator == decimalFormatSymbols.groupingSeparator && this.decimalSeparator == decimalFormatSymbols.decimalSeparator && this.percent == decimalFormatSymbols.percent && this.perMill == decimalFormatSymbols.perMill && this.digit == decimalFormatSymbols.digit && this.minusSign == decimalFormatSymbols.minusSign && this.patternSeparator == decimalFormatSymbols.patternSeparator && this.infinity.equals(decimalFormatSymbols.infinity) && this.NaN.equals(decimalFormatSymbols.NaN) && this.currencySymbol.equals(decimalFormatSymbols.currencySymbol) && this.intlCurrencySymbol.equals(decimalFormatSymbols.intlCurrencySymbol) && this.currency == decimalFormatSymbols.currency && this.monetarySeparator == decimalFormatSymbols.monetarySeparator && this.locale.equals(decimalFormatSymbols.locale);
    }

    public int hashCode() {
        int n = this.zeroDigit;
        n = n * 37 + this.groupingSeparator;
        n = n * 37 + this.decimalSeparator;
        return n;
    }

    private void initialize(Locale locale) {
        Object object;
        this.locale = locale;
        boolean bl = false;
        Object[] objectArray = (Object[])cachedLocaleData.get(locale);
        if (objectArray == null) {
            objectArray = new Object[3];
            object = LocaleData.getLocaleElements(locale);
            objectArray[0] = ((ResourceBundle)object).getStringArray("NumberElements");
            bl = true;
        }
        object = (String[])objectArray[0];
        this.decimalSeparator = object[0].charAt(0);
        this.groupingSeparator = ((String)object[1]).charAt(0);
        this.patternSeparator = ((String)object[2]).charAt(0);
        this.percent = ((String)object[3]).charAt(0);
        this.zeroDigit = ((String)object[4]).charAt(0);
        this.digit = ((String)object[5]).charAt(0);
        this.minusSign = ((String)object[6]).charAt(0);
        this.exponential = ((String)object[7]).charAt(0);
        this.perMill = ((String)object[8]).charAt(0);
        this.infinity = object[9];
        this.NaN = object[10];
        if (!"".equals(locale.getCountry())) {
            try {
                this.currency = Currency.getInstance(locale);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (this.currency != null) {
            this.intlCurrencySymbol = this.currency.getCurrencyCode();
            if (objectArray[1] != null && objectArray[1] == this.intlCurrencySymbol) {
                this.currencySymbol = (String)objectArray[2];
            } else {
                this.currencySymbol = this.currency.getSymbol(locale);
                objectArray[1] = this.intlCurrencySymbol;
                objectArray[2] = this.currencySymbol;
                bl = true;
            }
        } else {
            this.intlCurrencySymbol = "XXX";
            try {
                this.currency = Currency.getInstance(this.intlCurrencySymbol);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.currencySymbol = "\u00a4";
        }
        this.monetarySeparator = this.decimalSeparator;
        if (bl) {
            cachedLocaleData.put(locale, objectArray);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        block4: {
            objectInputStream.defaultReadObject();
            if (this.serialVersionOnStream < 1) {
                this.monetarySeparator = this.decimalSeparator;
                this.exponential = (char)69;
            }
            if (this.serialVersionOnStream < 2) {
                this.locale = new Locale("");
            }
            this.serialVersionOnStream = 2;
            if (this.intlCurrencySymbol == null) break block4;
            try {
                this.currency = Currency.getInstance(this.intlCurrencySymbol);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }
}

