/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.security.GeneralSecurityException;
import java.security.cert.CertPath;

public class CertPathValidatorException
extends GeneralSecurityException {
    static final long serialVersionUID = -2365020986539324560L;
    private int index = -1;
    private CertPath certPath;
    private Throwable ie;

    public CertPathValidatorException() {
    }

    public CertPathValidatorException(String string) {
        super(string);
    }

    public CertPathValidatorException(Throwable throwable) {
        this.initCause(throwable);
    }

    public CertPathValidatorException(String string, Throwable throwable) {
        super(string);
        this.initCause(throwable);
    }

    public CertPathValidatorException(String string, Throwable throwable, CertPath certPath, int n) {
        this(string, throwable);
        if (n < -1 || certPath != null && n >= certPath.getCertificates().size()) {
            throw new IndexOutOfBoundsException("Index of the certificate in specified CertPath is out of bound");
        }
        if (certPath == null && n != -1) {
            throw new IllegalArgumentException();
        }
        this.certPath = certPath;
        this.index = n;
    }

    public String getMessage() {
        return super.getMessage();
    }

    public CertPath getCertPath() {
        return this.certPath;
    }

    public int getIndex() {
        return this.index;
    }

    public Throwable getCause() {
        return super.getCause();
    }

    public String toString() {
        if (this.getCause() == null) {
            return super.toString();
        }
        return super.toString() + "; internal cause is: \n\t" + this.getCause().toString();
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream printStream) {
        super.printStackTrace(printStream);
    }

    public void printStackTrace(PrintWriter printWriter) {
        super.printStackTrace(printWriter);
    }
}

