/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeListenerProxy;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class VetoableChangeSupport
implements Serializable {
    private transient Vector listeners;
    private Hashtable children;
    private Object source;
    private int vetoableChangeSupportSerializedDataVersion = 2;
    static final long serialVersionUID = -5090210921595982017L;

    public VetoableChangeSupport(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        this.source = object;
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener instanceof VetoableChangeListenerProxy) {
            VetoableChangeListenerProxy vetoableChangeListenerProxy = (VetoableChangeListenerProxy)vetoableChangeListener;
            this.addVetoableChangeListener(vetoableChangeListenerProxy.getPropertyName(), (VetoableChangeListener)vetoableChangeListenerProxy.getListener());
        } else if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(vetoableChangeListener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener instanceof VetoableChangeListenerProxy) {
            VetoableChangeListenerProxy vetoableChangeListenerProxy = (VetoableChangeListenerProxy)vetoableChangeListener;
            this.removeVetoableChangeListener(vetoableChangeListenerProxy.getPropertyName(), (VetoableChangeListener)vetoableChangeListenerProxy.getListener());
        } else {
            if (this.listeners == null) {
                return;
            }
            this.listeners.removeElement(vetoableChangeListener);
        }
    }

    public synchronized VetoableChangeListener[] getVetoableChangeListeners() {
        ArrayList arrayList = new ArrayList();
        if (this.listeners != null) {
            arrayList.addAll(this.listeners);
        }
        if (this.children != null) {
            Iterator iterator = this.children.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                VetoableChangeSupport vetoableChangeSupport = (VetoableChangeSupport)this.children.get(string);
                VetoableChangeListener[] vetoableChangeListenerArray = vetoableChangeSupport.getVetoableChangeListeners();
                int n = vetoableChangeListenerArray.length - 1;
                while (n >= 0) {
                    arrayList.add(new VetoableChangeListenerProxy(string, vetoableChangeListenerArray[n]));
                    --n;
                }
            }
        }
        return (VetoableChangeListener[])arrayList.toArray(new VetoableChangeListener[0]);
    }

    public synchronized void addVetoableChangeListener(String string, VetoableChangeListener vetoableChangeListener) {
        VetoableChangeSupport vetoableChangeSupport;
        if (this.children == null) {
            this.children = new Hashtable();
        }
        if ((vetoableChangeSupport = (VetoableChangeSupport)this.children.get(string)) == null) {
            vetoableChangeSupport = new VetoableChangeSupport(this.source);
            this.children.put(string, vetoableChangeSupport);
        }
        vetoableChangeSupport.addVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void removeVetoableChangeListener(String string, VetoableChangeListener vetoableChangeListener) {
        if (this.children == null) {
            return;
        }
        VetoableChangeSupport vetoableChangeSupport = (VetoableChangeSupport)this.children.get(string);
        if (vetoableChangeSupport == null) {
            return;
        }
        vetoableChangeSupport.removeVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized VetoableChangeListener[] getVetoableChangeListeners(String string) {
        VetoableChangeSupport vetoableChangeSupport;
        ArrayList arrayList = new ArrayList();
        if (this.children != null && (vetoableChangeSupport = (VetoableChangeSupport)this.children.get(string)) != null) {
            arrayList.addAll(Arrays.asList(vetoableChangeSupport.getVetoableChangeListeners()));
        }
        return (VetoableChangeListener[])arrayList.toArray(new VetoableChangeListener[0]);
    }

    public void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        if (this.listeners == null && this.children == null) {
            return;
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this.source, string, object, object2);
        this.fireVetoableChange(propertyChangeEvent);
    }

    public void fireVetoableChange(String string, int n, int n2) throws PropertyVetoException {
        if (n == n2) {
            return;
        }
        this.fireVetoableChange(string, new Integer(n), new Integer(n2));
    }

    public void fireVetoableChange(String string, boolean bl, boolean bl2) throws PropertyVetoException {
        if (bl == bl2) {
            return;
        }
        this.fireVetoableChange(string, (Object)bl, (Object)bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void fireVetoableChange(PropertyChangeEvent var1_1) throws PropertyVetoException {
        block14: {
            var2_2 = var1_1.getOldValue();
            var3_3 = var1_1.getNewValue();
            var4_4 = var1_1.getPropertyName();
            if (var2_2 != null && var3_3 != null && var2_2.equals(var3_3)) {
                return;
            }
            var5_5 = null;
            var6_6 = null;
            var7_7 = this;
            synchronized (var7_7) {
                if (this.listeners != null) {
                    var5_5 = (Vector)this.listeners.clone();
                }
                if (this.children != null && var4_4 != null) {
                    var6_6 = (VetoableChangeSupport)this.children.get(var4_4);
                }
            }
            if (this.listeners != null) {
                try {
                    var8_9 = 0;
                    while (var8_9 < var5_5.size()) {
                        var9_11 = (VetoableChangeListener)var5_5.elementAt(var8_9);
                        var9_11.vetoableChange(var1_1);
                        ++var8_9;
                    }
                    break block14;
                }
                catch (PropertyVetoException var8_10) {
                    var1_1 = new PropertyChangeEvent(this.source, var4_4, var3_3, var2_2);
                    var9_12 = 0;
                    ** while (var9_12 < var5_5.size())
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        var10_13 = (VetoableChangeListener)var5_5.elementAt(var9_12);
                        var10_13.vetoableChange(var1_1);
                    }
                    catch (PropertyVetoException var10_14) {
                        // empty catch block
                    }
                    ++var9_12;
                    continue;
                }
lbl39:
                // 1 sources

                throw var8_10;
            }
        }
        if (var6_6 != null) {
            var6_6.fireVetoableChange(var1_1);
        }
    }

    public synchronized boolean hasListeners(String string) {
        VetoableChangeSupport vetoableChangeSupport;
        if (this.listeners != null && !this.listeners.isEmpty()) {
            return true;
        }
        if (this.children != null && (vetoableChangeSupport = (VetoableChangeSupport)this.children.get(string)) != null && vetoableChangeSupport.listeners != null) {
            return !vetoableChangeSupport.listeners.isEmpty();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Vector vector = null;
        VetoableChangeSupport vetoableChangeSupport = this;
        synchronized (vetoableChangeSupport) {
            if (this.listeners != null) {
                vector = (Vector)this.listeners.clone();
            }
        }
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                VetoableChangeListener vetoableChangeListener = (VetoableChangeListener)vector.elementAt(n);
                if (vetoableChangeListener instanceof Serializable) {
                    objectOutputStream.writeObject(vetoableChangeListener);
                }
                ++n;
            }
        }
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        Object object;
        objectInputStream.defaultReadObject();
        while (null != (object = objectInputStream.readObject())) {
            this.addVetoableChangeListener((VetoableChangeListener)object);
        }
    }
}

