/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nio.cs;

import com.ibm.bidiTools.bdlayout.BidiConvert;
import com.ibm.nio.cs.IBMCharsetDecoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;
import java.security.AccessController;
import sun.misc.VM;
import sun.security.action.GetPropertyAction;

class UTF8_Decoder
extends IBMCharsetDecoder {
    private final int flags;
    private String bidiParms;
    private boolean bidiEnabled = false;
    private static String bidiInit = "NO";
    public static final int[] States = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 4, 1};
    public static final int[] StateMask = new int[]{0, 0, 31, 15, 7};

    protected UTF8_Decoder(Charset charset, int n) {
        super(charset, 1.0f, 1.0f);
        this.flags = n;
        this.bidiParms = bidiInit;
        if (null == this.bidiParms) {
            if (VM.isBooted()) {
                this.bidiParms = System.getSecurityManager() == null ? (String)new GetPropertyAction("JAVABIDI").run() : (String)AccessController.doPrivileged(new GetPropertyAction("JAVABIDI"));
                if (null == this.bidiParms) {
                    this.bidiParms = "NO";
                }
                bidiInit = this.bidiParms;
            } else {
                this.bidiParms = "NO";
            }
        }
        this.bidiEnabled = !"NO".equals(this.bidiParms);
    }

    private boolean validSecond(int n, int n2, int n3) {
        if (n3 < 128 || n3 > 191) {
            return false;
        }
        if ((this.flags & 2) != 0) {
            return true;
        }
        switch (n) {
            case 2: {
                if (n2 >= 2) break;
                return false;
            }
            case 3: {
                if (n2 != 0 || n3 >= 160) break;
                return false;
            }
            case 4: {
                if ((this.flags & 4) != 0) {
                    return false;
                }
                if (n2 == 0 && n3 < 144) {
                    return false;
                }
                if (n2 == 4 && n3 > 143) {
                    return false;
                }
                if (n2 <= 4) break;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        byte[] byArray = byteBuffer.array();
        int n = byteBuffer.arrayOffset() + byteBuffer.position();
        int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
        char[] cArray = charBuffer.array();
        int n3 = charBuffer.arrayOffset() + charBuffer.position();
        int n4 = charBuffer.arrayOffset() + charBuffer.limit();
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = n;
        try {
            while (n < n2) {
                int n9;
                if (n5 == 0) {
                    while ((n9 = byArray[n++]) >= 0) {
                        if (n4 - n3 < 1) {
                            n8 = --n;
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        cArray[n3++] = (char)n9;
                        if (n < n2) continue;
                        n8 = n;
                        CoderResult coderResult = CoderResult.UNDERFLOW;
                        return coderResult;
                    }
                    n8 = n - 1;
                    n5 = States[(n9 & 0xFF) >> 3];
                    n6 = 1;
                    n7 = n9 & StateMask[n5];
                    if (n5 != 1) continue;
                    CoderResult coderResult = CoderResult.malformedForLength(1);
                    return coderResult;
                }
                n9 = byArray[n++] & 0xFF;
                if (n6 == 1) {
                    if (!this.validSecond(n5, n7, n9)) {
                        CoderResult coderResult = CoderResult.malformedForLength(n6);
                        return coderResult;
                    }
                } else if (n9 < 128 || n9 > 191) {
                    CoderResult coderResult = CoderResult.malformedForLength(n6);
                    return coderResult;
                }
                n7 = n7 << 6 | n9 & 0x3F;
                if (n6 + 1 >= n5) {
                    if (n7 < 65536) {
                        if (n4 - n3 < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        cArray[n3++] = (char)n7;
                    } else {
                        if (n4 - n3 < 2) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        cArray[n3++] = (char)((n7 - 65536) / 1024 + 55296);
                        cArray[n3++] = (char)((n7 - 65536) % 1024 + 56320);
                    }
                    n5 = 0;
                    n8 = n;
                    continue;
                }
                ++n6;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            byteBuffer.position(n8 - byteBuffer.arrayOffset());
            charBuffer.position(n3 - charBuffer.arrayOffset());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        CoderResult coderResult;
        int n = byteBuffer.position();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        try {
            block2: while (byteBuffer.hasRemaining()) {
                block16: {
                    int n5;
                    if (n2 != 0) {
                        n5 = byteBuffer.get() & 0xFF;
                        if (n3 == 1) {
                            if (!this.validSecond(n2, n4, n5)) {
                                CoderResult coderResult2 = CoderResult.malformedForLength(n3);
                                Object var11_19 = null;
                                byteBuffer.position(n);
                                return coderResult2;
                            }
                        } else if (n5 < 128 || n5 > 191) {
                            CoderResult coderResult3 = CoderResult.malformedForLength(n3);
                            Object var11_20 = null;
                            byteBuffer.position(n);
                            return coderResult3;
                        }
                        n4 = n4 << 6 | n5 & 0x3F;
                        if (n3 + 1 >= n2) {
                            if (n4 < 65536) {
                                if (!charBuffer.hasRemaining()) {
                                    CoderResult coderResult4 = CoderResult.OVERFLOW;
                                    Object var11_21 = null;
                                    byteBuffer.position(n);
                                    return coderResult4;
                                }
                                charBuffer.put((char)n4);
                            } else {
                                if (charBuffer.remaining() < 2) {
                                    CoderResult coderResult5 = CoderResult.OVERFLOW;
                                    Object var11_22 = null;
                                    byteBuffer.position(n);
                                    return coderResult5;
                                }
                                charBuffer.put((char)((n4 - 65536) / 1024 + 55296));
                                charBuffer.put((char)((n4 - 65536) % 1024 + 56320));
                            }
                            n += n2;
                            n2 = 0;
                            continue;
                        }
                        ++n3;
                        continue;
                    }
                    do {
                        if ((n5 = byteBuffer.get()) < 0) {
                            n2 = States[(n5 & 0xFF) >> 3];
                            n3 = 1;
                            n4 = n5 & StateMask[n2];
                            if (n2 != 1) continue block2;
                            break block16;
                        }
                        if (!charBuffer.hasRemaining()) {
                            CoderResult coderResult6 = CoderResult.OVERFLOW;
                            Object var11_16 = null;
                            byteBuffer.position(n);
                            return coderResult6;
                        }
                        charBuffer.put((char)n5);
                        ++n;
                    } while (byteBuffer.hasRemaining());
                    CoderResult coderResult7 = CoderResult.UNDERFLOW;
                    Object var11_17 = null;
                    byteBuffer.position(n);
                    return coderResult7;
                }
                CoderResult coderResult8 = CoderResult.malformedForLength(1);
                Object var11_18 = null;
                byteBuffer.position(n);
                return coderResult8;
            }
            coderResult = CoderResult.UNDERFLOW;
            Object var11_23 = null;
        }
        catch (Throwable throwable) {
            Object var11_24 = null;
            byteBuffer.position(n);
            throw throwable;
        }
        byteBuffer.position(n);
        return coderResult;
    }

    protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        BidiConvert bidiConvert;
        int n;
        int n2;
        char[] cArray;
        CoderResult coderResult;
        boolean bl;
        int n3 = charBuffer.position();
        if (byteBuffer.hasArray() && charBuffer.hasArray() && !IBMCharsetDecoder.UseBuffer) {
            bl = true;
            coderResult = this.decodeArrayLoop(byteBuffer, charBuffer);
            int n4 = charBuffer.position();
            cArray = charBuffer.array();
            n2 = charBuffer.arrayOffset() + n3;
            n = charBuffer.arrayOffset() + n4;
        } else {
            bl = false;
            coderResult = this.decodeBufferLoop(byteBuffer, charBuffer);
            int n5 = charBuffer.position();
            n2 = 0;
            n = n5 - n3;
            cArray = new char[n];
            charBuffer.position(n3);
            charBuffer.get(cArray);
            charBuffer.position(n5);
        }
        if (this.bidiEnabled && (bidiConvert = new BidiConvert()).isBidiData(cArray, n2, n, this.bidiParms, this.toString())) {
            cArray = bidiConvert.toUnicode(cArray, n2, n, this.bidiParms, this.toString());
            if (bl) {
                System.arraycopy(cArray, 0, charBuffer.array(), charBuffer.arrayOffset() + n3, cArray.length);
            } else {
                charBuffer.position(n3);
                charBuffer.put(cArray);
            }
        }
        return coderResult;
    }
}

