/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import com.ibm.jvm.format.TraceFile;
import com.ibm.jvm.format.Util;
import java.io.BufferedWriter;
import java.io.IOException;

public class ServiceSection {
    private String eyecatcher_string;
    private int length;
    private int version;
    private int modification;
    private long level_offset;
    private TraceFile traceFile;

    public ServiceSection(TraceFile traceFile, int n) throws IOException {
        this.traceFile = traceFile;
        traceFile.seek(n);
        this.eyecatcher_string = Util.convertAndCheckEyecatcher(traceFile.readI());
        this.length = traceFile.readI();
        this.version = traceFile.readI();
        this.modification = traceFile.readI();
        this.level_offset = traceFile.getFilePointer();
        Util.Debug.println("ServiceSection: eyecatcher:        " + this.eyecatcher_string);
        Util.Debug.println("ServiceSection: length:            " + this.length);
        Util.Debug.println("ServiceSection: version:           " + this.version);
        Util.Debug.println("ServiceSection: modification:      " + this.modification);
    }

    protected void summary(BufferedWriter bufferedWriter) throws IOException {
        this.traceFile.seek(this.level_offset);
        byte by = 0;
        Util.Debug.println("ServiceSection: level_offset:        " + this.level_offset);
        bufferedWriter.write("Service Level :");
        bufferedWriter.newLine();
        by = this.traceFile.readByte();
        if (by != 0) {
            bufferedWriter.write("        " + (char)by);
            while ((by = this.traceFile.readByte()) != 0) {
                bufferedWriter.write((char)by);
            }
            bufferedWriter.newLine();
        }
        bufferedWriter.newLine();
    }
}

