/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.converters;

import java.math.BigDecimal;

public class FloatingPoint {
    public static final int HEXADECIMAL_FLOATING_POINT = 64;
    public static final int IEEE_754_FLOATING_POINT = 72;
    public static final int IEEE_754_FLOATING_POINT_BYTE_REVERSED = 71;
    public static final int VAX_BINARY_FLOATING_POINT = 73;
    private static final long IEEE_DOUBLE_SIGN_MASK = Long.MIN_VALUE;
    private static final long IEEE_DOUBLE_EXPONENT_MASK = 0x7FF0000000000000L;
    private static final long IEEE_DOUBLE_MANTISSA_MASK = 0xFFFFFFFFFFFFFL;
    private static final long IEEE_DOUBLE_MANTISSA_MSB_MASK = 0x80000000000000L;
    private static final long IEEE_DOUBLE_BIAS = 1022L;
    private static final int IEEE_FLOAT_SIGN_MASK = Integer.MIN_VALUE;
    private static final int IEEE_FLOAT_EXPONENT_MASK = 2139095040;
    private static final int IEEE_FLOAT_MANTISSA_MASK = 0x7FFFFF;
    private static final int IEEE_FLOAT_MANTISSA_MSB_MASK = 0x800000;
    private static final int IEEE_FLOAT_BIAS = 126;
    private static final long HEX_DOUBLE_SIGN_MASK = Long.MIN_VALUE;
    private static final int HEX_DOUBLE_BIAS = 64;
    private static final long HEX_DOUBLE_EXPONENT_MASK = 0x7F00000000000000L;
    private static final long HEX_DOUBLE_MANTISSA_MASK = 0xFFFFFFFFFFFFFFL;
    private static final int HEX_FLOAT_SIGN_MASK = Integer.MIN_VALUE;
    private static final int HEX_FLOAT_BIAS = 64;
    private static final int HEX_FLOAT_EXPONENT_MASK = 0x7F000000;
    private static final int HEX_FLOAT_MANTISSA_MASK = 0xFFFFFF;
    private static final int VAX_FLOAT_SIGN_MASK = Integer.MIN_VALUE;
    private static final int VAX_FLOAT_EXPONENT_MASK = 2139095040;
    private static final int VAX_FLOAT_MANTISSA_MASK = 0x7FFFFF;
    private static final int VAX_FLOAT_MANTISSA_MSB_MASK = 0x800000;
    private static final int VAX_FLOAT_BIAS = 128;

    private FloatingPoint() {
    }

    public static BigDecimal getBigDecimal(byte[] byArray, int n, int n2) {
        switch (n2) {
            case 64: {
                return FloatingPoint.hexadecimalBytesToBigDecimal(byArray, n);
            }
            case 72: {
                return FloatingPoint.ieee754BytesToBigDecimal(byArray, n);
            }
            case 71: {
                return FloatingPoint.ieee754ReversedBytesToBigDecimal(byArray, n);
            }
            case 73: {
                return FloatingPoint.vaxBytesToBigDecimal(byArray, n);
            }
        }
        throw new IllegalArgumentException();
    }

    public static double getDouble(byte[] byArray, int n, int n2) {
        switch (n2) {
            case 64: {
                return FloatingPoint.hexadecimalBytesToDouble(byArray, n);
            }
            case 72: {
                return FloatingPoint.ieee754BytesToDouble(byArray, n);
            }
            case 71: {
                return FloatingPoint.ieee754ReversedBytesToDouble(byArray, n);
            }
            case 73: {
                return FloatingPoint.vaxBytesToDouble(byArray, n);
            }
        }
        throw new IllegalArgumentException();
    }

    public static float getFloat(byte[] byArray, int n, int n2) {
        switch (n2) {
            case 64: {
                return FloatingPoint.hexadecimalBytesToFloat(byArray, n);
            }
            case 72: {
                return FloatingPoint.ieee754BytesToFloat(byArray, n);
            }
            case 71: {
                return FloatingPoint.ieee754ReversedBytesToFloat(byArray, n);
            }
            case 73: {
                return FloatingPoint.vaxBytesToFloat(byArray, n);
            }
        }
        throw new IllegalArgumentException();
    }

    public static BigDecimal hexadecimalBytesToBigDecimal(byte[] byArray, int n) {
        throw new UnsupportedOperationException();
    }

    public static double hexadecimalBytesToDouble(byte[] byArray, int n) {
        return FloatingPoint.hexBitsToDouble(FloatingPoint.convertFromByteToLong(byArray, n));
    }

    public static float hexadecimalBytesToFloat(byte[] byArray, int n) {
        return FloatingPoint.hexBitsToFloat(FloatingPoint.convertFromByteToInt(byArray, n, 4));
    }

    public static BigDecimal ieee754BytesToBigDecimal(byte[] byArray, int n) {
        throw new UnsupportedOperationException();
    }

    public static double ieee754BytesToDouble(byte[] byArray, int n) {
        return Double.longBitsToDouble(FloatingPoint.convertFromByteToLong(byArray, n));
    }

    public static float ieee754BytesToFloat(byte[] byArray, int n) {
        return Float.intBitsToFloat(FloatingPoint.convertFromByteToInt(byArray, n, 4));
    }

    public static BigDecimal ieee754ReversedBytesToBigDecimal(byte[] byArray, int n) {
        throw new UnsupportedOperationException();
    }

    public static double ieee754ReversedBytesToDouble(byte[] byArray, int n) {
        byArray = FloatingPoint.swap(byArray, n, 8);
        return Double.longBitsToDouble(FloatingPoint.convertFromByteToLong(byArray, n));
    }

    public static float ieee754ReversedBytesToFloat(byte[] byArray, int n) {
        byArray = FloatingPoint.swap(byArray, n, 4);
        return Float.intBitsToFloat(FloatingPoint.convertFromByteToInt(byArray, n, 4));
    }

    public static BigDecimal vaxBytesToBigDecimal(byte[] byArray, int n) {
        throw new UnsupportedOperationException();
    }

    public static double vaxBytesToDouble(byte[] byArray, int n) {
        throw new UnsupportedOperationException();
    }

    public static float vaxBytesToFloat(byte[] byArray, int n) {
        return FloatingPoint.VAXBitsToFloat(FloatingPoint.convertFromByteToInt(byArray, n, 4));
    }

    private static int convertFromByteToInt(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        if (n2 == 2) {
            n3 = 16;
        }
        int n5 = n;
        while (n5 < n + n2) {
            if (n5 == n) {
                n4 = byArray[n5] << 24 >>> n3;
            } else {
                int n6 = byArray[n5] << 24;
                int n7 = n6 >>> n3;
                n4 |= n7;
            }
            n3 += 8;
            ++n5;
        }
        return n4;
    }

    private static long convertFromByteToLong(byte[] byArray, int n) {
        return (long)byArray[n] << 56 & 0xFF00000000000000L | (long)byArray[n + 1] << 48 & 0xFF000000000000L | (long)byArray[n + 2] << 40 & 0xFF0000000000L | (long)byArray[n + 3] << 32 & 0xFF00000000L | (long)byArray[n + 4] << 24 & 0xFF000000L | (long)byArray[n + 5] << 16 & 0xFF0000L | (long)byArray[n + 6] << 8 & 0xFF00L | (long)byArray[n + 7] & 0xFFL;
    }

    private static double hexBitsToDouble(long l) {
        boolean bl;
        boolean bl2 = bl = (l & Long.MIN_VALUE) == 0L;
        if ((l & Long.MAX_VALUE) == 0L) {
            if (bl) {
                return 0.0;
            }
            return -0.0;
        }
        long l2 = l & 0xFFFFFFFFFFFFFFL;
        long l3 = l & 0x7F00000000000000L;
        l3 >>= 56;
        long l4 = (l3 -= 64L) * 4L;
        long l5 = l2;
        if (l4 <= -1022L) {
            l5 >>= 1;
            while (l4 < -1022L) {
                ++l4;
                l5 >>= 1;
            }
        }
        while (l5 != 0L && (l5 & 0x80000000000000L) == 0L && l4 > -1022L) {
            l5 <<= 1;
            --l4;
        }
        if (l4 < -1045L) {
            return 0.0;
        }
        if (l4 > 1024L) {
            if (bl) {
                return Double.POSITIVE_INFINITY;
            }
            return Double.NEGATIVE_INFINITY;
        }
        long l6 = 0L;
        if (!bl) {
            l6 |= Long.MIN_VALUE;
        }
        l4 += 1022L;
        l6 |= (l4 <<= 52);
        l5 >>= 3;
        return Double.longBitsToDouble(l6 |= (l5 &= 0xFFFFFFFFFFFFFL));
    }

    private static float hexBitsToFloat(int n) {
        boolean bl;
        boolean bl2 = bl = (n & Integer.MIN_VALUE) == 0;
        if ((n & Integer.MAX_VALUE) == 0) {
            if (bl) {
                return 0.0f;
            }
            return -0.0f;
        }
        int n2 = n & 0xFFFFFF;
        int n3 = n & 0x7F000000;
        n3 >>= 24;
        int n4 = (n3 -= 64) * 4;
        int n5 = n2;
        if (n4 <= -126) {
            n5 >>= 1;
            while (n4 < -126) {
                ++n4;
                n5 >>= 1;
            }
        }
        while (n5 != 0 && (n5 & 0x800000) == 0 && n4 > -126) {
            n5 <<= 1;
            --n4;
        }
        if (n4 < -149) {
            return 0.0f;
        }
        if (n4 > 128) {
            if (bl) {
                return Float.POSITIVE_INFINITY;
            }
            return Float.NEGATIVE_INFINITY;
        }
        int n6 = 0;
        if (!bl) {
            n6 |= Integer.MIN_VALUE;
        }
        n4 += 126;
        n6 |= (n4 <<= 23);
        return Float.intBitsToFloat(n6 |= (n5 &= 0x7FFFFF));
    }

    private static byte[] swap(byte[] byArray, int n, int n2) {
        int n3 = n;
        int n4 = n + n2 - 1;
        while (n3 < n4) {
            byte by = byArray[n3];
            byArray[n3] = byArray[n4];
            byArray[n4] = by;
            ++n3;
            --n4;
        }
        return byArray;
    }

    private static float VAXBitsToFloat(int n) {
        boolean bl = (n & Integer.MIN_VALUE) == 0;
        System.out.println("VAXBitsToFloat ");
        System.out.println("FloatBits : " + n);
        if ((n & Integer.MAX_VALUE) == 0) {
            if (bl) {
                return 0.0f;
            }
            return -0.0f;
        }
        int n2 = n & 0x7FFFFF;
        int n3 = n & 0x7F800000;
        int n4 = n3 >> 23;
        System.out.println("exponent =" + (n4 -= 128));
        System.out.println("mantissa =" + n2);
        double d = n2;
        if (n3 < -255) {
            return 0.0f;
        }
        if (n3 > 127) {
            if (bl) {
                return Float.POSITIVE_INFINITY;
            }
            return Float.NEGATIVE_INFINITY;
        }
        int n5 = 0;
        if (!bl) {
            n5 |= Integer.MIN_VALUE;
        }
        d = n3 != 0 ? 0.1 + (double)n2 / 100.0 : 0.0 + (double)n2 / 100.0;
        float f = (float)(d * Math.pow(2.0, n4));
        return f;
    }
}

