/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.util;

import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import javax.swing.JTextArea;

public class JTextLabel
extends JTextArea
implements PropertyChangeListener {
    private Component containingPane;

    public JTextLabel(Component component, String string) {
        super(string);
        this.containingPane = component;
        this.makeJTextFieldAccessible();
    }

    public JTextLabel(String string) {
        this(null, string);
    }

    private void makeJTextFieldAccessible() {
        HashSet<AWTKeyStroke> hashSet = new HashSet<AWTKeyStroke>();
        hashSet.add(AWTKeyStroke.getAWTKeyStroke(9, 0));
        this.setFocusTraversalKeys(0, hashSet);
        hashSet.clear();
        hashSet.add(AWTKeyStroke.getAWTKeyStroke(9, 64));
        this.setFocusTraversalKeys(1, hashSet);
        class FocusHandler
        extends FocusAdapter {
            private JTextArea text;

            public FocusHandler(JTextArea jTextArea) {
                this.text = jTextArea;
            }

            public void focusGained(FocusEvent focusEvent) {
                this.text.getCaret().setVisible(true);
            }
        }
        this.addFocusListener(new FocusHandler(this));
        Font font = (Font)Toolkit.getDefaultToolkit().getDesktopProperty("win.messagebox.font");
        if (font != null) {
            this.setFont(font);
        }
        Toolkit.getDefaultToolkit().addPropertyChangeListener("win.messagebox.font", this);
        Toolkit.getDefaultToolkit().addPropertyChangeListener("win.3d.backgroundColor", this);
        this.setEditable(false);
        this.setOpaque(false);
        this.getAccessibleContext().setAccessibleDescription(this.getText());
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Color color = (Color)toolkit.getDesktopProperty("win.3d.backgroundColor");
        if (color != null) {
            this.setBackground(color);
        }
    }

    public void setText(String string) {
        this.getAccessibleContext().setAccessibleDescription(string);
        super.setText(string);
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }
}

