/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.cache;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import sun.plugin.cache.JarCacheTableCellRenderer;
import sun.plugin.cache.JarCacheTableColumn;
import sun.plugin.cache.JarCacheTableColumnModel;
import sun.plugin.cache.JarCacheTableHeaderRenderer;
import sun.plugin.cache.JarCacheTableSorter;
import sun.plugin.cache.TableKeyActions;

public class JarCacheTable
extends JTable {
    public static final Font tableFont = new Font("Dialog", 0, 10);
    private final Color shadeColor = new Color(232, 232, 232);
    private DefaultTableCellRenderer tableCellRenderer = new JarCacheTableCellRenderer(tableFont, this.shadeColor);
    private JarCacheTableColumnModel tableColumnModel = new JarCacheTableColumnModel();
    private JarCacheTableColumn[] tableColumns = null;
    private JarCacheTableSorter sorter = null;
    private String[] colNames = null;

    public JarCacheTable() {
        TableColumn tableColumn;
        int n;
        int n2;
        this.sizeColumnsToFit(3);
        this.setAutoResizeMode(0);
        this.setColumnModel(this.tableColumnModel);
        this.registerKeyboardAction(TableKeyActions.decColumnAction, KeyStroke.getKeyStroke(114, 0), 0);
        this.registerKeyboardAction(TableKeyActions.incColumnAction, KeyStroke.getKeyStroke(115, 0), 0);
        this.tableColumns = this.tableColumnModel.getColumnArray();
        this.colNames = new String[this.tableColumns.length];
        for (n2 = 0; n2 < this.tableColumns.length; ++n2) {
            this.colNames[n2] = this.tableColumns[n2].getHeaderValue().toString();
        }
        this.sorter = new JarCacheTableSorter(this.colNames);
        this.sorter.addMouseListenerToHeaderInTable(this);
        this.setModel(this.sorter);
        n2 = this.getColumnModel().getColumnCount();
        for (n = 0; n < n2; ++n) {
            tableColumn = this.getColumnModel().getColumn(n);
            tableColumn.setCellRenderer(new DefaultTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    if (component instanceof Component) {
                        component.getAccessibleContext().setAccessibleName(jTable.getModel().getColumnName(jTable.convertColumnIndexToModel(n2)) + " " + object);
                        component.getAccessibleContext().setAccessibleDescription(jTable.getModel().getColumnName(jTable.convertColumnIndexToModel(n2)) + " " + object);
                    }
                    return component;
                }
            });
        }
        n = this.tableColumnModel.getColumnCount();
        tableColumn = null;
        for (int i = 0; i < n; ++i) {
            tableColumn = this.columnModel.getColumn(i);
            if (this.tableColumns[i].isVisible()) {
                tableColumn.setMinWidth(this.tableColumns[i].getMinWidth());
                tableColumn.setPreferredWidth(this.tableColumns[i].getPreferredWidth());
                tableColumn.setResizable(this.tableColumns[i].getResizable());
                continue;
            }
            tableColumn.setMinWidth(0);
            tableColumn.setMaxWidth(0);
        }
        this.setHeaderRenderers();
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JarCacheTable.this.removeRows();
            }
        };
        this.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(127, 0), 2);
        this.getTableHeader().setReorderingAllowed(false);
        this.setPreferredScrollableViewportSize(this.getPreferredSize());
    }

    public void setHeaderRenderers() {
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            tableColumnModel.getColumn(i).setHeaderRenderer(new JarCacheTableHeaderRenderer());
        }
    }

    public void refresh() {
        this.sorter.refresh();
    }

    public JarCacheTableColumnModel getJarCacheTableColumnModel() {
        return this.tableColumnModel;
    }

    public JarCacheTableColumn[] getJarCacheTableColumns() {
        return this.tableColumns;
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        return this.tableCellRenderer;
    }

    public Font getFont() {
        return tableFont;
    }

    public void removeRows() {
        this.sorter.removeRows(this.getSelectedRows());
    }

    public void adjustColumnSize(Container container) {
        int n;
        int n2 = this.tableColumnModel.getColumnCount();
        int n3 = 0;
        int n4 = 0;
        TableColumn tableColumn = null;
        for (int i = 0; i < n2 - 1; ++i) {
            tableColumn = this.columnModel.getColumn(i);
            if (!this.tableColumns[i].isVisible()) continue;
            int n5 = 0;
            JarCacheTableHeaderRenderer jarCacheTableHeaderRenderer = (JarCacheTableHeaderRenderer)tableColumn.getHeaderRenderer();
            if (jarCacheTableHeaderRenderer != null) {
                n5 = jarCacheTableHeaderRenderer.getPreferredSize().width;
                tableColumn.setMinWidth(n5);
            }
            n3 += n5 > (n = this.tableColumns[i].getWidth()) ? n5 : n;
            n4 += tableColumn.getPreferredWidth();
        }
        n4 = n3;
        Dimension dimension = container.getSize();
        Insets insets = container.getInsets();
        tableColumn = this.columnModel.getColumn(n2 - 1);
        n = (int)(dimension.getWidth() - (double)n4 - (double)insets.left - (double)insets.right - 3.0);
        tableColumn.setPreferredWidth(n);
    }
}

