/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11.provider;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandomSpi;

public final class SecureRandom
extends SecureRandomSpi {
    private MessageDigest md5;
    private SecureRandom seedGenerator;
    private byte[] state;
    private int ri;
    private int tMix = 1;

    public SecureRandom() {
        this.init(null);
    }

    public SecureRandom(byte[] byArray) {
        this.init(byArray);
    }

    public byte[] engineGenerateSeed(int n) {
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[1];
        int n2 = 0;
        while (n2 < n) {
            this.trng(byArray2, 0, 1);
            byArray[n2] = byArray2[0];
            ++n2;
        }
        return byArray;
    }

    public synchronized void engineNextBytes(byte[] byArray) {
        if (this.state == null) {
            byte[] byArray2 = this.engineGenerateSeed(40);
            this.state = this.md5.digest(byArray2);
        }
        this.random(byArray, 0, byArray.length, false);
    }

    public synchronized void engineSetSeed(byte[] byArray) {
        if (this.state != null) {
            this.md5.update(this.state);
            int n = 0;
            while (n < this.state.length) {
                this.state[n] = 0;
                ++n;
            }
        }
        this.state = this.md5.digest(byArray);
    }

    private void init(byte[] byArray) {
        String string = "IBMPKCS11";
        try {
            this.md5 = MessageDigest.getInstance("MD5", string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError(String.valueOf(string) + " MD5 is not available");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new InternalError(String.valueOf(string) + " is not available");
        }
        if (byArray != null) {
            this.engineSetSeed(byArray);
        }
    }

    private synchronized void random(byte[] byArray, int n, int n2, boolean bl) {
        int n3 = 0;
        while (n3 < n2) {
            this.ri = (this.ri + 1) % 8;
            int n4 = this.ri;
            if (n4 == 0) {
                this.state = this.md5.digest(this.state);
            }
            if (n4 % this.tMix == 0 && bl) {
                byte by = this.state[n4];
                this.trng(this.state, n4, 1);
                int n5 = n4;
                this.state[n5] = (byte)(this.state[n5] ^ by);
            }
            byArray[n++] = this.state[n4];
            ++n3;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void trng(byte[] var1_1, int var2_2, int var3_3) {
        var4_4 = 0;
        var5_5 = 0;
        ** GOTO lbl30
        {
            var6_6 = -1;
            while (true) {
                var7_7 = 0;
                while (var7_7 == 0) {
                    var8_9 = System.currentTimeMillis() + 1L;
                    while (System.currentTimeMillis() < var8_9) {
                        ++var7_7;
                    }
                }
                if (var6_6 != -1) {
                    var6_6 ^= var7_7;
                    break;
                }
                var6_6 = var7_7;
            }
            var8_8 = 0;
            while (var8_8 < 16) {
                if ((var6_6 & 1) != 0) {
                    var5_5 = var5_5 << 1 | var7_7 & 1;
                    ++var4_4;
                }
                ++var8_8;
                var6_6 >>>= 1;
                var7_7 >>>= 1;
            }
            do {
                if (var4_4 < 8) continue block0;
                var1_1[var2_2++] = (byte)(var5_5 >> (var4_4 -= 8));
lbl30:
                // 2 sources

            } while (var3_3-- > 0);
        }
    }
}

