/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.cli;

import com.ibm.gsk.ikeyman.basic.KMException;
import com.ibm.gsk.ikeyman.basic.KMSystem;
import com.ibm.gsk.ikeyman.basic.KeyDatabaseException;
import com.ibm.gsk.ikeyman.basic.KeyDatabaseOperatorNullException;
import com.ibm.gsk.ikeyman.basic.KeyStoreManager;
import com.ibm.gsk.ikeyman.basic.KeyStoreManagerException;
import com.ibm.gsk.ikeyman.cli.CLIConstants;
import com.ibm.gsk.ikeyman.cli.CLIDatabaseInfo;
import com.ibm.gsk.ikeyman.ikeycmd;
import java.util.Enumeration;
import java.util.Vector;

public class CLICryptoDatabaseManager
implements CLIConstants {
    public static void keyDbChangePw(CLIDatabaseInfo cLIDatabaseInfo) throws KMException, KeyDatabaseException, KeyDatabaseOperatorNullException {
        System.out.print(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO"));
        ikeycmd.displayHelp("-keydb -changepw", "CMS", -47);
        ikeycmd.debugMsg("CLICryptoDatabaseManager::keyDbChangePw, 0000");
        KeyStoreManager keyStoreManager = null;
        cLIDatabaseInfo.init();
        String string = cLIDatabaseInfo.getName();
        String string2 = cLIDatabaseInfo.getPassword();
        String string3 = cLIDatabaseInfo.getNewPassword();
        String string4 = cLIDatabaseInfo.getTokenLabel();
        long l = cLIDatabaseInfo.getExpire();
        int n = cLIDatabaseInfo.getDbType();
        int n2 = cLIDatabaseInfo.getSlotID();
        ikeycmd.debugMsg("TokenModuleName: " + string);
        ikeycmd.debugMsg("TokenPassword: " + string2);
        ikeycmd.debugMsg("newPassword: " + string3);
        ikeycmd.debugMsg("DBType: " + n);
        ikeycmd.debugMsg("TokenLabel: " + string4);
        ikeycmd.debugMsg("SlotID:  " + n2);
        ikeycmd.debugMsg("\n");
        try {
            keyStoreManager = CLICryptoDatabaseManager.makeCryptoDatabase(string4, n2, n, string);
            if (keyStoreManager == null) {
                throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_NOT_INITIALIZED"));
            }
            keyStoreManager.open(string2);
            keyStoreManager.changePassword(string3);
            keyStoreManager.close();
        }
        catch (KMException kMException) {
            if (ikeycmd.DEBUG) {
                ikeycmd.debugMsg("CLICryptoDatabaseManager::keyDbChangePw, 9900, KMException");
                ikeycmd.debugMsg(kMException.getMessage());
            }
            throw kMException;
        }
    }

    protected static boolean cryptographicTokenExists(int n) {
        try {
            return KeyStoreManager.isCryptoGraphicTokenExists(n);
        }
        catch (KMException kMException) {
            return false;
        }
    }

    public static KeyStoreManager makeCryptoDatabase(String string, int n, int n2, String string2) throws KeyStoreManagerException, KMException {
        int[] nArray = KeyStoreManager.getSupportedCLIDatabaseTypes();
        KeyStoreManager keyStoreManager = new KeyStoreManager(true);
        int n3 = n2 == 10 ? 1 : 2;
        ikeycmd.debugMsg("CLICryptoDatabaseManager::cryptographicModuleName  " + string2);
        ikeycmd.debugMsg("CLICryptoDatabaseManager::cryptoType  " + n3);
        switch (n3) {
            case 1: {
                if (n != -1) {
                    ikeycmd.displayHelp("-relativeSlotNumber", -42);
                }
                if (string == null) {
                    ikeycmd.displayHelp("-tokenlabel", -45);
                }
                KMSystem.cleanAll();
                break;
            }
            case 2: {
                if (string != null) {
                    ikeycmd.displayHelp("-tokenlabel", -42);
                }
                if (n != -1) break;
                ikeycmd.displayHelp("-relativeSlotNumber", -45);
                break;
            }
        }
        KeyStoreManager.initCryptoGraphicToken(string2, n3);
        try {
            if (CLICryptoDatabaseManager.cryptographicTokenExists(n3)) {
                KeyStoreManager keyStoreManager2;
                keyStoreManager = keyStoreManager2 = new KeyStoreManager(string, n, n3, true);
            }
            return keyStoreManager;
        }
        catch (KMException kMException) {
            System.out.println(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO"));
            return null;
        }
    }

    public static boolean validateCSPName(String string) {
        try {
            Vector vector = KeyStoreManager.getMSCspNameList();
            if (vector == null) {
                return false;
            }
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                if (!enumeration.nextElement().toString().equals(string)) continue;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            ikeycmd.debugMsg("Exception occurred=, while trying to retrive CSP name: " + exception);
            return false;
        }
        catch (Error error) {
            ikeycmd.debugMsg("Exception occurred=, while trying to retrive CSP name: " + error);
            return false;
        }
    }

    public static boolean isCSPCrypto(String string) {
        if (KMSystem.isJNIEnabled()) {
            return CLICryptoDatabaseManager.validateCSPName(string);
        }
        return false;
    }

    public static String getCryptoModuleName() {
        String string = System.getProperty("DEFAULT_CRYPTOGRAPHIC_MODULE");
        ikeycmd.debugMsg("CLICryptoDatabaseManager.getCryptoModuleName=" + string);
        if (string != null) {
            return string;
        }
        return KMSystem.getInitSetting("DEFAULT_CRYPTOGRAPHIC_MODULE");
    }
}

