/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.List;
import java.awt.ScrollPane;
import java.awt.TextArea;
import java.awt.peer.PanelPeer;
import sun.awt.SunGraphicsCallback;
import sun.awt.motif.MCanvasPeer;
import sun.awt.motif.MComponentPeer;
import sun.awt.motif.MToolkit;

class MPanelPeer
extends MCanvasPeer
implements PanelPeer {
    MPanelPeer() {
    }

    MPanelPeer(Component component) {
        super(component);
    }

    MPanelPeer(Component component, Object object) {
        super(component, object);
    }

    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        SunGraphicsCallback.PaintHeavyweightComponentsCallback.getInstance().runComponents(((Container)this.target).getComponents(), graphics, 3);
    }

    public void print(Graphics graphics) {
        super.print(graphics);
        SunGraphicsCallback.PrintHeavyweightComponentsCallback.getInstance().runComponents(((Container)this.target).getComponents(), graphics, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBackground(Color color) {
        Container container = (Container)this.target;
        Object object = this.target.getTreeLock();
        synchronized (object) {
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                MComponentPeer mComponentPeer = (MComponentPeer)MToolkit.targetToPeer(component);
                if (mComponentPeer == null) continue;
                Color color2 = component.getBackground();
                if (color2 == null || color2.equals(color)) {
                    mComponentPeer.setBackground(color);
                    mComponentPeer.pSetBackground(color);
                }
                if (!(component instanceof List) && !(component instanceof TextArea) && !(component instanceof ScrollPane)) continue;
                mComponentPeer.pSetScrollbarBackground(color);
            }
        }
        this.pSetBackground(color);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setForeground(Color color) {
        Container container = (Container)this.target;
        Object object = this.target.getTreeLock();
        synchronized (object) {
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                MComponentPeer mComponentPeer = (MComponentPeer)MToolkit.targetToPeer(component);
                if (mComponentPeer == null) continue;
                Color color2 = component.getForeground();
                if (color2 == null || color2.equals(color)) {
                    mComponentPeer.setForeground(color);
                    mComponentPeer.pSetForeground(color);
                }
                if (!(component instanceof List) && !(component instanceof TextArea) && !(component instanceof ScrollPane)) continue;
                mComponentPeer.pSetInnerForeground(color);
            }
        }
        this.pSetForeground(color);
    }

    public Insets insets() {
        return this.getInsets();
    }

    private void recursiveDisplayChanged(Component component, int n) {
        Component[] componentArray;
        if (component instanceof Container) {
            componentArray = ((Container)component).getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                this.recursiveDisplayChanged(componentArray[i], n);
            }
        }
        if ((componentArray = component.getPeer()) != null && componentArray instanceof MCanvasPeer) {
            MCanvasPeer mCanvasPeer = (MCanvasPeer)componentArray;
            mCanvasPeer.displayChanged(n);
        }
    }

    public void displayChanged(int n) {
        Component[] componentArray = ((Container)this.target).getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            this.recursiveDisplayChanged(componentArray[i], n);
        }
    }

    protected boolean shouldFocusOnClick() {
        return ((Container)this.target).getComponentCount() == 0;
    }
}

