/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.Robot;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.awt.event.WindowEvent;
import java.awt.peer.ButtonPeer;
import java.awt.peer.CanvasPeer;
import java.awt.peer.CheckboxMenuItemPeer;
import java.awt.peer.CheckboxPeer;
import java.awt.peer.ChoicePeer;
import java.awt.peer.DialogPeer;
import java.awt.peer.FileDialogPeer;
import java.awt.peer.FontPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.LabelPeer;
import java.awt.peer.ListPeer;
import java.awt.peer.MenuBarPeer;
import java.awt.peer.MenuItemPeer;
import java.awt.peer.MenuPeer;
import java.awt.peer.PanelPeer;
import java.awt.peer.PopupMenuPeer;
import java.awt.peer.RobotPeer;
import java.awt.peer.ScrollPanePeer;
import java.awt.peer.ScrollbarPeer;
import java.awt.peer.TextAreaPeer;
import java.awt.peer.TextFieldPeer;
import java.awt.peer.WindowPeer;
import java.io.FilePermission;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.SocketPermission;
import java.net.URL;
import java.security.AccessController;
import java.security.Permission;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import sun.awt.AWTAutoShutdown;
import sun.awt.AppContext;
import sun.awt.ComponentFactory;
import sun.awt.DebugHelper;
import sun.awt.InputMethodSupport;
import sun.awt.PeerEvent;
import sun.awt.PostEventQueue;
import sun.awt.WindowClosingListener;
import sun.awt.WindowClosingSupport;
import sun.awt.font.FontDesignMetrics;
import sun.awt.im.InputContext;
import sun.awt.im.SimpleInputMethodWindow;
import sun.awt.image.ByteArrayImageSource;
import sun.awt.image.FileImageSource;
import sun.awt.image.URLImageSource;
import sun.misc.SoftCache;
import sun.security.action.GetPropertyAction;

public abstract class SunToolkit
extends Toolkit
implements WindowClosingSupport,
WindowClosingListener,
ComponentFactory,
InputMethodSupport {
    private static boolean hotjavaUrlCache = false;
    private static final String POST_EVENT_QUEUE_KEY = "PostEventQueue";
    protected static final Hashtable peerMap = AWTAutoShutdown.getInstance().getPeerMap();
    private static final Map appContextMap = Collections.synchronizedMap(new WeakHashMap());
    public static final FontMetrics[] lastMetrics = new FontMetrics[5];
    static SoftCache imgCache = new SoftCache();
    private static Locale startupLocale = null;
    private static String dataTransfererClassName = null;
    private transient WindowClosingListener windowClosingListener;

    public SunToolkit() {
        Object object;
        DebugHelper.init();
        this.windowClosingListener = null;
        ThreadGroup threadGroup = null;
        String string = System.getProperty("awt.threadgroup", "");
        if (string.length() != 0) {
            try {
                object = Class.forName(string).getConstructor(String.class);
                threadGroup = (ThreadGroup)((Constructor)object).newInstance("AWT-ThreadGroup");
            }
            catch (Exception exception) {
                System.err.println("Failed loading " + string + ": " + exception);
            }
        }
        object = new Runnable(){

            public void run() {
                EventQueue eventQueue;
                String string = Toolkit.getProperty("AWT.EventQueueClass", "java.awt.EventQueue");
                try {
                    eventQueue = (EventQueue)Class.forName(string).newInstance();
                }
                catch (Exception exception) {
                    System.err.println("Failed loading " + string + ": " + exception);
                    eventQueue = new EventQueue();
                }
                AppContext appContext = AppContext.getAppContext();
                appContext.put(AppContext.EVENT_QUEUE_KEY, eventQueue);
                PostEventQueue postEventQueue = new PostEventQueue(eventQueue);
                appContext.put(SunToolkit.POST_EVENT_QUEUE_KEY, postEventQueue);
            }
        };
        if (threadGroup != null) {
            Thread thread = new Thread(threadGroup, (Runnable)object, "EventQueue-Init");
            thread.start();
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            object.run();
        }
    }

    public abstract WindowPeer createWindow(Window var1) throws HeadlessException;

    public abstract FramePeer createFrame(Frame var1) throws HeadlessException;

    public abstract DialogPeer createDialog(Dialog var1) throws HeadlessException;

    public abstract ButtonPeer createButton(Button var1) throws HeadlessException;

    public abstract TextFieldPeer createTextField(TextField var1) throws HeadlessException;

    public abstract ChoicePeer createChoice(Choice var1) throws HeadlessException;

    public abstract LabelPeer createLabel(Label var1) throws HeadlessException;

    public abstract ListPeer createList(List var1) throws HeadlessException;

    public abstract CheckboxPeer createCheckbox(Checkbox var1) throws HeadlessException;

    public abstract ScrollbarPeer createScrollbar(Scrollbar var1) throws HeadlessException;

    public abstract ScrollPanePeer createScrollPane(ScrollPane var1) throws HeadlessException;

    public abstract TextAreaPeer createTextArea(TextArea var1) throws HeadlessException;

    public abstract FileDialogPeer createFileDialog(FileDialog var1) throws HeadlessException;

    public abstract MenuBarPeer createMenuBar(MenuBar var1) throws HeadlessException;

    public abstract MenuPeer createMenu(Menu var1) throws HeadlessException;

    public abstract PopupMenuPeer createPopupMenu(PopupMenu var1) throws HeadlessException;

    public abstract MenuItemPeer createMenuItem(MenuItem var1) throws HeadlessException;

    public abstract CheckboxMenuItemPeer createCheckboxMenuItem(CheckboxMenuItem var1) throws HeadlessException;

    public abstract DragSourceContextPeer createDragSourceContextPeer(DragGestureEvent var1) throws InvalidDnDOperationException;

    public abstract FontPeer getFontPeer(String var1, int var2);

    public abstract RobotPeer createRobot(Robot var1, GraphicsDevice var2) throws AWTException;

    public static AppContext createNewAppContext() {
        EventQueue eventQueue;
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        String string = Toolkit.getProperty("AWT.EventQueueClass", "java.awt.EventQueue");
        try {
            eventQueue = (EventQueue)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            System.err.println("Failed loading " + string + ": " + exception);
            eventQueue = new EventQueue();
        }
        AppContext appContext = new AppContext(threadGroup);
        appContext.put(AppContext.EVENT_QUEUE_KEY, eventQueue);
        PostEventQueue postEventQueue = new PostEventQueue(eventQueue);
        appContext.put(POST_EVENT_QUEUE_KEY, postEventQueue);
        return appContext;
    }

    private static native Object getPrivateKey(Object var0);

    static native void wakeupEventQueue(EventQueue var0, boolean var1);

    protected static Object targetToPeer(Object object) {
        if (object != null && !GraphicsEnvironment.isHeadless()) {
            return peerMap.get(SunToolkit.getPrivateKey(object));
        }
        return null;
    }

    protected static void targetCreatedPeer(Object object, Object object2) {
        if (object != null && object2 != null && !GraphicsEnvironment.isHeadless()) {
            peerMap.put(SunToolkit.getPrivateKey(object), object2);
        }
    }

    protected static void targetDisposedPeer(Object object, Object object2) {
        Object object3;
        if (object != null && object2 != null && !GraphicsEnvironment.isHeadless() && peerMap.get(object3 = SunToolkit.getPrivateKey(object)) == object2) {
            peerMap.remove(object3);
        }
    }

    public static AppContext targetToAppContext(Object object) {
        if (object != null && !GraphicsEnvironment.isHeadless()) {
            return (AppContext)appContextMap.get(SunToolkit.getPrivateKey(object));
        }
        return null;
    }

    public static native void setLWRequestStatus(Window var0, boolean var1);

    public static native void setZOrder(Container var0, Component var1, int var2);

    public static void insertTargetMapping(Object object, AppContext appContext) {
        if (!GraphicsEnvironment.isHeadless()) {
            appContextMap.put(SunToolkit.getPrivateKey(object), appContext);
        }
    }

    public static void postEvent(AppContext appContext, AWTEvent aWTEvent) {
        if (aWTEvent == null) {
            throw new NullPointerException();
        }
        PostEventQueue postEventQueue = (PostEventQueue)appContext.get(POST_EVENT_QUEUE_KEY);
        if (postEventQueue != null) {
            postEventQueue.postEvent(aWTEvent);
        }
    }

    public static void flushPendingEvents() {
        AppContext appContext = AppContext.getAppContext();
        PostEventQueue postEventQueue = (PostEventQueue)appContext.get(POST_EVENT_QUEUE_KEY);
        if (postEventQueue != null) {
            postEventQueue.flush();
        }
    }

    public static boolean isPostEventQueueEmpty() {
        AppContext appContext = AppContext.getAppContext();
        PostEventQueue postEventQueue = (PostEventQueue)appContext.get(POST_EVENT_QUEUE_KEY);
        if (postEventQueue != null) {
            return postEventQueue.noEvents();
        }
        return true;
    }

    public static void executeOnEventHandlerThread(Object object, Runnable runnable) {
        SunToolkit.executeOnEventHandlerThread(new PeerEvent(object, runnable, 1L));
    }

    public static void executeOnEventHandlerThread(PeerEvent peerEvent) {
        SunToolkit.postEvent(SunToolkit.targetToAppContext(peerEvent.getSource()), peerEvent);
    }

    public Dimension getScreenSize() {
        return new Dimension(this.getScreenWidth(), this.getScreenHeight());
    }

    protected abstract int getScreenWidth();

    protected abstract int getScreenHeight();

    public FontMetrics getFontMetrics(Font font) {
        FontMetrics fontMetrics;
        for (int i = 0; i < lastMetrics.length && (fontMetrics = lastMetrics[i]) != null; ++i) {
            if (fontMetrics.getFont() != font) continue;
            return fontMetrics;
        }
        FontDesignMetrics fontDesignMetrics = new FontDesignMetrics(font);
        System.arraycopy(lastMetrics, 0, lastMetrics, 1, lastMetrics.length - 1);
        SunToolkit.lastMetrics[0] = fontDesignMetrics;
        return fontDesignMetrics;
    }

    public String[] getFontList() {
        String[] stringArray = new String[]{"Dialog", "SansSerif", "Serif", "Monospaced", "DialogInput"};
        return stringArray;
    }

    public PanelPeer createPanel(Panel panel) {
        return (PanelPeer)((Object)this.createComponent(panel));
    }

    public CanvasPeer createCanvas(Canvas canvas) {
        return (CanvasPeer)((Object)this.createComponent(canvas));
    }

    static synchronized Image getImageFromHash(Toolkit toolkit, URL uRL) {
        Object object;
        block10: {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                try {
                    object = uRL.openConnection().getPermission();
                    if (object == null) break block10;
                    try {
                        securityManager.checkPermission((Permission)object);
                    }
                    catch (SecurityException securityException) {
                        if (object instanceof FilePermission && ((Permission)object).getActions().indexOf("read") != -1) {
                            securityManager.checkRead(((Permission)object).getName());
                            break block10;
                        }
                        if (object instanceof SocketPermission && ((Permission)object).getActions().indexOf("connect") != -1) {
                            securityManager.checkConnect(uRL.getHost(), uRL.getPort());
                            break block10;
                        }
                        throw securityException;
                    }
                }
                catch (IOException iOException) {
                    securityManager.checkConnect(uRL.getHost(), uRL.getPort());
                }
            }
        }
        if ((object = (Image)imgCache.get((Object)uRL)) == null) {
            try {
                object = toolkit.createImage(new URLImageSource(uRL));
                imgCache.put((Object)uRL, object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return object;
    }

    static synchronized Image getImageFromHash(Toolkit toolkit, String string) {
        Image image;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(string);
        }
        if ((image = (Image)imgCache.get((Object)string)) == null) {
            try {
                image = toolkit.createImage(new FileImageSource(string));
                imgCache.put((Object)string, (Object)image);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return image;
    }

    public Image getImage(String string) {
        return SunToolkit.getImageFromHash((Toolkit)this, string);
    }

    public Image getImage(URL uRL) {
        return SunToolkit.getImageFromHash((Toolkit)this, uRL);
    }

    public Image createImage(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(string);
        }
        return this.createImage(new FileImageSource(string));
    }

    public Image createImage(URL uRL) {
        block7: {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                try {
                    Permission permission = uRL.openConnection().getPermission();
                    if (permission == null) break block7;
                    try {
                        securityManager.checkPermission(permission);
                    }
                    catch (SecurityException securityException) {
                        if (permission instanceof FilePermission && permission.getActions().indexOf("read") != -1) {
                            securityManager.checkRead(permission.getName());
                            break block7;
                        }
                        if (permission instanceof SocketPermission && permission.getActions().indexOf("connect") != -1) {
                            securityManager.checkConnect(uRL.getHost(), uRL.getPort());
                            break block7;
                        }
                        throw securityException;
                    }
                }
                catch (IOException iOException) {
                    securityManager.checkConnect(uRL.getHost(), uRL.getPort());
                }
            }
        }
        return this.createImage(new URLImageSource(uRL));
    }

    public Image createImage(byte[] byArray, int n, int n2) {
        return this.createImage(new ByteArrayImageSource(byArray, n, n2));
    }

    protected EventQueue getSystemEventQueueImpl() {
        return SunToolkit.getSystemEventQueueImplPP();
    }

    static EventQueue getSystemEventQueueImplPP() {
        AppContext appContext = AppContext.getAppContext();
        EventQueue eventQueue = (EventQueue)appContext.get(AppContext.EVENT_QUEUE_KEY);
        return eventQueue;
    }

    public static Container getNativeContainer(Component component) {
        return Toolkit.getNativeContainer(component);
    }

    public Window createInputMethodWindow(String string, InputContext inputContext) {
        return new SimpleInputMethodWindow(string, inputContext);
    }

    public boolean enableInputMethodsForTextComponent() {
        return false;
    }

    public static Locale getStartupLocale() {
        if (startupLocale == null) {
            String string;
            String string2;
            String string3 = AccessController.doPrivileged(new GetPropertyAction("user.language", "en"));
            String string4 = AccessController.doPrivileged(new GetPropertyAction("user.region"));
            if (string4 != null) {
                int n = string4.indexOf(95);
                if (n >= 0) {
                    string2 = string4.substring(0, n);
                    string = string4.substring(n + 1);
                } else {
                    string2 = string4;
                    string = "";
                }
            } else {
                string2 = AccessController.doPrivileged(new GetPropertyAction("user.country", ""));
                string = AccessController.doPrivileged(new GetPropertyAction("user.variant", ""));
            }
            startupLocale = new Locale(string3, string2, string);
        }
        return startupLocale;
    }

    public Locale getDefaultKeyboardLocale() {
        return SunToolkit.getStartupLocale();
    }

    protected static void setDataTransfererClassName(String string) {
        dataTransfererClassName = string;
    }

    public static String getDataTransfererClassName() {
        if (dataTransfererClassName == null) {
            Toolkit.getDefaultToolkit();
        }
        return dataTransfererClassName;
    }

    public WindowClosingListener getWindowClosingListener() {
        return this.windowClosingListener;
    }

    public void setWindowClosingListener(WindowClosingListener windowClosingListener) {
        this.windowClosingListener = windowClosingListener;
    }

    public RuntimeException windowClosingNotify(WindowEvent windowEvent) {
        if (this.windowClosingListener != null) {
            return this.windowClosingListener.windowClosingNotify(windowEvent);
        }
        return null;
    }

    public RuntimeException windowClosingDelivered(WindowEvent windowEvent) {
        if (this.windowClosingListener != null) {
            return this.windowClosingListener.windowClosingDelivered(windowEvent);
        }
        return null;
    }
}

