/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GraphicAttribute;
import java.awt.font.LineMetrics;
import java.awt.font.NumericShaper;
import java.awt.font.StyledParagraph;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLine;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import sun.awt.font.AdvanceCache;
import sun.awt.font.Decoration;
import sun.awt.font.FontResolver;

public final class TextLayout
implements Cloneable {
    private int characterCount;
    private boolean isVerticalLine = false;
    private byte baseline;
    private float[] baselineOffsets;
    private TextLine textLine;
    private TextLine.TextLineMetrics lineMetrics = null;
    private float visibleAdvance;
    private int hashCodeCache;
    private OptInfo optInfo;
    private boolean cacheIsValid = false;
    private float justifyRatio;
    private static final float ALREADY_JUSTIFIED = -53.9f;
    private static float dx;
    private static float dy;
    private Rectangle2D naturalBounds = null;
    private Rectangle2D boundsRect = null;
    private boolean caretsInLigaturesAreAllowed = false;
    public static final CaretPolicy DEFAULT_CARET_POLICY;

    public TextLayout(String string, Font font, FontRenderContext fontRenderContext) {
        if (font == null) {
            throw new IllegalArgumentException("Null font passed to TextLayout constructor.");
        }
        if (string == null) {
            throw new IllegalArgumentException("Null string passed to TextLayout constructor.");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("Zero length string passed to TextLayout constructor.");
        }
        char[] cArray = string.toCharArray();
        if (TextLayout.sameBaselineUpTo(font, cArray, 0, cArray.length) == cArray.length) {
            this.fastInit(cArray, font, null, fontRenderContext);
        } else {
            AttributedString attributedString = new AttributedString(string);
            attributedString.addAttribute(TextAttribute.FONT, font);
            this.standardInit(attributedString.getIterator(), cArray, fontRenderContext);
        }
    }

    public TextLayout(String string, Map map, FontRenderContext fontRenderContext) {
        if (string == null) {
            throw new IllegalArgumentException("Null string passed to TextLayout constructor.");
        }
        if (map == null) {
            throw new IllegalArgumentException("Null map passed to TextLayout constructor.");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("Zero length string passed to TextLayout constructor.");
        }
        char[] cArray = string.toCharArray();
        Font font = TextLayout.singleFont(cArray, 0, cArray.length, map);
        if (font != null) {
            this.fastInit(cArray, font, map, fontRenderContext);
        } else {
            AttributedString attributedString = new AttributedString(string, map);
            this.standardInit(attributedString.getIterator(), cArray, fontRenderContext);
        }
    }

    private static Font singleFont(char[] cArray, int n, int n2, Map map) {
        if (map.get(TextAttribute.CHAR_REPLACEMENT) != null) {
            return null;
        }
        Font font = (Font)map.get(TextAttribute.FONT);
        if (font == null) {
            if (map.get(TextAttribute.FAMILY) != null) {
                font = Font.getFont(map);
                if (font.canDisplayUpTo(cArray, n, n2) != -1) {
                    return null;
                }
            } else {
                FontResolver fontResolver = FontResolver.getInstance();
                int n3 = fontResolver.getFontIndex(cArray[n]);
                for (int i = n + 1; i < n2; ++i) {
                    if (fontResolver.getFontIndex(cArray[i]) == n3) continue;
                    return null;
                }
                font = fontResolver.getFont(n3, map);
            }
        }
        if (TextLayout.sameBaselineUpTo(font, cArray, n, n2) != n2) {
            return null;
        }
        return font;
    }

    public TextLayout(AttributedCharacterIterator attributedCharacterIterator, FontRenderContext fontRenderContext) {
        Map<AttributedCharacterIterator.Attribute, Object> map;
        Font font;
        int n;
        if (attributedCharacterIterator == null) {
            throw new IllegalArgumentException("Null iterator passed to TextLayout constructor.");
        }
        int n2 = attributedCharacterIterator.getBeginIndex();
        if (n2 == (n = attributedCharacterIterator.getEndIndex())) {
            throw new IllegalArgumentException("Zero length iterator passed to TextLayout constructor.");
        }
        int n3 = n - n2;
        attributedCharacterIterator.first();
        char[] cArray = new char[n3];
        int n4 = 0;
        char c = attributedCharacterIterator.first();
        while (true) {
            if (c == '\uffff') break;
            cArray[n4++] = c;
            c = attributedCharacterIterator.next();
        }
        attributedCharacterIterator.first();
        if (attributedCharacterIterator.getRunLimit() == n && (font = TextLayout.singleFont(cArray, 0, n3, map = attributedCharacterIterator.getAttributes())) != null) {
            this.fastInit(cArray, font, map, fontRenderContext);
            return;
        }
        this.standardInit(attributedCharacterIterator, cArray, fontRenderContext);
    }

    TextLayout(TextLine textLine, byte by, float[] fArray, float f) {
        this.characterCount = textLine.characterCount();
        this.baseline = by;
        this.baselineOffsets = fArray;
        this.textLine = textLine;
        this.justifyRatio = f;
    }

    private void paragraphInit(byte by, LineMetrics lineMetrics, Map map, char[] cArray) {
        Object v;
        this.baseline = by;
        this.baselineOffsets = TextLine.getNormalizedOffsets(lineMetrics.getBaselineOffsets(), this.baseline);
        this.justifyRatio = TextLine.getJustifyRatio(map);
        if (map != null && (v = map.get(TextAttribute.NUMERIC_SHAPING)) != null) {
            try {
                NumericShaper numericShaper = (NumericShaper)v;
                numericShaper.shape(cArray, 0, cArray.length);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    private void fastInit(char[] cArray, Font font, Map map, FontRenderContext fontRenderContext) {
        this.isVerticalLine = false;
        LineMetrics lineMetrics = font.getLineMetrics(cArray, 0, cArray.length, fontRenderContext);
        byte by = (byte)lineMetrics.getBaselineIndex();
        if (map == null) {
            this.baseline = by;
            this.baselineOffsets = lineMetrics.getBaselineOffsets();
            this.justifyRatio = 1.0f;
        } else {
            this.paragraphInit(by, lineMetrics, map, cArray);
        }
        this.characterCount = cArray.length;
        this.optInfo = OptInfo.create(fontRenderContext, cArray, font, lineMetrics, map);
        if (this.optInfo == null) {
            this.textLine = TextLine.fastCreateTextLine(fontRenderContext, cArray, font, lineMetrics, map);
        }
    }

    private void initTextLine() {
        this.textLine = this.optInfo.createTextLine();
        this.optInfo = null;
    }

    private void standardInit(AttributedCharacterIterator attributedCharacterIterator, char[] cArray, FontRenderContext fontRenderContext) {
        this.characterCount = cArray.length;
        Map<AttributedCharacterIterator.Attribute, Object> map = attributedCharacterIterator.getAttributes();
        boolean bl = TextLine.advanceToFirstFont(attributedCharacterIterator);
        if (bl) {
            Font font = TextLine.getFontAtCurrentPos(attributedCharacterIterator);
            int n = attributedCharacterIterator.getIndex() - attributedCharacterIterator.getBeginIndex();
            LineMetrics lineMetrics = font.getLineMetrics(cArray, n, n + 1, fontRenderContext);
            this.paragraphInit((byte)lineMetrics.getBaselineIndex(), lineMetrics, map, cArray);
        } else {
            GraphicAttribute graphicAttribute = (GraphicAttribute)map.get(TextAttribute.CHAR_REPLACEMENT);
            byte by = TextLayout.getBaselineFromGraphic(graphicAttribute);
            Font font = new Font(new Hashtable(5, 0.9f));
            LineMetrics lineMetrics = font.getLineMetrics(" ", 0, 1, fontRenderContext);
            this.paragraphInit(by, lineMetrics, map, cArray);
        }
        this.textLine = TextLine.standardCreateTextLine(fontRenderContext, attributedCharacterIterator, cArray, this.baselineOffsets);
    }

    private void ensureCache() {
        if (!this.cacheIsValid) {
            this.buildCache();
        }
    }

    private void buildCache() {
        if (this.textLine == null) {
            this.initTextLine();
        }
        this.lineMetrics = this.textLine.getMetrics();
        if (this.textLine.isDirectionLTR()) {
            int n;
            int n2;
            for (n2 = this.characterCount - 1; n2 != -1 && this.textLine.isCharSpace(n = this.textLine.visualToLogical(n2)); --n2) {
            }
            if (n2 == this.characterCount - 1) {
                this.visibleAdvance = this.lineMetrics.advance;
            } else if (n2 == -1) {
                this.visibleAdvance = 0.0f;
            } else {
                n = this.textLine.visualToLogical(n2);
                this.visibleAdvance = this.textLine.getCharLinePosition(n) + this.textLine.getCharAdvance(n);
            }
        } else {
            int n;
            int n3;
            for (n3 = 0; n3 != this.characterCount && this.textLine.isCharSpace(n = this.textLine.visualToLogical(n3)); ++n3) {
            }
            if (n3 == this.characterCount) {
                this.visibleAdvance = 0.0f;
            } else if (n3 == 0) {
                this.visibleAdvance = this.lineMetrics.advance;
            } else {
                n = this.textLine.visualToLogical(n3);
                float f = this.textLine.getCharLinePosition(n);
                this.visibleAdvance = this.lineMetrics.advance - f;
            }
        }
        this.naturalBounds = null;
        this.boundsRect = null;
        this.hashCodeCache = 0;
        this.cacheIsValid = true;
    }

    private Rectangle2D getNaturalBounds() {
        this.ensureCache();
        if (this.naturalBounds == null) {
            float f;
            int n = this.textLine.visualToLogical(0);
            float f2 = this.textLine.getCharAngle(n);
            float f3 = f = this.isVerticalLine ? -dy : -dx;
            if (f2 < 0.0f) {
                f += f2 * this.textLine.getCharAscent(n);
            } else if (f2 > 0.0f) {
                f -= f2 * this.textLine.getCharDescent(n);
            }
            int n2 = this.textLine.visualToLogical(this.characterCount - 1);
            f2 = this.textLine.getCharAngle(n2);
            float f4 = this.lineMetrics.advance;
            if (f2 < 0.0f) {
                f4 -= f2 * this.textLine.getCharDescent(n2);
            } else if (f2 > 0.0f) {
                f4 += f2 * this.textLine.getCharAscent(n2);
            }
            float f5 = f4 - f;
            this.naturalBounds = this.isVerticalLine ? new Rectangle2D.Float(-this.lineMetrics.descent, f, this.lineMetrics.ascent + this.lineMetrics.descent, f5) : new Rectangle2D.Float(f, -this.lineMetrics.ascent, f5, this.lineMetrics.ascent + this.lineMetrics.descent);
        }
        return this.naturalBounds;
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    private void checkTextHit(TextHitInfo textHitInfo) {
        if (textHitInfo == null) {
            throw new IllegalArgumentException("TextHitInfo is null.");
        }
        if (textHitInfo.getInsertionIndex() < 0 || textHitInfo.getInsertionIndex() > this.characterCount) {
            throw new IllegalArgumentException("TextHitInfo is out of range");
        }
    }

    public TextLayout getJustifiedLayout(float f) {
        int n;
        if (f <= 0.0f) {
            throw new IllegalArgumentException("justificationWidth <= 0 passed to TextLayout.getJustifiedLayout()");
        }
        if (this.justifyRatio == -53.9f) {
            throw new Error("Can't justify again.");
        }
        this.ensureCache();
        for (n = this.characterCount; n > 0 && this.textLine.isCharWhitespace(n - 1); --n) {
        }
        TextLine textLine = this.textLine.getJustifiedLine(f, this.justifyRatio, 0, n);
        if (textLine != null) {
            return new TextLayout(textLine, this.baseline, this.baselineOffsets, -53.9f);
        }
        return this;
    }

    protected void handleJustify(float f) {
    }

    public byte getBaseline() {
        return this.baseline;
    }

    public float[] getBaselineOffsets() {
        float[] fArray = new float[this.baselineOffsets.length];
        System.arraycopy(this.baselineOffsets, 0, fArray, 0, fArray.length);
        return fArray;
    }

    public float getAdvance() {
        if (this.optInfo != null) {
            try {
                return this.optInfo.getAdvance();
            }
            catch (Error error) {
                // empty catch block
            }
        }
        this.ensureCache();
        return this.lineMetrics.advance;
    }

    public float getVisibleAdvance() {
        this.ensureCache();
        return this.visibleAdvance;
    }

    public float getAscent() {
        if (this.optInfo != null) {
            return this.optInfo.getLineMetrics().getAscent();
        }
        this.ensureCache();
        return this.lineMetrics.ascent;
    }

    public float getDescent() {
        if (this.optInfo != null) {
            return this.optInfo.getLineMetrics().getDescent();
        }
        this.ensureCache();
        return this.lineMetrics.descent;
    }

    public float getLeading() {
        if (this.optInfo != null) {
            return this.optInfo.getLineMetrics().getLeading();
        }
        this.ensureCache();
        return this.lineMetrics.leading;
    }

    public Rectangle2D getBounds() {
        Rectangle2D rectangle2D;
        if (this.optInfo != null) {
            return this.optInfo.getVisualBounds();
        }
        this.ensureCache();
        if (this.boundsRect == null) {
            rectangle2D = this.textLine.getBounds();
            if (dx != 0.0f || dy != 0.0f) {
                rectangle2D.setRect(rectangle2D.getX() - (double)dx, rectangle2D.getY() - (double)dy, rectangle2D.getWidth(), rectangle2D.getHeight());
            }
            this.boundsRect = rectangle2D;
        }
        rectangle2D = new Rectangle2D.Float();
        rectangle2D.setRect(this.boundsRect);
        return rectangle2D;
    }

    public boolean isLeftToRight() {
        return this.optInfo != null || this.textLine.isDirectionLTR();
    }

    public boolean isVertical() {
        return this.isVerticalLine;
    }

    public int getCharacterCount() {
        return this.characterCount;
    }

    private float[] getCaretInfo(int n, Rectangle2D rectangle2D, float[] fArray) {
        float f;
        float f2;
        float f3;
        float f4;
        if (n == 0 || n == this.characterCount) {
            float f5;
            int n2;
            if (n == this.characterCount) {
                n2 = this.textLine.visualToLogical(this.characterCount - 1);
                f5 = this.textLine.getCharLinePosition(n2) + this.textLine.getCharAdvance(n2);
            } else {
                n2 = this.textLine.visualToLogical(n);
                f5 = this.textLine.getCharLinePosition(n2);
            }
            float f6 = this.textLine.getCharAngle(n2);
            f3 = f4 = f5 + f6 * this.textLine.getCharAscent(n2);
            f = f2 = f5 - f6 * this.textLine.getCharDescent(n2);
        } else {
            int n3 = this.textLine.visualToLogical(n - 1);
            float f7 = this.textLine.getCharAngle(n3);
            float f8 = this.textLine.getCharLinePosition(n3) + this.textLine.getCharAdvance(n3);
            if (f7 != 0.0f) {
                f3 = f8 + f7 * this.textLine.getCharAscent(n3);
                f = f8 - f7 * this.textLine.getCharDescent(n3);
            } else {
                f3 = f = f8;
            }
            n3 = this.textLine.visualToLogical(n);
            f7 = this.textLine.getCharAngle(n3);
            f8 = this.textLine.getCharLinePosition(n3);
            if (f7 != 0.0f) {
                f4 = f8 + f7 * this.textLine.getCharAscent(n3);
                f2 = f8 - f7 * this.textLine.getCharDescent(n3);
            } else {
                f4 = f2 = f8;
            }
        }
        float f9 = (f3 + f4) / 2.0f;
        float f10 = (f + f2) / 2.0f;
        if (fArray == null) {
            fArray = new float[2];
        }
        if (this.isVerticalLine) {
            fArray[1] = (float)((double)(f9 - f10) / rectangle2D.getWidth());
            fArray[0] = (float)((double)f9 + (double)fArray[1] * rectangle2D.getX());
        } else {
            fArray[1] = (float)((double)(f9 - f10) / rectangle2D.getHeight());
            fArray[0] = (float)((double)f10 + (double)fArray[1] * rectangle2D.getMaxY());
        }
        return fArray;
    }

    public float[] getCaretInfo(TextHitInfo textHitInfo, Rectangle2D rectangle2D) {
        this.ensureCache();
        this.checkTextHit(textHitInfo);
        return this.getCaretInfo(this.hitToCaret(textHitInfo), rectangle2D, null);
    }

    public float[] getCaretInfo(TextHitInfo textHitInfo) {
        return this.getCaretInfo(textHitInfo, this.getNaturalBounds());
    }

    private int hitToCaret(TextHitInfo textHitInfo) {
        int n = textHitInfo.getCharIndex();
        if (n < 0) {
            return this.textLine.isDirectionLTR() ? 0 : this.characterCount;
        }
        if (n >= this.characterCount) {
            return this.textLine.isDirectionLTR() ? this.characterCount : 0;
        }
        int n2 = this.textLine.logicalToVisual(n);
        if (textHitInfo.isLeadingEdge() != this.textLine.isCharLTR(n)) {
            ++n2;
        }
        return n2;
    }

    private TextHitInfo caretToHit(int n) {
        if (n == 0 || n == this.characterCount) {
            if (n == this.characterCount == this.textLine.isDirectionLTR()) {
                return TextHitInfo.leading(this.characterCount);
            }
            return TextHitInfo.trailing(-1);
        }
        int n2 = this.textLine.visualToLogical(n);
        boolean bl = this.textLine.isCharLTR(n2);
        return bl ? TextHitInfo.leading(n2) : TextHitInfo.trailing(n2);
    }

    private boolean caretIsValid(int n) {
        if (n == this.characterCount || n == 0) {
            return true;
        }
        int n2 = this.textLine.visualToLogical(n);
        if (!this.textLine.isCharLTR(n2) && this.textLine.isCharLTR(n2 = this.textLine.visualToLogical(n - 1))) {
            return true;
        }
        return this.textLine.caretAtOffsetIsValid(n2);
    }

    public TextHitInfo getNextRightHit(TextHitInfo textHitInfo) {
        this.ensureCache();
        this.checkTextHit(textHitInfo);
        int n = this.hitToCaret(textHitInfo);
        if (n == this.characterCount) {
            return null;
        }
        while (!this.caretIsValid(++n)) {
        }
        return this.caretToHit(n);
    }

    public TextHitInfo getNextRightHit(int n, CaretPolicy caretPolicy) {
        TextHitInfo textHitInfo;
        if (n < 0 || n > this.characterCount) {
            throw new IllegalArgumentException("Offset out of bounds in TextLayout.getNextRightHit()");
        }
        if (caretPolicy == null) {
            throw new IllegalArgumentException("Null CaretPolicy passed to TextLayout.getNextRightHit()");
        }
        TextHitInfo textHitInfo2 = TextHitInfo.afterOffset(n);
        TextHitInfo textHitInfo3 = this.getNextRightHit(caretPolicy.getStrongCaret(textHitInfo2, textHitInfo = textHitInfo2.getOtherHit(), this));
        if (textHitInfo3 != null) {
            TextHitInfo textHitInfo4 = this.getVisualOtherHit(textHitInfo3);
            return caretPolicy.getStrongCaret(textHitInfo4, textHitInfo3, this);
        }
        return null;
    }

    public TextHitInfo getNextRightHit(int n) {
        return this.getNextRightHit(n, DEFAULT_CARET_POLICY);
    }

    public TextHitInfo getNextLeftHit(TextHitInfo textHitInfo) {
        this.ensureCache();
        this.checkTextHit(textHitInfo);
        int n = this.hitToCaret(textHitInfo);
        if (n == 0) {
            return null;
        }
        while (!this.caretIsValid(--n)) {
        }
        return this.caretToHit(n);
    }

    public TextHitInfo getNextLeftHit(int n, CaretPolicy caretPolicy) {
        TextHitInfo textHitInfo;
        if (caretPolicy == null) {
            throw new IllegalArgumentException("Null CaretPolicy passed to TextLayout.getNextLeftHit()");
        }
        if (n < 0 || n > this.characterCount) {
            throw new IllegalArgumentException("Offset out of bounds in TextLayout.getNextLeftHit()");
        }
        TextHitInfo textHitInfo2 = TextHitInfo.afterOffset(n);
        TextHitInfo textHitInfo3 = this.getNextLeftHit(caretPolicy.getStrongCaret(textHitInfo2, textHitInfo = textHitInfo2.getOtherHit(), this));
        if (textHitInfo3 != null) {
            TextHitInfo textHitInfo4 = this.getVisualOtherHit(textHitInfo3);
            return caretPolicy.getStrongCaret(textHitInfo4, textHitInfo3, this);
        }
        return null;
    }

    public TextHitInfo getNextLeftHit(int n) {
        return this.getNextLeftHit(n, DEFAULT_CARET_POLICY);
    }

    public TextHitInfo getVisualOtherHit(TextHitInfo textHitInfo) {
        boolean bl;
        int n;
        this.ensureCache();
        this.checkTextHit(textHitInfo);
        int n2 = textHitInfo.getCharIndex();
        if (n2 == -1 || n2 == this.characterCount) {
            int n3 = this.textLine.isDirectionLTR() == (n2 == -1) ? 0 : this.characterCount - 1;
            n = this.textLine.visualToLogical(n3);
            bl = this.textLine.isDirectionLTR() == (n2 == -1) ? this.textLine.isCharLTR(n) : !this.textLine.isCharLTR(n);
        } else {
            boolean bl2;
            int n4 = this.textLine.logicalToVisual(n2);
            if (this.textLine.isCharLTR(n2) == textHitInfo.isLeadingEdge()) {
                --n4;
                bl2 = false;
            } else {
                ++n4;
                bl2 = true;
            }
            if (n4 > -1 && n4 < this.characterCount) {
                n = this.textLine.visualToLogical(n4);
                bl = bl2 == this.textLine.isCharLTR(n);
            } else {
                n = bl2 == this.textLine.isDirectionLTR() ? this.characterCount : -1;
                bl = n == this.characterCount;
            }
        }
        return bl ? TextHitInfo.leading(n) : TextHitInfo.trailing(n);
    }

    private double[] getCaretPath(int n, Rectangle2D rectangle2D, boolean bl) {
        double[] dArray;
        double d;
        double d2;
        double d3;
        double d4;
        float[] fArray = this.getCaretInfo(n, rectangle2D, null);
        double d5 = fArray[0];
        double d6 = fArray[1];
        double d7 = -3141.59;
        double d8 = -2.7;
        double d9 = rectangle2D.getX();
        double d10 = d9 + rectangle2D.getWidth();
        double d11 = rectangle2D.getY();
        double d12 = d11 + rectangle2D.getHeight();
        boolean bl2 = false;
        if (this.isVerticalLine) {
            if (d6 >= 0.0) {
                d4 = d9;
                d3 = d10;
            } else {
                d3 = d9;
                d4 = d10;
            }
            d2 = d5 + d4 * d6;
            d = d5 + d3 * d6;
            if (bl) {
                if (d2 < d11) {
                    if (d6 <= 0.0 || d <= d11) {
                        d2 = d = d11;
                    } else {
                        bl2 = true;
                        d2 = d11;
                        d8 = d11;
                        d7 = d3 + (d11 - d) / d6;
                        if (d > d12) {
                            d = d12;
                        }
                    }
                } else if (d > d12) {
                    if (d6 >= 0.0 || d2 >= d12) {
                        d2 = d = d12;
                    } else {
                        bl2 = true;
                        d = d12;
                        d8 = d12;
                        d7 = d4 + (d12 - d3) / d6;
                    }
                }
            }
        } else {
            if (d6 >= 0.0) {
                d2 = d12;
                d = d11;
            } else {
                d = d12;
                d2 = d11;
            }
            d4 = d5 - d2 * d6;
            d3 = d5 - d * d6;
            if (bl) {
                if (d4 < d9) {
                    if (d6 <= 0.0 || d3 <= d9) {
                        d4 = d3 = d9;
                    } else {
                        bl2 = true;
                        d4 = d9;
                        d7 = d9;
                        d8 = d - (d9 - d3) / d6;
                        if (d3 > d10) {
                            d3 = d10;
                        }
                    }
                } else if (d3 > d10) {
                    if (d6 >= 0.0 || d4 >= d10) {
                        d4 = d3 = d10;
                    } else {
                        bl2 = true;
                        d3 = d10;
                        d7 = d10;
                        d8 = d2 - (d10 - d4) / d6;
                    }
                }
            }
        }
        if (bl2) {
            double[] dArray2 = new double[6];
            dArray2[0] = d4;
            dArray2[1] = d2;
            dArray2[2] = d7;
            dArray2[3] = d8;
            dArray2[4] = d3;
            dArray = dArray2;
            dArray2[5] = d;
        } else {
            double[] dArray3 = new double[4];
            dArray3[0] = d4;
            dArray3[1] = d2;
            dArray3[2] = d3;
            dArray = dArray3;
            dArray3[3] = d;
        }
        return dArray;
    }

    private static GeneralPath pathToShape(double[] dArray, boolean bl) {
        GeneralPath generalPath = new GeneralPath(0, dArray.length);
        generalPath.moveTo((float)dArray[0], (float)dArray[1]);
        for (int i = 2; i < dArray.length; i += 2) {
            generalPath.lineTo((float)dArray[i], (float)dArray[i + 1]);
        }
        if (bl) {
            generalPath.closePath();
        }
        return generalPath;
    }

    public Shape getCaretShape(TextHitInfo textHitInfo, Rectangle2D rectangle2D) {
        this.ensureCache();
        this.checkTextHit(textHitInfo);
        if (rectangle2D == null) {
            throw new IllegalArgumentException("Null Rectangle2D passed to TextLayout.getCaret()");
        }
        int n = this.hitToCaret(textHitInfo);
        GeneralPath generalPath = TextLayout.pathToShape(this.getCaretPath(n, rectangle2D, false), false);
        return generalPath;
    }

    public Shape getCaretShape(TextHitInfo textHitInfo) {
        return this.getCaretShape(textHitInfo, this.getNaturalBounds());
    }

    private final TextHitInfo getStrongHit(TextHitInfo textHitInfo, TextHitInfo textHitInfo2) {
        byte by;
        byte by2 = this.getCharacterLevel(textHitInfo.getCharIndex());
        if (by2 == (by = this.getCharacterLevel(textHitInfo2.getCharIndex()))) {
            if (textHitInfo2.isLeadingEdge() && !textHitInfo.isLeadingEdge()) {
                return textHitInfo2;
            }
            return textHitInfo;
        }
        return by2 < by ? textHitInfo : textHitInfo2;
    }

    public byte getCharacterLevel(int n) {
        if (n < -1 || n > this.characterCount) {
            throw new IllegalArgumentException("Index is out of range in getCharacterLevel.");
        }
        if (this.optInfo != null) {
            return 0;
        }
        this.ensureCache();
        if (n == -1 || n == this.characterCount) {
            return (byte)(!this.textLine.isDirectionLTR() ? 1 : 0);
        }
        return this.textLine.getCharLevel(n);
    }

    public Shape[] getCaretShapes(int n, Rectangle2D rectangle2D, CaretPolicy caretPolicy) {
        this.ensureCache();
        if (n < 0 || n > this.characterCount) {
            throw new IllegalArgumentException("Offset out of bounds in TextLayout.getCaretShapes()");
        }
        if (rectangle2D == null) {
            throw new IllegalArgumentException("Null Rectangle2D passed to TextLayout.getCaretShapes()");
        }
        if (caretPolicy == null) {
            throw new IllegalArgumentException("Null CaretPolicy passed to TextLayout.getCaretShapes()");
        }
        Shape[] shapeArray = new Shape[2];
        TextHitInfo textHitInfo = TextHitInfo.afterOffset(n);
        int n2 = this.hitToCaret(textHitInfo);
        GeneralPath generalPath = TextLayout.pathToShape(this.getCaretPath(n2, rectangle2D, false), false);
        TextHitInfo textHitInfo2 = textHitInfo.getOtherHit();
        int n3 = this.hitToCaret(textHitInfo2);
        if (n2 == n3) {
            shapeArray[0] = generalPath;
        } else {
            GeneralPath generalPath2 = TextLayout.pathToShape(this.getCaretPath(n3, rectangle2D, false), false);
            TextHitInfo textHitInfo3 = caretPolicy.getStrongCaret(textHitInfo, textHitInfo2, this);
            boolean bl = textHitInfo3.equals(textHitInfo);
            if (bl) {
                shapeArray[0] = generalPath;
                shapeArray[1] = generalPath2;
            } else {
                shapeArray[0] = generalPath2;
                shapeArray[1] = generalPath;
            }
        }
        return shapeArray;
    }

    public Shape[] getCaretShapes(int n, Rectangle2D rectangle2D) {
        return this.getCaretShapes(n, rectangle2D, DEFAULT_CARET_POLICY);
    }

    public Shape[] getCaretShapes(int n) {
        return this.getCaretShapes(n, this.getNaturalBounds(), DEFAULT_CARET_POLICY);
    }

    private GeneralPath boundingShape(double[] dArray, double[] dArray2) {
        int n;
        int n2;
        int n3;
        boolean bl;
        GeneralPath generalPath = TextLayout.pathToShape(dArray, false);
        if (this.isVerticalLine) {
            bl = dArray[1] > dArray[dArray.length - 1] == dArray2[1] > dArray2[dArray2.length - 1];
        } else {
            boolean bl2 = bl = dArray[0] > dArray[dArray.length - 2] == dArray2[0] > dArray2[dArray2.length - 2];
        }
        if (bl) {
            n3 = dArray2.length - 2;
            n2 = -2;
            n = -2;
        } else {
            n3 = 0;
            n2 = dArray2.length;
            n = 2;
        }
        for (int i = n3; i != n2; i += n) {
            generalPath.lineTo((float)dArray2[i], (float)dArray2[i + 1]);
        }
        generalPath.closePath();
        return generalPath;
    }

    private GeneralPath caretBoundingShape(int n, int n2, Rectangle2D rectangle2D) {
        if (n > n2) {
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        return this.boundingShape(this.getCaretPath(n, rectangle2D, true), this.getCaretPath(n2, rectangle2D, true));
    }

    private GeneralPath leftShape(Rectangle2D rectangle2D) {
        double[] dArray = this.isVerticalLine ? new double[]{rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D.getY()} : new double[]{rectangle2D.getX(), rectangle2D.getY() + rectangle2D.getHeight(), rectangle2D.getX(), rectangle2D.getY()};
        double[] dArray2 = this.getCaretPath(0, rectangle2D, true);
        return this.boundingShape(dArray, dArray2);
    }

    private GeneralPath rightShape(Rectangle2D rectangle2D) {
        double[] dArray = this.isVerticalLine ? new double[]{rectangle2D.getX(), rectangle2D.getY() + rectangle2D.getHeight(), rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D.getY() + rectangle2D.getHeight()} : new double[]{rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D.getY() + rectangle2D.getHeight(), rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D.getY()};
        double[] dArray2 = this.getCaretPath(this.characterCount, rectangle2D, true);
        return this.boundingShape(dArray2, dArray);
    }

    public int[] getLogicalRangesForVisualSelection(TextHitInfo textHitInfo, TextHitInfo textHitInfo2) {
        int n;
        this.ensureCache();
        this.checkTextHit(textHitInfo);
        this.checkTextHit(textHitInfo2);
        boolean[] blArray = new boolean[this.characterCount];
        int n2 = this.hitToCaret(textHitInfo);
        int n3 = this.hitToCaret(textHitInfo2);
        if (n2 > n3) {
            n = n2;
            n2 = n3;
            n3 = n;
        }
        if (n2 < n3) {
            for (n = n2; n < n3; ++n) {
                blArray[this.textLine.visualToLogical((int)n)] = true;
            }
        }
        n = 0;
        boolean bl = false;
        for (int i = 0; i < this.characterCount; ++i) {
            if (blArray[i] == bl) continue;
            boolean bl2 = bl = !bl;
            if (!bl) continue;
            ++n;
        }
        int[] nArray = new int[n * 2];
        n = 0;
        bl = false;
        for (int i = 0; i < this.characterCount; ++i) {
            if (blArray[i] == bl) continue;
            nArray[n++] = i;
            bl = !bl;
        }
        if (bl) {
            nArray[n++] = this.characterCount;
        }
        return nArray;
    }

    public Shape getVisualHighlightShape(TextHitInfo textHitInfo, TextHitInfo textHitInfo2, Rectangle2D rectangle2D) {
        this.ensureCache();
        this.checkTextHit(textHitInfo);
        this.checkTextHit(textHitInfo2);
        if (rectangle2D == null) {
            throw new IllegalArgumentException("Null Rectangle2D passed to TextLayout.getVisualHighlightShape()");
        }
        GeneralPath generalPath = new GeneralPath(0);
        int n = this.hitToCaret(textHitInfo);
        int n2 = this.hitToCaret(textHitInfo2);
        generalPath.append(this.caretBoundingShape(n, n2, rectangle2D), false);
        if (n == 0 || n2 == 0) {
            generalPath.append(this.leftShape(rectangle2D), false);
        }
        if (n == this.characterCount || n2 == this.characterCount) {
            generalPath.append(this.rightShape(rectangle2D), false);
        }
        return generalPath;
    }

    public Shape getVisualHighlightShape(TextHitInfo textHitInfo, TextHitInfo textHitInfo2) {
        return this.getVisualHighlightShape(textHitInfo, textHitInfo2, this.getNaturalBounds());
    }

    public Shape getLogicalHighlightShape(int n, int n2, Rectangle2D rectangle2D) {
        int n3;
        if (rectangle2D == null) {
            throw new IllegalArgumentException("Null Rectangle2D passed to TextLayout.getLogicalHighlightShape()");
        }
        this.ensureCache();
        if (n > n2) {
            int n4 = n;
            n = n2;
            n2 = n4;
        }
        if (n < 0 || n2 > this.characterCount) {
            throw new IllegalArgumentException("Range is invalid in TextLayout.getLogicalHighlightShape()");
        }
        int[] nArray = new int[10];
        int n5 = 0;
        if (n < n2) {
            int n6 = n;
            do {
                nArray[n5++] = this.hitToCaret(TextHitInfo.leading(n6));
                n3 = this.textLine.isCharLTR(n6);
                while (++n6 < n2 && this.textLine.isCharLTR(n6) == n3) {
                }
                int n7 = n6;
                nArray[n5++] = this.hitToCaret(TextHitInfo.trailing(n7 - 1));
                if (n5 != nArray.length) continue;
                int[] nArray2 = new int[nArray.length + 10];
                System.arraycopy(nArray, 0, nArray2, 0, n5);
                nArray = nArray2;
            } while (n6 < n2);
        } else {
            n5 = 2;
            nArray[0] = nArray[1] = this.hitToCaret(TextHitInfo.leading(n));
        }
        GeneralPath generalPath = new GeneralPath(0);
        for (n3 = 0; n3 < n5; n3 += 2) {
            generalPath.append(this.caretBoundingShape(nArray[n3], nArray[n3 + 1], rectangle2D), false);
        }
        if (this.textLine.isDirectionLTR() && n == 0 || !this.textLine.isDirectionLTR() && n2 == this.characterCount) {
            generalPath.append(this.leftShape(rectangle2D), false);
        }
        if (this.textLine.isDirectionLTR() && n2 == this.characterCount || !this.textLine.isDirectionLTR() && n == 0) {
            generalPath.append(this.rightShape(rectangle2D), false);
        }
        return generalPath;
    }

    public Shape getLogicalHighlightShape(int n, int n2) {
        return this.getLogicalHighlightShape(n, n2, this.getNaturalBounds());
    }

    public Shape getBlackBoxBounds(int n, int n2) {
        this.ensureCache();
        if (n > n2) {
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        if (n < 0 || n2 > this.characterCount) {
            throw new IllegalArgumentException("Invalid range passed to TextLayout.getBlackBoxBounds()");
        }
        GeneralPath generalPath = new GeneralPath(1);
        if (n < this.characterCount) {
            for (int i = n; i < n2; ++i) {
                if (this.textLine.isCharWhitespace(i)) continue;
                Rectangle2D rectangle2D = this.textLine.getCharBounds(i);
                generalPath.append(rectangle2D, false);
            }
        }
        if (dx != 0.0f || dy != 0.0f) {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.setToTranslation(dx, dy);
            generalPath = (GeneralPath)generalPath.createTransformedShape(affineTransform);
        }
        return generalPath;
    }

    private float caretToPointDistance(float[] fArray, float f, float f2) {
        float f3 = this.isVerticalLine ? f2 : f;
        float f4 = this.isVerticalLine ? -f : f2;
        return f3 - fArray[0] + f4 * fArray[1];
    }

    public TextHitInfo hitTestChar(float f, float f2, Rectangle2D rectangle2D) {
        TextHitInfo textHitInfo;
        float f3;
        float f4;
        int n;
        this.ensureCache();
        float[] fArray = new float[2];
        int n2 = 0;
        fArray = this.getCaretInfo(n2, rectangle2D, fArray);
        if (this.caretToPointDistance(fArray, f, f2) < 0.0f) {
            return this.textLine.isDirectionLTR() ? TextHitInfo.trailing(-1) : TextHitInfo.leading(this.characterCount);
        }
        int n3 = this.characterCount;
        if (this.caretToPointDistance(fArray = this.getCaretInfo(n3, rectangle2D, fArray), f, f2) >= 0.0f) {
            return this.textLine.isDirectionLTR() ? TextHitInfo.leading(this.characterCount) : TextHitInfo.trailing(-1);
        }
        while (n2 + 1 != n3) {
            n = (n2 + n3) / 2;
            while (!this.caretIsValid(n)) {
                ++n;
            }
            if (n == n3) {
                n = (n2 + n3) / 2;
                while (!this.caretIsValid(--n)) {
                }
                if (n == n2) break;
            }
            if ((f4 = this.caretToPointDistance(fArray = this.getCaretInfo(n, rectangle2D, fArray), f, f2)) == 0.0f) {
                int n4 = this.textLine.visualToLogical(n);
                boolean bl = this.textLine.isCharLTR(n4);
                return bl ? TextHitInfo.leading(n4) : TextHitInfo.trailing(n4);
            }
            if (f4 < 0.0f) {
                n3 = n;
                continue;
            }
            n2 = n;
        }
        n = this.textLine.visualToLogical(n2);
        f4 = this.textLine.getCharLinePosition(n) + (this.isVerticalLine ? -dy : -dx);
        int n5 = this.textLine.visualToLogical(n3 - 1);
        if (n3 - n2 > 1) {
            float f5 = this.textLine.getCharLinePosition(n5);
            f4 += (f5 - f4) / 2.0f;
        }
        fArray[0] = f4 += this.textLine.getCharAdvance(n5) / 2.0f;
        fArray[1] = this.textLine.getCharAngle(n);
        if (fArray[1] != 0.0f) {
            fArray[0] = fArray[0] + fArray[1] * (this.isVerticalLine ? this.textLine.getCharXPosition(n) : this.textLine.getCharYPosition(n));
        }
        if ((f3 = this.caretToPointDistance(fArray, f, f2)) < 0.0f) {
            textHitInfo = this.textLine.isCharLTR(n) ? TextHitInfo.leading(n) : TextHitInfo.trailing(n);
        } else {
            n = this.textLine.visualToLogical(n3 - 1);
            boolean bl = !this.textLine.isCharLTR(n);
            textHitInfo = bl ? TextHitInfo.leading(n) : TextHitInfo.trailing(n);
        }
        return textHitInfo;
    }

    public TextHitInfo hitTestChar(float f, float f2) {
        return this.hitTestChar(f, f2, this.getNaturalBounds());
    }

    public int hashCode() {
        if (this.hashCodeCache == 0) {
            this.ensureCache();
            this.hashCodeCache = this.textLine.hashCode();
        }
        return this.hashCodeCache;
    }

    public boolean equals(Object object) {
        return object instanceof TextLayout && this.equals((TextLayout)object);
    }

    public boolean equals(TextLayout textLayout) {
        if (textLayout == null) {
            return false;
        }
        if (textLayout == this) {
            return true;
        }
        this.ensureCache();
        return this.textLine.equals(textLayout.textLine);
    }

    public String toString() {
        this.ensureCache();
        return this.textLine.toString();
    }

    public void draw(Graphics2D graphics2D, float f, float f2) {
        if (graphics2D == null) {
            throw new IllegalArgumentException("Null Graphics2D passed to TextLayout.draw()");
        }
        if (this.optInfo != null) {
            if (this.optInfo.draw(graphics2D, f, f2)) {
                return;
            }
            this.initTextLine();
        }
        this.textLine.draw(graphics2D, f - dx, f2 - dy);
    }

    TextLine getTextLineForTesting() {
        return this.textLine;
    }

    private static int sameBaselineUpTo(Font font, char[] cArray, int n, int n2) {
        return n2;
    }

    static byte getBaselineFromGraphic(GraphicAttribute graphicAttribute) {
        byte by = (byte)graphicAttribute.getAlignment();
        if (by == -2 || by == -1) {
            return 0;
        }
        return by;
    }

    public Shape getOutline(AffineTransform affineTransform) {
        this.ensureCache();
        return this.textLine.getOutline(affineTransform);
    }

    static {
        DEFAULT_CARET_POLICY = new CaretPolicy();
    }

    public static class CaretPolicy {
        public TextHitInfo getStrongCaret(TextHitInfo textHitInfo, TextHitInfo textHitInfo2, TextLayout textLayout) {
            return textLayout.getStrongHit(textHitInfo, textHitInfo2);
        }
    }

    static class OptInfo
    implements Decoration.Label {
        private static final float MAGIC_ADVANCE = -12345.67f;
        private FontRenderContext frc;
        private char[] chars;
        private Font font;
        private LineMetrics metrics;
        private Map attrs;
        private float advance;
        private Rectangle2D vb;
        private Decoration decoration;
        private String str;

        private OptInfo(FontRenderContext fontRenderContext, char[] cArray, Font font, LineMetrics lineMetrics, Map map) {
            this.frc = fontRenderContext;
            this.chars = cArray;
            this.font = font;
            this.metrics = lineMetrics;
            this.attrs = map;
            if (map != null) {
                this.attrs = new HashMap(map);
            }
            this.advance = -12345.67f;
        }

        TextLine createTextLine() {
            return TextLine.fastCreateTextLine(this.frc, this.chars, this.font, this.metrics, this.attrs);
        }

        float getAdvance() {
            if (this.advance == -12345.67f) {
                AdvanceCache advanceCache = AdvanceCache.get(this.font, this.frc);
                this.advance = advanceCache.getAdvance(this.chars, 0, this.chars.length);
            }
            return this.advance;
        }

        public LineMetrics getLineMetrics() {
            return this.metrics;
        }

        public Rectangle2D getLogicalBounds() {
            return new Rectangle2D.Float(0.0f, -this.metrics.getAscent(), this.getAdvance(), this.metrics.getHeight());
        }

        public void handleDraw(Graphics2D graphics2D, float f, float f2) {
            if (this.str == null) {
                this.str = new String(this.chars, 0, this.chars.length);
            }
            graphics2D.drawString(this.str, f, f2);
        }

        public Rectangle2D handleGetCharVisualBounds(int n) {
            throw new InternalError();
        }

        public Rectangle2D handleGetVisualBounds() {
            AdvanceCache advanceCache = AdvanceCache.get(this.font, this.frc);
            return advanceCache.getVisualBounds(this.chars, 0, this.chars.length);
        }

        public Shape handleGetOutline(float f, float f2) {
            throw new InternalError();
        }

        boolean draw(Graphics2D graphics2D, float f, float f2) {
            if (graphics2D.getFontRenderContext().equals(this.frc)) {
                Font font = graphics2D.getFont();
                graphics2D.setFont(this.font);
                this.getDecoration().drawTextAndDecorations(this, graphics2D, f, f2);
                graphics2D.setFont(font);
                return true;
            }
            return false;
        }

        Rectangle2D getVisualBounds() {
            if (this.vb == null) {
                this.vb = this.getDecoration().getVisualBounds(this);
            }
            return (Rectangle2D)this.vb.clone();
        }

        Decoration getDecoration() {
            if (this.decoration == null) {
                this.decoration = this.attrs == null ? Decoration.getDecoration(null) : Decoration.getDecoration(StyledParagraph.addInputMethodAttrs(this.attrs));
            }
            return this.decoration;
        }

        static OptInfo create(FontRenderContext fontRenderContext, char[] cArray, Font font, LineMetrics lineMetrics, Map map) {
            if (!font.isTransformed() && AdvanceCache.supportsText(cArray) && (map == null || map.get(TextAttribute.CHAR_REPLACEMENT) == null)) {
                return new OptInfo(fontRenderContext, cArray, font, lineMetrics, map);
            }
            return null;
        }
    }
}

