/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.ColorType;
import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthBorder;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthGraphics;
import com.sun.java.swing.plaf.gtk.SynthPainter;
import com.sun.java.swing.plaf.gtk.SynthUI;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableCellRenderer;

abstract class SynthStyle {
    private static final SynthGraphics SYNTH_GRAPHICS = new SynthGraphics();

    SynthStyle() {
    }

    public SynthGraphics getSynthGraphics(SynthContext synthContext) {
        return SYNTH_GRAPHICS;
    }

    public Color getColor(SynthContext synthContext, ColorType colorType) {
        return this.getColor(synthContext.getComponent(), synthContext.getRegion(), synthContext.getComponentState(), colorType);
    }

    public Font getFont(SynthContext synthContext) {
        return this.getFont(synthContext.getComponent(), synthContext.getRegion(), synthContext.getComponentState());
    }

    public Color getColor(JComponent jComponent, Region region, int n, ColorType colorType) {
        if (!region.isSubregion() && (n & 1) == 1) {
            if (colorType == ColorType.BACKGROUND) {
                return jComponent.getBackground();
            }
            if (colorType == ColorType.FOREGROUND || colorType == ColorType.TEXT_FOREGROUND) {
                return jComponent.getForeground();
            }
        }
        return this._getColor(jComponent, region, n, colorType);
    }

    protected abstract Color _getColor(JComponent var1, Region var2, int var3, ColorType var4);

    public Font getFont(JComponent jComponent, Region region, int n) {
        if (n == 1) {
            return jComponent.getFont();
        }
        Font font = jComponent.getFont();
        if (font != null && !(font instanceof UIResource)) {
            return font;
        }
        return this._getFont(jComponent, region, n);
    }

    protected abstract Font _getFont(JComponent var1, Region var2, int var3);

    public Insets getInsets(SynthContext synthContext, Insets insets) {
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        insets.right = 0;
        insets.left = 0;
        insets.bottom = 0;
        insets.top = 0;
        return insets;
    }

    public SynthPainter getBorderPainter(SynthContext synthContext) {
        return null;
    }

    public SynthPainter getBackgroundPainter(SynthContext synthContext) {
        return null;
    }

    public boolean isOpaque(SynthContext synthContext) {
        return true;
    }

    public abstract Object get(SynthContext var1, Object var2);

    void installDefaults(SynthContext synthContext, SynthUI synthUI) {
        JComponent jComponent;
        Border border;
        if (!synthContext.isSubregion() && ((border = (jComponent = synthContext.getComponent()).getBorder()) == null || border instanceof UIResource)) {
            jComponent.setBorder(new SynthBorder(synthUI, this.getInsets(synthContext, null)));
        }
        this.installDefaults(synthContext);
    }

    public void installDefaults(SynthContext synthContext) {
        if (!synthContext.isSubregion()) {
            Color color;
            Color color2;
            JComponent jComponent = synthContext.getComponent();
            Region region = synthContext.getRegion();
            Font font = jComponent.getFont();
            if (font == null || font instanceof UIResource) {
                jComponent.setFont(this._getFont(jComponent, region, 1));
            }
            if ((color2 = jComponent.getBackground()) == null || color2 instanceof UIResource) {
                jComponent.setBackground(this._getColor(jComponent, region, 1, ColorType.BACKGROUND));
            }
            if ((color = jComponent.getForeground()) == null || color instanceof UIResource) {
                jComponent.setForeground(this._getColor(jComponent, region, 1, ColorType.FOREGROUND));
            }
            if (region != Region.LABEL || !(jComponent instanceof TableCellRenderer)) {
                jComponent.setOpaque(this.isOpaque(synthContext));
            }
        }
    }

    public void uninstallDefaults(SynthContext synthContext) {
        JComponent jComponent;
        Border border;
        if (!synthContext.isSubregion() && (border = (jComponent = synthContext.getComponent()).getBorder()) instanceof UIResource) {
            jComponent.setBorder(null);
        }
    }

    public int getInt(SynthContext synthContext, Object object, int n) {
        Object object2 = this.get(synthContext, object);
        if (object2 instanceof Number) {
            return ((Number)object2).intValue();
        }
        return n;
    }

    public boolean getBoolean(SynthContext synthContext, Object object, boolean bl) {
        Object object2 = this.get(synthContext, object);
        if (object2 instanceof Boolean) {
            return (Boolean)object2;
        }
        return bl;
    }

    public Icon getIcon(SynthContext synthContext, Object object) {
        Object object2 = this.get(synthContext, object);
        if (object2 instanceof Icon) {
            return (Icon)object2;
        }
        return null;
    }

    public String getString(SynthContext synthContext, Object object, String string) {
        Object object2 = this.get(synthContext, object);
        if (object2 instanceof String) {
            return (String)object2;
        }
        return string;
    }
}

