/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class SynthComboPopup
extends JPopupMenu {
    static final ListModel EmptyListModel = new ListModel(){

        public int getSize() {
            return 0;
        }

        public Object getElementAt(int n) {
            return null;
        }

        public void addListDataListener(ListDataListener listDataListener) {
        }

        public void removeListDataListener(ListDataListener listDataListener) {
        }
    };
    protected JComboBox comboBox;
    protected JList list;
    protected JScrollPane scroller;
    protected boolean valueIsAdjusting = false;
    protected MouseMotionListener mouseMotionListener;
    protected MouseListener mouseListener;
    protected KeyListener keyListener;
    protected ListSelectionListener listSelectionListener;
    protected MouseListener listMouseListener;
    protected MouseMotionListener listMouseMotionListener;
    protected PropertyChangeListener propertyChangeListener;
    protected ListDataListener listDataListener;
    protected ItemListener itemListener;
    protected Timer autoscrollTimer;
    protected boolean hasEntered = false;
    protected boolean isAutoScrolling = false;
    protected int scrollDirection = 0;
    protected static final int SCROLL_UP = 0;
    protected static final int SCROLL_DOWN = 1;

    public void show() {
        this.setListSelection(this.comboBox.getSelectedIndex());
        Point point = this.getPopupLocation();
        this.show(this.comboBox, point.x, point.y);
    }

    public void hide() {
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
        for (int i = 0; i < menuElementArray.length; ++i) {
            if (menuElementArray[i] != this) continue;
            menuSelectionManager.clearSelectedPath();
            break;
        }
        if (menuElementArray.length > 0) {
            this.comboBox.repaint();
        }
    }

    public JList getList() {
        return this.list;
    }

    public MouseListener getMouseListener() {
        if (this.mouseListener == null) {
            this.mouseListener = this.createMouseListener();
        }
        return this.mouseListener;
    }

    public MouseMotionListener getMouseMotionListener() {
        if (this.mouseMotionListener == null) {
            this.mouseMotionListener = this.createMouseMotionListener();
        }
        return this.mouseMotionListener;
    }

    public KeyListener getKeyListener() {
        if (this.keyListener == null) {
            this.keyListener = this.createKeyListener();
        }
        return this.keyListener;
    }

    public void uninstallingUI() {
        if (this.propertyChangeListener != null) {
            this.comboBox.removePropertyChangeListener(this.propertyChangeListener);
        }
        if (this.itemListener != null) {
            this.comboBox.removeItemListener(this.itemListener);
        }
        this.uninstallComboBoxModelListeners(this.comboBox.getModel());
        this.uninstallKeyboardActions();
        this.uninstallListListeners();
        this.list.setModel(EmptyListModel);
    }

    protected void uninstallComboBoxModelListeners(ComboBoxModel comboBoxModel) {
        if (comboBoxModel != null && this.listDataListener != null) {
            comboBoxModel.removeListDataListener(this.listDataListener);
        }
    }

    protected void uninstallKeyboardActions() {
    }

    public SynthComboPopup(JComboBox jComboBox) {
        this.comboBox = jComboBox;
        this.installComboBoxListeners();
        this.setLightWeightPopupEnabled(this.comboBox.isLightWeightPopupEnabled());
        this.list = this.createList();
        this.list.setName("ComboBox.list");
        this.configureList();
        this.scroller = this.createScroller();
        this.scroller.setName("ComboBox.scrollPane");
        this.configureScroller();
        this.configurePopup();
        this.installKeyboardActions();
    }

    protected void firePopupMenuWillBecomeVisible() {
        super.firePopupMenuWillBecomeVisible();
        this.comboBox.firePopupMenuWillBecomeVisible();
    }

    protected void firePopupMenuWillBecomeInvisible() {
        super.firePopupMenuWillBecomeInvisible();
        this.comboBox.firePopupMenuWillBecomeInvisible();
    }

    protected void firePopupMenuCanceled() {
        super.firePopupMenuCanceled();
        this.comboBox.firePopupMenuCanceled();
    }

    protected MouseListener createMouseListener() {
        return new InvocationMouseHandler();
    }

    protected MouseMotionListener createMouseMotionListener() {
        return new InvocationMouseMotionHandler();
    }

    protected KeyListener createKeyListener() {
        return null;
    }

    protected ListSelectionListener createListSelectionListener() {
        return null;
    }

    protected ListDataListener createListDataListener() {
        return null;
    }

    protected MouseListener createListMouseListener() {
        return new ListMouseHandler();
    }

    protected MouseMotionListener createListMouseMotionListener() {
        return new ListMouseMotionHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected ItemListener createItemListener() {
        return new ItemHandler();
    }

    protected JList createList() {
        return new JList(this.comboBox.getModel()){

            public void processMouseEvent(MouseEvent mouseEvent) {
                if (mouseEvent.isControlDown()) {
                    mouseEvent = new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers() ^ 2, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                }
                super.processMouseEvent(mouseEvent);
            }
        };
    }

    protected void configureList() {
        this.list.setFont(this.comboBox.getFont());
        this.list.setCellRenderer(this.comboBox.getRenderer());
        this.list.setFocusable(false);
        this.list.setSelectionMode(0);
        this.setListSelection(this.comboBox.getSelectedIndex());
        this.installListListeners();
    }

    protected void installListListeners() {
        this.listMouseListener = this.createListMouseListener();
        if (this.listMouseListener != null) {
            this.list.addMouseListener(this.listMouseListener);
        }
        if ((this.listMouseMotionListener = this.createListMouseMotionListener()) != null) {
            this.list.addMouseMotionListener(this.listMouseMotionListener);
        }
        if ((this.listSelectionListener = this.createListSelectionListener()) != null) {
            this.list.addListSelectionListener(this.listSelectionListener);
        }
    }

    void uninstallListListeners() {
        if (this.listMouseListener != null) {
            this.list.removeMouseListener(this.listMouseListener);
            this.listMouseListener = null;
        }
        if (this.listMouseMotionListener != null) {
            this.list.removeMouseMotionListener(this.listMouseMotionListener);
            this.listMouseMotionListener = null;
        }
        if (this.listSelectionListener != null) {
            this.list.removeListSelectionListener(this.listSelectionListener);
            this.listSelectionListener = null;
        }
    }

    protected JScrollPane createScroller() {
        return new JScrollPane(this.list, 20, 31);
    }

    protected void configureScroller() {
        this.scroller.setFocusable(false);
        this.scroller.getVerticalScrollBar().setFocusable(false);
        this.scroller.setBorder(null);
    }

    protected void configurePopup() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorderPainted(true);
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.setOpaque(false);
        this.add(this.scroller);
        this.setDoubleBuffered(true);
        this.setFocusable(false);
    }

    protected void installComboBoxListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.comboBox.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((this.itemListener = this.createItemListener()) != null) {
            this.comboBox.addItemListener(this.itemListener);
        }
        this.installComboBoxModelListeners(this.comboBox.getModel());
    }

    protected void installComboBoxModelListeners(ComboBoxModel comboBoxModel) {
        if (comboBoxModel != null && (this.listDataListener = this.createListDataListener()) != null) {
            comboBoxModel.addListDataListener(this.listDataListener);
        }
    }

    protected void installKeyboardActions() {
    }

    public boolean isFocusTraversable() {
        return false;
    }

    protected void startAutoScrolling(int n) {
        if (this.isAutoScrolling) {
            this.autoscrollTimer.stop();
        }
        this.isAutoScrolling = true;
        if (n == 0) {
            this.scrollDirection = 0;
            Point point = SwingUtilities.convertPoint(this.scroller, new Point(1, 1), this.list);
            int n2 = this.list.locationToIndex(point);
            this.list.setSelectedIndex(n2);
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SynthComboPopup.this.autoScrollUp();
                }
            };
            this.autoscrollTimer = new Timer(100, actionListener);
        } else if (n == 1) {
            this.scrollDirection = 1;
            Dimension dimension = this.scroller.getSize();
            Point point = SwingUtilities.convertPoint(this.scroller, new Point(1, dimension.height - 1 - 2), this.list);
            int n3 = this.list.locationToIndex(point);
            this.list.setSelectedIndex(n3);
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SynthComboPopup.this.autoScrollDown();
                }
            };
            this.autoscrollTimer = new Timer(100, actionListener);
        }
        this.autoscrollTimer.start();
    }

    protected void stopAutoScrolling() {
        this.isAutoScrolling = false;
        if (this.autoscrollTimer != null) {
            this.autoscrollTimer.stop();
            this.autoscrollTimer = null;
        }
    }

    protected void autoScrollUp() {
        int n = this.list.getSelectedIndex();
        if (n > 0) {
            this.list.setSelectedIndex(n - 1);
            this.list.ensureIndexIsVisible(n - 1);
        }
    }

    protected void autoScrollDown() {
        int n;
        int n2 = this.list.getSelectedIndex();
        if (n2 < (n = this.list.getModel().getSize() - 1)) {
            this.list.setSelectedIndex(n2 + 1);
            this.list.ensureIndexIsVisible(n2 + 1);
        }
    }

    protected void delegateFocus(MouseEvent mouseEvent) {
        if (this.comboBox.isEditable()) {
            Component component = this.comboBox.getEditor().getEditorComponent();
            if (!(component instanceof JComponent) || ((JComponent)component).isRequestFocusEnabled()) {
                component.requestFocus();
            }
        } else if (this.comboBox.isRequestFocusEnabled()) {
            this.comboBox.requestFocus();
        }
    }

    protected void togglePopup() {
        if (this.isVisible()) {
            this.hide();
        } else {
            this.show();
        }
    }

    private void setListSelection(int n) {
        if (n == -1) {
            this.list.clearSelection();
        } else {
            this.list.setSelectedIndex(n);
            this.list.ensureIndexIsVisible(n);
        }
    }

    protected MouseEvent convertMouseEvent(MouseEvent mouseEvent) {
        Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), this.list);
        MouseEvent mouseEvent2 = new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
        return mouseEvent2;
    }

    protected int getPopupHeightForRowCount(int n) {
        int n2 = Math.min(n, this.comboBox.getItemCount());
        int n3 = 0;
        ListCellRenderer listCellRenderer = this.list.getCellRenderer();
        Object object = null;
        for (int i = 0; i < n2; ++i) {
            object = this.list.getModel().getElementAt(i);
            Component component = listCellRenderer.getListCellRendererComponent(this.list, object, i, false, false);
            n3 += component.getPreferredSize().height;
        }
        return n3 == 0 ? 100 : n3;
    }

    protected Rectangle computePopupBounds(int n, int n2, int n3, int n4) {
        Rectangle rectangle;
        Cloneable cloneable;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsConfiguration graphicsConfiguration = this.comboBox.getGraphicsConfiguration();
        Point point = new Point();
        SwingUtilities.convertPointFromScreen(point, this.comboBox);
        if (graphicsConfiguration != null) {
            cloneable = toolkit.getScreenInsets(graphicsConfiguration);
            rectangle = graphicsConfiguration.getBounds();
            rectangle.width -= cloneable.left + cloneable.right;
            rectangle.height -= cloneable.top + cloneable.bottom;
            rectangle.x += point.x + cloneable.left;
            rectangle.y += point.y + cloneable.top;
        } else {
            rectangle = new Rectangle(point, toolkit.getScreenSize());
        }
        cloneable = new Rectangle(n, n2, n3, n4);
        if (n2 + n4 > rectangle.y + rectangle.height && n4 < rectangle.height) {
            ((Rectangle)cloneable).y = -((Rectangle)cloneable).height;
        }
        return cloneable;
    }

    private Point getPopupLocation() {
        Dimension dimension = this.comboBox.getSize();
        Insets insets = this.getInsets();
        dimension.setSize(dimension.width - (insets.right + insets.left), this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount()));
        Rectangle rectangle = this.computePopupBounds(0, this.comboBox.getBounds().height, dimension.width, dimension.height);
        Dimension dimension2 = rectangle.getSize();
        Point point = rectangle.getLocation();
        this.scroller.setMaximumSize(dimension2);
        this.scroller.setPreferredSize(dimension2);
        this.scroller.setMinimumSize(dimension2);
        this.list.revalidate();
        return point;
    }

    protected void updateListBoxSelectionForEvent(MouseEvent mouseEvent, boolean bl) {
        Point point = mouseEvent.getPoint();
        if (this.list == null) {
            return;
        }
        int n = this.list.locationToIndex(point);
        if (n == -1) {
            n = point.y < 0 ? 0 : this.comboBox.getModel().getSize() - 1;
        }
        if (this.list.getSelectedIndex() != n) {
            this.list.setSelectedIndex(n);
            if (bl) {
                this.list.ensureIndexIsVisible(n);
            }
        }
    }

    protected class PropertyChangeHandler
    implements PropertyChangeListener {
        protected PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JComboBox jComboBox = (JComboBox)propertyChangeEvent.getSource();
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("model")) {
                ComboBoxModel comboBoxModel = (ComboBoxModel)propertyChangeEvent.getOldValue();
                ComboBoxModel comboBoxModel2 = (ComboBoxModel)propertyChangeEvent.getNewValue();
                SynthComboPopup.this.uninstallComboBoxModelListeners(comboBoxModel);
                SynthComboPopup.this.installComboBoxModelListeners(comboBoxModel2);
                SynthComboPopup.this.list.setModel(comboBoxModel2);
                if (SynthComboPopup.this.isVisible()) {
                    SynthComboPopup.this.hide();
                }
            } else if (string.equals("renderer")) {
                SynthComboPopup.this.list.setCellRenderer(jComboBox.getRenderer());
                if (SynthComboPopup.this.isVisible()) {
                    SynthComboPopup.this.hide();
                }
            } else if (string.equals("componentOrientation")) {
                ComponentOrientation componentOrientation = (ComponentOrientation)propertyChangeEvent.getNewValue();
                JList jList = SynthComboPopup.this.getList();
                if (jList != null && jList.getComponentOrientation() != componentOrientation) {
                    jList.setComponentOrientation(componentOrientation);
                }
                if (SynthComboPopup.this.scroller != null && SynthComboPopup.this.scroller.getComponentOrientation() != componentOrientation) {
                    SynthComboPopup.this.scroller.setComponentOrientation(componentOrientation);
                }
                if (componentOrientation != SynthComboPopup.this.getComponentOrientation()) {
                    SynthComboPopup.this.setComponentOrientation(componentOrientation);
                }
            } else if (string.equals("lightWeightPopupEnabled")) {
                SynthComboPopup.this.setLightWeightPopupEnabled(jComboBox.isLightWeightPopupEnabled());
            }
        }
    }

    protected class ItemHandler
    implements ItemListener {
        protected ItemHandler() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                JComboBox jComboBox = (JComboBox)itemEvent.getSource();
                SynthComboPopup.this.setListSelection(jComboBox.getSelectedIndex());
            }
        }
    }

    protected class ListMouseMotionHandler
    extends MouseMotionAdapter {
        protected ListMouseMotionHandler() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            Rectangle rectangle = new Rectangle();
            SynthComboPopup.this.list.computeVisibleRect(rectangle);
            if (rectangle.contains(point)) {
                SynthComboPopup.this.updateListBoxSelectionForEvent(mouseEvent, false);
            }
        }
    }

    protected class ListMouseHandler
    extends MouseAdapter {
        protected ListMouseHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            SynthComboPopup.this.comboBox.setSelectedIndex(SynthComboPopup.this.list.getSelectedIndex());
            SynthComboPopup.this.comboBox.setPopupVisible(false);
            if (SynthComboPopup.this.comboBox.isEditable() && SynthComboPopup.this.comboBox.getEditor() != null) {
                SynthComboPopup.this.comboBox.configureEditor(SynthComboPopup.this.comboBox.getEditor(), SynthComboPopup.this.comboBox.getSelectedItem());
            }
        }
    }

    class ListDataHandler
    implements ListDataListener {
        ListDataHandler() {
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
        }
    }

    protected class ListSelectionHandler
    implements ListSelectionListener {
        protected ListSelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
        }
    }

    class InvocationKeyHandler
    extends KeyAdapter {
        InvocationKeyHandler() {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }
    }

    protected class InvocationMouseMotionHandler
    extends MouseMotionAdapter {
        protected InvocationMouseMotionHandler() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (SynthComboPopup.this.isVisible()) {
                MouseEvent mouseEvent2 = SynthComboPopup.this.convertMouseEvent(mouseEvent);
                Rectangle rectangle = new Rectangle();
                SynthComboPopup.this.list.computeVisibleRect(rectangle);
                if (mouseEvent2.getPoint().y >= rectangle.y && mouseEvent2.getPoint().y <= rectangle.y + rectangle.height - 1) {
                    Point point;
                    SynthComboPopup.this.hasEntered = true;
                    if (SynthComboPopup.this.isAutoScrolling) {
                        SynthComboPopup.this.stopAutoScrolling();
                    }
                    if (rectangle.contains(point = mouseEvent2.getPoint())) {
                        SynthComboPopup.this.updateListBoxSelectionForEvent(mouseEvent2, false);
                    }
                } else if (SynthComboPopup.this.hasEntered) {
                    int n;
                    int n2 = n = mouseEvent2.getPoint().y < rectangle.y ? 0 : 1;
                    if (SynthComboPopup.this.isAutoScrolling && SynthComboPopup.this.scrollDirection != n) {
                        SynthComboPopup.this.stopAutoScrolling();
                        SynthComboPopup.this.startAutoScrolling(n);
                    } else if (!SynthComboPopup.this.isAutoScrolling) {
                        SynthComboPopup.this.startAutoScrolling(n);
                    }
                } else if (mouseEvent.getPoint().y < 0) {
                    SynthComboPopup.this.hasEntered = true;
                    SynthComboPopup.this.startAutoScrolling(0);
                }
            }
        }
    }

    protected class InvocationMouseHandler
    extends MouseAdapter {
        protected InvocationMouseHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent) || !SynthComboPopup.this.comboBox.isEnabled()) {
                return;
            }
            if (SynthComboPopup.this.comboBox.isEditable()) {
                Component component = SynthComboPopup.this.comboBox.getEditor().getEditorComponent();
                if (!(component instanceof JComponent) || ((JComponent)component).isRequestFocusEnabled()) {
                    component.requestFocus();
                }
            } else if (SynthComboPopup.this.comboBox.isRequestFocusEnabled()) {
                SynthComboPopup.this.comboBox.requestFocus();
            }
            SynthComboPopup.this.togglePopup();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            Component component = (Component)mouseEvent.getSource();
            Dimension dimension = component.getSize();
            Rectangle rectangle = new Rectangle(0, 0, dimension.width - 1, dimension.height - 1);
            if (!rectangle.contains(mouseEvent.getPoint())) {
                MouseEvent mouseEvent2 = SynthComboPopup.this.convertMouseEvent(mouseEvent);
                Point point = mouseEvent2.getPoint();
                Rectangle rectangle2 = new Rectangle();
                SynthComboPopup.this.list.computeVisibleRect(rectangle2);
                if (rectangle2.contains(point)) {
                    SynthComboPopup.this.comboBox.setSelectedIndex(SynthComboPopup.this.list.getSelectedIndex());
                }
                SynthComboPopup.this.comboBox.setPopupVisible(false);
            }
            SynthComboPopup.this.hasEntered = false;
            SynthComboPopup.this.stopAutoScrolling();
        }
    }
}

