/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.DSAPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.DSAPublicKey;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11DSAPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11DSAPublicKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11KeySpec;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.X509EncodedKeySpec;

public class DSAPKCS11KeyFactory
extends KeyFactorySpi {
    private PKCS11Session session = null;
    private static Debug debug1 = Debug.getInstance((String)"pkcs11impl");
    private static Debug debug2 = Debug.getInstance((String)"dsapkcs11keyfactory");
    private static Debug debug = debug1 == null ? debug2 : debug1;
    private static String className = "com.ibm.crypto.pkcs11impl.provider.DSAPKCS11KeyFactory";
    static /* synthetic */ Class class$java$security$spec$DSAPublicKeySpec;
    static /* synthetic */ Class class$java$security$spec$DSAPrivateKeySpec;

    public DSAPKCS11KeyFactory() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "DSAPKCS11KeyFactory");
        }
        this.session = IBMPKCS11Impl.session;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "DSAPKCS11KeyFactory");
        }
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        DSAPrivateKey dSAPrivateKey = null;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineGeneratePrivate", (Object)keySpec);
        }
        if (keySpec instanceof DSAPrivateKeySpec) {
            DSAPrivateKeySpec dSAPrivateKeySpec = (DSAPrivateKeySpec)keySpec;
            BigInteger bigInteger = dSAPrivateKeySpec.getP();
            BigInteger bigInteger2 = dSAPrivateKeySpec.getQ();
            BigInteger bigInteger3 = dSAPrivateKeySpec.getG();
            BigInteger bigInteger4 = dSAPrivateKeySpec.getX();
            try {
                PKCS11Object pKCS11Object = null;
                byte[] byArray = null;
                Boolean bl = Boolean.FALSE;
                Boolean bl2 = Boolean.FALSE;
                Boolean bl3 = Boolean.TRUE;
                byArray = this.genID();
                int[] nArray = new int[]{0, 256, 258, 2, 1, 259, 264, 304, 305, 306, 17};
                Object[] objectArray = new Object[]{PKCS11Object.PRIVATE_KEY, PKCS11Object.DSA, byArray, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, Boolean.TRUE, bigInteger, bigInteger2, bigInteger3, bigInteger4.toByteArray()};
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineGeneratePublic", "P: " + bigInteger + "\n bit len: " + bigInteger.bitLength());
                    debug.text(16384L, (Object)className, "engineGeneratePublic", "Q: " + bigInteger2 + "\n bit len: " + bigInteger2.bitLength());
                    debug.text(16384L, (Object)className, "engineGeneratePublic", "G: " + bigInteger3 + "\n bit len: " + bigInteger3.bitLength());
                    debug.text(16384L, (Object)className, "engineGeneratePublic", "X: " + bigInteger4 + "\n bit len: " + bigInteger4.bitLength());
                }
                pKCS11Object = this.session.createObject(nArray, objectArray);
                dSAPrivateKey = new DSAPrivateKey(pKCS11Object, null, byArray, null, Boolean.FALSE, Boolean.FALSE, Boolean.TRUE, bigInteger, bigInteger2, bigInteger3, bigInteger4);
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "engineGeneratePrivate");
                }
                return dSAPrivateKey;
            }
            catch (Exception exception) {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "engineGeneratePrivate_1", (Throwable)exception);
                    debug.exit(16384L, (Object)className, "engineGeneratePrivate");
                }
                throw new InvalidKeySpecException("Invalid key spec: " + exception.getMessage());
            }
        }
        if (keySpec instanceof PKCS11KeySpec) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "engineGeneratePrivate_3");
            }
            PKCS11Object pKCS11Object = ((PKCS11KeySpec)keySpec).getObject();
            try {
                return new DSAPrivateKey(pKCS11Object, (String)this.getAttrValue(pKCS11Object, 3), (byte[])this.getAttrValue(pKCS11Object, 258), (byte[])this.getAttrValue(pKCS11Object, 257), (Boolean)this.getAttrValue(pKCS11Object, 1), (Boolean)this.getAttrValue(pKCS11Object, 259), (Boolean)this.getAttrValue(pKCS11Object, 354), (BigInteger)this.getAttrValue(pKCS11Object, 304), (BigInteger)this.getAttrValue(pKCS11Object, 305), (BigInteger)this.getAttrValue(pKCS11Object, 306), new BigInteger((byte[])this.getAttrValue(pKCS11Object, 17)));
            }
            catch (Exception exception) {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "engineGeneratePrivate_4", (Throwable)exception);
                    debug.exit(16384L, (Object)className, "engineGeneratePrivate");
                }
                throw new InvalidKeySpecException("Invalid key spec: " + exception.getMessage());
            }
        }
        if (debug != null) {
            debug.text(16384L, (Object)className, "engineGeneratePrivate_5", "Invalid key spec");
            debug.exit(16384L, (Object)className, "engineGeneratePrivate");
        }
        throw new InvalidKeySpecException("Invalid key spec");
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineGeneratePublic", (Object)keySpec);
        }
        try {
            DSAPublicKey dSAPublicKey = null;
            if (keySpec instanceof DSAPublicKeySpec) {
                DSAPublicKeySpec dSAPublicKeySpec = (DSAPublicKeySpec)keySpec;
                BigInteger bigInteger = dSAPublicKeySpec.getP();
                BigInteger bigInteger2 = dSAPublicKeySpec.getQ();
                BigInteger bigInteger3 = dSAPublicKeySpec.getG();
                BigInteger bigInteger4 = dSAPublicKeySpec.getY();
                PKCS11Object pKCS11Object = null;
                byte[] byArray = null;
                byArray = this.genID();
                int[] nArray = new int[]{0, 256, 258, 1, 266, 304, 305, 306, 17};
                Object[] objectArray = new Object[]{PKCS11Object.PUBLIC_KEY, PKCS11Object.DSA, byArray, Boolean.FALSE, Boolean.TRUE, bigInteger, bigInteger2, bigInteger3, bigInteger4.toByteArray()};
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineGeneratePublic", "P: " + bigInteger + "\n bit len: " + bigInteger.bitLength());
                    debug.text(16384L, (Object)className, "engineGeneratePublic", "Q: " + bigInteger2 + "\n bit len: " + bigInteger2.bitLength());
                    debug.text(16384L, (Object)className, "engineGeneratePublic", "G: " + bigInteger3 + "\n bit len: " + bigInteger3.bitLength());
                    debug.text(16384L, (Object)className, "engineGeneratePublic", "Y: " + bigInteger4 + "\n bit len: " + bigInteger4.bitLength());
                }
                pKCS11Object = this.session.createObject(nArray, objectArray);
                dSAPublicKey = new DSAPublicKey(pKCS11Object, byArray, null, null, Boolean.FALSE, bigInteger, bigInteger2, bigInteger3, bigInteger4);
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "engineGeneratePublic");
                }
                return dSAPublicKey;
            }
            if (keySpec instanceof X509EncodedKeySpec) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "engineGeneratePublic");
                }
                return new DSAPublicKey(((X509EncodedKeySpec)keySpec).getEncoded());
            }
            if (keySpec instanceof PKCS11KeySpec) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "engineGeneratePublic_3");
                }
                PKCS11Object pKCS11Object = ((PKCS11KeySpec)keySpec).getObject();
                return new DSAPublicKey(pKCS11Object, (byte[])this.getAttrValue(pKCS11Object, 258), (byte[])this.getAttrValue(pKCS11Object, 257), (String)this.getAttrValue(pKCS11Object, 3), (Boolean)this.getAttrValue(pKCS11Object, 1), (BigInteger)this.getAttrValue(pKCS11Object, 304), (BigInteger)this.getAttrValue(pKCS11Object, 305), (BigInteger)this.getAttrValue(pKCS11Object, 306), new BigInteger((byte[])this.getAttrValue(pKCS11Object, 17)));
            }
            if (debug != null) {
                debug.text(16384L, (Object)className, "engineGeneratePublic_1", "Invalid Key spec");
                debug.exit(16384L, (Object)className, "engineGeneratePublic");
            }
            throw new InvalidKeySpecException("Invalid key spec");
        }
        catch (InvalidKeyException invalidKeyException) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineGeneratePublic_2", (Throwable)invalidKeyException);
                debug.exit(16384L, (Object)className, "engineGeneratePublic");
            }
            throw new InvalidKeySpecException("Invalid key spec: " + invalidKeyException.getMessage());
        }
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineGetKeySpec", (Object)key, (Object)clazz);
        }
        try {
            if (key instanceof PKCS11DSAPublicKey) {
                Class<?> clazz2 = Class.forName("java.security.spec.DSAPublicKeySpec");
                Class<?> clazz3 = Class.forName("java.security.spec.X509EncodedKeySpec");
                if (clazz2.isAssignableFrom(clazz)) {
                    DSAPublicKey dSAPublicKey = (DSAPublicKey)key;
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineGetKeySpec", (Object)"DSAPublicKeySpec");
                    }
                    return new DSAPublicKeySpec(dSAPublicKey.getValue(), dSAPublicKey.getPrime(), dSAPublicKey.getSubprime(), dSAPublicKey.getBase());
                }
                if (clazz3.isAssignableFrom(clazz)) {
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineGetKeySpec", (Object)"X509EncodedKeySpec");
                    }
                    return new X509EncodedKeySpec(key.getEncoded());
                }
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineGetKeySpec", "Inappropriate key specification");
                    debug.exit(16384L, (Object)className, "engineGetKeySpec");
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (key instanceof java.security.interfaces.DSAPublicKey) {
                Class<?> clazz4 = Class.forName("java.security.spec.DSAPublicKeySpec");
                Class<?> clazz5 = Class.forName("java.security.spec.X509EncodedKeySpec");
                if (clazz4.isAssignableFrom(clazz)) {
                    java.security.interfaces.DSAPublicKey dSAPublicKey = (java.security.interfaces.DSAPublicKey)key;
                    DSAParams dSAParams = dSAPublicKey.getParams();
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineGetKeySpec", (Object)"DSAPublicKeySpec_1");
                    }
                    return new DSAPublicKeySpec(dSAPublicKey.getY(), dSAParams.getP(), dSAParams.getQ(), dSAParams.getG());
                }
                if (clazz5.isAssignableFrom(clazz)) {
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineGetKeySpec", (Object)"X509EncodedKeySpec_1");
                    }
                    return new X509EncodedKeySpec(key.getEncoded());
                }
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineGetKeySpec", "Inappropriate key specification");
                    debug.exit(16384L, (Object)className, "engineGetKeySpec");
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (key instanceof PKCS11DSAPrivateKey) {
                Class<?> clazz6 = Class.forName("java.security.spec.DSAPrivateKeySpec");
                if (clazz6.isAssignableFrom(clazz)) {
                    DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)key;
                    if (dSAPrivateKey.getSensitive().booleanValue()) {
                        if (debug != null) {
                            debug.text(16384L, (Object)className, "engineGetKeySpec", "Private key value is not exportable");
                            debug.exit(16384L, (Object)className, "engineGetKeySpec");
                        }
                        throw new PKCS11Exception("Private key value is not exportable");
                    }
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineGetKeySpec", (Object)"DSAPrivateKeySpec");
                    }
                    return new DSAPrivateKeySpec(dSAPrivateKey.getValue(), dSAPrivateKey.getPrime(), dSAPrivateKey.getSubprime(), dSAPrivateKey.getBase());
                }
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineGetKeySpec", "Inappropriate key specification");
                    debug.exit(16384L, (Object)className, "engineGetKeySpec");
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (key instanceof java.security.interfaces.DSAPrivateKey) {
                Class<?> clazz7 = Class.forName("java.security.spec.DSAPrivateKeySpec");
                if (clazz7.isAssignableFrom(clazz)) {
                    java.security.interfaces.DSAPrivateKey dSAPrivateKey = (java.security.interfaces.DSAPrivateKey)key;
                    DSAParams dSAParams = dSAPrivateKey.getParams();
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineGetKeySpec", (Object)"DSAPrivateKeySpec_1");
                    }
                    return new DSAPrivateKeySpec(dSAPrivateKey.getX(), dSAParams.getP(), dSAParams.getQ(), dSAParams.getG());
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (debug != null) {
                debug.text(16384L, (Object)className, "engineGetKeySpec", "Inappropriate key specification");
                debug.exit(16384L, (Object)className, "engineGetKeySpec");
            }
            throw new InvalidKeySpecException("Inappropriate key type");
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineGetKeySpec", (Throwable)classNotFoundException);
                debug.exit(16384L, (Object)className, "engineGetKeySpec");
            }
            throw new InvalidKeySpecException("Unsupported key specification: " + classNotFoundException.getMessage());
        }
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineTranslateKey", (Object)key);
        }
        try {
            if (key instanceof java.security.interfaces.DSAPublicKey) {
                if (key instanceof DSAPublicKey) {
                    return key;
                }
                DSAPublicKeySpec dSAPublicKeySpec = (DSAPublicKeySpec)this.engineGetKeySpec(key, class$java$security$spec$DSAPublicKeySpec == null ? (class$java$security$spec$DSAPublicKeySpec = DSAPKCS11KeyFactory.class$("java.security.spec.DSAPublicKeySpec")) : class$java$security$spec$DSAPublicKeySpec);
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "engineTranslateKey", (Object)"DSAPublicKey");
                }
                return this.engineGeneratePublic(dSAPublicKeySpec);
            }
            if (key instanceof java.security.interfaces.DSAPrivateKey) {
                if (key instanceof DSAPrivateKey) {
                    return key;
                }
                DSAPrivateKeySpec dSAPrivateKeySpec = (DSAPrivateKeySpec)this.engineGetKeySpec(key, class$java$security$spec$DSAPrivateKeySpec == null ? (class$java$security$spec$DSAPrivateKeySpec = DSAPKCS11KeyFactory.class$("java.security.spec.DSAPrivateKeySpec")) : class$java$security$spec$DSAPrivateKeySpec);
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "engineTranslateKey", (Object)"DSAPrivateKey");
                }
                return this.engineGeneratePrivate(dSAPrivateKeySpec);
            }
            if (debug != null) {
                debug.text(16384L, (Object)className, "engineTranslateKey", "Wrong algorithm type");
                debug.exit(16384L, (Object)className, "engineTranslateKey");
            }
            throw new InvalidKeyException("Wrong algorithm type");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineTranslateKey", (Throwable)invalidKeySpecException);
                debug.exit(16384L, (Object)className, "engineTranslateKey");
            }
            throw new InvalidKeyException("Cannot translate key: " + invalidKeySpecException.getMessage());
        }
    }

    private byte[] genID() {
        Serializable serializable;
        byte[] byArray = new byte[33];
        byte[] byArray2 = new byte[24];
        byte[] byArray3 = null;
        int n = 0;
        try {
            serializable = SecureRandom.getInstance("IBMSecureRandom", "IBMPKCS11Impl");
            ((SecureRandom)serializable).nextBytes(byArray2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        serializable = new BigInteger(1, byArray2);
        try {
            byArray3 = ((BigInteger)serializable).toString().getBytes("8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError("Can not convert string");
        }
        n = ((BigInteger)serializable).toString().length();
        if (n > 24) {
            n = 24;
        }
        System.arraycopy(byArray3, 0, byArray, 9, n);
        byArray[0] = 73;
        byArray[1] = 66;
        byArray[2] = 77;
        byArray[3] = 80;
        byArray[4] = 75;
        byArray[5] = 67;
        byArray[6] = 83;
        byArray[7] = 49;
        byArray[8] = 49;
        return byArray;
    }

    private Object getAttrValue(PKCS11Object pKCS11Object, int n) {
        Object object;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getValue", (Object)pKCS11Object, (Object)new Integer(n));
        }
        try {
            object = pKCS11Object.getAttributeValue(n);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "getValue", exception.getMessage());
            }
            object = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getValue");
        }
        return object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

