/*
 * Decompiled with CFR 0.152.
 */
package java.util.regex;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.ASCII;
import java.util.regex.Matcher;
import java.util.regex.PatternSyntaxException;
import sun.text.Normalizer;

public final class Pattern
implements Serializable {
    public static final int UNIX_LINES = 1;
    public static final int CASE_INSENSITIVE = 2;
    public static final int COMMENTS = 4;
    public static final int MULTILINE = 8;
    public static final int DOTALL = 32;
    public static final int UNICODE_CASE = 64;
    public static final int CANON_EQ = 128;
    private static final long serialVersionUID = 5073258162644648461L;
    private String pattern;
    private int flags;
    private transient String normalizedPattern;
    transient Node root;
    transient Node matchRoot;
    transient char[] buffer;
    transient GroupHead[] groupNodes;
    private transient char[] temp;
    transient int groupCount;
    transient int localCount;
    private transient int cursor;
    private transient int patternLength;
    static final int MAX_REPS = Integer.MAX_VALUE;
    static final int GREEDY = 0;
    static final int LAZY = 1;
    static final int POSSESSIVE = 2;
    static final int INDEPENDENT = 3;
    static Node accept = new Node();
    static Node lastAccept = new LastNode();
    static HashMap families = null;
    static HashMap categories = null;
    private static final String[] familyNames = new String[]{"BasicLatin", "Latin-1Supplement", "LatinExtended-A", "LatinExtended-Bound", "IPAExtensions", "SpacingModifierLetters", "CombiningDiacriticalMarks", "Greek", "Cyrillic", "Armenian", "Hebrew", "Arabic", "Syriac", "Thaana", "Devanagari", "Bengali", "Gurmukhi", "Gujarati", "Oriya", "Tamil", "Telugu", "Kannada", "Malayalam", "Sinhala", "Thai", "Lao", "Tibetan", "Myanmar", "Georgian", "HangulJamo", "Ethiopic", "Cherokee", "UnifiedCanadianAboriginalSyllabics", "Ogham", "Runic", "Khmer", "Mongolian", "LatinExtendedAdditional", "GreekExtended", "GeneralPunctuation", "SuperscriptsandSubscripts", "CurrencySymbols", "CombiningMarksforSymbols", "LetterlikeSymbols", "NumberForms", "Arrows", "MathematicalOperators", "MiscellaneousTechnical", "ControlPictures", "OpticalCharacterRecognition", "EnclosedAlphanumerics", "BoxDrawing", "BlockElements", "GeometricShapes", "MiscellaneousSymbols", "Dingbats", "BraillePatterns", "CJKRadicalsSupplement", "KangxiRadicals", "IdeographicDescriptionCharacters", "CJKSymbolsandPunctuation", "Hiragana", "Katakana", "Bopomofo", "HangulCompatibilityJamo", "Kanbun", "BopomofoExtended", "EnclosedCJKLettersandMonths", "CJKCompatibility", "CJKUnifiedIdeographsExtensionA", "CJKUnifiedIdeographs", "YiSyllables", "YiRadicals", "HangulSyllables", "HighSurrogates", "HighPrivateUseSurrogates", "LowSurrogates", "PrivateUse", "CJKCompatibilityIdeographs", "AlphabeticPresentationForms", "ArabicPresentationForms-A", "CombiningHalfMarks", "CJKCompatibilityForms", "SmallFormVariants", "ArabicPresentationForms-Bound", "Specials", "HalfwidthandFullwidthForms"};
    private static final String[] categoryNames = new String[]{"Cn", "Lu", "Ll", "Lt", "Lm", "Lo", "Mn", "Me", "Mc", "Nd", "Nl", "No", "Zs", "Zl", "Zp", "Cc", "Cf", "Co", "Cs", "Pd", "Ps", "Pe", "Pc", "Po", "Sm", "Sc", "Sk", "So", "L", "M", "N", "Z", "C", "P", "S", "LD", "L1", "all", "ASCII", "Alnum", "Alpha", "Blank", "Cntrl", "Digit", "Graph", "Lower", "Print", "Punct", "Space", "Upper", "XDigit"};
    private static final Node[] familyNodes = new Node[]{new Range(127), new Range(0x8000FF), new Range(16777599), new Range(25166415), new Range(38797999), new Range(45089535), new Range(50332527), new Range(57672703), new Range(0x40004FF), new Range(87033231), new Range(93324799), new Range(0x60006FF), new Range(117442383), new Range(125831103), new Range(150997375), new Range(159386111), new Range(167774847), new Range(176163583), new Range(184552319), new Range(192941055), new Range(201329791), new Range(209718527), new Range(218107263), new Range(226495999), new Range(234884735), new Range(243273471), new Range(0xF000FFF), new Range(268439711), new Range(278925567), new Range(0x110011FF), new Range(301994879), new Range(329257983), new Range(335550079), new Range(377493151), new Range(379590399), new Range(394270719), new Range(402659503), new Range(503324415), new Range(0x1F001FFF), new Range(536879215), new Range(544219295), new Range(547365071), new Range(550510847), new Range(553656655), new Range(558899599), new Range(563094015), new Range(0x220022FF), new Range(587211775), new Range(603989055), new Range(608183391), new Range(610280703), new Range(620766591), new Range(629155231), new Range(631252479), new Range(637544191), new Range(654321599), new Range(671099135), new Range(780152575), new Range(788541407), new Range(0x2FF02FFF), new Range(0x3000303F), new Range(809513119), new Range(815804671), new Range(822096175), new Range(825241999), new Range(831533471), new Range(832582079), new Range(838873855), new Range(0x330033FF), new Range(872435125), new Range(1308663807), new Range(-1610570609), new Range(-1534024497), new Range(-1409230941), new Range(-671032449), new Range(-612312065), new Range(-603922433), new Range(-536807169), new Range(-117376257), new Range(-83821745), new Range(-78578177), new Range(-31392209), new Range(-30343601), new Range(-28246417), new Range(-26149122), new Specials(), new Range(-16711697)};
    private static final Node[] categoryNodes = new Node[]{new Category(1), new Category(2), new Category(4), new Category(8), new Category(16), new Category(32), new Category(64), new Category(128), new Category(256), new Category(512), new Category(1024), new Category(2048), new Category(4096), new Category(8192), new Category(16384), new Category(32768), new Category(65536), new Category(262144), new Category(524288), new Category(0x100000), new Category(0x200000), new Category(0x400000), new Category(0x800000), new Category(0x1000000), new Category(0x2000000), new Category(0x4000000), new Category(0x8000000), new Category(0x10000000), new Category(62), new Category(448), new Category(3584), new Category(28672), new Category(884736), new Category(0x1F00000), new Category(0x1E000000), new Category(574), new Range(255), new All(), new Range(127), new Ctype(1792), new Ctype(768), new Ctype(16384), new Ctype(8192), new Range(0x300039), new Ctype(5888), new Range(6357114), new Range(2097278), new Ctype(4096), new Ctype(2048), new Range(4259930), new Ctype(32768)};

    public static Pattern compile(String string) {
        return new Pattern(string, 0);
    }

    public static Pattern compile(String string, int n) {
        return new Pattern(string, n);
    }

    public String pattern() {
        return this.pattern;
    }

    public Matcher matcher(CharSequence charSequence) {
        Matcher matcher = new Matcher(this, charSequence);
        return matcher;
    }

    public int flags() {
        return this.flags;
    }

    public static boolean matches(String string, CharSequence charSequence) {
        Pattern pattern = Pattern.compile(string);
        Matcher matcher = pattern.matcher(charSequence);
        return matcher.matches();
    }

    public String[] split(CharSequence charSequence, int n) {
        int n2;
        int n3 = 0;
        boolean bl = n > 0;
        ArrayList arrayList = new ArrayList();
        Matcher matcher = this.matcher(charSequence);
        while (matcher.find()) {
            String string;
            if (!bl || arrayList.size() < n - 1) {
                string = ((Object)charSequence.subSequence(n3, matcher.start())).toString();
                arrayList.add(string);
                n3 = matcher.end();
                continue;
            }
            if (arrayList.size() != n - 1) continue;
            string = ((Object)charSequence.subSequence(n3, charSequence.length())).toString();
            arrayList.add(string);
            n3 = matcher.end();
        }
        if (n3 == 0) {
            return new String[]{((Object)charSequence).toString()};
        }
        if (!bl || arrayList.size() < n) {
            arrayList.add(((Object)charSequence.subSequence(n3, charSequence.length())).toString());
        }
        if (n == 0) {
            for (n2 = arrayList.size(); n2 > 0 && arrayList.get(n2 - 1).equals(""); --n2) {
            }
        }
        Object[] objectArray = new String[n2];
        return (String[])arrayList.subList(0, n2).toArray(objectArray);
    }

    public String[] split(CharSequence charSequence) {
        return this.split(charSequence, 0);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.groupCount = 1;
        this.localCount = 0;
        if (this.pattern.length() > 0) {
            this.compile();
        } else {
            this.root = new Start(lastAccept);
        }
    }

    private Pattern(String string, int n) {
        this.pattern = string;
        this.flags = n;
        this.groupCount = 1;
        this.localCount = 0;
        if (this.pattern.length() > 0) {
            this.compile();
        } else {
            this.root = new Start(lastAccept);
            this.matchRoot = lastAccept;
        }
    }

    private void normalize() {
        boolean bl = false;
        char c = '\uffff';
        this.normalizedPattern = Normalizer.decompose(this.pattern, false, 0);
        this.patternLength = this.normalizedPattern.length();
        StringBuffer stringBuffer = new StringBuffer(this.patternLength);
        for (int i = 0; i < this.patternLength; ++i) {
            char c2 = this.normalizedPattern.charAt(i);
            if (Character.getType(c2) == 6 && c != '\uffff') {
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append(c);
                stringBuffer2.append(c2);
                while (Character.getType(c2) == 6 && ++i < this.patternLength) {
                    c2 = this.normalizedPattern.charAt(i);
                    stringBuffer2.append(c2);
                }
                String string = this.produceEquivalentAlternation(stringBuffer2.toString());
                stringBuffer.setLength(stringBuffer.length() - 1);
                stringBuffer.append("(?:").append(string).append(")");
            } else if (c2 == '[' && c != '\\') {
                i = this.normalizeCharClass(stringBuffer, i);
            } else {
                stringBuffer.append(c2);
            }
            c = c2;
        }
        this.normalizedPattern = stringBuffer.toString();
    }

    private int normalizeCharClass(StringBuffer stringBuffer, int n) {
        char c;
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = null;
        char c2 = '\uffff';
        ++n;
        stringBuffer2.append("[");
        while (true) {
            if ((c = this.normalizedPattern.charAt(n)) == ']' && c2 != '\\') break;
            if (Character.getType(c) == 6) {
                StringBuffer stringBuffer4 = new StringBuffer();
                stringBuffer4.append(c2);
                while (Character.getType(c) == 6) {
                    stringBuffer4.append(c);
                    if (++n >= this.normalizedPattern.length()) break;
                    c = this.normalizedPattern.charAt(n);
                }
                String string = this.produceEquivalentAlternation(stringBuffer4.toString());
                stringBuffer2.setLength(stringBuffer2.length() - 1);
                if (stringBuffer3 == null) {
                    stringBuffer3 = new StringBuffer();
                }
                stringBuffer3.append('|');
                stringBuffer3.append(string);
            } else {
                stringBuffer2.append(c);
                ++n;
            }
            if (n == this.normalizedPattern.length()) {
                this.error("Unclosed character class");
            }
            c2 = c;
        }
        stringBuffer2.append(c);
        String string = stringBuffer3 != null ? new String("(?:" + stringBuffer2.toString() + stringBuffer3.toString() + ")") : stringBuffer2.toString();
        stringBuffer.append(string);
        return n;
    }

    private String produceEquivalentAlternation(String string) {
        if (string.length() == 1) {
            return new String(string);
        }
        String string2 = string.substring(0, 1);
        String string3 = string.substring(1);
        String[] stringArray = this.producePermutations(string3);
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < stringArray.length; ++i) {
            String string4 = string2 + stringArray[i];
            if (i > 0) {
                stringBuffer.append("|" + string4);
            }
            if ((string4 = this.composeOneStep(string4)) == null) continue;
            stringBuffer.append("|" + this.produceEquivalentAlternation(string4));
        }
        return stringBuffer.toString();
    }

    private String[] producePermutations(String string) {
        int n;
        int n2;
        if (string.length() == 1) {
            return new String[]{string};
        }
        if (string.length() == 2) {
            if (this.getClass(string.charAt(1)) == this.getClass(string.charAt(0))) {
                return new String[]{string};
            }
            String[] stringArray = new String[2];
            stringArray[0] = string;
            StringBuffer stringBuffer = new StringBuffer(2);
            stringBuffer.append(string.charAt(1));
            stringBuffer.append(string.charAt(0));
            stringArray[1] = stringBuffer.toString();
            return stringArray;
        }
        int n3 = 1;
        for (int i = 1; i < string.length(); ++i) {
            n3 *= i + 1;
        }
        String[] stringArray = new String[n3];
        int[] nArray = new int[string.length()];
        for (n2 = 0; n2 < string.length(); ++n2) {
            nArray[n2] = this.getClass(string.charAt(n2));
        }
        n2 = 0;
        block2: for (int i = 0; i < string.length(); ++i) {
            n = 0;
            for (int j = i - 1; j >= 0; --j) {
                if (nArray[j] == nArray[i]) continue block2;
            }
            StringBuffer stringBuffer = new StringBuffer(string);
            String string2 = stringBuffer.delete(i, i + 1).toString();
            String[] stringArray2 = this.producePermutations(string2);
            String string3 = string.substring(i, i + 1);
            for (int j = 0; j < stringArray2.length; ++j) {
                stringArray[n2++] = string3 + stringArray2[j];
            }
        }
        String[] stringArray3 = new String[n2];
        for (n = 0; n < n2; ++n) {
            stringArray3[n] = stringArray[n];
        }
        return stringArray3;
    }

    private int getClass(char c) {
        return Normalizer.getClass(c);
    }

    private String composeOneStep(String string) {
        String string2 = string.substring(0, 2);
        String string3 = Normalizer.compose(string2, false, 0);
        if (string3.equals(string2)) {
            return null;
        }
        String string4 = string.substring(2);
        return string3 + string4;
    }

    private void compile() {
        if (this.has(128)) {
            this.normalize();
        } else {
            this.normalizedPattern = this.pattern;
        }
        this.patternLength = this.normalizedPattern.length();
        this.temp = new char[this.patternLength + 2];
        this.normalizedPattern.getChars(0, this.patternLength, this.temp, 0);
        this.temp[this.patternLength] = '\u0000';
        this.temp[this.patternLength + 1] = '\u0000';
        this.buffer = new char[32];
        this.groupNodes = new GroupHead[10];
        this.matchRoot = this.expr(lastAccept);
        if (this.patternLength != this.cursor) {
            if (this.peek() == 41) {
                this.error("Unmatched closing ')'");
            } else {
                this.error("Unexpected internal error");
            }
        }
        if (this.matchRoot instanceof Slice) {
            this.root = BnM.optimize(this.matchRoot);
            if (this.root == this.matchRoot) {
                this.root = new Start(this.matchRoot);
            }
        } else {
            this.root = this.matchRoot instanceof Begin || this.matchRoot instanceof First ? this.matchRoot : new Start(this.matchRoot);
        }
        this.temp = null;
        this.buffer = null;
        this.groupNodes = null;
        this.patternLength = 0;
    }

    private static void printObjectTree(Node node) {
        while (node != null) {
            if (node instanceof Prolog) {
                System.out.println(node);
                Pattern.printObjectTree(((Prolog)node).loop);
                System.out.println("**** end contents prolog loop");
            } else if (node instanceof Loop) {
                System.out.println(node);
                Pattern.printObjectTree(((Loop)node).body);
                System.out.println("**** end contents Loop body");
            } else if (node instanceof Curly) {
                System.out.println(node);
                Pattern.printObjectTree(((Curly)node).atom);
                System.out.println("**** end contents Curly body");
            } else {
                if (node instanceof GroupTail) {
                    System.out.println(node);
                    System.out.println("Tail next is " + node.next);
                    return;
                }
                System.out.println(node);
            }
            node = node.next;
            if (node != null) {
                System.out.println("->next:");
            }
            if (node != accept) continue;
            System.out.println("Accept Node");
            node = null;
        }
    }

    private boolean has(int n) {
        return (this.flags & n) > 0;
    }

    private void accept(int n, String string) {
        int n2 = this.temp[this.cursor++];
        if (this.has(4)) {
            n2 = this.parsePastWhitespace(n2);
        }
        if (n != n2) {
            this.error(string);
        }
    }

    private void mark(char c) {
        this.temp[this.patternLength] = c;
    }

    private int peek() {
        int n = this.temp[this.cursor];
        if (this.has(4)) {
            n = this.peekPastWhitespace(n);
        }
        return n;
    }

    private int read() {
        int n = this.temp[this.cursor++];
        if (this.has(4)) {
            n = this.parsePastWhitespace(n);
        }
        return n;
    }

    private int readEscaped() {
        char c = this.temp[this.cursor++];
        return c;
    }

    private int next() {
        int n = this.temp[++this.cursor];
        if (this.has(4)) {
            n = this.peekPastWhitespace(n);
        }
        return n;
    }

    private int nextEscaped() {
        char c = this.temp[++this.cursor];
        return c;
    }

    private int peekPastWhitespace(int n) {
        while (ASCII.isSpace(n) || n == 35) {
            while (ASCII.isSpace(n)) {
                n = this.temp[++this.cursor];
            }
            if (n != 35) continue;
            n = this.peekPastLine();
        }
        return n;
    }

    private int parsePastWhitespace(int n) {
        while (ASCII.isSpace(n) || n == 35) {
            while (ASCII.isSpace(n)) {
                n = this.temp[this.cursor++];
            }
            if (n != 35) continue;
            n = this.parsePastLine();
        }
        return n;
    }

    private int parsePastLine() {
        char c = this.temp[this.cursor++];
        while (c != '\u0000' && !this.isLineSeparator(c)) {
            c = this.temp[this.cursor++];
        }
        return c;
    }

    private int peekPastLine() {
        char c = this.temp[++this.cursor];
        while (c != '\u0000' && !this.isLineSeparator(c)) {
            c = this.temp[++this.cursor];
        }
        return c;
    }

    private boolean isLineSeparator(int n) {
        if (this.has(1)) {
            return n == 10;
        }
        return n == 10 || n == 13 || (n | 1) == 8233 || n == 133;
    }

    private int skip() {
        int n = this.cursor;
        char c = this.temp[n + 1];
        this.cursor = n + 2;
        return c;
    }

    private void unread() {
        --this.cursor;
    }

    private Node error(String string) {
        throw new PatternSyntaxException(string, this.normalizedPattern, this.cursor - 1);
    }

    private Node expr(Node node) {
        Node node2 = null;
        while (true) {
            Node node3 = this.sequence(node);
            node2 = node2 == null ? node3 : new Branch(node2, node3);
            if (this.peek() != 124) {
                return node2;
            }
            this.next();
        }
    }

    private Node sequence(Node node) {
        Node node2 = null;
        Node node3 = null;
        Node node4 = null;
        block12: while (true) {
            int n = this.peek();
            switch (n) {
                case 40: {
                    node4 = this.group0();
                    if (node4 == null) continue block12;
                    if (node2 == null) {
                        node2 = node4;
                    } else {
                        node3.next = node4;
                    }
                    node3 = this.root;
                    continue block12;
                }
                case 91: {
                    node4 = this.clazz(true);
                    break;
                }
                case 92: {
                    n = this.nextEscaped();
                    if (n == 112 || n == 80) {
                        boolean bl = n == 80;
                        boolean bl2 = true;
                        n = this.next();
                        if (n != 123) {
                            this.unread();
                        } else {
                            bl2 = false;
                        }
                        node4 = this.family(bl, bl2);
                        break;
                    }
                    this.unread();
                    node4 = this.atom();
                    break;
                }
                case 94: {
                    this.next();
                    if (this.has(8)) {
                        if (this.has(1)) {
                            node4 = new UnixCaret();
                            break;
                        }
                        node4 = new Caret();
                        break;
                    }
                    node4 = new Begin();
                    break;
                }
                case 36: {
                    this.next();
                    if (this.has(1)) {
                        node4 = new UnixDollar(this.has(8));
                        break;
                    }
                    node4 = new Dollar(this.has(8));
                    break;
                }
                case 46: {
                    this.next();
                    if (this.has(32)) {
                        node4 = new All();
                        break;
                    }
                    if (this.has(1)) {
                        node4 = new UnixDot();
                        break;
                    }
                    node4 = new Dot();
                    break;
                }
                case 41: 
                case 124: {
                    break block12;
                }
                case 93: 
                case 125: {
                    node4 = this.atom();
                    break;
                }
                case 42: 
                case 43: 
                case 63: {
                    this.next();
                    return this.error("Dangling meta character '" + (char)n + "'");
                }
                case 0: {
                    if (this.cursor >= this.patternLength) break block12;
                }
                default: {
                    node4 = this.atom();
                }
            }
            node4 = this.closure(node4);
            if (node2 == null) {
                node2 = node3 = node4;
                continue;
            }
            node3.next = node4;
            node3 = node4;
        }
        if (node2 == null) {
            return node;
        }
        node3.next = node;
        return node2;
    }

    private Node atom() {
        int n = 0;
        int n2 = -1;
        int n3 = this.peek();
        block6: while (true) {
            switch (n3) {
                case 42: 
                case 43: 
                case 63: 
                case 123: {
                    if (n <= true) break block6;
                    this.cursor = n2;
                    --n;
                    break block6;
                }
                case 36: 
                case 40: 
                case 41: 
                case 46: 
                case 91: 
                case 94: 
                case 124: {
                    break block6;
                }
                case 92: {
                    n3 = this.nextEscaped();
                    if (n3 == 112 || n3 == 80) {
                        if (n > 0) {
                            this.unread();
                            break block6;
                        }
                        if (n3 != 112 && n3 != 80) break block6;
                        boolean bl = n3 == 80;
                        boolean bl2 = true;
                        n3 = this.next();
                        if (n3 != 123) {
                            this.unread();
                        } else {
                            bl2 = false;
                        }
                        return this.family(bl, bl2);
                    }
                    this.unread();
                    n2 = this.cursor;
                    n3 = this.escape(false, n == 0);
                    if (n3 >= 0) {
                        this.append(n3, n);
                        ++n;
                        n3 = this.peek();
                        continue block6;
                    }
                    if (n == 0) {
                        return this.root;
                    }
                    this.cursor = n2;
                    break block6;
                }
                case 0: {
                    if (this.cursor >= this.patternLength) break block6;
                }
                default: {
                    n2 = this.cursor;
                    this.append(n3, n);
                    ++n;
                    n3 = this.next();
                    continue block6;
                }
            }
            break;
        }
        if (n == 1) {
            return this.newSingle(this.buffer[0]);
        }
        return this.newSlice(this.buffer, n);
    }

    private void append(int n, int n2) {
        if (n2 >= this.buffer.length) {
            char[] cArray = new char[n2 + n2];
            System.arraycopy(this.buffer, 0, cArray, 0, n2);
            this.buffer = cArray;
        }
        this.buffer[n2] = (char)n;
    }

    private Node ref(int n) {
        boolean bl = false;
        block3: while (!bl) {
            int n2 = this.peek();
            switch (n2) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    int n3 = n * 10 + (n2 - 48);
                    if (this.groupCount - 1 < n3) {
                        bl = true;
                        continue block3;
                    }
                    n = n3;
                    this.read();
                    continue block3;
                }
            }
            bl = true;
        }
        if (this.has(2)) {
            return new CIBackRef(n);
        }
        return new BackRef(n);
    }

    private int escape(boolean bl, boolean bl2) {
        int n = this.skip();
        switch (n) {
            case 48: {
                return this.o();
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                if (bl) break;
                if (this.groupCount < n - 48) {
                    this.error("No such group yet exists at this point in the pattern");
                }
                if (bl2) {
                    this.root = this.ref(n - 48);
                }
                return -1;
            }
            case 65: {
                if (bl) break;
                if (bl2) {
                    this.root = new Begin();
                }
                return -1;
            }
            case 66: {
                if (bl) break;
                if (bl2) {
                    this.root = new Bound(Bound.NONE);
                }
                return -1;
            }
            case 67: {
                break;
            }
            case 68: {
                if (bl2) {
                    this.root = new NotCtype(1024);
                }
                return -1;
            }
            case 69: 
            case 70: {
                break;
            }
            case 71: {
                if (bl) break;
                if (bl2) {
                    this.root = new LastMatch();
                }
                return -1;
            }
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: {
                break;
            }
            case 81: {
                if (bl2) {
                    int n2;
                    int n3 = this.cursor;
                    while ((n2 = this.readEscaped()) != 0 && (n2 != 92 || (n2 = this.readEscaped()) != 69 && n2 != 0)) {
                    }
                    int n4 = this.cursor - 1;
                    if (n2 == 69) {
                        --n4;
                    } else {
                        this.unread();
                    }
                    for (int i = n3; i < n4; ++i) {
                        this.append(this.temp[i], i - n3);
                    }
                    this.root = this.newSlice(this.buffer, n4 - n3);
                }
                return -1;
            }
            case 82: {
                break;
            }
            case 83: {
                if (bl2) {
                    this.root = new NotCtype(2048);
                }
                return -1;
            }
            case 84: 
            case 85: 
            case 86: {
                break;
            }
            case 87: {
                if (bl2) {
                    this.root = new NotCtype(67328);
                }
                return -1;
            }
            case 88: 
            case 89: {
                break;
            }
            case 90: {
                if (bl) break;
                if (bl2) {
                    this.root = this.has(1) ? new UnixDollar(false) : new Dollar(false);
                }
                return -1;
            }
            case 97: {
                return 7;
            }
            case 98: {
                if (bl) break;
                if (bl2) {
                    this.root = new Bound(Bound.BOTH);
                }
                return -1;
            }
            case 99: {
                return this.c();
            }
            case 100: {
                if (bl2) {
                    this.root = new Ctype(1024);
                }
                return -1;
            }
            case 101: {
                return 27;
            }
            case 102: {
                return 12;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: {
                break;
            }
            case 110: {
                return 10;
            }
            case 111: 
            case 112: 
            case 113: {
                break;
            }
            case 114: {
                return 13;
            }
            case 115: {
                if (bl2) {
                    this.root = new Ctype(2048);
                }
                return -1;
            }
            case 116: {
                return 9;
            }
            case 117: {
                return this.u();
            }
            case 118: {
                return 11;
            }
            case 119: {
                if (bl2) {
                    this.root = new Ctype(67328);
                }
                return -1;
            }
            case 120: {
                return this.x();
            }
            case 121: {
                break;
            }
            case 122: {
                if (bl) break;
                if (bl2) {
                    this.root = new End();
                }
                return -1;
            }
            default: {
                return n;
            }
        }
        this.error("Illegal/unsupported escape squence");
        return -2;
    }

    private Node clazz(boolean bl) {
        Node node = null;
        Node node2 = null;
        BitClass bitClass = new BitClass(false);
        boolean bl2 = true;
        boolean bl3 = true;
        int n = this.next();
        block7: while (true) {
            switch (n) {
                case 94: {
                    if (!bl3 || this.temp[this.cursor - 1] != '[') break;
                    n = this.next();
                    bl2 = !bl2;
                    continue block7;
                }
                case 91: {
                    bl3 = false;
                    node2 = this.clazz(true);
                    node = node == null ? node2 : new Add(node, node2);
                    n = this.peek();
                    continue block7;
                }
                case 38: {
                    bl3 = false;
                    n = this.next();
                    if (n == 38) {
                        n = this.next();
                        Node node3 = null;
                        while (n != 93 && n != 38) {
                            if (n == 91) {
                                node3 = node3 == null ? this.clazz(true) : new Add(node3, this.clazz(true));
                            } else {
                                this.unread();
                                node3 = this.clazz(false);
                            }
                            n = this.peek();
                        }
                        if (node3 != null) {
                            node2 = node3;
                        }
                        if (node == null) {
                            if (node3 == null) {
                                return this.error("Bad class syntax");
                            }
                            node = node3;
                            continue block7;
                        }
                        node = new Both(node, node2);
                        continue block7;
                    }
                    this.unread();
                    break;
                }
                case 0: {
                    bl3 = false;
                    if (this.cursor < this.patternLength) break;
                    return this.error("Unclosed character class");
                }
                case 93: {
                    bl3 = false;
                    if (node == null) break;
                    if (bl) {
                        this.next();
                    }
                    return node;
                }
                default: {
                    bl3 = false;
                }
            }
            node2 = this.range(bitClass);
            if (bl2) {
                if (node == null) {
                    node = node2;
                } else if (node != node2) {
                    node = new Add(node, node2);
                }
            } else if (node == null) {
                node = node2.dup(true);
            } else if (node != node2) {
                node = new Sub(node, node2);
            }
            n = this.peek();
        }
    }

    private Node range(BitClass bitClass) {
        int n = this.peek();
        if (n == 92) {
            n = this.nextEscaped();
            if (n == 112 || n == 80) {
                boolean bl = n == 80;
                boolean bl2 = true;
                n = this.next();
                if (n != 123) {
                    this.unread();
                } else {
                    bl2 = false;
                }
                return this.family(bl, bl2);
            }
            this.unread();
            n = this.escape(true, true);
            if (n == -1) {
                return this.root;
            }
        } else {
            n = this.single();
        }
        if (n >= 0) {
            if (this.peek() == 45) {
                char c = this.temp[this.cursor + 1];
                if (c == '[') {
                    if (n < 256) {
                        return bitClass.add(n, this.flags());
                    }
                    return this.newSingle(n);
                }
                if (c != ']') {
                    this.next();
                    int n2 = this.single();
                    if (n2 < n) {
                        return this.error("Illegal character range");
                    }
                    if (this.has(2)) {
                        return new CIRange((n << 16) + n2);
                    }
                    return new Range((n << 16) + n2);
                }
            }
            if (n < 256) {
                return bitClass.add(n, this.flags());
            }
            return this.newSingle(n);
        }
        return this.error("Unexpected character '" + (char)n + "'");
    }

    private int single() {
        int n = this.peek();
        switch (n) {
            case 92: {
                return this.escape(true, false);
            }
        }
        this.next();
        return n;
    }

    private Node family(boolean bl, boolean bl2) {
        String string;
        this.next();
        if (bl2) {
            string = new String(this.temp, this.cursor, 1).intern();
            this.read();
        } else {
            int n = this.cursor;
            this.mark('}');
            while (this.read() != 125) {
            }
            this.mark('\u0000');
            int n2 = this.cursor;
            if (n2 > this.patternLength) {
                return this.error("Unclosed character family");
            }
            if (n + 1 >= n2) {
                return this.error("Empty character family");
            }
            string = new String(this.temp, n, n2 - n - 1).intern();
        }
        if (string.startsWith("In")) {
            string = string.substring(2, string.length()).intern();
            return this.retrieveFamilyNode(string).dup(bl);
        }
        if (string.startsWith("Is")) {
            string = string.substring(2, string.length()).intern();
        }
        return this.retrieveCategoryNode(string).dup(bl);
    }

    private Node retrieveFamilyNode(String string) {
        Node node;
        if (families == null) {
            int n = familyNodes.length;
            families = new HashMap((int)((double)n / 0.75) + 1);
            for (int i = 0; i < n; ++i) {
                families.put(familyNames[i], familyNodes[i]);
            }
        }
        if ((node = (Node)families.get(string)) != null) {
            return node;
        }
        return this.familyError(string, "Unknown character family {");
    }

    private Node retrieveCategoryNode(String string) {
        Node node;
        if (categories == null) {
            int n = categoryNodes.length;
            categories = new HashMap((int)((double)n / 0.75) + 1);
            for (int i = 0; i < n; ++i) {
                categories.put(categoryNames[i], categoryNodes[i]);
            }
        }
        if ((node = (Node)categories.get(string)) != null) {
            return node;
        }
        return this.familyError(string, "Unknown character category {");
    }

    private Node familyError(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        stringBuffer.append(string);
        stringBuffer.append("}");
        string = stringBuffer.toString();
        return this.error(string);
    }

    private Node group0() {
        Object object;
        Node node = null;
        Node node2 = null;
        int n = this.flags;
        this.root = null;
        int n2 = this.next();
        if (n2 == 63) {
            n2 = this.skip();
            switch (n2) {
                case 58: {
                    node = this.createGroup(true);
                    node2 = this.root;
                    node.next = this.expr(node2);
                    break;
                }
                case 33: 
                case 61: {
                    node = this.createGroup(true);
                    node2 = this.root;
                    node.next = this.expr(node2);
                    if (n2 == 61) {
                        node = node2 = new Pos(node);
                        break;
                    }
                    node = node2 = new Neg(node);
                    break;
                }
                case 62: {
                    node = this.createGroup(true);
                    node2 = this.root;
                    node.next = this.expr(node2);
                    node = node2 = new Ques(node, 3);
                    break;
                }
                case 60: {
                    n2 = this.read();
                    node = this.createGroup(true);
                    node2 = this.root;
                    node.next = this.expr(node2);
                    object = new TreeInfo();
                    node.study((TreeInfo)object);
                    if (!((TreeInfo)object).maxValid) {
                        return this.error("Look-behind group does not have an obvious maximum length");
                    }
                    if (n2 == 61) {
                        node = node2 = new Behind(node, ((TreeInfo)object).maxLength, ((TreeInfo)object).minLength);
                        break;
                    }
                    if (n2 == 33) {
                        node = node2 = new NotBehind(node, ((TreeInfo)object).maxLength, ((TreeInfo)object).minLength);
                        break;
                    }
                    this.error("Unknown look-behind group");
                    break;
                }
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    if (this.groupNodes[n2 - 48] != null) {
                        node = node2 = new GroupRef(this.groupNodes[n2 - 48]);
                        break;
                    }
                    return this.error("Unknown group reference");
                }
                case 36: 
                case 64: {
                    return this.error("Unknown group type");
                }
                default: {
                    this.unread();
                    this.addFlag();
                    n2 = this.read();
                    if (n2 == 41) {
                        return null;
                    }
                    if (n2 != 58) {
                        return this.error("Unknown inline modifier");
                    }
                    node = this.createGroup(true);
                    node2 = this.root;
                    node.next = this.expr(node2);
                    break;
                }
            }
        } else {
            node = this.createGroup(false);
            node2 = this.root;
            node.next = this.expr(node2);
        }
        this.accept(41, "Unclosed group");
        this.flags = n;
        object = this.closure(node);
        if (object == node) {
            this.root = node2;
            return object;
        }
        if (node == node2) {
            this.root = object;
            return object;
        }
        if (object instanceof Ques) {
            Ques ques = (Ques)object;
            if (ques.type == 2) {
                this.root = object;
                return object;
            }
            node2 = node2.next = new Dummy();
            node = ques.type == 0 ? new Branch(node, node2) : new Branch(node2, node);
            this.root = node2;
            return node;
        }
        if (object instanceof Curly) {
            Curly curly = (Curly)object;
            if (curly.type == 2) {
                this.root = object;
                return object;
            }
            TreeInfo treeInfo = new TreeInfo();
            if (node.study(treeInfo)) {
                GroupTail groupTail = (GroupTail)node2;
                node = this.root = new GroupCurly(node.next, curly.cmin, curly.cmax, curly.type, ((GroupTail)node2).localIndex, ((GroupTail)node2).groupIndex);
                return node;
            }
            int n3 = ((GroupHead)node).localIndex;
            Loop loop = curly.type == 0 ? new Loop(this.localCount, n3) : new LazyLoop(this.localCount, n3);
            Prolog prolog = new Prolog(loop);
            ++this.localCount;
            loop.cmin = curly.cmin;
            loop.cmax = curly.cmax;
            loop.body = node;
            node2.next = loop;
            this.root = loop;
            return prolog;
        }
        if (object instanceof First) {
            this.root = object;
            return object;
        }
        return this.error("Internal logic error");
    }

    private Node createGroup(boolean bl) {
        int n = this.localCount++;
        int n2 = 0;
        if (!bl) {
            n2 = this.groupCount++;
        }
        GroupHead groupHead = new GroupHead(n);
        this.root = new GroupTail(n, n2);
        if (!bl && n2 < 10) {
            this.groupNodes[n2] = groupHead;
        }
        return groupHead;
    }

    private void addFlag() {
        int n = this.peek();
        while (true) {
            switch (n) {
                case 105: {
                    this.flags |= 2;
                    break;
                }
                case 109: {
                    this.flags |= 8;
                    break;
                }
                case 115: {
                    this.flags |= 0x20;
                    break;
                }
                case 100: {
                    this.flags |= 1;
                    break;
                }
                case 117: {
                    this.flags |= 0x40;
                    break;
                }
                case 99: {
                    this.flags |= 0x80;
                    break;
                }
                case 120: {
                    this.flags |= 4;
                    break;
                }
                case 45: {
                    n = this.next();
                    this.subFlag();
                }
                default: {
                    return;
                }
            }
            n = this.next();
        }
    }

    private void subFlag() {
        int n = this.peek();
        while (true) {
            switch (n) {
                case 105: {
                    this.flags &= 0xFFFFFFFD;
                    break;
                }
                case 109: {
                    this.flags &= 0xFFFFFFF7;
                    break;
                }
                case 115: {
                    this.flags &= 0xFFFFFFDF;
                    break;
                }
                case 100: {
                    this.flags &= 0xFFFFFFFE;
                    break;
                }
                case 117: {
                    this.flags &= 0xFFFFFFBF;
                    break;
                }
                case 99: {
                    this.flags &= 0xFFFFFF7F;
                    break;
                }
                case 120: {
                    this.flags &= 0xFFFFFFFB;
                    break;
                }
                default: {
                    return;
                }
            }
            n = this.next();
        }
    }

    private Node closure(Node node) {
        int n = this.peek();
        switch (n) {
            case 63: {
                n = this.next();
                if (n == 63) {
                    this.next();
                    return new Ques(node, 1);
                }
                if (n == 43) {
                    this.next();
                    return new Ques(node, 2);
                }
                return new Ques(node, 0);
            }
            case 42: {
                n = this.next();
                if (n == 63) {
                    this.next();
                    return new Curly(node, 0, Integer.MAX_VALUE, 1);
                }
                if (n == 43) {
                    this.next();
                    return new Curly(node, 0, Integer.MAX_VALUE, 2);
                }
                return new Curly(node, 0, Integer.MAX_VALUE, 0);
            }
            case 43: {
                n = this.next();
                if (n == 63) {
                    this.next();
                    return new Curly(node, 1, Integer.MAX_VALUE, 1);
                }
                if (n == 43) {
                    this.next();
                    return new Curly(node, 1, Integer.MAX_VALUE, 2);
                }
                return new Curly(node, 1, Integer.MAX_VALUE, 0);
            }
            case 123: {
                n = this.temp[this.cursor + 1];
                if (ASCII.isDigit(n)) {
                    Curly curly;
                    this.skip();
                    int n2 = 0;
                    do {
                        n2 = n2 * 10 + (n - 48);
                    } while (ASCII.isDigit(n = this.read()));
                    int n3 = n2;
                    if (n == 44) {
                        n = this.read();
                        n3 = Integer.MAX_VALUE;
                        if (n != 125) {
                            n3 = 0;
                            while (ASCII.isDigit(n)) {
                                n3 = n3 * 10 + (n - 48);
                                n = this.read();
                            }
                        }
                    }
                    if (n != 125) {
                        return this.error("Unclosed counted closure");
                    }
                    if ((n2 | n3 | n3 - n2) < 0) {
                        return this.error("Illegal repetition range");
                    }
                    n = this.peek();
                    if (n == 63) {
                        this.next();
                        curly = new Curly(node, n2, n3, 1);
                    } else if (n == 43) {
                        this.next();
                        curly = new Curly(node, n2, n3, 2);
                    } else {
                        curly = new Curly(node, n2, n3, 0);
                    }
                    return curly;
                }
                this.error("Illegal repetition");
                return node;
            }
        }
        return node;
    }

    private int c() {
        if (this.cursor < this.patternLength) {
            return this.read() ^ 0x40;
        }
        this.error("Illegal control escape sequence");
        return -1;
    }

    private int o() {
        int n = this.read();
        if ((n - 48 | 55 - n) >= 0) {
            int n2 = this.read();
            if ((n2 - 48 | 55 - n2) >= 0) {
                int n3 = this.read();
                if ((n3 - 48 | 55 - n3) >= 0 && (n - 48 | 51 - n) >= 0) {
                    return (n - 48) * 64 + (n2 - 48) * 8 + (n3 - 48);
                }
                this.unread();
                return (n - 48) * 8 + (n2 - 48);
            }
            this.unread();
            return n - 48;
        }
        this.error("Illegal octal escape sequence");
        return -1;
    }

    private int x() {
        int n;
        int n2 = this.read();
        if (ASCII.isHexDigit(n2) && ASCII.isHexDigit(n = this.read())) {
            return ASCII.toDigit(n2) * 16 + ASCII.toDigit(n);
        }
        this.error("Illegal hexadecimal escape sequence");
        return -1;
    }

    private int u() {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            int n2 = this.read();
            if (!ASCII.isHexDigit(n2)) {
                this.error("Illegal Unicode escape sequence");
            }
            n = n * 16 + ASCII.toDigit(n2);
        }
        return n;
    }

    private Node newSingle(int n) {
        int n2 = this.flags;
        if ((n2 & 2) == 0) {
            return new Single(n);
        }
        if ((n2 & 0x40) == 0) {
            return new SingleA(n);
        }
        return new SingleU(n);
    }

    private Node newSlice(char[] cArray, int n) {
        char[] cArray2 = new char[n];
        int n2 = this.flags;
        if ((n2 & 2) == 0) {
            for (n2 = 0; n2 < n; ++n2) {
                cArray2[n2] = cArray[n2];
            }
            return new Slice(cArray2);
        }
        if ((n2 & 0x40) == 0) {
            for (n2 = 0; n2 < n; ++n2) {
                cArray2[n2] = (char)ASCII.toLower(cArray[n2]);
            }
            return new SliceA(cArray2);
        }
        for (n2 = 0; n2 < n; ++n2) {
            char c = cArray[n2];
            c = Character.toUpperCase(c);
            cArray2[n2] = c = Character.toLowerCase(c);
        }
        return new SliceU(cArray2);
    }

    static final class BnM
    extends Node {
        char[] buffer;
        int[] lastOcc;
        int[] optoSft;

        static Node optimize(Node node) {
            int n;
            if (!(node instanceof Slice)) {
                return node;
            }
            char[] cArray = ((Slice)node).buffer;
            int n2 = cArray.length;
            if (n2 < 4) {
                return node;
            }
            int[] nArray = new int[128];
            int[] nArray2 = new int[n2];
            for (n = 0; n < n2; ++n) {
                nArray[cArray[n] & 0x7F] = n + 1;
            }
            block1: for (n = n2; n > 0; --n) {
                int n3;
                for (n3 = n2 - 1; n3 >= n; --n3) {
                    if (cArray[n3] != cArray[n3 - n]) continue block1;
                    nArray2[n3 - 1] = n;
                }
                while (n3 > 0) {
                    nArray2[--n3] = n;
                }
            }
            nArray2[n2 - 1] = 1;
            return new BnM(cArray, nArray, nArray2, node.next);
        }

        BnM(char[] cArray, int[] nArray, int[] nArray2, Node node) {
            this.buffer = cArray;
            this.lastOcc = nArray;
            this.optoSft = nArray2;
            this.next = node;
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            char[] cArray = this.buffer;
            int n2 = cArray.length;
            int n3 = matcher.to - n2;
            block0: while (n <= n3) {
                int n4;
                for (n4 = n2 - 1; n4 >= 0; --n4) {
                    char c = charSequence.charAt(n + n4);
                    if (c == cArray[n4]) continue;
                    n += Math.max(n4 + 1 - this.lastOcc[c & 0x7F], this.optoSft[n4]);
                    continue block0;
                }
                matcher.first = n;
                n4 = this.next.match(matcher, n + n2, charSequence) ? 1 : 0;
                if (n4 != 0) {
                    matcher.groups[0] = matcher.first = n;
                    matcher.groups[1] = matcher.last;
                    return true;
                }
                ++n;
            }
            return false;
        }

        boolean study(TreeInfo treeInfo) {
            treeInfo.minLength += this.buffer.length;
            treeInfo.maxValid = false;
            return this.next.study(treeInfo);
        }
    }

    static final class Bound
    extends Node {
        static int LEFT = 1;
        static int RIGHT = 2;
        static int BOTH = 3;
        static int NONE = 4;
        int type;

        Bound(int n) {
            this.type = n;
        }

        int check(Matcher matcher, int n, CharSequence charSequence) {
            char c;
            boolean bl = false;
            if (n > matcher.from) {
                c = charSequence.charAt(n - 1);
                bl = c == '_' || Character.isLetterOrDigit(c);
            }
            boolean bl2 = false;
            if (n < matcher.to) {
                c = charSequence.charAt(n);
                boolean bl3 = bl2 = c == '_' || Character.isLetterOrDigit(c);
            }
            return bl ^ bl2 ? (bl2 ? LEFT : RIGHT) : NONE;
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            return (this.check(matcher, n, charSequence) & this.type) > 0 && this.next.match(matcher, n, charSequence);
        }
    }

    static final class Sub
    extends Add {
        Sub(Node node, Node node2) {
            super(node, node2);
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            if (n < matcher.to) {
                return !this.rhs.match(matcher, n, charSequence) && this.lhs.match(matcher, n, charSequence) && this.next.match(matcher, matcher.last, charSequence);
            }
            return false;
        }

        boolean study(TreeInfo treeInfo) {
            this.lhs.study(treeInfo);
            return this.next.study(treeInfo);
        }
    }

    static class Both
    extends Node {
        Node lhs;
        Node rhs;

        Both(Node node, Node node2) {
            this.lhs = node;
            this.rhs = node2;
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            if (n < matcher.to) {
                return this.lhs.match(matcher, n, charSequence) && this.rhs.match(matcher, n, charSequence) && this.next.match(matcher, matcher.last, charSequence);
            }
            return false;
        }

        boolean study(TreeInfo treeInfo) {
            boolean bl = treeInfo.maxValid;
            boolean bl2 = treeInfo.deterministic;
            int n = treeInfo.minLength;
            int n2 = treeInfo.maxLength;
            this.lhs.study(treeInfo);
            int n3 = treeInfo.minLength;
            int n4 = treeInfo.maxLength;
            treeInfo.minLength = n;
            treeInfo.maxLength = n2;
            this.rhs.study(treeInfo);
            treeInfo.minLength = Math.min(n3, treeInfo.minLength);
            treeInfo.maxLength = Math.max(n4, treeInfo.maxLength);
            treeInfo.maxValid = bl;
            treeInfo.deterministic = bl2;
            return this.next.study(treeInfo);
        }
    }

    static class Add
    extends Node {
        Node lhs;
        Node rhs;

        Add(Node node, Node node2) {
            this.lhs = node;
            this.rhs = node2;
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            if (n < matcher.to) {
                return (this.lhs.match(matcher, n, charSequence) || this.rhs.match(matcher, n, charSequence)) && this.next.match(matcher, matcher.last, charSequence);
            }
            return false;
        }

        boolean study(TreeInfo treeInfo) {
            boolean bl = treeInfo.maxValid;
            boolean bl2 = treeInfo.deterministic;
            int n = treeInfo.minLength;
            int n2 = treeInfo.maxLength;
            this.lhs.study(treeInfo);
            int n3 = treeInfo.minLength;
            int n4 = treeInfo.maxLength;
            treeInfo.minLength = n;
            treeInfo.maxLength = n2;
            this.rhs.study(treeInfo);
            treeInfo.minLength = Math.min(n3, treeInfo.minLength);
            treeInfo.maxLength = Math.max(n4, treeInfo.maxLength);
            treeInfo.maxValid = bl;
            treeInfo.deterministic = bl2;
            return this.next.study(treeInfo);
        }
    }

    static final class NotBehind
    extends Node {
        Node cond;
        int rmax;
        int rmin;

        NotBehind(Node node, int n, int n2) {
            this.cond = node;
            this.rmax = n;
            this.rmin = n2;
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int n2 = Math.max(n - this.rmax, matcher.from);
            for (int i = n - this.rmin; i >= n2; --i) {
                if (!this.cond.match(matcher, i, charSequence) || matcher.last != n) continue;
                return false;
            }
            return this.next.match(matcher, n, charSequence);
        }
    }

    static final class Behind
    extends Node {
        Node cond;
        int rmax;
        int rmin;

        Behind(Node node, int n, int n2) {
            this.cond = node;
            this.rmax = n;
            this.rmin = n2;
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int n2 = Math.max(n - this.rmax, matcher.from);
            for (int i = n - this.rmin; i >= n2; --i) {
                if (!this.cond.match(matcher, i, charSequence) || matcher.last != n) continue;
                return this.next.match(matcher, n, charSequence);
            }
            return false;
        }
    }

    static final class Neg
    extends Node {
        Node cond;

        Neg(Node node) {
            this.cond = node;
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            return !this.cond.match(matcher, n, charSequence) && this.next.match(matcher, n, charSequence);
        }
    }

    static final class Pos
    extends Node {
        Node cond;

        Pos(Node node) {
            this.cond = node;
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            return this.cond.match(matcher, n, charSequence) && this.next.match(matcher, n, charSequence);
        }
    }

    static final class Conditional
    extends Node {
        Node cond;
        Node yes;
        Node not;

        Conditional(Node node, Node node2, Node node3) {
            this.cond = node;
            this.yes = node2;
            this.not = node3;
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            if (this.cond.match(matcher, n, charSequence)) {
                return this.yes.match(matcher, n, charSequence);
            }
            return this.not.match(matcher, n, charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            int n = treeInfo.minLength;
            int n2 = treeInfo.maxLength;
            boolean bl = treeInfo.maxValid;
            treeInfo.reset();
            this.yes.study(treeInfo);
            int n3 = treeInfo.minLength;
            int n4 = treeInfo.maxLength;
            boolean bl2 = treeInfo.maxValid;
            treeInfo.reset();
            this.not.study(treeInfo);
            treeInfo.minLength = n + Math.min(n3, treeInfo.minLength);
            treeInfo.maxLength = n2 + Math.max(n4, treeInfo.maxLength);
            treeInfo.maxValid = bl & bl2 & treeInfo.maxValid;
            treeInfo.deterministic = false;
            return this.next.study(treeInfo);
        }
    }

    static final class First
    extends Node {
        Node atom;

        First(Node node) {
            this.atom = BnM.optimize(node);
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            if (this.atom instanceof BnM) {
                return this.atom.match(matcher, n, charSequence) && this.next.match(matcher, matcher.last, charSequence);
            }
            while (n <= matcher.to) {
                if (this.atom.match(matcher, n, charSequence)) {
                    return this.next.match(matcher, matcher.last, charSequence);
                }
                ++n;
                ++matcher.first;
            }
            return false;
        }

        boolean study(TreeInfo treeInfo) {
            this.atom.study(treeInfo);
            treeInfo.maxValid = false;
            treeInfo.deterministic = false;
            return this.next.study(treeInfo);
        }
    }

    static class CIBackRef
    extends Node {
        int groupIndex;

        CIBackRef(int n) {
            this.groupIndex = n + n;
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int n2 = matcher.groups[this.groupIndex];
            int n3 = matcher.groups[this.groupIndex + 1];
            int n4 = n3 - n2;
            if (n2 < 0) {
                return false;
            }
            if (n + n4 > matcher.to) {
                return false;
            }
            for (int i = 0; i < n4; ++i) {
                char c;
                char c2 = charSequence.charAt(n + i);
                if (c2 == (c = charSequence.charAt(n2 + i)) || (c2 = Character.toUpperCase(c2)) == (c = Character.toUpperCase(c)) || (c2 = Character.toLowerCase(c2)) == (c = Character.toLowerCase(c))) continue;
                return false;
            }
            return this.next.match(matcher, n + n4, charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            treeInfo.maxValid = false;
            return this.next.study(treeInfo);
        }
    }

    static class BackRef
    extends Node {
        int groupIndex;

        BackRef(int n) {
            this.groupIndex = n + n;
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int n2 = matcher.groups[this.groupIndex];
            int n3 = matcher.groups[this.groupIndex + 1];
            int n4 = n3 - n2;
            if (n2 < 0) {
                return false;
            }
            if (n + n4 > matcher.to) {
                return false;
            }
            for (int i = 0; i < n4; ++i) {
                if (charSequence.charAt(n + i) == charSequence.charAt(n2 + i)) continue;
                return false;
            }
            return this.next.match(matcher, n + n4, charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            treeInfo.maxValid = false;
            return this.next.study(treeInfo);
        }
    }

    static final class LazyLoop
    extends Loop {
        LazyLoop(int n, int n2) {
            super(n, n2);
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            if (n > matcher.locals[this.beginIndex]) {
                int n2 = matcher.locals[this.countIndex];
                if (n2 < this.cmin) {
                    matcher.locals[this.countIndex] = n2 + 1;
                    boolean bl = this.body.match(matcher, n, charSequence);
                    if (!bl) {
                        matcher.locals[this.countIndex] = n2;
                    }
                    return bl;
                }
                if (this.next.match(matcher, n, charSequence)) {
                    return true;
                }
                if (n2 < this.cmax) {
                    matcher.locals[this.countIndex] = n2 + 1;
                    boolean bl = this.body.match(matcher, n, charSequence);
                    if (!bl) {
                        matcher.locals[this.countIndex] = n2;
                    }
                    return bl;
                }
                return false;
            }
            return this.next.match(matcher, n, charSequence);
        }

        boolean matchInit(Matcher matcher, int n, CharSequence charSequence) {
            int n2 = matcher.locals[this.countIndex];
            boolean bl = false;
            if (0 < this.cmin) {
                matcher.locals[this.countIndex] = 1;
                bl = this.body.match(matcher, n, charSequence);
            } else if (this.next.match(matcher, n, charSequence)) {
                bl = true;
            } else if (0 < this.cmax) {
                matcher.locals[this.countIndex] = 1;
                bl = this.body.match(matcher, n, charSequence);
            }
            matcher.locals[this.countIndex] = n2;
            return bl;
        }

        boolean study(TreeInfo treeInfo) {
            treeInfo.maxValid = false;
            treeInfo.deterministic = false;
            return false;
        }
    }

    static class Loop
    extends Node {
        Node body;
        int countIndex;
        int beginIndex;
        int cmin;
        int cmax;

        Loop(int n, int n2) {
            this.countIndex = n;
            this.beginIndex = n2;
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            if (n > matcher.locals[this.beginIndex]) {
                int n2 = matcher.locals[this.countIndex];
                if (n2 < this.cmin) {
                    matcher.locals[this.countIndex] = n2 + 1;
                    boolean bl = this.body.match(matcher, n, charSequence);
                    if (!bl) {
                        matcher.locals[this.countIndex] = n2;
                    }
                    return bl;
                }
                if (n2 < this.cmax) {
                    matcher.locals[this.countIndex] = n2 + 1;
                    boolean bl = this.body.match(matcher, n, charSequence);
                    if (!bl) {
                        matcher.locals[this.countIndex] = n2;
                    } else {
                        return true;
                    }
                }
            }
            return this.next.match(matcher, n, charSequence);
        }

        boolean matchInit(Matcher matcher, int n, CharSequence charSequence) {
            int n2 = matcher.locals[this.countIndex];
            boolean bl = false;
            if (0 < this.cmin) {
                matcher.locals[this.countIndex] = 1;
                bl = this.body.match(matcher, n, charSequence);
            } else if (0 < this.cmax) {
                matcher.locals[this.countIndex] = 1;
                bl = this.body.match(matcher, n, charSequence);
                if (!bl) {
                    bl = this.next.match(matcher, n, charSequence);
                }
            } else {
                bl = this.next.match(matcher, n, charSequence);
            }
            matcher.locals[this.countIndex] = n2;
            return bl;
        }

        boolean study(TreeInfo treeInfo) {
            treeInfo.maxValid = false;
            treeInfo.deterministic = false;
            return false;
        }
    }

    static final class Prolog
    extends Node {
        Loop loop;

        Prolog(Loop loop) {
            this.loop = loop;
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            return this.loop.matchInit(matcher, n, charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            return this.loop.study(treeInfo);
        }
    }

    static final class GroupTail
    extends Node {
        int localIndex;
        int groupIndex;

        GroupTail(int n, int n2) {
            this.localIndex = n;
            this.groupIndex = n2 + n2;
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int n2 = matcher.locals[this.localIndex];
            if (n2 >= 0) {
                int n3 = matcher.groups[this.groupIndex];
                int n4 = matcher.groups[this.groupIndex + 1];
                matcher.groups[this.groupIndex] = n2;
                matcher.groups[this.groupIndex + 1] = n;
                if (this.next.match(matcher, n, charSequence)) {
                    return true;
                }
                matcher.groups[this.groupIndex] = n3;
                matcher.groups[this.groupIndex + 1] = n4;
                return false;
            }
            matcher.last = n;
            return true;
        }
    }

    static final class GroupRef
    extends Node {
        GroupHead head;

        GroupRef(GroupHead groupHead) {
            this.head = groupHead;
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            return this.head.matchRef(matcher, n, charSequence) && this.next.match(matcher, matcher.last, charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            treeInfo.maxValid = false;
            treeInfo.deterministic = false;
            return this.next.study(treeInfo);
        }
    }

    static final class GroupHead
    extends Node {
        int localIndex;

        GroupHead(int n) {
            this.localIndex = n;
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int n2 = matcher.locals[this.localIndex];
            matcher.locals[this.localIndex] = n;
            boolean bl = this.next.match(matcher, n, charSequence);
            matcher.locals[this.localIndex] = n2;
            return bl;
        }

        boolean matchRef(Matcher matcher, int n, CharSequence charSequence) {
            int n2 = matcher.locals[this.localIndex];
            matcher.locals[this.localIndex] = ~n;
            boolean bl = this.next.match(matcher, n, charSequence);
            matcher.locals[this.localIndex] = n2;
            return bl;
        }
    }

    static final class Branch
    extends Node {
        Node prev;

        Branch(Node node, Node node2) {
            this.prev = node;
            this.next = node2;
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            return this.prev.match(matcher, n, charSequence) || this.next.match(matcher, n, charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            int n = treeInfo.minLength;
            int n2 = treeInfo.maxLength;
            boolean bl = treeInfo.maxValid;
            treeInfo.reset();
            this.prev.study(treeInfo);
            int n3 = treeInfo.minLength;
            int n4 = treeInfo.maxLength;
            boolean bl2 = treeInfo.maxValid;
            treeInfo.reset();
            this.next.study(treeInfo);
            treeInfo.minLength = n + Math.min(n3, treeInfo.minLength);
            treeInfo.maxLength = n2 + Math.max(n4, treeInfo.maxLength);
            treeInfo.maxValid = bl & bl2 & treeInfo.maxValid;
            treeInfo.deterministic = false;
            return false;
        }
    }

    static final class GroupCurly
    extends Node {
        Node atom;
        int type;
        int cmin;
        int cmax;
        int localIndex;
        int groupIndex;

        GroupCurly(Node node, int n, int n2, int n3, int n4, int n5) {
            this.atom = node;
            this.type = n3;
            this.cmin = n;
            this.cmax = n2;
            this.localIndex = n4;
            this.groupIndex = n5;
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int[] nArray = matcher.groups;
            int[] nArray2 = matcher.locals;
            int n2 = nArray2[this.localIndex];
            int n3 = nArray[this.groupIndex];
            int n4 = nArray[this.groupIndex + 1];
            nArray2[this.localIndex] = -1;
            boolean bl = true;
            for (int i = 0; i < this.cmin; ++i) {
                if (!this.atom.match(matcher, n, charSequence)) {
                    bl = false;
                    break;
                }
                nArray[this.groupIndex] = n;
                nArray[this.groupIndex + 1] = n = matcher.last;
            }
            if (bl) {
                bl = this.type == 0 ? this.match0(matcher, n, this.cmin, charSequence) : (this.type == 1 ? this.match1(matcher, n, this.cmin, charSequence) : this.match2(matcher, n, this.cmin, charSequence));
            }
            if (!bl) {
                nArray2[this.localIndex] = n2;
                nArray[this.groupIndex] = n3;
                nArray[this.groupIndex + 1] = n4;
            }
            return bl;
        }

        boolean match0(Matcher matcher, int n, int n2, CharSequence charSequence) {
            int[] nArray = matcher.groups;
            int n3 = nArray[this.groupIndex];
            int n4 = nArray[this.groupIndex + 1];
            if (n2 < this.cmax && this.atom.match(matcher, n, charSequence)) {
                int n5 = matcher.last - n;
                if (n5 <= 0) {
                    nArray[this.groupIndex] = n;
                    nArray[this.groupIndex + 1] = n += n5;
                } else {
                    block7: {
                        do {
                            nArray[this.groupIndex] = n;
                            nArray[this.groupIndex + 1] = n += n5;
                            if (++n2 >= this.cmax || !this.atom.match(matcher, n, charSequence)) break block7;
                        } while (n + n5 == matcher.last);
                        if (this.match0(matcher, n, n2, charSequence)) {
                            return true;
                        }
                    }
                    while (n2 > this.cmin) {
                        if (this.next.match(matcher, n, charSequence)) {
                            nArray[this.groupIndex + 1] = n;
                            nArray[this.groupIndex] = n -= n5;
                            return true;
                        }
                        nArray[this.groupIndex + 1] = n;
                        nArray[this.groupIndex] = n -= n5;
                        --n2;
                    }
                }
            }
            nArray[this.groupIndex] = n3;
            nArray[this.groupIndex + 1] = n4;
            return this.next.match(matcher, n, charSequence);
        }

        boolean match1(Matcher matcher, int n, int n2, CharSequence charSequence) {
            while (!this.next.match(matcher, n, charSequence)) {
                if (n2 >= this.cmax) {
                    return false;
                }
                if (!this.atom.match(matcher, n, charSequence)) {
                    return false;
                }
                if (n == matcher.last) {
                    return false;
                }
                matcher.groups[this.groupIndex] = n;
                matcher.groups[this.groupIndex + 1] = n = matcher.last;
                ++n2;
            }
            return true;
        }

        boolean match2(Matcher matcher, int n, int n2, CharSequence charSequence) {
            while (n2 < this.cmax && this.atom.match(matcher, n, charSequence)) {
                matcher.groups[this.groupIndex] = n;
                matcher.groups[this.groupIndex + 1] = matcher.last;
                if (n == matcher.last) break;
                n = matcher.last;
                ++n2;
            }
            return this.next.match(matcher, n, charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            int n = treeInfo.minLength;
            int n2 = treeInfo.maxLength;
            boolean bl = treeInfo.maxValid;
            boolean bl2 = treeInfo.deterministic;
            treeInfo.reset();
            this.atom.study(treeInfo);
            int n3 = treeInfo.minLength * this.cmin + n;
            if (n3 < n) {
                n3 = 0xFFFFFFF;
            }
            treeInfo.minLength = n3;
            if (bl & treeInfo.maxValid) {
                treeInfo.maxLength = n3 = treeInfo.maxLength * this.cmax + n2;
                if (n3 < n2) {
                    treeInfo.maxValid = false;
                }
            } else {
                treeInfo.maxValid = false;
            }
            treeInfo.deterministic = treeInfo.deterministic && this.cmin == this.cmax ? bl2 : false;
            return this.next.study(treeInfo);
        }
    }

    static final class Curly
    extends Node {
        Node atom;
        int type;
        int cmin;
        int cmax;

        Curly(Node node, int n, int n2, int n3) {
            this.atom = node;
            this.type = n3;
            this.cmin = n;
            this.cmax = n2;
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int n2;
            for (n2 = 0; n2 < this.cmin; ++n2) {
                if (!this.atom.match(matcher, n, charSequence)) {
                    return false;
                }
                n = matcher.last;
            }
            if (this.type == 0) {
                return this.match0(matcher, n, n2, charSequence);
            }
            if (this.type == 1) {
                return this.match1(matcher, n, n2, charSequence);
            }
            return this.match2(matcher, n, n2, charSequence);
        }

        boolean match0(Matcher matcher, int n, int n2, CharSequence charSequence) {
            int n3;
            if (n2 >= this.cmax) {
                return this.next.match(matcher, n, charSequence);
            }
            int n4 = n2++;
            if (this.atom.match(matcher, n, charSequence) && (n3 = matcher.last - n) != 0) {
                n = matcher.last;
                while (n2 < this.cmax && this.atom.match(matcher, n, charSequence)) {
                    if (n + n3 != matcher.last) {
                        if (!this.match0(matcher, matcher.last, n2 + 1, charSequence)) break;
                        return true;
                    }
                    n += n3;
                    ++n2;
                }
                while (n2 >= n4) {
                    if (this.next.match(matcher, n, charSequence)) {
                        return true;
                    }
                    n -= n3;
                    --n2;
                }
                return false;
            }
            return this.next.match(matcher, n, charSequence);
        }

        boolean match1(Matcher matcher, int n, int n2, CharSequence charSequence) {
            while (!this.next.match(matcher, n, charSequence)) {
                if (n2 >= this.cmax) {
                    return false;
                }
                if (!this.atom.match(matcher, n, charSequence)) {
                    return false;
                }
                if (n == matcher.last) {
                    return false;
                }
                n = matcher.last;
                ++n2;
            }
            return true;
        }

        boolean match2(Matcher matcher, int n, int n2, CharSequence charSequence) {
            while (n2 < this.cmax && this.atom.match(matcher, n, charSequence) && n != matcher.last) {
                n = matcher.last;
                ++n2;
            }
            return this.next.match(matcher, n, charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            int n = treeInfo.minLength;
            int n2 = treeInfo.maxLength;
            boolean bl = treeInfo.maxValid;
            boolean bl2 = treeInfo.deterministic;
            treeInfo.reset();
            this.atom.study(treeInfo);
            int n3 = treeInfo.minLength * this.cmin + n;
            if (n3 < n) {
                n3 = 0xFFFFFFF;
            }
            treeInfo.minLength = n3;
            if (bl & treeInfo.maxValid) {
                treeInfo.maxLength = n3 = treeInfo.maxLength * this.cmax + n2;
                if (n3 < n2) {
                    treeInfo.maxValid = false;
                }
            } else {
                treeInfo.maxValid = false;
            }
            treeInfo.deterministic = treeInfo.deterministic && this.cmin == this.cmax ? bl2 : false;
            return this.next.study(treeInfo);
        }
    }

    static final class Ques
    extends Node {
        Node atom;
        int type;

        Ques(Node node, int n) {
            this.atom = node;
            this.type = n;
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            switch (this.type) {
                case 0: {
                    return this.atom.match(matcher, n, charSequence) && this.next.match(matcher, matcher.last, charSequence) || this.next.match(matcher, n, charSequence);
                }
                case 1: {
                    return this.next.match(matcher, n, charSequence) || this.atom.match(matcher, n, charSequence) && this.next.match(matcher, matcher.last, charSequence);
                }
                case 2: {
                    if (this.atom.match(matcher, n, charSequence)) {
                        n = matcher.last;
                    }
                    return this.next.match(matcher, n, charSequence);
                }
            }
            return this.atom.match(matcher, n, charSequence) && this.next.match(matcher, matcher.last, charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            if (this.type != 3) {
                int n = treeInfo.minLength;
                this.atom.study(treeInfo);
                treeInfo.minLength = n;
                treeInfo.deterministic = false;
                return this.next.study(treeInfo);
            }
            this.atom.study(treeInfo);
            return this.next.study(treeInfo);
        }
    }

    static final class UnixDot
    extends Node {
        UnixDot() {
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            if (n < matcher.to) {
                char c = charSequence.charAt(n);
                return c != '\n' && this.next.match(matcher, n + 1, charSequence);
            }
            return false;
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }
    }

    static final class Dot
    extends Node {
        Dot() {
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            if (n < matcher.to) {
                char c = charSequence.charAt(n);
                return c != '\n' && c != '\r' && (c | '\u0001') != 8233 && c != '\u0085' && this.next.match(matcher, n + 1, charSequence);
            }
            return false;
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }
    }

    static final class All
    extends Node {
        All() {
        }

        Node dup(boolean bl) {
            if (bl) {
                return new Single(-1);
            }
            return new All();
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            return n < matcher.to && this.next.match(matcher, n + 1, charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }
    }

    static class CINotRange
    extends NotRange {
        int lower;
        int upper;

        CINotRange(int n) {
            this.lower = n >>> 16;
            this.upper = n & 0xFFFF;
        }

        Node dup(boolean bl) {
            if (bl) {
                return new CIRange((this.lower << 16) + this.upper);
            }
            return new CINotRange((this.lower << 16) + this.upper);
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            if (n < matcher.to) {
                boolean bl;
                char c = charSequence.charAt(n);
                boolean bl2 = bl = (c - this.lower | this.upper - c) < 0;
                if (bl) {
                    boolean bl3 = bl = ((c = Character.toUpperCase(c)) - this.lower | this.upper - c) < 0;
                    if (bl) {
                        bl = ((c = Character.toLowerCase(c)) - this.lower | this.upper - c) < 0;
                    }
                }
                return bl && this.next.match(matcher, n + 1, charSequence);
            }
            return false;
        }
    }

    static class NotRange
    extends Node {
        int lower;
        int upper;

        NotRange() {
        }

        NotRange(int n) {
            this.lower = n >>> 16;
            this.upper = n & 0xFFFF;
        }

        Node dup(boolean bl) {
            if (bl) {
                return new Range((this.lower << 16) + this.upper);
            }
            return new NotRange((this.lower << 16) + this.upper);
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            if (n < matcher.to) {
                char c = charSequence.charAt(n);
                return (c - this.lower | this.upper - c) < 0 && this.next.match(matcher, n + 1, charSequence);
            }
            return false;
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }
    }

    static final class CIRange
    extends Range {
        CIRange(int n) {
            this.lower = n >>> 16;
            this.upper = n & 0xFFFF;
        }

        Node dup(boolean bl) {
            if (bl) {
                return new CINotRange((this.lower << 16) + this.upper);
            }
            return new CIRange((this.lower << 16) + this.upper);
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            if (n < matcher.to) {
                boolean bl;
                char c = charSequence.charAt(n);
                boolean bl2 = bl = (c - this.lower | this.upper - c) >= 0;
                if (!bl) {
                    boolean bl3 = bl = ((c = Character.toUpperCase(c)) - this.lower | this.upper - c) >= 0;
                    if (!bl) {
                        bl = ((c = Character.toLowerCase(c)) - this.lower | this.upper - c) >= 0;
                    }
                }
                return bl && this.next.match(matcher, n + 1, charSequence);
            }
            return false;
        }
    }

    static class Range
    extends Node {
        int lower;
        int upper;

        Range() {
        }

        Range(int n) {
            this.lower = n >>> 16;
            this.upper = n & 0xFFFF;
        }

        Node dup(boolean bl) {
            if (bl) {
                return new NotRange((this.lower << 16) + this.upper);
            }
            return new Range((this.lower << 16) + this.upper);
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            if (n < matcher.to) {
                char c = charSequence.charAt(n);
                return (c - this.lower | this.upper - c) >= 0 && this.next.match(matcher, n + 1, charSequence);
            }
            return false;
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }
    }

    static final class SliceU
    extends Node {
        char[] buffer;

        SliceU(char[] cArray) {
            this.buffer = cArray;
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            char[] cArray = this.buffer;
            int n2 = cArray.length;
            if (n + n2 > matcher.to) {
                return false;
            }
            for (int i = 0; i < n2; ++i) {
                char c = charSequence.charAt(n + i);
                c = Character.toUpperCase(c);
                if (cArray[i] == (c = Character.toLowerCase(c))) continue;
                return false;
            }
            return this.next.match(matcher, n + n2, charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            treeInfo.minLength += this.buffer.length;
            treeInfo.maxLength += this.buffer.length;
            return this.next.study(treeInfo);
        }
    }

    static final class SliceA
    extends Node {
        char[] buffer;

        SliceA(char[] cArray) {
            this.buffer = cArray;
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            char[] cArray = this.buffer;
            int n2 = cArray.length;
            if (n + n2 > matcher.to) {
                return false;
            }
            for (int i = 0; i < n2; ++i) {
                int n3 = ASCII.toLower(charSequence.charAt(n + i));
                if (cArray[i] == n3) continue;
                return false;
            }
            return this.next.match(matcher, n + n2, charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            treeInfo.minLength += this.buffer.length;
            treeInfo.maxLength += this.buffer.length;
            return this.next.study(treeInfo);
        }
    }

    static final class Slice
    extends Node {
        char[] buffer;

        Slice(char[] cArray) {
            this.buffer = cArray;
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            char[] cArray = this.buffer;
            int n2 = cArray.length;
            if (n + n2 > matcher.to) {
                return false;
            }
            for (int i = 0; i < n2; ++i) {
                if (cArray[i] == charSequence.charAt(n + i)) continue;
                return false;
            }
            return this.next.match(matcher, n + n2, charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            treeInfo.minLength += this.buffer.length;
            treeInfo.maxLength += this.buffer.length;
            return this.next.study(treeInfo);
        }
    }

    static final class Not
    extends Node {
        Node atom;

        Not(Node node) {
            this.atom = node;
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            return !this.atom.match(matcher, n, charSequence) && this.next.match(matcher, n + 1, charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }
    }

    static final class Specials
    extends Node {
        Specials() {
        }

        Node dup(boolean bl) {
            if (bl) {
                return new Not(this);
            }
            return new Specials();
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            if (n < matcher.to) {
                char c = charSequence.charAt(n);
                return ((c - 65520 | 65533 - c) >= 0 || c == '\ufeff') && this.next.match(matcher, n + 1, charSequence);
            }
            return false;
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }
    }

    static final class NotCtype
    extends Node {
        int ctype;

        NotCtype(int n) {
            this.ctype = n;
        }

        Node dup(boolean bl) {
            if (bl) {
                return new Ctype(this.ctype);
            }
            return new NotCtype(this.ctype);
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            return n < matcher.to && !ASCII.isType(charSequence.charAt(n), this.ctype) && this.next.match(matcher, n + 1, charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }
    }

    static final class Ctype
    extends Node {
        int ctype;

        Ctype(int n) {
            this.ctype = n;
        }

        Node dup(boolean bl) {
            if (bl) {
                return new NotCtype(this.ctype);
            }
            return new Ctype(this.ctype);
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            return n < matcher.to && ASCII.isType(charSequence.charAt(n), this.ctype) && this.next.match(matcher, n + 1, charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }
    }

    static final class Category
    extends Node {
        int atype;

        Category(int n) {
            this.atype = n;
        }

        Node dup(boolean bl) {
            return new Category(bl ? ~this.atype : this.atype);
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            return n < matcher.to && (this.atype & 1 << Character.getType(charSequence.charAt(n))) != 0 && this.next.match(matcher, n + 1, charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }
    }

    static final class NotSingleU
    extends Node {
        int ch;

        NotSingleU(int n) {
            this.ch = Character.toLowerCase(Character.toUpperCase((char)n));
        }

        Node dup(boolean bl) {
            if (bl) {
                return new SingleU(this.ch);
            }
            return new NotSingleU(this.ch);
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            if (n < matcher.to) {
                char c = charSequence.charAt(n);
                if (c == this.ch) {
                    return false;
                }
                c = Character.toUpperCase(c);
                if ((c = Character.toLowerCase(c)) != this.ch) {
                    return this.next.match(matcher, n + 1, charSequence);
                }
            }
            return false;
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }
    }

    static final class SingleU
    extends Node {
        int ch;

        SingleU(int n) {
            this.ch = Character.toLowerCase(Character.toUpperCase((char)n));
        }

        Node dup(boolean bl) {
            if (bl) {
                return new NotSingleU(this.ch);
            }
            return new SingleU(this.ch);
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            if (n < matcher.to) {
                char c = charSequence.charAt(n);
                if (c == this.ch) {
                    return this.next.match(matcher, n + 1, charSequence);
                }
                c = Character.toUpperCase(c);
                if ((c = Character.toLowerCase(c)) == this.ch) {
                    return this.next.match(matcher, n + 1, charSequence);
                }
            }
            return false;
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }
    }

    static final class NotSingleA
    extends Node {
        int ch;

        NotSingleA(int n) {
            this.ch = ASCII.toLower(n);
        }

        Node dup(boolean bl) {
            if (bl) {
                return new SingleA(this.ch);
            }
            return new NotSingleA(this.ch);
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            char c;
            if (n < matcher.to && (c = charSequence.charAt(n)) != this.ch && ASCII.toLower(c) != this.ch) {
                return this.next.match(matcher, n + 1, charSequence);
            }
            return false;
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }
    }

    static final class SingleA
    extends Node {
        int ch;

        SingleA(int n) {
            this.ch = ASCII.toLower(n);
        }

        Node dup(boolean bl) {
            if (bl) {
                return new NotSingleA(this.ch);
            }
            return new SingleA(this.ch);
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            char c;
            if (n < matcher.to && ((c = charSequence.charAt(n)) == this.ch || ASCII.toLower(c) == this.ch)) {
                return this.next.match(matcher, n + 1, charSequence);
            }
            return false;
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }
    }

    static final class NotSingle
    extends Node {
        int ch;

        NotSingle(int n) {
            this.ch = n;
        }

        Node dup(boolean bl) {
            if (bl) {
                return new Single(this.ch);
            }
            return new NotSingle(this.ch);
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            return n < matcher.to && charSequence.charAt(n) != this.ch && this.next.match(matcher, n + 1, charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }
    }

    static final class Single
    extends Node {
        int ch;

        Single(int n) {
            this.ch = n;
        }

        Node dup(boolean bl) {
            if (bl) {
                return new NotSingle(this.ch);
            }
            return new Single(this.ch);
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            return n < matcher.to && charSequence.charAt(n) == this.ch && this.next.match(matcher, n + 1, charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }
    }

    static final class UnixDollar
    extends Node {
        boolean multiline;

        UnixDollar(boolean bl) {
            this.multiline = bl;
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            if (n < matcher.to) {
                char c = charSequence.charAt(n);
                if (c == '\n') {
                    if (!this.multiline && n != matcher.to - 1) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            return this.next.match(matcher, n, charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            this.next.study(treeInfo);
            return treeInfo.deterministic;
        }
    }

    static final class Dollar
    extends Node {
        boolean multiline;

        Dollar(boolean bl) {
            this.multiline = bl;
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            char c;
            if (!this.multiline) {
                if (n < matcher.to - 2) {
                    return false;
                }
                if (n == matcher.to - 2) {
                    c = charSequence.charAt(n);
                    if (c != '\r') {
                        return false;
                    }
                    c = charSequence.charAt(n + 1);
                    if (c != '\n') {
                        return false;
                    }
                }
            }
            if (n < matcher.to) {
                c = charSequence.charAt(n);
                if (c == '\n') {
                    if (n > 0 && charSequence.charAt(n - 1) == '\r') {
                        return false;
                    }
                } else if (c != '\r' && c != '\u0085' && (c | '\u0001') != 8233) {
                    return false;
                }
            }
            return this.next.match(matcher, n, charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            this.next.study(treeInfo);
            return treeInfo.deterministic;
        }
    }

    static final class LastMatch
    extends Node {
        LastMatch() {
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            if (n != matcher.oldLast) {
                return false;
            }
            return this.next.match(matcher, n, charSequence);
        }
    }

    static final class UnixCaret
    extends Node {
        UnixCaret() {
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            char c;
            if (n > matcher.from && (c = charSequence.charAt(n - 1)) != '\n') {
                return false;
            }
            if (n == matcher.to) {
                return false;
            }
            return this.next.match(matcher, n, charSequence);
        }
    }

    static final class Caret
    extends Node {
        Caret() {
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            if (n > matcher.from) {
                char c = charSequence.charAt(n - 1);
                if (c != '\n' && c != '\r' && (c | '\u0001') != 8233 && c != '\u0085') {
                    return false;
                }
                if (c == '\r' && charSequence.charAt(n) == '\n') {
                    return false;
                }
            }
            if (n == matcher.to) {
                return false;
            }
            return this.next.match(matcher, n, charSequence);
        }
    }

    static final class End
    extends Node {
        End() {
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            return n == matcher.to && this.next.match(matcher, n, charSequence);
        }
    }

    static final class Begin
    extends Node {
        Begin() {
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            if (n == matcher.from && this.next.match(matcher, n, charSequence)) {
                matcher.first = n;
                matcher.groups[0] = n;
                matcher.groups[1] = matcher.last;
                return true;
            }
            return false;
        }
    }

    static final class Start
    extends Node {
        int minLength;

        Start(Node node) {
            this.next = node;
            TreeInfo treeInfo = new TreeInfo();
            this.next.study(treeInfo);
            this.minLength = treeInfo.minLength;
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            if (n > matcher.to - this.minLength) {
                return false;
            }
            boolean bl = false;
            int n2 = matcher.to - this.minLength;
            while (n <= n2 && !(bl = this.next.match(matcher, n, charSequence))) {
                ++n;
            }
            if (bl) {
                matcher.groups[0] = matcher.first = n;
                matcher.groups[1] = matcher.last;
            }
            return bl;
        }

        boolean study(TreeInfo treeInfo) {
            this.next.study(treeInfo);
            treeInfo.maxValid = false;
            treeInfo.deterministic = false;
            return false;
        }
    }

    static class Dummy
    extends Node {
        Dummy() {
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            return this.next.match(matcher, n, charSequence);
        }
    }

    static class LastNode
    extends Node {
        LastNode() {
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            if (matcher.acceptMode == 1 && n != matcher.to) {
                return false;
            }
            matcher.last = n;
            matcher.groups[0] = matcher.first;
            matcher.groups[1] = matcher.last;
            return true;
        }
    }

    static class Node {
        Node next = accept;

        Node() {
        }

        Node dup(boolean bl) {
            if (bl) {
                return new Not(this);
            }
            throw new RuntimeException("internal error in Node dup()");
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            matcher.last = n;
            matcher.groups[0] = matcher.first;
            matcher.groups[1] = matcher.last;
            return true;
        }

        boolean study(TreeInfo treeInfo) {
            if (this.next != null) {
                return this.next.study(treeInfo);
            }
            return treeInfo.deterministic;
        }
    }

    static final class BitClass
    extends Node {
        boolean[] bits = new boolean[256];
        boolean complementMe = false;

        BitClass(boolean bl) {
            this.complementMe = bl;
        }

        BitClass(boolean[] blArray, boolean bl) {
            this.complementMe = bl;
            this.bits = blArray;
        }

        Node add(int n, int n2) {
            if ((n2 & 2) == 0) {
                this.bits[n] = true;
                return this;
            }
            if (n < 128) {
                this.bits[n] = true;
                if (ASCII.isUpper(n)) {
                    this.bits[n += 32] = true;
                } else if (ASCII.isLower(n)) {
                    this.bits[n -= 32] = true;
                }
                return this;
            }
            n = Character.toLowerCase((char)n);
            this.bits[n] = true;
            n = Character.toUpperCase((char)n);
            this.bits[n] = true;
            return this;
        }

        Node dup(boolean bl) {
            return new BitClass(this.bits, bl);
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            if (n < matcher.to) {
                char c = charSequence.charAt(n);
                if (c > '\u00ff') {
                    return false;
                }
                if (this.complementMe) {
                    return !this.bits[c] && this.next.match(matcher, n + 1, charSequence);
                }
                if (this.bits[c]) {
                    return this.next.match(matcher, n + 1, charSequence);
                }
            }
            return false;
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }
    }

    static final class TreeInfo {
        int minLength;
        int maxLength;
        boolean maxValid;
        boolean deterministic;

        TreeInfo() {
            this.reset();
        }

        void reset() {
            this.minLength = 0;
            this.maxLength = 0;
            this.maxValid = true;
            this.deterministic = true;
        }
    }
}

