/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarVerifier;
import java.util.jar.JavaUtilJarAccessImpl;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import sun.misc.SharedSecrets;
import sun.security.action.GetPropertyAction;
import sun.security.util.ManifestEntryVerifier;

public class JarFile
extends ZipFile {
    private Manifest man;
    private JarEntry manEntry;
    private boolean manLoaded;
    private JarVerifier jv;
    private boolean jvInitialized;
    private boolean verify;
    private static Vector insts = new Vector(20, 20);
    private static Hashtable jarsInit = new Hashtable(2);
    private boolean computedHasClassPathAttribute;
    private boolean hasClassPathAttribute;
    public static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    private static int[] lastOcc;
    private static int[] optoSft;
    private static char[] src;
    private static String javaHome;

    public JarFile(String string) throws IOException {
        this(new File(string), true, 1);
    }

    public JarFile(String string, boolean bl) throws IOException {
        this(new File(string), bl, 1);
    }

    public JarFile(File file) throws IOException {
        this(file, true, 1);
    }

    public JarFile(File file, boolean bl) throws IOException {
        this(file, bl, 1);
    }

    public JarFile(File file, boolean bl, int n) throws IOException {
        super(file, n);
        this.verify = bl;
    }

    private static boolean ibmJVMTidyUp() {
        for (int i = 0; i < insts.size(); ++i) {
            SoftReference softReference = (SoftReference)insts.get(i);
            JarFile jarFile = (JarFile)softReference.get();
            if (null == jarFile) continue;
            jarFile.manLoaded = false;
            jarFile.man = null;
            jarFile.jv = null;
            jarFile.jvInitialized = false;
        }
        insts.clear();
        return true;
    }

    public Manifest getManifest() throws IOException {
        if (!this.manLoaded) {
            Object[] objectArray;
            this.manEntry = this.getJarEntry(MANIFEST_NAME);
            if (this.manEntry == null && (objectArray = this.getMetaInfEntryNames()) != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (!MANIFEST_NAME.equals(objectArray[i].toUpperCase(Locale.ENGLISH))) continue;
                    this.manEntry = this.getJarEntry(objectArray[i]);
                    break;
                }
            }
            if (this.manEntry != null) {
                if (this.verify) {
                    objectArray = this.getBytes(this.manEntry);
                    this.man = new Manifest(new ByteArrayInputStream((byte[])objectArray));
                    this.jv = new JarVerifier(this.man, (byte[])objectArray);
                } else {
                    this.man = new Manifest(super.getInputStream(this.manEntry));
                }
                insts.add(new SoftReference(this));
            }
            this.manLoaded = true;
        }
        return this.man;
    }

    private native String[] getMetaInfEntryNames();

    public JarEntry getJarEntry(String string) {
        return (JarEntry)this.getEntry(string);
    }

    public ZipEntry getEntry(String string) {
        ZipEntry zipEntry = super.getEntry(string);
        if (zipEntry != null) {
            return new JarFileEntry(zipEntry);
        }
        return null;
    }

    public Enumeration entries() {
        final Enumeration enumeration = super.entries();
        return new Enumeration(){

            public boolean hasMoreElements() {
                return enumeration.hasMoreElements();
            }

            public Object nextElement() {
                ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
                return new JarFileEntry(zipEntry);
            }
        };
    }

    private void maybeInstantiateVerifier() throws IOException {
        if (this.jv != null) {
            return;
        }
        if (this.verify) {
            String[] stringArray = this.getMetaInfEntryNames();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i].toUpperCase(Locale.ENGLISH);
                    if (!string.endsWith(".DSA") && !string.endsWith(".RSA") && !string.endsWith(".SF")) continue;
                    this.getManifest();
                    return;
                }
            }
            this.verify = false;
        }
    }

    private void initializeVerifier() {
        block9: {
            ManifestEntryVerifier manifestEntryVerifier = null;
            try {
                String[] stringArray = this.getMetaInfEntryNames();
                if (stringArray != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        byte[] byArray;
                        JarEntry jarEntry = this.getJarEntry(stringArray[i]);
                        if (jarEntry.isDirectory()) continue;
                        if (manifestEntryVerifier == null) {
                            manifestEntryVerifier = new ManifestEntryVerifier(this.man);
                        }
                        if ((byArray = this.getBytes(jarEntry)) == null || byArray.length <= 0) continue;
                        this.jv.beginEntry(jarEntry, manifestEntryVerifier);
                        this.jv.update(byArray.length, byArray, 0, byArray.length, manifestEntryVerifier);
                        this.jv.update(-1, null, 0, 0, manifestEntryVerifier);
                    }
                }
            }
            catch (IOException iOException) {
                this.jv = null;
                this.verify = false;
                if (JarVerifier.debug == null) break block9;
                JarVerifier.debug.println("IOException (" + iOException + "), treating Jar file as unsigned");
            }
        }
        if (this.jv != null) {
            this.jv.doneWithMeta();
            if (JarVerifier.debug != null) {
                JarVerifier.debug.println("done with meta!");
            }
            if (this.jv.nothingToVerify()) {
                if (JarVerifier.debug != null) {
                    JarVerifier.debug.println("nothing to verify!");
                }
                this.jv = null;
                this.verify = false;
            }
        }
    }

    private byte[] getBytes(ZipEntry zipEntry) throws IOException {
        byte[] byArray = new byte[(int)zipEntry.getSize()];
        DataInputStream dataInputStream = new DataInputStream(super.getInputStream(zipEntry));
        dataInputStream.readFully(byArray, 0, byArray.length);
        dataInputStream.close();
        return byArray;
    }

    public synchronized InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        this.maybeInstantiateVerifier();
        if (this.jv == null) {
            return super.getInputStream(zipEntry);
        }
        if (!this.jvInitialized) {
            if (jarsInit.contains(this)) {
                throw new IOException("Unable to read from JAR which is currently being initialised!");
            }
            jarsInit.put(this, this);
            this.initializeVerifier();
            jarsInit.remove(this);
            this.jvInitialized = true;
            if (this.jv == null) {
                return super.getInputStream(zipEntry);
            }
        }
        return new JarVerifier.VerifierStream(this.man, (JarEntry)zipEntry, super.getInputStream(zipEntry), this.jv);
    }

    boolean hasClassPathAttribute() throws IOException {
        if (this.computedHasClassPathAttribute) {
            return this.hasClassPathAttribute;
        }
        this.hasClassPathAttribute = false;
        if (!this.isKnownToNotHaveClassPathAttribute()) {
            Object[] objectArray;
            JarEntry jarEntry = this.getJarEntry(MANIFEST_NAME);
            if (jarEntry == null && (objectArray = this.getMetaInfEntryNames()) != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (!MANIFEST_NAME.equals(objectArray[i].toUpperCase(Locale.ENGLISH))) continue;
                    jarEntry = this.getJarEntry(objectArray[i]);
                    break;
                }
            }
            if (jarEntry != null) {
                char c;
                int n;
                objectArray = new byte[(int)jarEntry.getSize()];
                DataInputStream dataInputStream = new DataInputStream(super.getInputStream(jarEntry));
                dataInputStream.readFully((byte[])objectArray, 0, objectArray.length);
                dataInputStream.close();
                int n2 = objectArray.length - src.length;
                block1: for (int i = 0; i <= n2; i += Math.max(n + 1 - lastOcc[c & 0x7F], optoSft[n])) {
                    for (n = 9; n >= 0; --n) {
                        c = (char)objectArray[i + n];
                        char c2 = c = (c - 65 | 90 - c) >= 0 ? (char)(c + 32) : c;
                        if (c == src[n]) continue;
                        continue block1;
                    }
                    this.hasClassPathAttribute = true;
                    break;
                }
            }
        }
        this.computedHasClassPathAttribute = true;
        return this.hasClassPathAttribute;
    }

    private boolean isKnownToNotHaveClassPathAttribute() {
        String string;
        String string2;
        if (javaHome == null) {
            javaHome = (String)AccessController.doPrivileged(new GetPropertyAction("java.home"));
        }
        return (string2 = this.getName()).startsWith(string = javaHome) && (string2.endsWith("rt.jar") || string2.endsWith("sunrsasign.jar") || string2.endsWith("jsse.jar") || string2.endsWith("jce.jar") || string2.endsWith("charsets.jar") || string2.endsWith("dnsns.jar") || string2.endsWith("ldapsec.jar") || string2.endsWith("localedata.jar") || string2.endsWith("sunjce_provider.jar"));
    }

    static {
        SharedSecrets.setJavaUtilJarAccess(new JavaUtilJarAccessImpl());
        src = new char[]{'c', 'l', 'a', 's', 's', '-', 'p', 'a', 't', 'h'};
        lastOcc = new int[128];
        optoSft = new int[10];
        JarFile.lastOcc[99] = 1;
        JarFile.lastOcc[108] = 2;
        JarFile.lastOcc[97] = 8;
        JarFile.lastOcc[115] = 5;
        JarFile.lastOcc[116] = 9;
        JarFile.lastOcc[45] = 6;
        JarFile.lastOcc[112] = 7;
        JarFile.lastOcc[104] = 10;
        for (int i = 0; i < 9; ++i) {
            JarFile.optoSft[i] = 10;
        }
        JarFile.optoSft[9] = 1;
    }

    private class JarFileEntry
    extends JarEntry {
        JarFileEntry(ZipEntry zipEntry) {
            super(zipEntry);
        }

        public Attributes getAttributes() throws IOException {
            Manifest manifest = JarFile.this.getManifest();
            if (manifest != null) {
                return manifest.getAttributes(this.getName());
            }
            return null;
        }

        public Certificate[] getCertificates() {
            Certificate[] certificateArray;
            try {
                JarFile.this.maybeInstantiateVerifier();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            if (this.certs == null && JarFile.this.jv != null && (certificateArray = JarFile.this.jv.getCerts(this.getName())) != null) {
                this.certs = (Certificate[])certificateArray.clone();
            }
            return this.certs;
        }
    }
}

