/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.jvm.ExtendedSystem;
import java.io.InputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.security.AccessController;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import sun.misc.Unsafe;
import sun.reflect.Reflection;
import sun.reflect.ReflectionFactory;
import sun.security.util.SecurityConstants;

public final class Class
implements Serializable {
    private static boolean have_extensions = true;
    private volatile transient Constructor cachedConstructor;
    private volatile transient Class newInstanceCallerCache;
    private static ProtectionDomain allPermDomain;
    private static boolean useCaches;
    private volatile transient SoftReference declaredFields;
    private volatile transient SoftReference publicFields;
    private volatile transient SoftReference declaredMethods;
    private volatile transient SoftReference publicMethods;
    private volatile transient SoftReference declaredConstructors;
    private volatile transient SoftReference publicConstructors;
    private volatile transient SoftReference declaredPublicFields;
    private volatile transient SoftReference declaredPublicMethods;
    private static final long serialVersionUID = 3206093459760846163L;
    private static final ObjectStreamField[] serialPersistentFields;
    private static ReflectionFactory reflectionFactory;
    private static boolean initted;

    private static native void registerNatives();

    private Class() {
        have_extensions = Class.haveExtensions();
    }

    public String toString() {
        return (this.isInterface() ? "interface " : (this.isPrimitive() ? "" : "class ")) + this.getName();
    }

    private static native Class forName1(String var0) throws ClassNotFoundException;

    private static native boolean haveExtensions();

    public static Class forName(String string) throws ClassNotFoundException {
        if (have_extensions) {
            return Class.forName1(string);
        }
        return Class.forName0(string, true, ClassLoader.getCallerClassLoader());
    }

    public static Class forName(String string, boolean bl, ClassLoader classLoader) throws ClassNotFoundException {
        ClassLoader classLoader2;
        SecurityManager securityManager;
        if (classLoader == null && (securityManager = System.getSecurityManager()) != null && (classLoader2 = ClassLoader.getCallerClassLoader()) != null) {
            securityManager.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
        }
        return Class.forName0(string, bl, classLoader);
    }

    private static native Class forName0(String var0, boolean var1, ClassLoader var2) throws ClassNotFoundException;

    public Object newInstance() throws InstantiationException, IllegalAccessException {
        if (System.getSecurityManager() != null) {
            this.checkMemberAccess(0, ClassLoader.getCallerClassLoader());
        }
        if (ExtendedSystem.isOldReflectionMode()) {
            return this.newInstance0();
        }
        return this.newInstance3();
    }

    private native Object newInstance0() throws InstantiationException, IllegalAccessException;

    private Object newInstance3() throws InstantiationException, IllegalAccessException {
        int n;
        Constructor constructor = this.cachedConstructor;
        Class clazz = this.newInstanceCallerCache;
        if (constructor == null) {
            if (this == Class.class) {
                throw new IllegalAccessException("Can not call newInstance() on the Class for java.lang.Class");
            }
            try {
                final Constructor constructor2 = this.getConstructor1(new Class[0], 1);
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        constructor2.setAccessible(true);
                        return null;
                    }
                });
                constructor = constructor2;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new InstantiationException(this.getName());
            }
        }
        if (!Reflection.quickCheckMemberAccess(this, n = constructor.getModifiers()) && this.newInstanceCallerCache != (clazz = Reflection.getCallerClass(3))) {
            Reflection.ensureMemberAccess(clazz, this, null, n);
        }
        if (useCaches) {
            this.cachedConstructor = constructor;
            this.newInstanceCallerCache = clazz;
        }
        try {
            return constructor.newInstance(null);
        }
        catch (InvocationTargetException invocationTargetException) {
            Unsafe.getUnsafe().throwException(invocationTargetException.getTargetException());
            return null;
        }
    }

    private Object newInstance1(Class clazz, ClassLoader classLoader) throws InstantiationException, IllegalAccessException {
        if (System.getSecurityManager() != null) {
            this.checkMemberAccess(0, classLoader);
        }
        return this.newInstance2(clazz);
    }

    private native Object newInstance2(Class var1) throws InstantiationException, IllegalAccessException;

    public native boolean isInstance(Object var1);

    public native boolean isAssignableFrom(Class var1);

    public native boolean isInterface();

    public native boolean isArray();

    public native boolean isPrimitive();

    public native String getName();

    public ClassLoader getClassLoader() {
        ClassLoader classLoader;
        ClassLoader classLoader2 = this.getClassLoader0();
        if (classLoader2 == null) {
            return null;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (classLoader = ClassLoader.getCallerClassLoader()) != null && classLoader != classLoader2 && !classLoader2.isAncestor(classLoader)) {
            securityManager.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
        }
        return classLoader2;
    }

    native ClassLoader getClassLoader0();

    public native Class getSuperclass();

    public Package getPackage() {
        return Package.getPackage(this);
    }

    public native Class[] getInterfaces();

    public native Class getComponentType();

    public native int getModifiers();

    public native Object[] getSigners();

    native void setSigners(Object[] var1);

    public native Class getDeclaringClass();

    public Class[] getClasses() {
        this.checkMemberAccess(0, ClassLoader.getCallerClassLoader());
        Class[] classArray = (Class[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ArrayList arrayList = new ArrayList();
                for (Class clazz = Class.this; clazz != null; clazz = clazz.getSuperclass()) {
                    Class[] classArray = clazz.getDeclaredClasses();
                    for (int i = 0; i < classArray.length; ++i) {
                        if (!Modifier.isPublic(classArray[i].getModifiers())) continue;
                        arrayList.add(classArray[i]);
                    }
                }
                return arrayList.toArray(new Class[0]);
            }
        });
        return classArray;
    }

    public Field[] getFields() throws SecurityException {
        this.checkMemberAccess(0, ClassLoader.getCallerClassLoader());
        if (ExtendedSystem.isOldReflectionMode()) {
            return this.privateGetDeclaredFields(true);
        }
        return Class.copyFields(this.privateGetPublicFields(null));
    }

    public Method[] getMethods() throws SecurityException {
        this.checkMemberAccess(0, ClassLoader.getCallerClassLoader());
        if (ExtendedSystem.isOldReflectionMode()) {
            return this.privateGetDeclaredMethods(true);
        }
        return Class.copyMethods(this.privateGetPublicMethods());
    }

    public Constructor[] getConstructors() throws SecurityException {
        this.checkMemberAccess(0, ClassLoader.getCallerClassLoader());
        if (ExtendedSystem.isOldReflectionMode()) {
            return this.privateGetDeclaredConstructors(true);
        }
        return Class.copyConstructors(this.privateGetDeclaredConstructors(true));
    }

    public Field getField(String string) throws NoSuchFieldException, SecurityException {
        this.checkMemberAccess(0, ClassLoader.getCallerClassLoader());
        if (ExtendedSystem.isOldReflectionMode()) {
            return this.getField0(string, 0, true);
        }
        Field field = this.getField1(string);
        if (field == null) {
            throw new NoSuchFieldException(string);
        }
        return field;
    }

    public Method getMethod(String string, Class[] classArray) throws NoSuchMethodException, SecurityException {
        this.checkMemberAccess(0, ClassLoader.getCallerClassLoader());
        if (ExtendedSystem.isOldReflectionMode()) {
            return this.getMethod0(string, classArray, 0, true);
        }
        Method method = this.getMethod1(string, classArray);
        if (method == null) {
            throw new NoSuchMethodException(this.getName() + "." + string + Class.argumentTypesToString(classArray));
        }
        return method;
    }

    public Constructor getConstructor(Class[] classArray) throws NoSuchMethodException, SecurityException {
        this.checkMemberAccess(0, ClassLoader.getCallerClassLoader());
        if (ExtendedSystem.isOldReflectionMode()) {
            return this.getConstructor0(classArray, 0);
        }
        return this.getConstructor1(classArray, 0);
    }

    public Class[] getDeclaredClasses() throws SecurityException {
        this.checkMemberAccess(1, ClassLoader.getCallerClassLoader());
        return this.getDeclaredClasses0();
    }

    public Field[] getDeclaredFields() throws SecurityException {
        this.checkMemberAccess(1, ClassLoader.getCallerClassLoader());
        if (ExtendedSystem.isOldReflectionMode()) {
            return this.privateGetDeclaredFields(false);
        }
        return Class.copyFields(this.privateGetDeclaredFields(false));
    }

    public Method[] getDeclaredMethods() throws SecurityException {
        this.checkMemberAccess(1, ClassLoader.getCallerClassLoader());
        if (ExtendedSystem.isOldReflectionMode()) {
            return this.privateGetDeclaredMethods(false);
        }
        return Class.copyMethods(this.privateGetDeclaredMethods(false));
    }

    public Constructor[] getDeclaredConstructors() throws SecurityException {
        this.checkMemberAccess(1, ClassLoader.getCallerClassLoader());
        if (ExtendedSystem.isOldReflectionMode()) {
            return this.privateGetDeclaredConstructors(false);
        }
        return Class.copyConstructors(this.privateGetDeclaredConstructors(false));
    }

    public Field getDeclaredField(String string) throws NoSuchFieldException, SecurityException {
        this.checkMemberAccess(1, ClassLoader.getCallerClassLoader());
        if (ExtendedSystem.isOldReflectionMode()) {
            return this.getField0(string, 1, true);
        }
        Field field = this.searchFields(this.privateGetDeclaredFields(false), string);
        if (field == null) {
            throw new NoSuchFieldException(string);
        }
        return field;
    }

    public Method getDeclaredMethod(String string, Class[] classArray) throws NoSuchMethodException, SecurityException {
        this.checkMemberAccess(1, ClassLoader.getCallerClassLoader());
        if (ExtendedSystem.isOldReflectionMode()) {
            return this.getMethod0(string, classArray, 1, true);
        }
        Method method = Class.searchMethods(this.privateGetDeclaredMethods(false), string, classArray);
        if (method == null) {
            throw new NoSuchMethodException(this.getName() + "." + string + Class.argumentTypesToString(classArray));
        }
        return method;
    }

    public Constructor getDeclaredConstructor(Class[] classArray) throws NoSuchMethodException, SecurityException {
        this.checkMemberAccess(1, ClassLoader.getCallerClassLoader());
        if (ExtendedSystem.isOldReflectionMode()) {
            return this.getConstructor0(classArray, 1);
        }
        return this.getConstructor1(classArray, 1);
    }

    public InputStream getResourceAsStream(String string) {
        string = this.resolveName(string);
        ClassLoader classLoader = this.getClassLoader0();
        if (classLoader == null) {
            return ClassLoader.getSystemResourceAsStream(string);
        }
        return classLoader.getResourceAsStream(string);
    }

    public URL getResource(String string) {
        string = this.resolveName(string);
        ClassLoader classLoader = this.getClassLoader0();
        if (classLoader == null) {
            return ClassLoader.getSystemResource(string);
        }
        return classLoader.getResource(string);
    }

    public ProtectionDomain getProtectionDomain() {
        ProtectionDomain protectionDomain;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SecurityConstants.GET_PD_PERMISSION);
        }
        if ((protectionDomain = this.getProtectionDomain0()) == null) {
            if (allPermDomain == null) {
                Permissions permissions = new Permissions();
                permissions.add(SecurityConstants.ALL_PERMISSION);
                allPermDomain = new ProtectionDomain(null, permissions);
            }
            protectionDomain = allPermDomain;
        }
        return protectionDomain;
    }

    private native ProtectionDomain getProtectionDomain0();

    native void setProtectionDomain0(ProtectionDomain var1);

    static native Class getPrimitiveClass(String var0);

    private void checkMemberAccess(int n, ClassLoader classLoader) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            String string;
            int n2;
            securityManager.checkMemberAccess(this, n);
            ClassLoader classLoader2 = this.getClassLoader0();
            if (!(classLoader == null || classLoader == classLoader2 || classLoader2 != null && classLoader2.isAncestor(classLoader) || (n2 = (string = this.getName()).lastIndexOf(46)) == -1)) {
                securityManager.checkPackageAccess(string.substring(0, n2));
            }
        }
    }

    private String resolveName(String string) {
        if (string == null) {
            return string;
        }
        if (!string.startsWith("/")) {
            Class clazz = this;
            while (clazz.isArray()) {
                clazz = clazz.getComponentType();
            }
            String string2 = clazz.getName();
            int n = string2.lastIndexOf(46);
            if (n != -1) {
                string = string2.substring(0, n).replace('.', '/') + "/" + string;
            }
        } else {
            string = string.substring(1);
        }
        return string;
    }

    private Field[] privateGetDeclaredFields(boolean bl) {
        Class.checkInitted();
        Field[] fieldArray = null;
        if (useCaches) {
            if (bl) {
                if (this.declaredPublicFields != null) {
                    fieldArray = (Field[])this.declaredPublicFields.get();
                }
            } else if (this.declaredFields != null) {
                fieldArray = (Field[])this.declaredFields.get();
            }
            if (fieldArray != null) {
                return fieldArray;
            }
        }
        fieldArray = this.getDeclaredFields0(bl);
        if (useCaches) {
            if (bl) {
                this.declaredPublicFields = new SoftReference(fieldArray);
            } else {
                this.declaredFields = new SoftReference(fieldArray);
            }
        }
        return fieldArray;
    }

    private Field[] privateGetPublicFields(Set set) {
        Class clazz;
        Class.checkInitted();
        Object[] objectArray = null;
        if (useCaches) {
            if (this.publicFields != null) {
                objectArray = (Field[])this.publicFields.get();
            }
            if (objectArray != null) {
                return objectArray;
            }
        }
        ArrayList arrayList = new ArrayList();
        if (set == null) {
            set = new HashSet();
        }
        Field[] fieldArray = this.privateGetDeclaredFields(true);
        Class.addAll(arrayList, fieldArray);
        Class[] classArray = this.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            Class clazz2 = classArray[i];
            if (set.contains(clazz2)) continue;
            set.add(clazz2);
            Class.addAll(arrayList, clazz2.privateGetPublicFields(set));
        }
        if (!this.isInterface() && (clazz = this.getSuperclass()) != null) {
            Class.addAll(arrayList, clazz.privateGetPublicFields(set));
        }
        objectArray = new Field[arrayList.size()];
        arrayList.toArray(objectArray);
        if (useCaches) {
            this.publicFields = new SoftReference(objectArray);
        }
        return objectArray;
    }

    private static void addAll(Collection collection, Field[] fieldArray) {
        for (int i = 0; i < fieldArray.length; ++i) {
            collection.add(fieldArray[i]);
        }
    }

    private Constructor[] privateGetDeclaredConstructors(boolean bl) {
        Class.checkInitted();
        Constructor[] constructorArray = null;
        if (useCaches) {
            if (bl) {
                if (this.publicConstructors != null) {
                    constructorArray = (Constructor[])this.publicConstructors.get();
                }
            } else if (this.declaredConstructors != null) {
                constructorArray = (Constructor[])this.declaredConstructors.get();
            }
            if (constructorArray != null) {
                return constructorArray;
            }
        }
        constructorArray = this.isInterface() ? new Constructor[]{} : this.getDeclaredConstructors0(bl);
        if (useCaches) {
            if (bl) {
                this.publicConstructors = new SoftReference(constructorArray);
            } else {
                this.declaredConstructors = new SoftReference(constructorArray);
            }
        }
        return constructorArray;
    }

    private Method[] privateGetDeclaredMethods(boolean bl) {
        Class.checkInitted();
        Method[] methodArray = null;
        if (useCaches) {
            if (bl) {
                if (this.declaredPublicMethods != null) {
                    methodArray = (Method[])this.declaredPublicMethods.get();
                }
            } else if (this.declaredMethods != null) {
                methodArray = (Method[])this.declaredMethods.get();
            }
            if (methodArray != null) {
                return methodArray;
            }
        }
        methodArray = this.getDeclaredMethods0(bl);
        if (useCaches) {
            if (bl) {
                this.declaredPublicMethods = new SoftReference(methodArray);
            } else {
                this.declaredMethods = new SoftReference(methodArray);
            }
        }
        return methodArray;
    }

    private Method[] privateGetPublicMethods() {
        Object object;
        Class clazz;
        int n;
        Class.checkInitted();
        Method[] methodArray = null;
        if (useCaches) {
            if (this.publicMethods != null) {
                methodArray = (Method[])this.publicMethods.get();
            }
            if (methodArray != null) {
                return methodArray;
            }
        }
        MethodArray methodArray2 = new MethodArray();
        Object object2 = this.privateGetDeclaredMethods(true);
        methodArray2.addAll((Method[])object2);
        object2 = new MethodArray();
        Class[] classArray = this.getInterfaces();
        for (n = 0; n < classArray.length; ++n) {
            ((MethodArray)object2).addAll(classArray[n].privateGetPublicMethods());
        }
        if (!this.isInterface() && (clazz = this.getSuperclass()) != null) {
            object = new MethodArray();
            ((MethodArray)object).addAll(clazz.privateGetPublicMethods());
            for (int i = 0; i < ((MethodArray)object).length(); ++i) {
                Method method = ((MethodArray)object).get(i);
                if (method == null || Modifier.isAbstract(method.getModifiers())) continue;
                ((MethodArray)object2).removeByNameAndSignature(method);
            }
            ((MethodArray)object).addAll((MethodArray)object2);
            object2 = object;
        }
        for (n = 0; n < methodArray2.length(); ++n) {
            object = methodArray2.get(n);
            ((MethodArray)object2).removeByNameAndSignature((Method)object);
        }
        methodArray2.addAllIfNotPresent((MethodArray)object2);
        methodArray2.compactAndTrim();
        methodArray = methodArray2.getArray();
        if (useCaches) {
            this.publicMethods = new SoftReference(methodArray);
        }
        return methodArray;
    }

    private Field searchFields(Field[] fieldArray, String string) {
        String string2 = string.intern();
        for (int i = 0; i < fieldArray.length; ++i) {
            if (fieldArray[i].getName() != string2) continue;
            return Class.getReflectionFactory().copyField(fieldArray[i]);
        }
        return null;
    }

    private Field getField1(String string) throws NoSuchFieldException {
        Class clazz;
        Field field = null;
        field = this.searchFields(this.privateGetDeclaredFields(true), string);
        if (field != null) {
            return field;
        }
        Class[] classArray = this.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            Class clazz2 = classArray[i];
            field = clazz2.getField1(string);
            if (field == null) continue;
            return field;
        }
        if (!this.isInterface() && (clazz = this.getSuperclass()) != null && (field = clazz.getField1(string)) != null) {
            return field;
        }
        return null;
    }

    private static Method searchMethods(Method[] methodArray, String string, Class[] classArray) {
        Method method = null;
        String string2 = string.intern();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method2 = methodArray[i];
            if (method2.getName() != string2 || !Class.arrayContentsEq(classArray, method2.getParameterTypes()) || method != null && !method.getReturnType().isAssignableFrom(method2.getReturnType())) continue;
            method = method2;
        }
        return method == null ? method : Class.getReflectionFactory().copyMethod(method);
    }

    private Method getMethod1(String string, Class[] classArray) {
        Class[] classArray2;
        Method method = null;
        method = Class.searchMethods(this.privateGetDeclaredMethods(true), string, classArray);
        if (method != null) {
            return method;
        }
        if (!this.isInterface() && (classArray2 = this.getSuperclass()) != null && (method = super.getMethod1(string, classArray)) != null) {
            return method;
        }
        classArray2 = this.getInterfaces();
        for (int i = 0; i < classArray2.length; ++i) {
            Class clazz = classArray2[i];
            method = clazz.getMethod1(string, classArray);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    private Constructor getConstructor1(Class[] classArray, int n) throws NoSuchMethodException {
        Constructor[] constructorArray = this.privateGetDeclaredConstructors(n == 0);
        for (int i = 0; i < constructorArray.length; ++i) {
            if (!Class.arrayContentsEq(classArray, constructorArray[i].getParameterTypes())) continue;
            return Class.getReflectionFactory().copyConstructor(constructorArray[i]);
        }
        throw new NoSuchMethodException(this.getName() + ".<init>" + Class.argumentTypesToString(classArray));
    }

    private static boolean arrayContentsEq(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == null) {
            return objectArray2 == null || objectArray2.length == 0;
        }
        if (objectArray2 == null) {
            return objectArray.length == 0;
        }
        if (objectArray.length != objectArray2.length) {
            return false;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == objectArray2[i]) continue;
            return false;
        }
        return true;
    }

    private static Field[] copyFields(Field[] fieldArray) {
        Field[] fieldArray2 = new Field[fieldArray.length];
        ReflectionFactory reflectionFactory = Class.getReflectionFactory();
        for (int i = 0; i < fieldArray.length; ++i) {
            fieldArray2[i] = reflectionFactory.copyField(fieldArray[i]);
        }
        return fieldArray2;
    }

    private static Method[] copyMethods(Method[] methodArray) {
        Method[] methodArray2 = new Method[methodArray.length];
        ReflectionFactory reflectionFactory = Class.getReflectionFactory();
        for (int i = 0; i < methodArray.length; ++i) {
            methodArray2[i] = reflectionFactory.copyMethod(methodArray[i]);
        }
        return methodArray2;
    }

    private static Constructor[] copyConstructors(Constructor[] constructorArray) {
        Constructor[] constructorArray2 = new Constructor[constructorArray.length];
        ReflectionFactory reflectionFactory = Class.getReflectionFactory();
        for (int i = 0; i < constructorArray.length; ++i) {
            constructorArray2[i] = reflectionFactory.copyConstructor(constructorArray[i]);
        }
        return constructorArray2;
    }

    private native Field[] getDeclaredFields0(boolean var1);

    private native Method[] getDeclaredMethods0(boolean var1);

    private native Constructor[] getDeclaredConstructors0(boolean var1);

    private native Class[] getDeclaredClasses0();

    private native Field getField0(String var1, int var2, boolean var3);

    private native Method getMethod0(String var1, Class[] var2, int var3, boolean var4);

    private native Constructor getConstructor0(Class[] var1, int var2);

    private static String argumentTypesToString(Class[] classArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        if (classArray != null) {
            for (int i = 0; i < classArray.length; ++i) {
                Class clazz;
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append((clazz = classArray[i]) == null ? "null" : clazz.getName());
            }
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean desiredAssertionStatus() {
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader == null) {
            return Class.desiredAssertionStatus0(this);
        }
        ClassLoader classLoader2 = classLoader;
        synchronized (classLoader2) {
            return classLoader.classAssertionStatus == null ? Class.desiredAssertionStatus0(this) : classLoader.desiredAssertionStatus(this.getName());
        }
    }

    private static native boolean desiredAssertionStatus0(Class var0);

    private static ReflectionFactory getReflectionFactory() {
        if (reflectionFactory == null) {
            reflectionFactory = (ReflectionFactory)AccessController.doPrivileged(new ReflectionFactory.GetReflectionFactoryAction());
        }
        return reflectionFactory;
    }

    private static void checkInitted() {
        if (initted) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (System.out == null) {
                    return null;
                }
                String string = System.getProperty("sun.reflect.noCaches");
                if (string != null && string.equals("true")) {
                    useCaches = false;
                } else {
                    useCaches = Class.canUseCaches();
                }
                initted = true;
                try {
                    Field field = Class.forName("java.lang.reflect.Method").getDeclaredField("useCaches");
                    if (null != field) {
                        field.setAccessible(true);
                        field.set(null, new Boolean(useCaches));
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    InternalError internalError = new InternalError();
                    internalError.initCause(classNotFoundException);
                    throw internalError;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    InternalError internalError = new InternalError();
                    internalError.initCause(noSuchFieldException);
                    throw internalError;
                }
                catch (IllegalAccessException illegalAccessException) {
                    InternalError internalError = new InternalError();
                    internalError.initCause(illegalAccessException);
                    throw internalError;
                }
                return null;
            }
        });
    }

    private static native boolean canUseCaches();

    static {
        Class.registerNatives();
        useCaches = false;
        serialPersistentFields = ObjectStreamClass.NO_FIELDS;
        initted = false;
    }

    static class MethodArray {
        private Method[] methods = new Method[20];
        private int length = 0;

        MethodArray() {
        }

        void add(Method method) {
            if (this.length == this.methods.length) {
                Method[] methodArray = new Method[2 * this.methods.length];
                System.arraycopy(this.methods, 0, methodArray, 0, this.methods.length);
                this.methods = methodArray;
            }
            this.methods[this.length++] = method;
        }

        void addAll(Method[] methodArray) {
            for (int i = 0; i < methodArray.length; ++i) {
                this.add(methodArray[i]);
            }
        }

        void addAll(MethodArray methodArray) {
            for (int i = 0; i < methodArray.length(); ++i) {
                this.add(methodArray.get(i));
            }
        }

        void addIfNotPresent(Method method) {
            for (int i = 0; i < this.length; ++i) {
                Method method2 = this.methods[i];
                if (method2 != method && (method2 == null || !method2.equals(method))) continue;
                return;
            }
            this.add(method);
        }

        void addAllIfNotPresent(MethodArray methodArray) {
            for (int i = 0; i < methodArray.length(); ++i) {
                Method method = methodArray.get(i);
                if (method == null) continue;
                this.addIfNotPresent(method);
            }
        }

        int length() {
            return this.length;
        }

        Method get(int n) {
            return this.methods[n];
        }

        void removeByNameAndSignature(Method method) {
            for (int i = 0; i < this.length; ++i) {
                Method method2 = this.methods[i];
                if (method2 == null || method2.getReturnType() != method.getReturnType() || method2.getName() != method.getName() || !Class.arrayContentsEq(method2.getParameterTypes(), method.getParameterTypes())) continue;
                this.methods[i] = null;
            }
        }

        void compactAndTrim() {
            int n = 0;
            for (int i = 0; i < this.length; ++i) {
                Method method = this.methods[i];
                if (method == null) continue;
                if (i != n) {
                    this.methods[n] = method;
                }
                ++n;
            }
            if (n != this.methods.length) {
                Method[] methodArray = new Method[n];
                System.arraycopy(this.methods, 0, methodArray, 0, n);
                this.methods = methodArray;
            }
        }

        Method[] getArray() {
            return this.methods;
        }
    }
}

